/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.expressions.ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.InferenceError;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.CreateFreshTypeVariableSubstitutorStageKt;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.stages.TypeArgumentMapping;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeExplicitTypeParameterConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.FirPlaceholderProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00132\u0006\u0010\f\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CreateFreshTypeVariableSubstitutorStage;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTypePreservingFlexibilityWrtTypeVariable", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "shouldBeFlexible", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "resolve"})
@SourceDebugExtension(value={"SMAP\nCreateFreshTypeVariableSubstitutorStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateFreshTypeVariableSubstitutorStage.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CreateFreshTypeVariableSubstitutorStage\n+ 2 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSinkKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n29#2,2:275\n23#2,9:277\n23#2,4:286\n1761#3,3:290\n*S KotlinDebug\n*F\n+ 1 CreateFreshTypeVariableSubstitutorStage.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CreateFreshTypeVariableSubstitutorStage\n*L\n50#1:275,2\n50#1:277,9\n89#1:286,4\n190#1:290,3\n*E\n"})
public final class CreateFreshTypeVariableSubstitutorStage
extends ResolutionStage {
    @NotNull
    public static final CreateFreshTypeVariableSubstitutorStage INSTANCE = new CreateFreshTypeVariableSubstitutorStage();

    private CreateFreshTypeVariableSubstitutorStage() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        Object declaration = candidate2.getSymbol().getFir();
        FirLazyDeclarationResolverKt.lazyResolveToPhase(candidate2.getSymbol(), FirResolvePhase.STATUS);
        if (!(declaration instanceof FirTypeParameterRefsOwner) || ((FirTypeParameterRefsOwner)declaration).getTypeParameters().isEmpty()) {
            candidate2.initializeSubstitutorAndVariables(ConeSubstitutor.Empty.INSTANCE, CollectionsKt.emptyList());
            return Unit.INSTANCE;
        }
        NewConstraintSystemImpl csBuilder = candidate2.getSystem().getBuilder();
        Pair pair = CreateFreshTypeVariableSubstitutorStageKt.access$createToFreshVariableSubstitutorAndAddInitialConstraints((FirTypeParameterRefsOwner)declaration, csBuilder, context2.getSession());
        ConeSubstitutor substitutor2 = (ConeSubstitutor)pair.component1();
        List freshVariables = (List)pair.component2();
        candidate2.initializeSubstitutorAndVariables(substitutor2, freshVariables);
        if (csBuilder.getHasContradiction()) {
            void $this$yieldDiagnostic$iv;
            CheckerSink checkerSink = sink;
            ResolutionDiagnostic diagnostic$iv = InapplicableCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        if (Intrinsics.areEqual(candidate2.getTypeArgumentMapping(), TypeArgumentMapping.NoExplicitArguments.INSTANCE)) {
            return Unit.INSTANCE;
        }
        List<FirTypeParameterRef> typeParameters2 = ((FirTypeParameterRefsOwner)declaration).getTypeParameters();
        int $i$f$yieldDiagnostic = ((Collection)typeParameters2).size();
        for (int index = 0; index < $i$f$yieldDiagnostic; ++index) {
            FirTypeParameterRef typeParameter = typeParameters2.get(index);
            ConeTypeVariable freshVariable = (ConeTypeVariable)freshVariables.get(index);
            FirTypeProjection typeArgument = candidate2.getTypeArgumentMapping().get(index);
            if (typeArgument instanceof FirTypeProjectionWithVariance) {
                csBuilder.addEqualityConstraint(freshVariable.getDefaultType(), TypeExpansionUtilsKt.fullyExpandedType$default(this.getTypePreservingFlexibilityWrtTypeVariable(FirTypeUtilsKt.getConeType(((FirTypeProjectionWithVariance)typeArgument).getTypeRef()), typeParameter, context2.getSession()), context2.getSession(), null, 2, null), new ConeExplicitTypeParameterConstraintPosition(typeArgument));
                continue;
            }
            if (typeArgument instanceof FirStarProjection) {
                KotlinTypeMarker kotlinTypeMarker = freshVariable.getDefaultType();
                Object object = CollectionsKt.firstOrNull(typeParameter.getSymbol().getResolvedBounds());
                if (object == null || (object = ((FirResolvedTypeRef)object).getConeType()) == null) {
                    object = context2.getSession().getBuiltinTypes().getNullableAnyType().getConeType();
                }
                csBuilder.addEqualityConstraint(kotlinTypeMarker, (KotlinTypeMarker)object, SimpleConstraintSystemConstraintPosition.INSTANCE);
                continue;
            }
            boolean bl = typeArgument instanceof FirPlaceholderProjection;
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl2 = false;
            String string = "Unexpected typeArgument: " + UtilsKt.renderWithType(typeArgument);
            throw new AssertionError((Object)string);
        }
        if (csBuilder.getHasContradiction()) {
            for (ConstraintSystemError error : csBuilder.getErrors()) {
                sink.reportDiagnostic(new InferenceError(error));
            }
            CheckerSink $this$yieldIfNeed$iv = sink;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final ConeKotlinType getTypePreservingFlexibilityWrtTypeVariable(ConeKotlinType type, FirTypeParameterRef typeParameter, FirSession session2) {
        ConeKotlinType coneKotlinType;
        if (this.shouldBeFlexible(typeParameter, TypeComponentsKt.getTypeContext(session2))) {
            ConeFlexibleType coneFlexibleType;
            ConeKotlinType coneKotlinType2 = type;
            if (coneKotlinType2 instanceof ConeRigidType) {
                coneFlexibleType = TypeUtilsKt.toTrivialFlexibleType((ConeRigidType)TypeUtilsKt.withNullability$default(type, false, TypeComponentsKt.getTypeContext(session2), null, false, 12, null), TypeComponentsKt.getTypeContext(session2));
            } else if (coneKotlinType2 instanceof ConeFlexibleType) {
                coneFlexibleType = new ConeFlexibleType((ConeRigidType)TypeUtilsKt.withNullability$default(((ConeFlexibleType)type).getLowerBound(), false, TypeComponentsKt.getTypeContext(session2), null, false, 12, null), (ConeRigidType)TypeUtilsKt.withNullability$default(((ConeFlexibleType)type).getUpperBound(), true, TypeComponentsKt.getTypeContext(session2), null, false, 12, null), false);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ConeFlexibleType $this$getTypePreservingFlexibilityWrtTypeVariable_u24lambda_u241 = coneFlexibleType;
            boolean bl = false;
            coneKotlinType = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.DontMakeExplicitJavaTypeArgumentsFlexible) ? $this$getTypePreservingFlexibilityWrtTypeVariable_u24lambda_u241 : (!ConeTypeUtilsKt.isMarkedNullable(type) ? $this$getTypePreservingFlexibilityWrtTypeVariable_u24lambda_u241 : (ConeFlexibleType)TypeUtilsKt.withAttributes((ConeKotlinType)$this$getTypePreservingFlexibilityWrtTypeVariable_u24lambda_u241, $this$getTypePreservingFlexibilityWrtTypeVariable_u24lambda_u241.getAttributes().add(new ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute(type, LanguageFeature.DontMakeExplicitJavaTypeArgumentsFlexible))));
        } else {
            coneKotlinType = type;
        }
        return coneKotlinType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeFlexible(FirTypeParameterRef $this$shouldBeFlexible, ConeTypeContext context2) {
        boolean bl;
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        if (languageVersionSettings.supportsFeature(LanguageFeature.DontMakeExplicitJavaTypeArgumentsFlexible)) return false;
        if (languageVersionSettings.supportsFeature(LanguageFeature.JavaTypeParameterDefaultRepresentationWithDNN)) {
            return false;
        }
        Iterable $this$any$iv = $this$shouldBeFlexible.getSymbol().getResolvedBounds();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
            boolean bl2 = false;
            ConeKotlinType type = it.getConeType();
            if (type instanceof ConeFlexibleType) return true;
            ConeTypeContext $this$shouldBeFlexible_u24lambda_u243_u24lambda_u242 = context2;
            boolean bl3 = false;
            TypeConstructorMarker typeConstructorMarker = $this$shouldBeFlexible_u24lambda_u243_u24lambda_u242.typeConstructor(type);
            Object object = typeConstructorMarker instanceof ConeTypeParameterLookupTag ? (ConeTypeParameterLookupTag)typeConstructorMarker : null;
            boolean bl4 = object != null && (object = ((ConeTypeParameterLookupTag)object).getSymbol()) != null && (object = (FirTypeParameter)((FirBasedSymbol)object).getFir()) != null ? INSTANCE.shouldBeFlexible((FirTypeParameterRef)object, context2) : false;
            if (bl4) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

