/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.BundleInstanceTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeBundleTasks
extends BaseCmd {
    public DescribeBundleTasks(String[] args) {
        super("ec2dbun", "ec2-describe-bundle-tasks");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    protected String getOptionString() {
        return "[BUNDLE [BUNDLE [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe bundle tasks.");
        System.out.println("     The BUNDLE parameter specifies the bundle IDs of the tasks to be described.");
        System.out.println("     If unspecified, all your bundle tasks will be returned.");
    }

    public void printOptions() {
        super.printOptions();
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] bundleIds = this.getNonOptions();
        RequestResultPair rsp = jec2.describeBundleTasks(Arrays.asList(bundleIds), this.getFilters(true));
        for (BundleInstanceTask task : (List)rsp.getResponse()) {
            out.output(System.out, task);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeBundleTasks(args).invoke();
    }
}

