/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.stress.util.TimingInterval;

public class TimingIntervals {
    final Map<String, TimingInterval> intervals;

    TimingIntervals(Iterable<String> opTypes) {
        long now = System.nanoTime();
        this.intervals = new TreeMap<String, TimingInterval>();
        for (String opType : opTypes) {
            this.intervals.put(opType, new TimingInterval(now));
        }
    }

    TimingIntervals(Map<String, TimingInterval> intervals) {
        this.intervals = intervals;
    }

    public TimingIntervals merge(TimingIntervals with, int maxSamples, long start) {
        assert (this.intervals.size() == with.intervals.size());
        TreeMap<String, TimingInterval> ret = new TreeMap<String, TimingInterval>();
        for (String opType : this.intervals.keySet()) {
            assert (with.intervals.containsKey(opType));
            ret.put(opType, TimingInterval.merge(Arrays.asList(this.intervals.get(opType), with.intervals.get(opType)), maxSamples, start));
        }
        return new TimingIntervals(ret);
    }

    public TimingInterval get(String opType) {
        return this.intervals.get(opType);
    }

    public TimingInterval combine(int maxSamples) {
        long start = Long.MAX_VALUE;
        for (TimingInterval ti : this.intervals.values()) {
            start = Math.min(start, ti.startNanos());
        }
        return TimingInterval.merge(this.intervals.values(), maxSamples, start);
    }

    public String str(TimingInterval.TimingParameter value) {
        return this.str(value, Float.NaN);
    }

    public String str(TimingInterval.TimingParameter value, float rank) {
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<String, TimingInterval> entry : this.intervals.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue().getStringValue(value, rank));
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
        return sb.toString();
    }

    public String opRates() {
        return this.str(TimingInterval.TimingParameter.OPRATE);
    }

    public String partitionRates() {
        return this.str(TimingInterval.TimingParameter.PARTITIONRATE);
    }

    public String rowRates() {
        return this.str(TimingInterval.TimingParameter.ROWRATE);
    }

    public String meanLatencies() {
        return this.str(TimingInterval.TimingParameter.MEANLATENCY);
    }

    public String maxLatencies() {
        return this.str(TimingInterval.TimingParameter.MAXLATENCY);
    }

    public String medianLatencies() {
        return this.str(TimingInterval.TimingParameter.MEDIANLATENCY);
    }

    public String rankLatencies(float rank) {
        return this.str(TimingInterval.TimingParameter.RANKLATENCY, rank);
    }

    public String errorCounts() {
        return this.str(TimingInterval.TimingParameter.ERRORCOUNT);
    }

    public String partitionCounts() {
        return this.str(TimingInterval.TimingParameter.PARTITIONCOUNT);
    }

    public long opRate() {
        long v = 0L;
        for (TimingInterval interval : this.intervals.values()) {
            v = (long)((double)v + interval.opRate());
        }
        return v;
    }

    public long startNanos() {
        long start = Long.MAX_VALUE;
        for (TimingInterval interval : this.intervals.values()) {
            start = Math.min(start, interval.startNanos());
        }
        return start;
    }

    public long endNanos() {
        long end = Long.MIN_VALUE;
        for (TimingInterval interval : this.intervals.values()) {
            end = Math.max(end, interval.startNanos());
        }
        return end;
    }

    public Map<String, TimingInterval> intervals() {
        return this.intervals;
    }
}

