/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fife.io.UnicodeReader;
import org.fife.rtext.EmptyIcon;
import org.fife.rtext.RText;
import org.fife.rtext.optionsdialog.LanguageListCellRenderer;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.app.GUIApplication;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class LanguageOptionPanel
extends OptionsDialogPanel
implements ListSelectionListener {
    private DefaultListModel listModel;
    private JList languageList;
    private Map<String, String> languageMap;
    private GUIApplication app;
    private static final String LANGUAGE_PROPERTY = "language";
    private static final String ROOT_ELEMENT = "RText-languages";
    private static final String LANGUAGE = "language";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final EmptyIcon EMPTY_ICON = new EmptyIcon(16, 11);
    private static final String FILE_NAME = "localizations.xml";

    public LanguageOptionPanel(GUIApplication app, ResourceBundle msg) {
        super(msg.getString("OptLaName"));
        this.app = app;
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        JPanel languagePanel = new JPanel();
        languagePanel.setBorder(BorderFactory.createCompoundBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptLaLabel")), UIUtil.getEmpty5Border()));
        languagePanel.setLayout(new BorderLayout());
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        SelectableLabel label = new SelectableLabel(msg.getString("OptLaDesc"));
        temp.add((Component)label, "Before");
        languagePanel.add((Component)temp, "North");
        this.listModel = new DefaultListModel();
        this.languageList = new JList(this.listModel);
        this.languageList.setCellRenderer(LanguageListCellRenderer.create());
        this.languageMap = new HashMap<String, String>(1);
        try {
            File file = new File(app.getInstallLocation(), FILE_NAME);
            this.getLocalizations(file);
        }
        catch (Exception e) {
            app.displayException((Throwable)e);
        }
        this.languageList.setSelectionModel((ListSelectionModel)new RListSelectionModel());
        this.languageList.addListSelectionListener(this);
        RScrollPane scrollPane = new RScrollPane((Component)this.languageList);
        languagePanel.add((Component)scrollPane);
        this.add(languagePanel);
        this.applyComponentOrientation(orientation);
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        rtext.setLanguage(this.getSelectedLanguage());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    private Icon getIconFor(String id) {
        Icon icon = null;
        URL url = this.getClass().getClassLoader().getResource("org/fife/rtext/graphics/flags/" + id + ".png");
        if (url != null) {
            try {
                icon = new ImageIcon(ImageIO.read(url));
            }
            catch (IOException ioe) {
                this.app.displayException((Throwable)ioe);
                icon = EMPTY_ICON;
            }
        } else {
            icon = EMPTY_ICON;
        }
        return icon;
    }

    private void getLocalizations(File xmlFile) throws IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new UnicodeReader(new BufferedInputStream(new FileInputStream(xmlFile)), "UTF-8"));
            is.setEncoding("UTF-8");
            doc = db.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("XML error:  Error parsing file");
        }
        this.initializeFromXMLFile(doc);
    }

    public final String getSelectedLanguage() {
        IconTextInfo iti = (IconTextInfo)this.languageList.getSelectedValue();
        String language = iti.getText();
        String code = this.languageMap.get(language);
        if (code == null) {
            this.app.displayException((Throwable)new InternalError("Couldn't find language code for language: " + language));
            code = "en";
        }
        return code;
    }

    public JComponent getTopJComponent() {
        return this.languageList;
    }

    private void initializeFromXMLFile(Node node) throws IOException {
        if (node == null) {
            throw new IOException("XML error:  node==null!");
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.initializeFromXMLFile(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                String nodeName = node.getNodeName();
                if (nodeName.equals(ROOT_ELEMENT)) {
                    NodeList childNodes = node.getChildNodes();
                    if (childNodes == null || childNodes.getLength() == 0) {
                        throw new IOException("XML error:  There must be at least 1 language declared!");
                    }
                    int childCount = childNodes.getLength();
                    for (int i = 0; i < childCount; ++i) {
                        this.initializeFromXMLFile(childNodes.item(i));
                    }
                    break;
                }
                if (nodeName.equals("language")) {
                    NodeList childNodes = node.getChildNodes();
                    if (childNodes != null && childNodes.getLength() > 0) {
                        throw new IOException("XML error:  language tags shouldn't have children!");
                    }
                    NamedNodeMap attributes = node.getAttributes();
                    if (attributes == null || attributes.getLength() != 2) {
                        throw new IOException("XML error:  language tags should have two attributes!");
                    }
                    String name = null;
                    String id = null;
                    for (int i = 0; i < 2; ++i) {
                        Node node2 = attributes.item(i);
                        nodeName = node2.getNodeName();
                        if (nodeName.equals(NAME)) {
                            name = node2.getNodeValue();
                            continue;
                        }
                        if (nodeName.equals(ID)) {
                            id = node2.getNodeValue();
                            continue;
                        }
                        throw new IOException("XML error: unknown attribute: '" + nodeName + "'");
                    }
                    if (name == null || id == null) {
                        throw new IOException("XML error: language must have attributes 'name' and 'id'.");
                    }
                    Icon icon = this.getIconFor(id);
                    IconTextInfo iti = new IconTextInfo(name, icon);
                    this.listModel.addElement(iti);
                    this.languageMap.put(name, id);
                    break;
                }
                throw new IOException("XML error:  Unknown element node: " + nodeName);
            }
            case 3: {
                break;
            }
            default: {
                throw new IOException("XML error:  Unknown node type: " + type);
            }
        }
    }

    private void setSelectedLanguage(String language) {
        String langValue;
        String langName;
        Object obj;
        int i;
        int count = this.listModel.size();
        for (i = 0; i < count; ++i) {
            obj = this.listModel.get(i);
            langName = ((IconTextInfo)obj).getText();
            langValue = this.languageMap.get(langName);
            if (!language.startsWith(langValue)) continue;
            this.languageList.setSelectedIndex(i);
            return;
        }
        for (i = 0; i < count; ++i) {
            obj = this.listModel.get(i);
            langName = ((IconTextInfo)obj).getText();
            langValue = this.languageMap.get(langName);
            if (!langValue.equals("en")) continue;
            this.languageList.setSelectedIndex(i);
            return;
        }
    }

    protected void setValuesImpl(Frame owner) {
        this.setSelectedLanguage(((RText)((Object)owner)).getLanguage());
    }

    public void valueChanged(ListSelectionEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange("language", -1, this.languageList.getSelectedIndex());
    }

    static class IconTextInfo {
        private Icon icon;
        private String text;

        public IconTextInfo(String text, Icon icon) {
            this.text = text;
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getText() {
            return this.text;
        }
    }
}

