/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class ScrollButton
extends BasicArrowButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;
    private int buttonWidth;
    private Icon icon;

    public ScrollButton(int direction, int width, boolean freeStanding) {
        super(direction);
        shadowColor = UIManager.getColor("ScrollBar.darkShadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.buttonWidth = width;
        this.isFreeStanding = freeStanding;
    }

    public void setFreeStanding(boolean freeStanding) {
        this.isFreeStanding = freeStanding;
    }

    public void paint(Graphics g) {
        int delta;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(UIManager.getColor("Button.borderColor"));
        Rectangle shadowRect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        boolean isPressed = this.model.isPressed();
        int n = delta = isPressed ? 1 : 0;
        if (isPressed) {
            g.setColor(UIManager.getColor("Button.highlight"));
            g.drawRect(shadowRect.x, shadowRect.y, shadowRect.width - 1, shadowRect.height - 1);
            g.setColor(UIManager.getColor("Button.shadow"));
            g.drawLine(shadowRect.x, shadowRect.y, shadowRect.x + shadowRect.width - 1, shadowRect.y);
            g.drawLine(shadowRect.x, shadowRect.y, shadowRect.x, shadowRect.y + shadowRect.height - 1);
        }
        if (this.icon == null) {
            switch (this.direction) {
                case 3: {
                    this.icon = UIManager.getIcon("Arrow.right");
                    break;
                }
                case 7: {
                    this.icon = UIManager.getIcon("Arrow.left");
                    break;
                }
                case 1: {
                    this.icon = UIManager.getIcon("Arrow.up");
                    break;
                }
                case 5: {
                    this.icon = UIManager.getIcon("Arrow.down");
                }
            }
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, g, this.getWidth() / 2 - this.icon.getIconWidth() / 2 + delta, this.getHeight() / 2 - this.icon.getIconHeight() / 2 + delta);
        }
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }
}

