/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindMarkColor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindServiceCallBack;

public class FindServiceCellRendererDecorator
implements TableCellRenderer {
    private TableCellRenderer _delegate;
    private FindServiceCallBack _findServiceCallBack;
    private Point _pointBuffer = new Point();
    private HashMap<Point, Color> _originalColorsByCell = new HashMap();

    public FindServiceCellRendererDecorator(TableCellRenderer delegate, FindServiceCallBack findServiceCallBack) {
        this._delegate = delegate;
        this._findServiceCallBack = findServiceCallBack;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        FindMarkColor findMarkColor = this._findServiceCallBack.getBackgroundColor(row, column);
        Component tableCellRendererComponent = this._delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (null != findMarkColor) {
            if (!(tableCellRendererComponent.getBackground() instanceof FindMarkColor)) {
                this._pointBuffer.setLocation(row, column);
                if (this._originalColorsByCell.containsKey(this._pointBuffer)) {
                    if (null != this._originalColorsByCell.get(this._pointBuffer)) {
                        this._originalColorsByCell.put(new Point(this._pointBuffer), null);
                    }
                } else {
                    this._originalColorsByCell.put(new Point(this._pointBuffer), tableCellRendererComponent.getBackground());
                }
            }
            tableCellRendererComponent.setBackground(findMarkColor);
        } else if (tableCellRendererComponent.getBackground() instanceof FindMarkColor) {
            this._pointBuffer.setLocation(row, column);
            Color originalBackground = this._originalColorsByCell.get(this._pointBuffer);
            if (null != originalBackground) {
                tableCellRendererComponent.setBackground(originalBackground);
            }
        }
        return tableCellRendererComponent;
    }
}

