/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Calculator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.NoIx;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;

public abstract class IndexedColumn {
    private ArrayList<Integer> _ix;
    private List<Object[]> _rows;
    private int _colIx;
    private ColumnDisplayDefinition _colDef;
    private Comparator _comparator;

    public IndexedColumn(List<Object[]> rows, int colIx, ColumnDisplayDefinition colDef) {
        this._rows = rows;
        this._colIx = colIx;
        this._colDef = colDef;
        this._ix = new ArrayList(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            this._ix.add(i);
        }
    }

    protected void sortIx(Comparator comparator) {
        this._comparator = comparator;
        Collections.sort(this._ix, this._comparator);
    }

    public int getColumnIndex() {
        return this._colIx;
    }

    public Object get(int ix) {
        return this._rows.get(this._ix.get(ix))[this._colIx];
    }

    public Object getRow(Integer rowIx) {
        return this._rows.get(rowIx)[this._colIx];
    }

    public int getRowIx(int ix) {
        return this._ix.get(ix);
    }

    public int binarySearch(Object border) {
        return Collections.binarySearch(this._ix, new NoIx(border), this._comparator);
    }

    public String getColumnName() {
        return this._colDef.getColumnName();
    }

    public Object getMin() {
        return this._rows.get(this._ix.get(0))[this._colIx];
    }

    public Object getMax() {
        return this._rows.get(this._ix.get(this._ix.size() - 1))[this._colIx];
    }

    public int size() {
        return this._ix.size();
    }

    public int getLastIndexOfVal(int startIx) {
        int ret = startIx;
        for (int i = startIx + 1; i < this._ix.size() && 0 == this._comparator.compare(new NoIx(this.get(startIx)), new NoIx(this.get(i))); ++i) {
            ++ret;
        }
        return ret;
    }

    public int getFirstIndexOfVal(int startIx) {
        for (int i = startIx - 1; 0 <= i; --i) {
            if (0 == this._comparator.compare(new NoIx(this.get(startIx)), new NoIx(this.get(i)))) continue;
            return i;
        }
        return 0;
    }

    public int compareObjects(Object o1, Object o2) {
        return this._comparator.compare(new NoIx(o1), new NoIx(o2));
    }

    public String renderObject(Object o) {
        return CellComponentFactory.renderObject(o, this._colDef);
    }

    public abstract Calculator getCalculator();

    public Comparator<? super Object> getComparator() {
        return this._comparator;
    }

    public List<Object[]> getResultRows(int firstIx, int lastIx) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>(lastIx - firstIx + 1);
        for (int i = firstIx; i <= lastIx; ++i) {
            ret.add(this._rows.get(this._ix.get(i)));
        }
        return ret;
    }

    public ColumnDisplayDefinition getColumnDisplayDefinition() {
        return this._colDef;
    }

    public abstract String calculateDist(Object var1, Object var2);

    public int countDistinctValsForInterval(int firstIx, int lastIx) {
        int count = 1;
        int firstIxOfCurrentValue = this.getRowIx(firstIx);
        for (int i = firstIx; i <= lastIx; ++i) {
            if (0 == this._comparator.compare(firstIxOfCurrentValue, this.getRowIx(i))) continue;
            ++count;
            firstIxOfCurrentValue = this.getRowIx(i);
        }
        return count;
    }

    public int countDistinctValsForColumn() {
        return this.countDistinctValsForInterval(0, this._ix.size() - 1);
    }
}

