/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public abstract class NumberConverter
implements ObjectConverter {
    private NumberFormat _numberFormat;
    private static boolean _groupingUsed = true;

    public NumberConverter() {
    }

    public NumberConverter(NumberFormat format) {
        this._numberFormat = format;
    }

    @Override
    public String toString(Object object, ConverterContext context) {
        try {
            if (context == null || context.getUserObject() == null || !(context.getUserObject() instanceof NumberFormat)) {
                if (object instanceof Number && ((Number)object).doubleValue() == Double.NaN) {
                    return "";
                }
                return this.getNumberFormat().format(object);
            }
            NumberFormat format = (NumberFormat)context.getUserObject();
            return format.format(object);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this._numberFormat = numberFormat;
    }

    protected NumberFormat getNumberFormat() {
        if (this._numberFormat == null) {
            this._numberFormat = DecimalFormat.getInstance();
        }
        this._numberFormat.setGroupingUsed(NumberConverter.isGroupingUsed());
        return this._numberFormat;
    }

    protected NumberFormat getDefaultNumberFormat() {
        NumberFormat format = DecimalFormat.getInstance(Locale.US);
        format.setGroupingUsed(NumberConverter.isGroupingUsed());
        return format;
    }

    protected Number parseNumber(String string) {
        Number number;
        try {
            number = this.getNumberFormat().parse(string);
        }
        catch (ParseException e) {
            try {
                number = this.getDefaultNumberFormat().parse(string);
            }
            catch (ParseException e1) {
                number = null;
            }
        }
        return number;
    }

    public static boolean isGroupingUsed() {
        return _groupingUsed;
    }

    public static void setGroupingUsed(boolean groupingUsed) {
        _groupingUsed = groupingUsed;
    }
}

