/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class Getopt {
    private final List<Option> options = new ArrayList<Option>();
    private int current = -1;
    private int optind = -1;
    private final String[] argv;
    private final String opts;

    public Getopt(String[] argv, String opts) {
        this.argv = (String[])argv.clone();
        this.opts = opts;
    }

    public void parse() throws ParseException {
        block0: for (int ii = 0; ii < this.argv.length; ++ii) {
            char[] chars = this.argv[ii].toCharArray();
            if (chars.length > 0 && chars[0] == '-') {
                if (this.argv[ii].equals("--")) {
                    this.optind = ii + 1;
                    break;
                }
                for (int jj = 1; jj < chars.length; ++jj) {
                    int idx = this.opts.indexOf(chars[jj]);
                    if (idx == -1) {
                        throw new ParseException("Unknown argument: " + this.argv[ii].substring(jj), ii);
                    }
                    Option option = new Option();
                    option.option = chars[jj];
                    this.options.add(option);
                    if (idx + 1 >= this.opts.length() || this.opts.charAt(idx + 1) != ':') continue;
                    if (jj + 1 < chars.length) {
                        option.argument = this.argv[ii].substring(jj + 1);
                        continue block0;
                    }
                    if (++ii < this.argv.length) {
                        option.argument = this.argv[ii];
                        continue;
                    }
                    throw new ParseException("Option " + chars[jj] + " requires an argument", ii);
                }
                continue;
            }
            this.optind = ii;
            break;
        }
    }

    public int getOpt() {
        int ret = -1;
        ++this.current;
        if (this.current < this.options.size()) {
            ret = this.options.get((int)this.current).option;
        }
        return ret;
    }

    public void reset() {
        this.current = -1;
    }

    public String getOptarg() {
        String ret = null;
        if (this.current < this.options.size()) {
            ret = this.options.get((int)this.current).argument;
        }
        return ret;
    }

    public int getOptind() {
        return this.optind;
    }

    private static class Option {
        char option;
        String argument;

        private Option() {
        }
    }
}

