/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.ProducerStatsRegistry$;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Sanitizer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class KafkaMetricsGroup$
implements KafkaMetricsGroup {
    public static KafkaMetricsGroup$ MODULE$;
    private final List<MetricName> consumerMetricNameList;
    private final List<MetricName> producerMetricNameList;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new KafkaMetricsGroup$();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaMetricsGroup$ kafkaMetricsGroup$ = this;
        synchronized (kafkaMetricsGroup$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private List<MetricName> consumerMetricNameList() {
        return this.consumerMetricNameList;
    }

    private List<MetricName> producerMetricNameList() {
        return this.producerMetricNameList;
    }

    public Option<String> kafka$metrics$KafkaMetricsGroup$$toMBeanName(Map<String, String> tags) {
        None$ none$;
        Map filteredTags = (Map)tags.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetricsGroup$.$anonfun$toMBeanName$1(x0$1)));
        if (filteredTags.nonEmpty()) {
            String tagsString = ((TraversableOnce)filteredTags.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                String string = new StringOps(Predef$.MODULE$.augmentString("%s=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, Sanitizer.jmxSanitize((String)value)}));
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
            none$ = new Some((Object)tagsString);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<String> kafka$metrics$KafkaMetricsGroup$$toScope(Map<String, String> tags) {
        None$ none$;
        Map filteredTags = (Map)tags.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetricsGroup$.$anonfun$toScope$1(x0$3)));
        if (filteredTags.nonEmpty()) {
            String tagsString = ((TraversableOnce)((List)filteredTags.toList().sortWith((Function2 & Serializable & scala.Serializable)(t1, t2) -> BoxesRunTime.boxToBoolean((boolean)KafkaMetricsGroup$.$anonfun$toScope$2(t1, t2)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                String string = new StringOps(Predef$.MODULE$.augmentString("%s.%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value.replaceAll("\\.", "_")}));
                return string;
            }, List$.MODULE$.canBuildFrom())).mkString(".");
            none$ = new Some((Object)tagsString);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public void removeAllConsumerMetrics(String clientId) {
        FetchRequestAndResponseStatsRegistry$.MODULE$.removeConsumerFetchRequestAndResponseStats(clientId);
        ConsumerTopicStatsRegistry$.MODULE$.removeConsumerTopicStat(clientId);
        ProducerRequestStatsRegistry$.MODULE$.removeProducerRequestStats(clientId);
        this.removeAllMetricsInList(this.consumerMetricNameList(), clientId);
    }

    @Override
    public void removeAllProducerMetrics(String clientId) {
        ProducerRequestStatsRegistry$.MODULE$.removeProducerRequestStats(clientId);
        ProducerTopicStatsRegistry$.MODULE$.removeProducerTopicStats(clientId);
        ProducerStatsRegistry$.MODULE$.removeProducerStats(clientId);
        this.removeAllMetricsInList(this.producerMetricNameList(), clientId);
    }

    private void removeAllMetricsInList(List<MetricName> metricNameList, String clientId) {
        metricNameList.foreach((Function1 & Serializable & scala.Serializable)metric -> {
            KafkaMetricsGroup$.$anonfun$removeAllMetricsInList$1(clientId, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$toMBeanName$1(Tuple2 x0$1) {
        String tagValue;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = tagValue = (String)tuple2._2();
        String string2 = "";
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$toScope$1(Tuple2 x0$3) {
        String tagValue;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = tagValue = (String)tuple2._2();
        String string2 = "";
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$toScope$2(Tuple2 t1, Tuple2 t2) {
        return new StringOps(Predef$.MODULE$.augmentString((String)t1._1())).$less(t2._1());
    }

    public static final /* synthetic */ void $anonfun$removeAllMetricsInList$2(Regex pattern$1, MetricName metric$1, MetricName registeredMetric) {
        block4: {
            String string = registeredMetric.getGroup();
            String string2 = metric$1.getGroup();
            if (string != null ? !string.equals(string2) : string2 != null) break block4;
            String string3 = registeredMetric.getName();
            String string4 = metric$1.getName();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String string5 = registeredMetric.getType();
                String string6 = metric$1.getType();
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    Option option = pattern$1.findFirstIn((CharSequence)registeredMetric.getMBeanName());
                    if (option instanceof Some) {
                        int beforeRemovalSize = Metrics.defaultRegistry().allMetrics().keySet().size();
                        Metrics.defaultRegistry().removeMetric(registeredMetric);
                        int afterRemovalSize = Metrics.defaultRegistry().allMetrics().keySet().size();
                        MODULE$.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Removing metric %s. Metrics registry size reduced from %d to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{registeredMetric, BoxesRunTime.boxToInteger((int)beforeRemovalSize), BoxesRunTime.boxToInteger((int)afterRemovalSize)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$removeAllMetricsInList$1(String clientId$1, MetricName metric) {
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString(".*clientId=" + clientId$1 + ".*")).r();
        Set registeredMetrics = (Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala();
        registeredMetrics.foreach((Function1 & Serializable & scala.Serializable)registeredMetric -> {
            KafkaMetricsGroup$.$anonfun$removeAllMetricsInList$2(pattern, metric, registeredMetric);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaMetricsGroup$() {
        MODULE$ = this;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.consumerMetricNameList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "FetchQueueSize"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "KafkaCommitsPerSec"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "ZooKeeperCommitsPerSec"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "RebalanceRateAndTime"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "OwnedPartitionsCount"), new MetricName("kafka.consumer", "ConsumerFetcherManager", "MaxLag"), new MetricName("kafka.consumer", "ConsumerFetcherManager", "MinFetchRate"), new MetricName("kafka.server", "FetcherLagMetrics", "ConsumerLag"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "MessagesPerSec"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "BytesPerSec"), new MetricName("kafka.server", "FetcherStats", "BytesPerSec"), new MetricName("kafka.server", "FetcherStats", "RequestsPerSec"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "FetchResponseSize"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "FetchRequestRateAndTimeMs"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "FetchRequestThrottleRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestSize")}));
        this.producerMetricNameList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("kafka.producer", "ProducerStats", "SerializationErrorsPerSec"), new MetricName("kafka.producer", "ProducerStats", "ResendsPerSec"), new MetricName("kafka.producer", "ProducerStats", "FailedSendsPerSec"), new MetricName("kafka.producer.async", "ProducerSendThread", "ProducerQueueSize"), new MetricName("kafka.producer", "ProducerTopicMetrics", "MessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "DroppedMessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "BytesPerSec"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestSize"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestThrottleRateAndTimeMs")}));
    }
}

