/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.SimulcastMode;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceRidGroupPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.SSRCInfoPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.impl.JidCreate;

public class ColibriConferenceIqProvider
extends IqProvider<ColibriConferenceIQ> {
    private static final Logger logger = new LoggerImpl(ColibriConferenceIqProvider.class.getName());

    public ColibriConferenceIqProvider() {
        ProviderManager.addExtensionProvider((String)"payload-type", (String)"http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<PayloadTypePacketExtension>(PayloadTypePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"rtcp-fb", (String)"urn:xmpp:jingle:apps:rtp:rtcp-fb:0", new DefaultPacketExtensionProvider<RtcpFbPacketExtension>(RtcpFbPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"rtp-hdrext", (String)"http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<RTPHdrExtPacketExtension>(RTPHdrExtPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"source", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourcePacketExtension>(SourcePacketExtension.class));
        ProviderManager.addExtensionProvider((String)"ssrc-group", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourceGroupPacketExtension>(SourceGroupPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"rid-group", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", new DefaultPacketExtensionProvider<SourceRidGroupPacketExtension>(SourceRidGroupPacketExtension.class));
        DefaultPacketExtensionProvider<ParameterPacketExtension> parameterProvider = new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class);
        ProviderManager.addExtensionProvider((String)"parameter", (String)"http://jitsi.org/protocol/colibri", parameterProvider);
        ProviderManager.addExtensionProvider((String)"parameter", (String)"urn:xmpp:jingle:apps:rtp:ssma:0", parameterProvider);
        ProviderManager.addExtensionProvider((String)"ssrc-info", (String)"http://jitsi.org/jitmeet", new DefaultPacketExtensionProvider<SSRCInfoPacketExtension>(SSRCInfoPacketExtension.class));
        DefaultPacketExtensionProvider<ColibriConferenceIQ.GracefulShutdown> shutdownProvider = new DefaultPacketExtensionProvider<ColibriConferenceIQ.GracefulShutdown>(ColibriConferenceIQ.GracefulShutdown.class);
        ProviderManager.addExtensionProvider((String)"graceful-shutdown", (String)"http://jitsi.org/protocol/colibri", shutdownProvider);
    }

    private void addChildExtension(ColibriConferenceIQ.Channel channel, ExtensionElement childExtension) {
        if (childExtension instanceof PayloadTypePacketExtension) {
            PayloadTypePacketExtension payloadType = (PayloadTypePacketExtension)childExtension;
            if ("opus".equals(payloadType.getName()) && payloadType.getChannels() != 2) {
                payloadType.setChannels(2);
            }
            channel.addPayloadType(payloadType);
        } else if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            channel.setTransport(transport);
        } else if (childExtension instanceof SourcePacketExtension) {
            channel.addSource((SourcePacketExtension)childExtension);
        } else if (childExtension instanceof SourceGroupPacketExtension) {
            SourceGroupPacketExtension sourceGroup = (SourceGroupPacketExtension)childExtension;
            channel.addSourceGroup(sourceGroup);
        } else if (childExtension instanceof RTPHdrExtPacketExtension) {
            RTPHdrExtPacketExtension rtpHdrExtPacketExtension = (RTPHdrExtPacketExtension)childExtension;
            channel.addRtpHeaderExtension(rtpHdrExtPacketExtension);
        } else {
            logger.error((Object)("Ignoring a child of 'channel' of unknown type: " + childExtension));
        }
    }

    private void addChildExtension(ColibriConferenceIQ.ChannelBundle bundle, ExtensionElement childExtension) {
        if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            bundle.setTransport(transport);
        }
    }

    private void addChildExtension(ColibriConferenceIQ.SctpConnection sctpConnection, ExtensionElement childExtension) {
        if (childExtension instanceof IceUdpTransportPacketExtension) {
            IceUdpTransportPacketExtension transport = (IceUdpTransportPacketExtension)childExtension;
            sctpConnection.setTransport(transport);
        }
    }

    private ExtensionElement parseExtension(XmlPullParser parser, String name, String namespace) throws XmlPullParserException, IOException, SmackParsingException {
        ExtensionElement extension;
        ExtensionElementProvider extensionProvider = ProviderManager.getExtensionProvider((String)name, (String)namespace);
        if (extensionProvider == null) {
            logger.warn(() -> "Should parse {" + namespace + "}:" + name + ", but found no extension provider");
            this.throwAway(parser, name);
            extension = null;
        } else {
            extension = (ExtensionElement)extensionProvider.parse(parser);
        }
        return extension;
    }

    public ColibriConferenceIQ parse(XmlPullParser parser, int initialDepth, IqData data, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ColibriConferenceIQ iq;
        String namespace = parser.getNamespace();
        if ("conference".equals(parser.getName()) && "http://jitsi.org/protocol/colibri".equals(namespace)) {
            String rtcstatsEnabled;
            String meetingId;
            String conferenceName;
            String conferenceGID;
            ColibriConferenceIQ conference = new ColibriConferenceIQ();
            String conferenceID = parser.getAttributeValue("", "id");
            if (conferenceID != null && conferenceID.length() != 0) {
                conference.setID(conferenceID);
            }
            if ((conferenceGID = parser.getAttributeValue("", "gid")) != null && conferenceGID.length() != 0) {
                conference.setGID(conferenceGID);
            }
            if (StringUtils.isNotEmpty((CharSequence)(conferenceName = parser.getAttributeValue("", "name")))) {
                conference.setName(JidCreate.entityBareFrom((String)conferenceName));
            }
            if (StringUtils.isNotEmpty((CharSequence)(meetingId = parser.getAttributeValue("", "meeting-id")))) {
                conference.setMeetingId(meetingId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(rtcstatsEnabled = parser.getAttributeValue("", "rtcstats-enabled")))) {
                conference.setRtcStatsEnabled(Boolean.parseBoolean(rtcstatsEnabled));
            }
            boolean done = false;
            ColibriConferenceIQ.Channel channel = null;
            ColibriConferenceIQ.RTCPTerminationStrategy rtcpTerminationStrategy = null;
            ColibriConferenceIQ.SctpConnection sctpConnection = null;
            ColibriConferenceIQ.ChannelBundle bundle = null;
            ColibriConferenceIQ.Content content = null;
            ColibriConferenceIQ.Recording recording = null;
            ColibriConferenceIQ.Endpoint conferenceEndpoint = null;
            StringBuilder ssrc = null;
            while (!done) {
                switch (parser.next()) {
                    case END_ELEMENT: {
                        String name = parser.getName();
                        if ("conference".equals(name)) {
                            done = true;
                            break;
                        }
                        if ("channel".equals(name)) {
                            content.addChannel(channel);
                            channel = null;
                            break;
                        }
                        if ("sctpconnection".equals(name)) {
                            if (sctpConnection != null) {
                                content.addSctpConnection(sctpConnection);
                            }
                            sctpConnection = null;
                            break;
                        }
                        if ("channel-bundle".equals(name)) {
                            if (bundle == null) break;
                            if (conference.addChannelBundle(bundle) != null) {
                                logger.warn((Object)"Replacing a channel-bundle with the sameID (not a valid Colibri packet).");
                            }
                            bundle = null;
                            break;
                        }
                        if ("endpoint".equals(name)) {
                            if (conference.addEndpoint(conferenceEndpoint) != null) {
                                logger.warn((Object)"Replacing an endpoint element with the sameID (not a valid Colibri packet).");
                            }
                            conferenceEndpoint = null;
                            break;
                        }
                        if ("ssrc".equals(name)) {
                            String s = ssrc.toString().trim();
                            if (s.length() != 0) {
                                int i = s.startsWith("-") ? Integer.parseInt(s) : (int)Long.parseLong(s);
                                channel.addSSRC(i);
                            }
                            ssrc = null;
                            break;
                        }
                        if ("content".equals(name)) {
                            conference.addContent(content);
                            content = null;
                            break;
                        }
                        if ("rtcp-termination-strategy".equals(name)) {
                            conference.setRTCPTerminationStrategy(rtcpTerminationStrategy);
                            rtcpTerminationStrategy = null;
                            break;
                        }
                        if ("recording".equals(name)) {
                            conference.setRecording(recording);
                            recording = null;
                            break;
                        }
                        if (!"graceful-shutdown".equals(name)) break;
                        conference.setGracefulShutdown(true);
                        break;
                    }
                    case START_ELEMENT: {
                        String id;
                        String channelBundleId;
                        String name = parser.getName();
                        if ("channel".equals(name)) {
                            String rtpPort;
                            String rtpLevelRelayType;
                            String rtcpPort;
                            String receivingSimulcastLayer;
                            String simulcastMode;
                            String lastN;
                            String initiator;
                            String channelID;
                            String host;
                            String packetDelay;
                            String expire;
                            String endpoint;
                            String type = parser.getAttributeValue("", "type");
                            channel = "octo".equals(type) ? new ColibriConferenceIQ.OctoChannel() : new ColibriConferenceIQ.Channel();
                            String direction = parser.getAttributeValue("", "direction");
                            if (direction != null && direction.length() != 0) {
                                channel.setDirection(direction);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)(endpoint = parser.getAttributeValue("", "endpoint")))) {
                                channel.setEndpoint(endpoint);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)(channelBundleId = parser.getAttributeValue("", "channel-bundle-id")))) {
                                channel.setChannelBundleId(channelBundleId);
                            }
                            if ((expire = parser.getAttributeValue("", "expire")) != null && expire.length() != 0) {
                                channel.setExpire(Integer.parseInt(expire));
                            }
                            if (StringUtils.isNotEmpty((CharSequence)(packetDelay = parser.getAttributeValue("", "packet-delay")))) {
                                channel.setPacketDelay(Integer.parseInt(packetDelay));
                            }
                            if ((host = parser.getAttributeValue("", "host")) != null && host.length() != 0) {
                                channel.setHost(host);
                            }
                            if ((channelID = parser.getAttributeValue("", "id")) != null && channelID.length() != 0) {
                                channel.setID(channelID);
                            }
                            if ((initiator = parser.getAttributeValue("", "initiator")) != null && initiator.length() != 0) {
                                channel.setInitiator(Boolean.valueOf(initiator));
                            }
                            if ((lastN = parser.getAttributeValue("", "last-n")) != null && lastN.length() != 0) {
                                channel.setLastN(Integer.parseInt(lastN));
                            }
                            if (StringUtils.isNotEmpty((CharSequence)(simulcastMode = parser.getAttributeValue("", "simulcast-mode")))) {
                                channel.setSimulcastMode(SimulcastMode.fromString(simulcastMode));
                            }
                            if ((receivingSimulcastLayer = parser.getAttributeValue("", "receive-simulcast-layer")) != null && receivingSimulcastLayer.length() != 0) {
                                channel.setReceivingSimulcastLayer(Integer.parseInt(receivingSimulcastLayer));
                            }
                            if ((rtcpPort = parser.getAttributeValue("", "rtcpport")) != null && rtcpPort.length() != 0) {
                                channel.setRTCPPort(Integer.parseInt(rtcpPort));
                            }
                            if ((rtpLevelRelayType = parser.getAttributeValue("", "rtp-level-relay-type")) != null && rtpLevelRelayType.length() != 0) {
                                channel.setRTPLevelRelayType(rtpLevelRelayType);
                            }
                            if ((rtpPort = parser.getAttributeValue("", "rtpport")) == null || rtpPort.length() == 0) break;
                            channel.setRTPPort(Integer.parseInt(rtpPort));
                            break;
                        }
                        if ("channel-bundle".equals(name)) {
                            String bundleId = parser.getAttributeValue("", "id");
                            if (!StringUtils.isNotEmpty((CharSequence)bundleId)) break;
                            bundle = new ColibriConferenceIQ.ChannelBundle(bundleId);
                            break;
                        }
                        if ("rtcp-termination-strategy".equals(name)) {
                            rtcpTerminationStrategy = new ColibriConferenceIQ.RTCPTerminationStrategy();
                            String strategyName = parser.getAttributeValue("", "name");
                            if (strategyName == null || strategyName.length() == 0) break;
                            rtcpTerminationStrategy.setName(strategyName);
                            break;
                        }
                        if ("relay".equals(name)) {
                            id = parser.getAttributeValue("", "id");
                            if (id == null || !(channel instanceof ColibriConferenceIQ.OctoChannel)) break;
                            ((ColibriConferenceIQ.OctoChannel)channel).addRelay(id);
                            break;
                        }
                        if ("ssrc".equals(name)) {
                            ssrc = new StringBuilder();
                            break;
                        }
                        if ("content".equals(name)) {
                            content = new ColibriConferenceIQ.Content();
                            String contentName = parser.getAttributeValue("", "name");
                            if (contentName == null || contentName.length() == 0) break;
                            content.setName(contentName);
                            break;
                        }
                        if ("recording".equals(name)) {
                            String stateStr = parser.getAttributeValue("", "state");
                            String token = parser.getAttributeValue("", "token");
                            recording = new ColibriConferenceIQ.Recording(stateStr, token);
                            break;
                        }
                        if ("sctpconnection".equals(name)) {
                            String expire;
                            String initiator;
                            String port;
                            String endpoint = parser.getAttributeValue("", "endpoint");
                            String connID = parser.getAttributeValue("", "id");
                            if (StringUtils.isEmpty((CharSequence)connID) && StringUtils.isEmpty((CharSequence)endpoint)) {
                                sctpConnection = null;
                                break;
                            }
                            sctpConnection = new ColibriConferenceIQ.SctpConnection();
                            if (StringUtils.isNotEmpty((CharSequence)connID)) {
                                sctpConnection.setID(connID);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)endpoint)) {
                                sctpConnection.setEndpoint(endpoint);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)(port = parser.getAttributeValue("", "port")))) {
                                sctpConnection.setPort(Integer.parseInt(port));
                            }
                            if (StringUtils.isNotEmpty((CharSequence)(channelBundleId = parser.getAttributeValue("", "channel-bundle-id")))) {
                                sctpConnection.setChannelBundleId(channelBundleId);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)(initiator = parser.getAttributeValue("", "initiator")))) {
                                sctpConnection.setInitiator(Boolean.valueOf(initiator));
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)(expire = parser.getAttributeValue("", "expire")))) break;
                            sctpConnection.setExpire(Integer.parseInt(expire));
                            break;
                        }
                        if ("endpoint".equals(name)) {
                            id = parser.getAttributeValue("", "id");
                            String displayName = parser.getAttributeValue("", "displayname");
                            String statsId = parser.getAttributeValue("", "stats-id");
                            if (!StringUtils.isNotEmpty((CharSequence)id)) break;
                            conferenceEndpoint = new ColibriConferenceIQ.Endpoint(id, statsId, displayName);
                            break;
                        }
                        if (channel == null && sctpConnection == null && bundle == null) break;
                        String peName = null;
                        String peNamespace = null;
                        if ("transport".equals(name) && "urn:xmpp:jingle:transports:ice-udp:1".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:transports:ice-udp:1";
                        } else if ("payload-type".equals(name)) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("rtcp-fb".equals(name) && "urn:xmpp:jingle:apps:rtp:rtcp-fb:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("rtp-hdrext".equals(name)) {
                            peName = name;
                            peNamespace = namespace;
                        } else if ("transport".equals(name) && "urn:xmpp:jingle:transports:raw-udp:1".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:transports:raw-udp:1";
                        } else if ("source".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        } else if ("ssrc-group".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        } else if ("rid-group".equals(name) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(parser.getNamespace())) {
                            peName = name;
                            peNamespace = "urn:xmpp:jingle:apps:rtp:ssma:0";
                        }
                        if (peName == null) {
                            this.throwAway(parser, name);
                            break;
                        }
                        ExtensionElement extension = this.parseExtension(parser, peName, peNamespace);
                        if (extension == null) break;
                        if (channel != null) {
                            this.addChildExtension(channel, extension);
                            break;
                        }
                        if (sctpConnection != null) {
                            this.addChildExtension(sctpConnection, extension);
                            break;
                        }
                        this.addChildExtension(bundle, extension);
                        break;
                    }
                    case TEXT_CHARACTERS: {
                        if (ssrc == null) break;
                        ssrc.append(parser.getText());
                    }
                }
            }
            iq = conference;
        } else {
            iq = null;
        }
        return iq;
    }

    private void throwAway(XmlPullParser parser, String name) throws XmlPullParserException, IOException, SmackParsingException {
        while (XmlPullParser.Event.END_ELEMENT != parser.next() || !name.equals(parser.getName())) {
        }
    }
}

