/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import java.awt.Rectangle;
import java.util.Iterator;
import org.flexdock.docking.state.FloatingGroup;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.flexdock.perspective.persist.xml.SerializerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FloatingGroupSerializer
implements ISerializer {
    public Element serialize(Document document, Object object) {
        FloatingGroup floatingGroup = (FloatingGroup)object;
        Element floatingGroupElement = document.createElement("FloatingGroup");
        floatingGroupElement.setAttribute("name", floatingGroup.getName());
        ISerializer rectangleSerializer = SerializerRegistry.getSerializer(Rectangle.class);
        Element rectangleElement = rectangleSerializer.serialize(document, floatingGroup.getBounds());
        floatingGroupElement.appendChild(rectangleElement);
        Iterator it = floatingGroup.getDockableIterator();
        while (it.hasNext()) {
            String dockableId = (String)it.next();
            Element dockableElement = document.createElement("Dockable");
            dockableElement.setAttribute("id", dockableId);
            floatingGroupElement.appendChild(dockableElement);
        }
        return floatingGroupElement;
    }

    public Object deserialize(Element element) {
        Node rectangleNode;
        String floatingGroupName = element.getAttribute("name");
        ISerializer rectangleSerializer = SerializerRegistry.getSerializer(Rectangle.class);
        FloatingGroup floatingGroup = new FloatingGroup(floatingGroupName);
        NodeList rectangleNodeList = element.getElementsByTagName("Rectangle");
        if (rectangleNodeList.getLength() > 0 && rectangleNodeList.item(0) instanceof Element && (rectangleNode = rectangleNodeList.item(0)) instanceof Element) {
            Element rectangleElement = (Element)rectangleNode;
            Rectangle rectangle = (Rectangle)rectangleSerializer.deserialize(rectangleElement);
            floatingGroup.setBounds(rectangle);
        }
        NodeList dockableNodeList = element.getElementsByTagName("Dockable");
        for (int i = 0; i < dockableNodeList.getLength(); ++i) {
            Node dockableNode = dockableNodeList.item(i);
            if (!(dockableNode instanceof Element)) continue;
            Element dockableElement = (Element)dockableNode;
            String dockableId = dockableElement.getAttribute("id");
            floatingGroup.addDockable(dockableId);
        }
        return floatingGroup;
    }
}

