/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Errortype
implements Function {
    public ValueEval evaluate(ValueEval[] args, int srcCellRow, short srcCellCol) {
        try {
            OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
            return ErrorEval.NA;
        }
        catch (EvaluationException e) {
            int result = this.translateErrorCodeToErrorTypeValue(e.getErrorEval().getErrorCode());
            return new NumberEval(result);
        }
    }

    private int translateErrorCodeToErrorTypeValue(int errorCode) {
        switch (errorCode) {
            case 0: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 15: {
                return 3;
            }
            case 23: {
                return 4;
            }
            case 29: {
                return 5;
            }
            case 36: {
                return 6;
            }
            case 42: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Invalid error code (" + errorCode + ")");
    }
}

