/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;

public class GraphiteInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public GraphiteInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    protected int getHorSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 1 : 0;
    }

    protected int getVerSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 3 : 0;
    }

    protected boolean centerButtons() {
        return false;
    }

    public void paintBorder(Graphics g) {
        if (this.isActive()) {
            g.setColor(ColorHelper.darker(AbstractLookAndFeel.getWindowBorderColor(), 10.0));
        } else {
            g.setColor(ColorHelper.darker(AbstractLookAndFeel.getWindowInactiveBorderColor(), 10.0));
        }
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g, int x, int y, String title) {
        if (this.isMacStyleWindowDecoration()) {
            x += this.paintIcon(g, x, y) + 5;
        }
        Graphics2D g2D = (Graphics2D)g;
        ColorUIResource fc = AbstractLookAndFeel.getWindowTitleForegroundColor();
        if (fc.equals(Color.white)) {
            ColorUIResource bc = AbstractLookAndFeel.getWindowTitleColorDark();
            g2D.setColor(bc);
            JTattooUtilities.drawString(this.frame, g, title, x - 1, y - 1);
            g2D.setColor(ColorHelper.darker(bc, 30.0));
            JTattooUtilities.drawString(this.frame, g, title, x + 1, y + 1);
        }
        g.setColor(fc);
        JTattooUtilities.drawString(this.frame, g, title, x, y);
    }
}

