/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.util.RandomXY;

public class DrawnCircleGenerator
extends AbstractDrawnGenerator {
    private final RandomXY start;
    private final RandomXY end;
    private final RandomXY tl;
    private final RandomXY tr;
    private final RandomXY br;
    private final RandomXY bl;
    private final boolean forFill;

    public DrawnCircleGenerator() {
        this(false);
    }

    public DrawnCircleGenerator(boolean forFill) {
        this.forFill = forFill;
        this.start = new RandomXY(50.0, 2.0, 0.0, 20.0);
        this.end = new RandomXY(50.0, 2.0, 0.0, 20.0);
        this.tl = new RandomXY(0.0, 0.0);
        this.tr = new RandomXY(100.0, 0.0);
        this.br = new RandomXY(100.0, 100.0);
        this.bl = new RandomXY(0.0, 100.0);
    }

    public Shape generate(AffineTransform matrix) {
        GeneralPath circle = new GeneralPath();
        Point2D startAt = this.start.generate();
        Point2D endAt = this.forFill ? startAt : this.end.generate();
        Point2D tlAt = this.tl.generate();
        Point2D trAt = this.tr.generate();
        Point2D brAt = this.br.generate();
        Point2D blAt = this.bl.generate();
        double xBL = blAt.getX();
        double yBL = blAt.getY();
        double xBR = brAt.getX();
        double yBR = brAt.getY();
        double bottomX = xBL + (xBR - xBL) / 2.0;
        double bottomY = yBL + (yBR - yBL) / 2.0;
        double[] coords = new double[]{startAt.getX(), startAt.getY(), trAt.getX(), trAt.getY(), xBR, yBR, bottomX, bottomY, bottomX, bottomY, xBL, yBL, tlAt.getX(), tlAt.getY(), endAt.getX(), endAt.getY()};
        if (matrix != null) {
            matrix.transform(coords, 0, coords, 0, coords.length / 2);
        }
        CubicCurve2D.Double left = new CubicCurve2D.Double(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], coords[6], coords[7]);
        CubicCurve2D.Double right = new CubicCurve2D.Double(coords[8], coords[9], coords[10], coords[11], coords[12], coords[13], coords[14], coords[15]);
        circle.append(left, false);
        circle.append(right, false);
        return circle;
    }

    public RandomXY getTL() {
        return this.tl;
    }

    public RandomXY getBR() {
        return this.br;
    }

    public RandomXY getBL() {
        return this.bl;
    }

    public RandomXY getTR() {
        return this.tr;
    }
}

