/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceListUI;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.jvnet.substance.api.renderers.SubstanceRenderer;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceStripingUtils;

@SubstanceApi
@SubstanceRenderer
public class SubstanceDefaultComboBoxRenderer
extends SubstanceDefaultListCellRenderer {
    private JComboBox combo;

    public SubstanceDefaultComboBoxRenderer(JComboBox combo) {
        this.combo = combo;
        Insets ins = SubstanceSizeUtils.getListCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(combo));
        this.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent result = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        ListUI listUI = list.getUI();
        if (listUI instanceof SubstanceListUI) {
            SubstanceListUI ui = (SubstanceListUI)listUI;
            ComponentState state = ui.getCellState(index, result);
            ComponentState prevState = ui.getPrevCellState(index);
            if (index == -1) {
                boolean isEnabled = this.combo.isEnabled();
                if (isSelected && isEnabled) {
                    state = ComponentState.SELECTED;
                    prevState = ComponentState.SELECTED;
                }
                if (!isEnabled) {
                    state = ComponentState.DISABLED_UNSELECTED;
                    prevState = ComponentState.DISABLED_UNSELECTED;
                }
            }
            JComponent compForSchemeQuery = index == -1 ? this.combo : list;
            SubstanceColorScheme scheme = isSelected ? SubstanceColorSchemeUtilities.getColorScheme(compForSchemeQuery, ColorSchemeAssociationKind.HIGHLIGHT, state) : SubstanceColorSchemeUtilities.getColorScheme(compForSchemeQuery, state);
            Color color = SubstanceColorUtilities.getInterpolatedForegroundColor(compForSchemeQuery, Integer.valueOf(index), scheme, state, scheme, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
            result.setForeground(color);
            SubstanceStripingUtils.applyStripedBackground(this.combo, index, this);
        }
        result.setOpaque(!isSelected && index >= 0);
        result.setEnabled(this.combo.isEnabled());
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        if (this.getText() == null || this.getText().equals("")) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    public static class SubstanceUIResource
    extends SubstanceDefaultComboBoxRenderer
    implements UIResource {
        public SubstanceUIResource(JComboBox combo) {
            super(combo);
        }
    }
}

