# This file is run when the "Start a New Server" button is pressed in the
# Main Status window.  The server list is stored in $env(HOME)/.quirc/servers
# Each line in the serverlist file should have the following format:

# <NETWORK>/<ADDRESS>[:<PORT>][ <DESC NOT CONTAINING "/">]

# Networks beginning with - will appear at the top of the list (baring other
# networks with symbols in them) and will be automatically opened in the tree.

set servers ""
if { [file exists $env(HOME)/.quirc/servers] } {
    set inputfile [open $env(HOME)/.quirc/servers "RDONLY"]
    while { ![eof $inputfile] } {
	gets $inputfile theline
	if { $theline!="" } {
	    set network [lindex [split $theline "/"] 0]
            if { [lsearch -exact $servers "/$network"]==-1 } {
		lappend servers "/$network"
            }
	    lappend servers "/$theline"
        }
    }
    close $inputfile
}

toplevel .newserver
wm title .newserver "Server Selection"
wm geometry .newserver 600x400

Tree:create .newserver.tree -width 300 -height 300 -yscrollcommand {.newserver.tree_yscroll set}
scrollbar .newserver.tree_yscroll -orient vertical -command {.newserver.tree yview}
pack .newserver.tree -side left -expand 1 -fill both -padx 2
pack .newserver.tree_yscroll -side left -fill y

foreach server $servers {
    Tree:newitem .newserver.tree $server
}

foreach server $servers {
    if { [string range $server 0 1]=="/-" } {
	Tree:open .newserver.tree $server
    }
}
proc openallservers {} {
    global servers
    foreach server $servers {
	Tree:open .newserver.tree $server
    }
}

proc closeallservers {} {
    global servers
    foreach server $servers {
	Tree:close .newserver.tree $server
    }
}

#-Opens up the tree
#openallservers

.newserver.tree bind x <1> {
    set lbl [Tree:labelat %W %x %y]
    Tree:setselection %W $lbl
    .newserver.network delete 0 end
    .newserver.network insert 0 [lindex [split $lbl "/"] 1]
    .newserver.server delete 0 end
    .newserver.server insert 0 [lindex [split $lbl "/"] 2]
}

.newserver.tree bind x <B1-Motion> {
    set lbl [Tree:labelat %W %x %y]
    Tree:setselection %W $lbl
    .newserver.network delete 0 end
    .newserver.network insert 0 [lindex [split $lbl "/"] 1]
    .newserver.server delete 0 end
    .newserver.server insert 0 [lindex [split $lbl "/"] 2]
}

.newserver.tree bind x <Double-1> {
    newserver [lindex [split [.newserver.server get] " "] 0]
    destroy .newserver
}

bind .newserver <Escape> {destroy .newserver}

label .newserver.networklabel -text "Network:"
entry .newserver.network
label .newserver.serverlabel -text "Server:"
entry .newserver.server

pack .newserver.networklabel .newserver.network .newserver.serverlabel .newserver.server -padx 10 -pady 10

bind .newserver.server <<Enter>> {newserver [lindex [split [.newserver.server get] " "] 0]; destroy .newserver}

proc addthis {} {
    global servers
    set add 1
    set outputfile [open $::env(HOME)/.quirc/servers "WRONLY CREAT TRUNC"]
    foreach server $servers {
	if { $server=="/[.newserver.network get]/[.newserver.server get]" } {
	    set add 0
	}
	if { [string match "*/*" [string range $server 1 end]] } { puts $outputfile [string range $server 1 end] }
    }
    if { $add && [.newserver.network get]!="" && [.newserver.server get]!="" } {
	puts $outputfile "[.newserver.network get]/[.newserver.server get]"
	if { [lsearch -exact $servers "/[.newserver.network get]"]==-1 } {
	    lappend servers "/[.newserver.network get]"
	    Tree:newitem .newserver.tree "/[.newserver.network get]"
	}
        Tree:newitem .newserver.tree "/[.newserver.network get]/[.newserver.server get]"
        lappend servers "/[.newserver.network get]/[.newserver.server get]"
    }
    close $outputfile
    #openallservers
}

frame .newserver.frameaddremove
pack .newserver.frameaddremove -padx 10 -pady 10
button .newserver.frameaddremove.add -text "Add" -command addthis
button .newserver.frameaddremove.remove -text "Remove" -command removethis
pack .newserver.frameaddremove.add -side left
pack .newserver.frameaddremove.remove -side right

frame .newserver.frameopenclose
pack .newserver.frameopenclose -padx 10 -pady 10
button .newserver.frameopenclose.open -text "Open Tree" -command openallservers
button .newserver.frameopenclose.close -text "Close Tree" -command closeallservers
pack .newserver.frameopenclose.open -side left
pack .newserver.frameopenclose.close -side right

frame .newserver.frameokcancel
pack .newserver.frameokcancel -side bottom -padx 10 -pady 10
button .newserver.frameokcancel.ok -text "OK" -command {newserver [lindex [split [.newserver.server get] " "] 0]; destroy .newserver}
button .newserver.frameokcancel.cancel -text "Cancel" -command {destroy .newserver}
pack .newserver.frameokcancel.ok -side left
pack .newserver.frameokcancel.cancel -side right
focus .newserver.server

proc removethis {} {
    global servers
    set outputfile [open $::env(HOME)/.quirc/servers "WRONLY CREAT TRUNC"]
    foreach server $servers {
	if { $server!="/[.newserver.network get]/[.newserver.server get]" } {
	    if { [string match "*/*" [string range $server 1 end]] } { puts $outputfile [string range $server 1 end] }
	}
    }
    close $outputfile
    foreach server $servers {
	Tree:delitem .newserver.tree $server
    }
    set servers ""
    if { [file exists $::env(HOME)/.quirc/servers] } {
	set inputfile [open $::env(HOME)/.quirc/servers "RDONLY"]
	while { ![eof $inputfile] } {
	    gets $inputfile theline
	    if { $theline!="" } {
	    set network [lindex [split $theline "/"] 0]
		if { [lsearch -exact $servers "/$network"]==-1 } {
		    lappend servers "/$network"
		}
		lappend servers "/$theline"
	    }
	}
	close $inputfile
    }
    foreach server $servers {
	Tree:newitem .newserver.tree $server
    }
    #openallservers
}
