/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.archive;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.IteratorReader;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.web.Util;

public class ZipAnalyzer
extends FileAnalyzer {
    protected ZipAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(src.getStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                names.add(name);
                if (xrefOut == null) continue;
                Util.htmlize(name, (Appendable)xrefOut);
                xrefOut.append("<br/>");
            }
        }
        doc.add((IndexableField)new TextField("full", (Reader)new IteratorReader(names)));
    }
}

