/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri.json;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.RTPLevelRelayType;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class JSONSerializer {
    static final String CANDIDATE_LIST = "candidates";
    static final String CHANNEL_BUNDLES = "channel-bundles";
    static final String ENDPOINTS = "endpoints";
    static final String CHANNELS = "channels";
    static final String CONTENTS = "contents";
    static final String FINGERPRINTS = "fingerprints";
    static final String PARAMETERS = "parameters";
    static final String PAYLOAD_TYPES = "payload-types";
    static final String RTCP_FBS = "rtcp-fbs";
    static final String SCTP_CONNECTIONS = "sctpconnections";
    static final String SOURCE_GROUPS = "ssrc-groups";
    static final String SOURCES = "sources";
    static final String SSRCS = "ssrcs";
    static final String RTP_HEADER_EXTS = "rtp-hdrexts";
    static final String WEBSOCKET_LIST = "web-sockets";
    static final String XMLNS = "xmlns";

    public static void serializeAbstractPacketExtensionAttributes(AbstractPacketExtension abstractPacketExtension, JSONObject jsonObject) {
        for (String name : abstractPacketExtension.getAttributeNames()) {
            Object value2 = abstractPacketExtension.getAttribute(name);
            if (value2 instanceof Enum) {
                value2 = value2.toString();
            }
            jsonObject.put(name, value2);
        }
    }

    public static JSONObject serializeCandidate(CandidatePacketExtension candidate) {
        JSONObject candidateJSONObject;
        if (candidate == null) {
            candidateJSONObject = null;
        } else {
            candidateJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes(candidate, candidateJSONObject);
        }
        return candidateJSONObject;
    }

    public static JSONArray serializeCandidates(Collection<CandidatePacketExtension> candidates) {
        JSONArray candidatesJSONArray;
        if (candidates == null) {
            candidatesJSONArray = null;
        } else {
            candidatesJSONArray = new JSONArray();
            for (CandidatePacketExtension candidate : candidates) {
                candidatesJSONArray.add(JSONSerializer.serializeCandidate(candidate));
            }
        }
        return candidatesJSONArray;
    }

    public static JSONObject serializeChannel(ColibriConferenceIQ.Channel channel) {
        JSONObject jsonObject;
        if (channel == null) {
            jsonObject = null;
        } else {
            String direction = channel.getDirection();
            Integer lastN = channel.getLastN();
            List<PayloadTypePacketExtension> payloadTypes = channel.getPayloadTypes();
            Collection<RTPHdrExtPacketExtension> rtpHdrExts = channel.getRtpHeaderExtensions();
            Integer receivingSimulcastStream = channel.getReceivingSimulcastLayer();
            RTPLevelRelayType rtpLevelRelayType = channel.getRTPLevelRelayType();
            List<SourcePacketExtension> sources = channel.getSources();
            List<SourceGroupPacketExtension> sourceGroups = channel.getSourceGroups();
            int[] ssrcs2 = channel.getSSRCs();
            jsonObject = JSONSerializer.serializeChannelCommon(channel);
            if (direction != null) {
                jsonObject.put("direction", direction);
            }
            if (lastN != null) {
                jsonObject.put("last-n", lastN);
            }
            if (lastN != null) {
                jsonObject.put("receive-simulcast-layer", receivingSimulcastStream);
            }
            if (payloadTypes != null && !payloadTypes.isEmpty()) {
                jsonObject.put(PAYLOAD_TYPES, JSONSerializer.serializePayloadTypes(payloadTypes));
            }
            if (rtpHdrExts != null && !rtpHdrExts.isEmpty()) {
                jsonObject.put(RTP_HEADER_EXTS, JSONSerializer.serializeRtpHdrExts(rtpHdrExts));
            }
            if (rtpLevelRelayType != null) {
                jsonObject.put("rtp-level-relay-type", rtpLevelRelayType.toString());
            }
            if (sources != null && !sources.isEmpty()) {
                jsonObject.put(SOURCES, JSONSerializer.serializeSources(sources));
            }
            if (sourceGroups != null && !sourceGroups.isEmpty()) {
                jsonObject.put(SOURCE_GROUPS, JSONSerializer.serializeSourceGroups(sourceGroups));
            }
            if (ssrcs2 != null && ssrcs2.length > 0) {
                jsonObject.put(SSRCS, JSONSerializer.serializeSSRCs(ssrcs2));
            }
        }
        return jsonObject;
    }

    public static JSONObject serializeChannelBundle(ColibriConferenceIQ.ChannelBundle channelBundle) {
        JSONObject jsonObject;
        if (channelBundle == null) {
            jsonObject = null;
        } else {
            String id = channelBundle.getId();
            IceUdpTransportPacketExtension transport = channelBundle.getTransport();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put("id", id);
            }
            if (transport != null) {
                jsonObject.put(transport.getElementName(), JSONSerializer.serializeTransport(transport));
            }
        }
        return jsonObject;
    }

    public static JSONObject serializeEndpoint(ColibriConferenceIQ.Endpoint endpoint) {
        JSONObject jsonObject;
        if (endpoint == null) {
            jsonObject = null;
        } else {
            String id = endpoint.getId();
            String statsId = endpoint.getStatsId();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put("id", id);
            }
            if (statsId != null) {
                jsonObject.put("stats-id", statsId);
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeChannelBundles(Collection<ColibriConferenceIQ.ChannelBundle> channelBundles) {
        JSONArray jsonArray;
        if (channelBundles == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.ChannelBundle channelBundle : channelBundles) {
                jsonArray.add(JSONSerializer.serializeChannelBundle(channelBundle));
            }
        }
        return jsonArray;
    }

    public static JSONArray serializeEndpoints(Collection<ColibriConferenceIQ.Endpoint> endpoints) {
        JSONArray jsonArray;
        if (endpoints == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.Endpoint endpoint : endpoints) {
                jsonArray.add(JSONSerializer.serializeEndpoint(endpoint));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeChannelCommon(ColibriConferenceIQ.ChannelCommon channelCommon) {
        JSONObject jsonObject;
        if (channelCommon == null) {
            jsonObject = null;
        } else {
            String id = channelCommon.getID();
            String channelBundleId = channelCommon.getChannelBundleId();
            String endpoint = channelCommon.getEndpoint();
            int expire = channelCommon.getExpire();
            Boolean initiator = channelCommon.isInitiator();
            IceUdpTransportPacketExtension transport = channelCommon.getTransport();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put("id", id);
            }
            if (channelBundleId != null) {
                jsonObject.put("channel-bundle-id", channelBundleId);
            }
            if (endpoint != null) {
                jsonObject.put("endpoint", endpoint);
            }
            if (expire >= 0) {
                jsonObject.put("expire", expire);
            }
            if (initiator != null) {
                jsonObject.put("initiator", initiator);
            }
            if (transport != null) {
                jsonObject.put(transport.getElementName(), JSONSerializer.serializeTransport(transport));
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeChannels(Collection<ColibriConferenceIQ.Channel> collection) {
        JSONArray jsonArray;
        if (collection == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.Channel element : collection) {
                jsonArray.add(JSONSerializer.serializeChannel(element));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeConference(ColibriConferenceIQ conference) {
        JSONObject jsonObject;
        if (conference == null) {
            jsonObject = null;
        } else {
            String id = conference.getID();
            List<ColibriConferenceIQ.Content> contents = conference.getContents();
            List<ColibriConferenceIQ.ChannelBundle> channelBundles = conference.getChannelBundles();
            List<ColibriConferenceIQ.Endpoint> endpoints = conference.getEndpoints();
            boolean isGracefulShutdown = conference.isGracefulShutdown();
            jsonObject = new JSONObject();
            if (id != null) {
                jsonObject.put("id", id);
            }
            if (contents != null && !contents.isEmpty()) {
                jsonObject.put(CONTENTS, JSONSerializer.serializeContents(contents));
            }
            if (channelBundles != null && !channelBundles.isEmpty()) {
                jsonObject.put(CHANNEL_BUNDLES, JSONSerializer.serializeChannelBundles(channelBundles));
            }
            if (endpoints != null && !endpoints.isEmpty()) {
                jsonObject.put(ENDPOINTS, JSONSerializer.serializeEndpoints(endpoints));
            }
            if (isGracefulShutdown) {
                jsonObject.put("graceful-shutdown", "true");
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeConferences(Collection<ColibriConferenceIQ> conferences) {
        JSONArray conferencesJSONArray;
        if (conferences == null) {
            conferencesJSONArray = null;
        } else {
            conferencesJSONArray = new JSONArray();
            for (ColibriConferenceIQ conference : conferences) {
                conferencesJSONArray.add(JSONSerializer.serializeConference(conference));
            }
        }
        return conferencesJSONArray;
    }

    public static JSONObject serializeContent(ColibriConferenceIQ.Content content) {
        JSONObject jsonObject;
        if (content == null) {
            jsonObject = null;
        } else {
            String name = content.getName();
            List<ColibriConferenceIQ.Channel> channels = content.getChannels();
            List<ColibriConferenceIQ.SctpConnection> sctpConnections = content.getSctpConnections();
            jsonObject = new JSONObject();
            if (name != null) {
                jsonObject.put("name", name);
            }
            if (channels != null && !channels.isEmpty()) {
                jsonObject.put(CHANNELS, JSONSerializer.serializeChannels(channels));
            }
            if (sctpConnections != null && !sctpConnections.isEmpty()) {
                jsonObject.put(SCTP_CONNECTIONS, JSONSerializer.serializeSctpConnections(sctpConnections));
            }
        }
        return jsonObject;
    }

    public static JSONArray serializeContents(Collection<ColibriConferenceIQ.Content> contents) {
        JSONArray jsonArray;
        if (contents == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.Content content : contents) {
                jsonArray.add(JSONSerializer.serializeContent(content));
            }
        }
        return jsonArray;
    }

    public static JSONObject serializeFingerprint(DtlsFingerprintPacketExtension fingerprint) {
        JSONObject fingerprintJSONObject;
        if (fingerprint == null) {
            fingerprintJSONObject = null;
        } else {
            String theFingerprint = fingerprint.getFingerprint();
            fingerprintJSONObject = new JSONObject();
            if (theFingerprint != null) {
                fingerprintJSONObject.put(fingerprint.getElementName(), theFingerprint);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes(fingerprint, fingerprintJSONObject);
        }
        return fingerprintJSONObject;
    }

    public static JSONArray serializeFingerprints(Collection<DtlsFingerprintPacketExtension> fingerprints) {
        JSONArray fingerprintsJSONArray;
        if (fingerprints == null) {
            fingerprintsJSONArray = null;
        } else {
            fingerprintsJSONArray = new JSONArray();
            for (DtlsFingerprintPacketExtension fingerprint : fingerprints) {
                fingerprintsJSONArray.add(JSONSerializer.serializeFingerprint(fingerprint));
            }
        }
        return fingerprintsJSONArray;
    }

    public static JSONObject serializeParameters(Collection<ParameterPacketExtension> parameters2) {
        JSONObject parametersJSONObject;
        if (parameters2 == null) {
            parametersJSONObject = null;
        } else {
            parametersJSONObject = new JSONObject();
            for (ParameterPacketExtension parameter : parameters2) {
                String name = parameter.getName();
                String value2 = parameter.getValue();
                if (name == null && value2 == null) continue;
                parametersJSONObject.put(name, value2);
            }
        }
        return parametersJSONObject;
    }

    public static JSONArray serializeRtcpFbs(@NotNull Collection<RtcpFbPacketExtension> rtcpFbs) {
        JSONArray rtcpFbsJSON = new JSONArray();
        for (RtcpFbPacketExtension ext : rtcpFbs) {
            String type2 = ext.getFeedbackType();
            String subtype = ext.getFeedbackSubtype();
            if (type2 == null) continue;
            JSONObject rtcpFbJSON = new JSONObject();
            rtcpFbJSON.put("type", type2);
            if (subtype != null) {
                rtcpFbJSON.put("subtype", subtype);
            }
            rtcpFbsJSON.add(rtcpFbJSON);
        }
        return rtcpFbsJSON;
    }

    public static JSONObject serializePayloadType(PayloadTypePacketExtension payloadType) {
        JSONObject payloadTypeJSONObject;
        if (payloadType == null) {
            payloadTypeJSONObject = null;
        } else {
            List<RtcpFbPacketExtension> rtcpFeedbackTypeList;
            List<ParameterPacketExtension> parameters2 = payloadType.getParameters();
            payloadTypeJSONObject = new JSONObject();
            JSONSerializer.serializeAbstractPacketExtensionAttributes(payloadType, payloadTypeJSONObject);
            if (parameters2 != null && !parameters2.isEmpty()) {
                payloadTypeJSONObject.put(PARAMETERS, JSONSerializer.serializeParameters(parameters2));
            }
            if ((rtcpFeedbackTypeList = payloadType.getRtcpFeedbackTypeList()) != null && !rtcpFeedbackTypeList.isEmpty()) {
                payloadTypeJSONObject.put(RTCP_FBS, JSONSerializer.serializeRtcpFbs(rtcpFeedbackTypeList));
            }
        }
        return payloadTypeJSONObject;
    }

    public static JSONArray serializePayloadTypes(Collection<PayloadTypePacketExtension> payloadTypes) {
        JSONArray payloadTypesJSONArray;
        if (payloadTypes == null) {
            payloadTypesJSONArray = null;
        } else {
            payloadTypesJSONArray = new JSONArray();
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                payloadTypesJSONArray.add(JSONSerializer.serializePayloadType(payloadType));
            }
        }
        return payloadTypesJSONArray;
    }

    public static JSONObject serializeRtpHdrExt(RTPHdrExtPacketExtension rtpHdrExt) {
        JSONObject rtpHdrExtJSONObject;
        if (rtpHdrExt == null) {
            rtpHdrExtJSONObject = null;
        } else {
            String attributes;
            ContentPacketExtension.SendersEnum senders;
            URI uri;
            rtpHdrExtJSONObject = new JSONObject();
            String id = rtpHdrExt.getID();
            if (id != null) {
                rtpHdrExtJSONObject.put("id", Long.valueOf(id));
            }
            if ((uri = rtpHdrExt.getURI()) != null) {
                rtpHdrExtJSONObject.put("uri", uri.toString());
            }
            if ((senders = rtpHdrExt.getSenders()) != null) {
                rtpHdrExtJSONObject.put("senders", senders.toString());
            }
            if ((attributes = rtpHdrExt.getAttributes()) != null) {
                rtpHdrExtJSONObject.put("attributes", attributes);
            }
        }
        return rtpHdrExtJSONObject;
    }

    public static JSONArray serializeRtpHdrExts(Collection<RTPHdrExtPacketExtension> rtpHdrExts) {
        JSONArray rtpHdrExtsJSONArray;
        if (rtpHdrExts == null) {
            rtpHdrExtsJSONArray = null;
        } else {
            rtpHdrExtsJSONArray = new JSONArray();
            for (RTPHdrExtPacketExtension rtpHdrExt : rtpHdrExts) {
                rtpHdrExtsJSONArray.add(JSONSerializer.serializeRtpHdrExt(rtpHdrExt));
            }
        }
        return rtpHdrExtsJSONArray;
    }

    public static JSONObject serializeSctpConnection(ColibriConferenceIQ.SctpConnection sctpConnection) {
        JSONObject jsonObject;
        if (sctpConnection == null) {
            jsonObject = null;
        } else {
            int port2 = sctpConnection.getPort();
            jsonObject = JSONSerializer.serializeChannelCommon(sctpConnection);
            jsonObject.put("port", port2);
        }
        return jsonObject;
    }

    public static JSONArray serializeSctpConnections(Collection<ColibriConferenceIQ.SctpConnection> collection) {
        JSONArray jsonArray;
        if (collection == null) {
            jsonArray = null;
        } else {
            jsonArray = new JSONArray();
            for (ColibriConferenceIQ.SctpConnection element : collection) {
                jsonArray.add(JSONSerializer.serializeSctpConnection(element));
            }
        }
        return jsonArray;
    }

    public static Object serializeSource(SourcePacketExtension source) {
        if (source == null) {
            return null;
        }
        String name = source.getName();
        String videoType = source.getVideoType();
        String rid = source.getRid();
        List<ParameterPacketExtension> parameters2 = source.getParameters();
        if (name == null && rid == null && parameters2.isEmpty()) {
            return source.getSSRC();
        }
        JSONObject sourceJSONObject = new JSONObject();
        sourceJSONObject.put("ssrc", source.getSSRC());
        if (name != null) {
            sourceJSONObject.put("name", name);
        }
        if (videoType != null) {
            sourceJSONObject.put("videoType", videoType);
        }
        if (rid != null) {
            sourceJSONObject.put("rid", rid);
        }
        if (!parameters2.isEmpty()) {
            sourceJSONObject.put(PARAMETERS, JSONSerializer.serializeParameters(parameters2));
        }
        return sourceJSONObject;
    }

    private static Object serializeSourceGroup(SourceGroupPacketExtension sourceGroup) {
        if (sourceGroup.getSemantics() != null && sourceGroup.getSemantics().length() != 0 && sourceGroup.getSources() != null && sourceGroup.getSources().size() != 0) {
            JSONObject sourceGroupJSONObject = new JSONObject();
            sourceGroupJSONObject.put("semantics", JSONValue.escape(sourceGroup.getSemantics()));
            JSONArray ssrcsJSONArray = new JSONArray();
            for (SourcePacketExtension source : sourceGroup.getSources()) {
                ssrcsJSONArray.add(source.getSSRC());
            }
            sourceGroupJSONObject.put(SOURCES, ssrcsJSONArray);
            return sourceGroupJSONObject;
        }
        return null;
    }

    public static JSONArray serializeSourceGroups(Collection<SourceGroupPacketExtension> sourceGroups) {
        JSONArray sourceGroupsJSONArray;
        if (sourceGroups == null || sourceGroups.size() == 0) {
            sourceGroupsJSONArray = null;
        } else {
            sourceGroupsJSONArray = new JSONArray();
            for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
                sourceGroupsJSONArray.add(JSONSerializer.serializeSourceGroup(sourceGroup));
            }
        }
        return sourceGroupsJSONArray;
    }

    public static JSONArray serializeSources(Collection<SourcePacketExtension> sources) {
        JSONArray sourcesJSONArray;
        if (sources == null) {
            sourcesJSONArray = null;
        } else {
            sourcesJSONArray = new JSONArray();
            for (SourcePacketExtension source : sources) {
                sourcesJSONArray.add(JSONSerializer.serializeSource(source));
            }
        }
        return sourcesJSONArray;
    }

    public static JSONArray serializeSSRCs(int[] ssrcs2) {
        JSONArray ssrcsJSONArray;
        if (ssrcs2 == null) {
            ssrcsJSONArray = null;
        } else {
            ssrcsJSONArray = new JSONArray();
            for (int i = 0; i < ssrcs2.length; ++i) {
                ssrcsJSONArray.add((long)ssrcs2[i] & 0xFFFFFFFFL);
            }
        }
        return ssrcsJSONArray;
    }

    public static JSONObject serializeTransport(IceUdpTransportPacketExtension transport) {
        JSONObject jsonObject;
        if (transport == null) {
            jsonObject = null;
        } else {
            String xmlns = transport.getNamespace();
            List<DtlsFingerprintPacketExtension> fingerprints = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            List<CandidatePacketExtension> candidateList = transport.getCandidateList();
            List<WebSocketPacketExtension> webSocketList = transport.getChildExtensionsOfType(WebSocketPacketExtension.class);
            RemoteCandidatePacketExtension remoteCandidate = transport.getRemoteCandidate();
            boolean rtcpMux = transport.isRtcpMux();
            jsonObject = new JSONObject();
            if (xmlns != null) {
                jsonObject.put(XMLNS, xmlns);
            }
            JSONSerializer.serializeAbstractPacketExtensionAttributes(transport, jsonObject);
            if (fingerprints != null && !fingerprints.isEmpty()) {
                jsonObject.put(FINGERPRINTS, JSONSerializer.serializeFingerprints(fingerprints));
            }
            if (candidateList != null && !candidateList.isEmpty()) {
                jsonObject.put(CANDIDATE_LIST, JSONSerializer.serializeCandidates(candidateList));
            }
            if (remoteCandidate != null) {
                jsonObject.put(remoteCandidate.getElementName(), JSONSerializer.serializeCandidate(remoteCandidate));
            }
            if (webSocketList != null && !webSocketList.isEmpty()) {
                jsonObject.put(WEBSOCKET_LIST, JSONSerializer.serializeWebSockets(webSocketList));
            }
            if (rtcpMux) {
                jsonObject.put("rtcp-mux", Boolean.TRUE);
            }
        }
        return jsonObject;
    }

    private static String serializeWebSocket(WebSocketPacketExtension webSocket) {
        if (webSocket.getActive()) {
            return "active";
        }
        return webSocket.getUrl();
    }

    private static JSONArray serializeWebSockets(List<WebSocketPacketExtension> webSocketList) {
        JSONArray webSocketsJSONArray;
        if (webSocketList == null) {
            webSocketsJSONArray = null;
        } else {
            webSocketsJSONArray = new JSONArray();
            for (WebSocketPacketExtension webSocket : webSocketList) {
                webSocketsJSONArray.add(JSONSerializer.serializeWebSocket(webSocket));
            }
        }
        return webSocketsJSONArray;
    }

    private JSONSerializer() {
    }
}

