/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat2;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.IncomingChatMessageListener;
import org.jivesoftware.smack.chat2.OutgoingChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ToTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smackx.xhtmlim.packet.XHTMLExtension;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class ChatManager
extends Manager {
    private static final Map<XMPPConnection, ChatManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatManager>();
    private static final StanzaFilter MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_CHAT, new OrFilter(new StanzaFilter[]{MessageWithBodiesFilter.INSTANCE, new StanzaExtensionFilter("html", "http://jabber.org/protocol/xhtml-im")})});
    private static final StanzaFilter OUTGOING_MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MESSAGE_FILTER, ToTypeFilter.ENTITY_FULL_OR_BARE_JID});
    private static final StanzaFilter INCOMING_MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MESSAGE_FILTER, FromTypeFilter.ENTITY_FULL_JID});
    private final Map<EntityBareJid, Chat> chats = new ConcurrentHashMap<EntityBareJid, Chat>();
    private final Set<IncomingChatMessageListener> incomingListeners = new CopyOnWriteArraySet<IncomingChatMessageListener>();
    private final Set<OutgoingChatMessageListener> outgoingListeners = new CopyOnWriteArraySet<OutgoingChatMessageListener>();
    private final AsyncButOrdered<Chat> asyncButOrdered = new AsyncButOrdered();
    private boolean xhtmlIm;

    public static synchronized ChatManager getInstanceFor(XMPPConnection connection) {
        ChatManager chatManager = INSTANCES.get(connection);
        if (chatManager == null) {
            chatManager = new ChatManager(connection);
            INSTANCES.put(connection, chatManager);
        }
        return chatManager;
    }

    private ChatManager(XMPPConnection connection) {
        super(connection);
        connection.addSyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                final Message message = (Message)stanza;
                if (!ChatManager.this.shouldAcceptMessage((MessageView)message)) {
                    return;
                }
                Jid from = message.getFrom();
                EntityFullJid fullFrom = from.asEntityFullJidOrThrow();
                final EntityBareJid bareFrom = fullFrom.asEntityBareJid();
                final Chat chat = ChatManager.this.chatWith(bareFrom);
                chat.lockedResource = fullFrom;
                ChatManager.this.asyncButOrdered.performAsyncButOrdered((Object)chat, new Runnable(){

                    @Override
                    public void run() {
                        for (IncomingChatMessageListener listener : ChatManager.this.incomingListeners) {
                            listener.newIncomingMessage(bareFrom, message, chat);
                        }
                    }
                });
            }
        }, INCOMING_MESSAGE_FILTER);
        connection.addMessageInterceptor(messageBuilder -> {
            if (!this.shouldAcceptMessage((MessageView)messageBuilder)) {
                return;
            }
            EntityBareJid to = messageBuilder.getTo().asEntityBareJidOrThrow();
            Chat chat = this.chatWith(to);
            for (OutgoingChatMessageListener listener : this.outgoingListeners) {
                listener.newOutgoingMessage(to, (MessageBuilder)messageBuilder, chat);
            }
        }, m -> OUTGOING_MESSAGE_FILTER.accept((Stanza)m));
        Roster roster = Roster.getInstanceFor((XMPPConnection)connection);
        roster.addRosterListener((RosterListener)new AbstractRosterListener(){

            public void presenceChanged(Presence presence) {
                Jid from = presence.getFrom();
                EntityBareJid bareFrom = from.asEntityBareJidIfPossible();
                if (bareFrom == null) {
                    return;
                }
                Chat chat = (Chat)((Object)ChatManager.this.chats.get(bareFrom));
                if (chat == null) {
                    return;
                }
                if (chat.lockedResource == null) {
                    return;
                }
                EntityFullJid fullFrom = from.asEntityFullJidIfPossible();
                if (chat.lockedResource.equals((CharSequence)fullFrom)) {
                    return;
                }
                if (chat.lastPresenceOfLockedResource == null) {
                    chat.lastPresenceOfLockedResource = presence;
                    return;
                }
                if (chat.lastPresenceOfLockedResource.getMode() != presence.getMode() || chat.lastPresenceOfLockedResource.getType() != presence.getType()) {
                    chat.unlockResource();
                }
            }
        });
    }

    private boolean shouldAcceptMessage(MessageView message) {
        if (message.hasExtension(Message.Body.QNAME)) {
            return true;
        }
        if (!this.xhtmlIm) {
            return false;
        }
        XHTMLExtension xhtmlExtension = XHTMLExtension.from(message);
        return xhtmlExtension != null;
    }

    public boolean addIncomingListener(IncomingChatMessageListener listener) {
        return this.incomingListeners.add(listener);
    }

    public boolean removeIncomingListener(IncomingChatMessageListener listener) {
        return this.incomingListeners.remove(listener);
    }

    public boolean addOutgoingListener(OutgoingChatMessageListener listener) {
        return this.outgoingListeners.add(listener);
    }

    public boolean removeOutgoingListener(OutgoingChatMessageListener listener) {
        return this.outgoingListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chat chatWith(EntityBareJid jid) {
        Chat chat = this.chats.get(jid);
        if (chat == null) {
            Map<EntityBareJid, Chat> map = this.chats;
            synchronized (map) {
                chat = this.chats.get(jid);
                if (chat != null) {
                    return chat;
                }
                chat = new Chat(this.connection(), jid);
                this.chats.put(jid, chat);
            }
        }
        return chat;
    }

    public void setXhmtlImEnabled(boolean xhtmlIm) {
        this.xhtmlIm = xhtmlIm;
    }
}

