/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SocketFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;

public class StandardSocketFactory
implements SocketFactory {
    protected String host = null;
    protected int port = 3306;
    protected Socket rawSocket = null;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$net$InetAddress;

    public Socket afterHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket connect(String hostname, int portNumber, Properties props) throws SocketException, IOException {
        if (props != null) {
            this.host = hostname;
            this.port = portNumber;
            boolean hasConnectTimeoutMethod = false;
            Method connectWithTimeoutMethod = null;
            try {
                Class<?> socketAddressClass = Class.forName("java.net.SocketAddress");
                connectWithTimeoutMethod = (class$java$net$Socket == null ? (class$java$net$Socket = StandardSocketFactory.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", socketAddressClass, Integer.TYPE);
                hasConnectTimeoutMethod = true;
            }
            catch (NoClassDefFoundError noClassDefFound) {
                hasConnectTimeoutMethod = false;
            }
            catch (NoSuchMethodException noSuchMethodEx) {
                hasConnectTimeoutMethod = false;
            }
            catch (Throwable catchAll) {
                hasConnectTimeoutMethod = false;
            }
            int connectTimeout = 0;
            String connectTimeoutStr = props.getProperty("connectTimeout");
            if (connectTimeoutStr != null) {
                try {
                    connectTimeout = Integer.parseInt(connectTimeoutStr);
                }
                catch (NumberFormatException nfe) {
                    throw new SocketException("Illegal value '" + connectTimeoutStr + "' for connectTimeout");
                }
            }
            if (this.host != null) {
                if (!hasConnectTimeoutMethod || connectTimeout == 0) {
                    InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                    Exception caughtWhileConnecting = null;
                    for (int i = 0; i < possibleAddresses.length; ++i) {
                        try {
                            this.rawSocket = new Socket(possibleAddresses[i], this.port);
                            break;
                        }
                        catch (Exception ex) {
                            caughtWhileConnecting = ex;
                            continue;
                        }
                    }
                    if (this.rawSocket == null) {
                        throw new SocketException(caughtWhileConnecting.toString());
                    }
                } else {
                    try {
                        Class<?> inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                        Constructor<?> addrConstructor = inetSocketAddressClass.getConstructor(class$java$net$InetAddress == null ? (class$java$net$InetAddress = StandardSocketFactory.class$("java.net.InetAddress")) : class$java$net$InetAddress, Integer.TYPE);
                        InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                        Throwable caughtWhileConnecting = null;
                        for (int i = 0; i < possibleAddresses.length; ++i) {
                            try {
                                Object sockAddr = addrConstructor.newInstance(possibleAddresses[i], new Integer(this.port));
                                this.rawSocket = new Socket();
                                connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(connectTimeout));
                                break;
                            }
                            catch (Exception ex) {
                                this.rawSocket = null;
                                caughtWhileConnecting = ex;
                                continue;
                            }
                        }
                        if (this.rawSocket == null) {
                            throw new SocketException(caughtWhileConnecting.toString());
                        }
                    }
                    catch (Throwable t) {
                        if (!(t instanceof SocketException)) {
                            throw new SocketException(t.toString());
                        }
                        throw (SocketException)t;
                    }
                }
                try {
                    this.rawSocket.setTcpNoDelay(true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return this.rawSocket;
            }
        }
        throw new SocketException("Unable to create socket");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

