/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management;

import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opensolaris.opengrok.Info;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.management.ManagementMBean;

public final class Management
implements ManagementMBean,
MBeanRegistration {
    private static Management managementInstance = null;
    private static final Logger log = Logger.getLogger("org.opensolaris.opengrok");
    private final Properties ogaProperties;
    private final long startTime;
    private Boolean update = Boolean.FALSE;
    private Integer noThreads = 1;
    private String[] subFiles = new String[0];
    private String configurationFile = null;
    private String publishHost = null;

    private Management(Properties ogaProperties) {
        this.startTime = System.currentTimeMillis();
        this.ogaProperties = ogaProperties;
        this.updateProperties();
    }

    private void updateProperties() {
        this.update = Boolean.valueOf(this.ogaProperties.getProperty("org.opensolaris.opengrok.indexer.updatedatabase"));
        this.noThreads = Integer.valueOf(this.ogaProperties.getProperty("org.opensolaris.opengrok.indexer.numberofthreads"));
        this.configurationFile = this.ogaProperties.getProperty("org.opensolaris.opengrok.configuration.file");
        String subfiles = this.ogaProperties.getProperty("org.opensolaris.opengrok.indexer.subfiles");
        if (subfiles != null) {
            this.subFiles = subfiles.split(",");
        }
        this.publishHost = this.ogaProperties.getProperty("org.opensolaris.opengrok.indexer.publishserver.url");
    }

    public static synchronized Management getInstance(Properties ogaProperties) {
        if (managementInstance == null) {
            managementInstance = new Management(ogaProperties);
        }
        return managementInstance;
    }

    public static Management getInstance() {
        return managementInstance;
    }

    @Override
    public String getProperty(String key) {
        return this.ogaProperties.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value) {
        if (key == null) {
            log.severe("Trying to set property with key == null");
            return;
        }
        this.ogaProperties.setProperty(key, value);
        this.saveProperties();
    }

    private void saveProperties() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void stop() {
        log.warning("STOPPING AGENT!");
    }

    @Override
    public String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public void setSystemProperty(String key, String value) {
        if (key == null) {
            log.severe("Trying to set property with key == null");
            return;
        }
        System.setProperty(key, value);
    }

    public String getAllSystemProperties() {
        return System.getProperties().toString();
    }

    @Override
    public String getSystemEnvProperty(String key) {
        return System.getenv(key);
    }

    public String getAllSystemEnvProperties() {
        return System.getenv().toString();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getStartDate() {
        return new Date(this.startTime);
    }

    @Override
    public String getVersion() {
        return Info.getFullVersion();
    }

    @Override
    public void setUpdateIndexDatabase(Boolean val) {
        this.update = val;
    }

    @Override
    public Boolean getUpdateIndexDatabase() {
        return this.update;
    }

    @Override
    public void setNumberOfThreads(Integer val) {
        this.noThreads = val;
    }

    @Override
    public Integer getNumberOfThreads() {
        return this.noThreads;
    }

    @Override
    public void setSubFiles(String[] sublist) {
        this.subFiles = sublist == null ? null : (String[])sublist.clone();
    }

    @Override
    public String[] getSubFiles() {
        return this.subFiles == null ? null : (String[])this.subFiles.clone();
    }

    @Override
    public String getConfigurationFile() {
        return this.configurationFile;
    }

    @Override
    public String getPublishServerURL() {
        return this.publishHost;
    }

    @Override
    public void setFileLogLevel(Level level) {
        OpenGrokLogger.setFileLogLevel(level);
    }

    @Override
    public void setFileLogPath(String path) throws IOException {
        OpenGrokLogger.setFileLogPath(path);
    }

    @Override
    public Level getConsoleLogLevel() {
        return OpenGrokLogger.getConsoleLogLevel();
    }

    @Override
    public Level getFileLogLevel() {
        return OpenGrokLogger.getFileLogLevel();
    }

    @Override
    public String getFileLogPath() {
        return OpenGrokLogger.getFileLogPath();
    }

    @Override
    public void setPublishServerURL(String url) {
        this.publishHost = url;
    }

    @Override
    public void setConsoleLogLevel(Level level) {
        OpenGrokLogger.setConsoleLogLevel(level);
    }

    @Override
    public void setConfigurationFile(String filename) {
        this.configurationFile = filename;
    }
}

