/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.AnnotationCodegenKt;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeAnnotationCollector;
import org.jetbrains.kotlin.backend.jvm.codegen.TypeAnnotationPosition;
import org.jetbrains.kotlin.backend.jvm.codegen.TypePathInfo;
import org.jetbrains.kotlin.backend.jvm.ir.IrJvmFlexibleTypeKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMappingKt;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 82\u00020\u0001:\u00018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H&J\"\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0015\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001dJ\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0012H\u0002J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$J$\u0010%\u001a\u0004\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020'2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010(\u001a\u00020\u0017H\u0002J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0014H\u0002J\u001a\u0010+\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/H\u0002J\"\u00100\u001a\u00020\u00102\b\u00101\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010*\u001a\u00020\u0014H\u0002J\u001d\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen;", "", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;)V", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "methodSignatureMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/MethodSignatureMapper;", "annotationDescriptorsAlreadyPresent", "", "", "genAnnotations", "", "annotated", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "descr", "visible", "", "visitTypeAnnotation", "path", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "generateNullabilityAnnotation", "declaration", "generateNullabilityAnnotation$backend_jvm_codegen", "isMovedReceiverParameterOfStaticValueClassReplacement", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parent", "generateAnnotationDefaultValue", "value", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "genAnnotation", "annotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "isTypeAnnotation", "genAnnotationArguments", "annotationVisitor", "getAnnotationArgumentJvmName", "annotationClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "parameterName", "Lorg/jetbrains/kotlin/name/Name;", "genCompileTimeValue", "name", "generateTypeAnnotations", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "position", "Lorg/jetbrains/kotlin/backend/jvm/codegen/TypeAnnotationPosition;", "generateTypeAnnotations$backend_jvm_codegen", "Companion", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nAnnotationCodegen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationCodegen.kt\norg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n669#2,11:389\n1#3:400\n*S KotlinDebug\n*F\n+ 1 AnnotationCodegen.kt\norg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen\n*L\n196#1:389,11\n*E\n"})
public abstract class AnnotationCodegen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassCodegen classCodegen;
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final MethodSignatureMapper methodSignatureMapper;
    @NotNull
    private final Set<String> annotationDescriptorsAlreadyPresent;
    @NotNull
    private static final Map<KotlinRetention, RetentionPolicy> annotationRetentionMap;

    public AnnotationCodegen(@NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter(classCodegen, "classCodegen");
        this.classCodegen = classCodegen;
        this.context = this.classCodegen.getContext();
        this.typeMapper = this.classCodegen.getTypeMapper();
        this.methodSignatureMapper = this.classCodegen.getMethodSignatureMapper();
        this.annotationDescriptorsAlreadyPresent = new LinkedHashSet();
    }

    public final void genAnnotations(@NotNull IrDeclaration annotated) {
        Intrinsics.checkNotNullParameter(annotated, "annotated");
        for (IrConstructorCall annotation : annotated.getAnnotations()) {
            String descriptor;
            boolean bl;
            Set applicableTargets = AnnotationCodegenKt.access$applicableTargetSet(Companion.getAnnotationClass(annotation));
            if (annotated instanceof IrSimpleFunction && annotated.getOrigin() == IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA() && !applicableTargets.contains((Object)KotlinTarget.FUNCTION) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_SETTER)) {
                bl = applicableTargets.contains((Object)KotlinTarget.EXPRESSION);
                if (!_Assertions.ENABLED || bl) continue;
                boolean $i$a$-assert-AnnotationCodegen$genAnnotations$32 = false;
                String $i$a$-assert-AnnotationCodegen$genAnnotations$32 = "Inconsistent target list for lambda annotation: " + applicableTargets + " on " + annotated;
                throw new AssertionError((Object)$i$a$-assert-AnnotationCodegen$genAnnotations$32);
            }
            if (annotated instanceof IrClass && Intrinsics.areEqual(((IrClass)annotated).getVisibility(), DescriptorVisibilities.LOCAL) && !applicableTargets.contains((Object)KotlinTarget.CLASS) && !applicableTargets.contains((Object)KotlinTarget.ANNOTATION_CLASS)) {
                bl = applicableTargets.contains((Object)KotlinTarget.EXPRESSION);
                if (!_Assertions.ENABLED || bl) continue;
                boolean bl2 = false;
                String string2 = "Inconsistent target list for object literal annotation: " + applicableTargets + " on " + annotated;
                throw new AssertionError((Object)string2);
            }
            if (this.genAnnotation(annotation, null, false) == null) continue;
            boolean bl3 = false;
            this.annotationDescriptorsAlreadyPresent.add(descriptor);
        }
    }

    @NotNull
    public abstract AnnotationVisitor visitAnnotation(@NotNull String var1, boolean var2);

    @NotNull
    public AnnotationVisitor visitTypeAnnotation(@NotNull String descr, @Nullable TypePath path, boolean visible) {
        Intrinsics.checkNotNullParameter(descr, "descr");
        throw new RuntimeException("Not implemented");
    }

    public final void generateNullabilityAnnotation$backend_jvm_codegen(@NotNull IrDeclaration declaration) {
        IrType irType;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (AnnotationCodegen.Companion.isInvisibleForNullabilityAnalysis(declaration)) {
            return;
        }
        if (declaration instanceof IrValueParameter) {
            IrDeclarationParent irDeclarationParent = ((IrValueParameter)declaration).getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            IrDeclaration parent2 = (IrDeclaration)((Object)irDeclarationParent);
            if (AnnotationCodegen.Companion.isInvisibleForNullabilityAnalysis(parent2)) {
                return;
            }
            if (this.isMovedReceiverParameterOfStaticValueClassReplacement((IrValueParameter)declaration, parent2)) {
                return;
            }
        }
        if (declaration instanceof IrSimpleFunction && ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol() != null && IrUtilsKt.isAnnotationClass(IrUtilsKt.getParentAsClass(declaration))) {
            return;
        }
        IrDeclaration irDeclaration2 = declaration;
        if (irDeclaration2 instanceof IrFunction) {
            irType = ((IrFunction)declaration).getReturnType();
        } else if (irDeclaration2 instanceof IrValueDeclaration) {
            irType = ((IrValueDeclaration)declaration).getType();
        } else if (irDeclaration2 instanceof IrField) {
            Object object = ((IrField)declaration).getCorrespondingPropertySymbol();
            boolean bl = object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isLateinit() : false;
            if (bl) {
                return;
            }
            irType = ((IrField)declaration).getType();
        } else {
            return;
        }
        IrType type2 = irType;
        if (AnnotationCodegenKt.access$isBareTypeParameterWithNullableUpperBound(type2)) {
            return;
        }
        if (IrJvmFlexibleTypeKt.isWithFlexibleNullability(type2)) {
            return;
        }
        Class annotationClass = IrTypeUtilsKt.isNullable(type2) ? Nullable.class : NotNull.class;
        String descriptor = Type.getType(annotationClass).getDescriptor();
        if (!this.annotationDescriptorsAlreadyPresent.contains(descriptor)) {
            Intrinsics.checkNotNull(descriptor);
            this.visitAnnotation(descriptor, false).visitEnd();
        }
    }

    private final boolean isMovedReceiverParameterOfStaticValueClassReplacement(IrValueParameter parameter, IrDeclaration parent2) {
        return (Intrinsics.areEqual(parent2.getOrigin(), JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_INLINE_CLASS_REPLACEMENT()) || Intrinsics.areEqual(parent2.getOrigin(), JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_MULTI_FIELD_VALUE_CLASS_REPLACEMENT())) && Intrinsics.areEqual(parameter.getOrigin(), IrDeclarationOrigin.Companion.getMOVED_DISPATCH_RECEIVER());
    }

    public final void generateAnnotationDefaultValue(@NotNull IrExpression value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        AnnotationVisitor visitor2 = this.visitAnnotation("", false);
        this.genCompileTimeValue(null, value2, visitor2);
        visitor2.visitEnd();
    }

    private final String genAnnotation(IrConstructorCall annotation, TypePath path, boolean isTypeAnnotation) {
        AnnotationVisitor annotationVisitor;
        FqName fqName;
        IrClass annotationClass = Companion.getAnnotationClass(annotation);
        RetentionPolicy retentionPolicy = AnnotationCodegen.Companion.getRetentionPolicy(annotationClass);
        if (retentionPolicy == RetentionPolicy.SOURCE && !this.context.getState().getClassBuilderMode().generateSourceRetentionAnnotations) {
            return null;
        }
        FqName fqName2 = fqName = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        if (Intrinsics.areEqual(fqName2 != null ? fqName2.parent() : null, StandardClassIds.INSTANCE.getBASE_INTERNAL_IR_PACKAGE()) || Intrinsics.areEqual(fqName, JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION)) {
            return null;
        }
        if (JvmIrUtilsKt.isOptionalAnnotationClass(annotationClass)) {
            return null;
        }
        this.classCodegen.addInnerClassInfo(annotationClass);
        String asmTypeDescriptor = IrTypeMapper.mapType$default(this.typeMapper, annotation.getType(), null, null, false, 14, null).getDescriptor();
        if (!isTypeAnnotation) {
            Intrinsics.checkNotNull(asmTypeDescriptor);
            annotationVisitor = this.visitAnnotation(asmTypeDescriptor, retentionPolicy == RetentionPolicy.RUNTIME);
        } else {
            Intrinsics.checkNotNull(asmTypeDescriptor);
            annotationVisitor = this.visitTypeAnnotation(asmTypeDescriptor, path, retentionPolicy == RetentionPolicy.RUNTIME);
        }
        AnnotationVisitor annotationVisitor2 = annotationVisitor;
        this.genAnnotationArguments(annotation, annotationVisitor2);
        annotationVisitor2.visitEnd();
        return asmTypeDescriptor;
    }

    private final void genAnnotationArguments(IrConstructorCall annotation, AnnotationVisitor annotationVisitor) {
        IrClass annotationClass = Companion.getAnnotationClass(annotation);
        for (IrValueParameter param : ((IrConstructor)annotation.getSymbol().getOwner()).getValueParameters()) {
            IrExpression value2 = annotation.getValueArgument(param.getIndex());
            if (value2 != null) {
                this.genCompileTimeValue(this.getAnnotationArgumentJvmName(annotationClass, param.getName()), value2, annotationVisitor);
                continue;
            }
            if (param.getDefaultValue() != null || !this.context.getState().getClassBuilderMode().generateBodies) continue;
            throw new IllegalStateException(("No value for annotation parameter " + RenderIrElementKt.render$default(param, null, 1, null)).toString());
        }
    }

    private final String getAnnotationArgumentJvmName(IrClass annotationClass, Name parameterName) {
        Object v2;
        block5: {
            if (annotationClass == null) {
                String string2 = parameterName.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                return string2;
            }
            Iterable $this$singleOrNull$iv = annotationClass.getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Object object;
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrSimpleFunction && Intrinsics.areEqual((object = ((IrSimpleFunction)it).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null ? object.getName() : null, parameterName) || it instanceof IrProperty && Intrinsics.areEqual(((IrProperty)it).getName(), parameterName))) continue;
                if (found$iv) {
                    v2 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        IrDeclaration irDeclaration2 = v2;
        if (irDeclaration2 == null) {
            String string3 = parameterName.asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            return string3;
        }
        IrDeclaration propertyOrGetter = irDeclaration2;
        IrSimpleFunction irSimpleFunction = propertyOrGetter instanceof IrSimpleFunction ? (IrSimpleFunction)propertyOrGetter : null;
        if (irSimpleFunction == null && (irSimpleFunction = ((IrProperty)propertyOrGetter).getGetter()) == null) {
            throw new IllegalStateException(("No getter for annotation property: " + RenderIrElementKt.render$default(propertyOrGetter, null, 1, null)).toString());
        }
        IrSimpleFunction getter2 = irSimpleFunction;
        return MethodSignatureMapper.mapFunctionName$default(this.methodSignatureMapper, getter2, false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void genCompileTimeValue(String name2, IrExpression value2, AnnotationVisitor annotationVisitor) {
        IrExpression irExpression = value2;
        if (irExpression instanceof IrConst) {
            annotationVisitor.visit(name2, ((IrConst)value2).getValue());
            return;
        }
        if (irExpression instanceof IrConstructorCall) {
            IrConstructor callee = (IrConstructor)((IrConstructorCall)value2).getSymbol().getOwner();
            if (!IrUtilsKt.isAnnotationClass(IrUtilsKt.getParentAsClass(callee))) throw new IllegalStateException(("Not supported as annotation! " + IrUtilsKt.ir2string(value2)).toString());
            IrType annotationClassType = callee.getReturnType();
            String internalAnnName = IrTypeMapper.mapType$default(this.typeMapper, annotationClassType, null, null, false, 14, null).getDescriptor();
            AnnotationVisitor visitor2 = annotationVisitor.visitAnnotation(name2, internalAnnName);
            Object object = IrTypesKt.getClassOrNull(annotationClassType);
            if (object != null && (object = (IrClass)object.getOwner()) != null) {
                Object object2 = object;
                ClassCodegen classCodegen = this.classCodegen;
                Object p0 = object2;
                boolean bl = false;
                classCodegen.addInnerClassInfo((IrClass)p0);
            }
            IrConstructorCall irConstructorCall = (IrConstructorCall)value2;
            Intrinsics.checkNotNull(visitor2);
            this.genAnnotationArguments(irConstructorCall, visitor2);
            visitor2.visitEnd();
            return;
        }
        if (irExpression instanceof IrGetEnumValue) {
            IrEnumEntry enumEntry = (IrEnumEntry)((IrGetEnumValue)value2).getSymbol().getOwner();
            IrClass enumClass = IrUtilsKt.getParentAsClass(enumEntry);
            this.classCodegen.addInnerClassInfo(enumClass);
            annotationVisitor.visitEnum(name2, IrTypeMappingKt.mapClass(this.typeMapper, enumClass).getDescriptor(), enumEntry.getName().asString());
            return;
        }
        if (irExpression instanceof IrVararg) {
            AnnotationVisitor visitor3 = annotationVisitor.visitArray(name2);
            for (IrVarargElement element : ((IrVararg)value2).getElements()) {
                Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                IrExpression irExpression2 = (IrExpression)element;
                Intrinsics.checkNotNull(visitor3);
                this.genCompileTimeValue(null, irExpression2, visitor3);
            }
            visitor3.visitEnd();
            return;
        }
        if (irExpression instanceof IrClassReference) {
            IrType classType = ((IrClassReference)value2).getClassType();
            Object object = IrTypesKt.getClassOrNull(classType);
            if (object != null && (object = (IrClass)object.getOwner()) != null) {
                Object object3 = object;
                ClassCodegen classCodegen = this.classCodegen;
                Object p0 = object3;
                boolean bl = false;
                classCodegen.addInnerClassInfo((IrClass)p0);
            }
            Type mappedType = JvmIrTypeUtilsKt.isInlineClassType(classType) ? IrTypeMappingKt.mapClass(this.typeMapper, JvmIrTypeUtilsKt.getErasedUpperBound(classType)) : IrTypeMapper.mapType$default(this.typeMapper, classType, null, null, false, 14, null);
            annotationVisitor.visit(name2, mappedType);
            return;
        }
        if (!(irExpression instanceof IrErrorExpression)) throw new IllegalStateException(("Unsupported compile-time value " + IrUtilsKt.ir2string(value2)).toString());
        throw new IllegalStateException(("Don't know how to compile annotation value " + IrUtilsKt.ir2string(value2)).toString());
    }

    public final void generateTypeAnnotations$backend_jvm_codegen(@NotNull IrType type2, @NotNull TypeAnnotationPosition position) {
        TypeMappingMode typeMappingMode;
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(position, "position");
        if (!this.context.getConfig().getEmitJvmTypeAnnotations()) {
            return;
        }
        TypeAnnotationPosition typeAnnotationPosition = position;
        if (typeAnnotationPosition instanceof TypeAnnotationPosition.FunctionReturnType) {
            typeMappingMode = MethodSignatureMapper.Companion.getTypeMappingModeForReturnType(this.context.getTypeSystem(), ((TypeAnnotationPosition.FunctionReturnType)position).getFunction(), ((TypeAnnotationPosition.FunctionReturnType)position).getFunction().getReturnType());
        } else if (typeAnnotationPosition instanceof TypeAnnotationPosition.ValueParameterType) {
            IrTypeSystemContext irTypeSystemContext = this.context.getTypeSystem();
            IrDeclarationParent irDeclarationParent = ((TypeAnnotationPosition.ValueParameterType)position).getParameter().getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            typeMappingMode = MethodSignatureMapper.Companion.getTypeMappingModeForParameter(irTypeSystemContext, (IrDeclaration)((Object)irDeclarationParent), type2);
        } else if (typeAnnotationPosition instanceof TypeAnnotationPosition.FieldType) {
            typeMappingMode = ((TypeAnnotationPosition.FieldType)position).getField().isFinal() ? MethodSignatureMapper.Companion.getTypeMappingModeForReturnType(this.context.getTypeSystem(), ((TypeAnnotationPosition.FieldType)position).getField(), ((TypeAnnotationPosition.FieldType)position).getField().getType()) : MethodSignatureMapper.Companion.getTypeMappingModeForParameter(this.context.getTypeSystem(), ((TypeAnnotationPosition.FieldType)position).getField(), ((TypeAnnotationPosition.FieldType)position).getField().getType());
        } else if (typeAnnotationPosition instanceof TypeAnnotationPosition.TypeParameterBoundType) {
            typeMappingMode = TypeMappingMode.GENERIC_ARGUMENT;
        } else if (typeAnnotationPosition instanceof TypeAnnotationPosition.Supertype) {
            typeMappingMode = TypeMappingMode.SUPER_TYPE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TypeMappingMode mode = typeMappingMode;
        for (TypePathInfo typePathInfo : new IrTypeAnnotationCollector(this.context).collectTypeAnnotations(type2, mode)) {
            for (IrConstructorCall annotation : typePathInfo.getAnnotations()) {
                this.genAnnotation(annotation, typePathInfo.getPath(), true);
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(KotlinRetention.SOURCE, RetentionPolicy.SOURCE), TuplesKt.to(KotlinRetention.BINARY, RetentionPolicy.CLASS), TuplesKt.to(KotlinRetention.RUNTIME, RetentionPolicy.RUNTIME)};
        annotationRetentionMap = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0092\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2b\u0010\u000f\u001a^\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0015\u0012\u0013\u0018\u00010\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a0\u0010J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010%\u001a\u00020$*\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen$Companion;", "", "<init>", "()V", "genAnnotationsOnTypeParametersAndBounds", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "typeParameterContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "referenceType", "", "boundType", "visitor", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "typeRef", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "typePath", "", "descriptor", "", "visible", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "isInvisibleForNullabilityAnalysis", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "annotationRetentionMap", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinRetention;", "Ljava/lang/annotation/RetentionPolicy;", "getRetentionPolicy", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "annotationClass", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getAnnotationClass", "(Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.codegen"})
    public static final class Companion {
        private Companion() {
        }

        public final void genAnnotationsOnTypeParametersAndBounds(@NotNull JvmBackendContext context, @NotNull IrTypeParametersContainer typeParameterContainer, @NotNull ClassCodegen classCodegen, int referenceType, int boundType, @NotNull Function4<? super Integer, ? super TypePath, ? super String, ? super Boolean, ? extends AnnotationVisitor> visitor2) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(typeParameterContainer, "typeParameterContainer");
            Intrinsics.checkNotNullParameter(classCodegen, "classCodegen");
            Intrinsics.checkNotNullParameter(visitor2, "visitor");
            Iterator iterator2 = ((Iterable)typeParameterContainer.getTypeParameters()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index = n++;
                IrTypeParameter typeParameter = (IrTypeParameter)iterator2.next();
                new AnnotationCodegen(classCodegen, referenceType, index, visitor2, typeParameterContainer){
                    final /* synthetic */ int $referenceType;
                    final /* synthetic */ int $index;
                    final /* synthetic */ Function4<Integer, TypePath, String, Boolean, AnnotationVisitor> $visitor;
                    final /* synthetic */ IrTypeParametersContainer $typeParameterContainer;
                    {
                        this.$referenceType = $referenceType;
                        this.$index = $index;
                        this.$visitor = $visitor;
                        this.$typeParameterContainer = $typeParameterContainer;
                        super($classCodegen);
                    }

                    public AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                        Intrinsics.checkNotNullParameter(descr, "descr");
                        TypeReference typeReference = TypeReference.newTypeParameterReference(this.$referenceType, this.$index);
                        return this.$visitor.invoke(typeReference.getValue(), null, descr, visible);
                    }

                    public AnnotationVisitor visitTypeAnnotation(String descr, TypePath path, boolean visible) {
                        Intrinsics.checkNotNullParameter(descr, "descr");
                        throw new IllegalStateException(("Type annotation cannot be on a type parameter: " + RenderIrElementKt.render$default(this.$typeParameterContainer, null, 1, null)).toString());
                    }
                }.genAnnotations(typeParameter);
                if (!context.getConfig().getEmitJvmTypeAnnotations()) continue;
                int superInterfaceIndex = 1;
                for (IrType superType : typeParameter.getSuperTypes()) {
                    boolean isClassOrTypeParameter = !org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isInterface(superType) && !org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isAnnotation(superType);
                    int superIndex = isClassOrTypeParameter ? 0 : superInterfaceIndex++;
                    new AnnotationCodegen(classCodegen, typeParameterContainer, boundType, index, superIndex, visitor2){
                        final /* synthetic */ IrTypeParametersContainer $typeParameterContainer;
                        final /* synthetic */ int $boundType;
                        final /* synthetic */ int $index;
                        final /* synthetic */ int $superIndex;
                        final /* synthetic */ Function4<Integer, TypePath, String, Boolean, AnnotationVisitor> $visitor;
                        {
                            this.$typeParameterContainer = $typeParameterContainer;
                            this.$boundType = $boundType;
                            this.$index = $index;
                            this.$superIndex = $superIndex;
                            this.$visitor = $visitor;
                            super($classCodegen);
                        }

                        public AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                            Intrinsics.checkNotNullParameter(descr, "descr");
                            throw new IllegalStateException(("Only type annotation can be on a type parameter bound: " + RenderIrElementKt.render$default(this.$typeParameterContainer, null, 1, null)).toString());
                        }

                        public AnnotationVisitor visitTypeAnnotation(String descr, TypePath path, boolean visible) {
                            Intrinsics.checkNotNullParameter(descr, "descr");
                            TypeReference typeReference = TypeReference.newTypeParameterBoundReference(this.$boundType, this.$index, this.$superIndex);
                            return this.$visitor.invoke(typeReference.getValue(), path, descr, visible);
                        }
                    }.generateTypeAnnotations$backend_jvm_codegen(superType, TypeAnnotationPosition.TypeParameterBoundType.INSTANCE);
                }
            }
        }

        private final boolean isInvisibleForNullabilityAnalysis(IrDeclaration declaration) {
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            return (irClass != null ? AdditionalIrUtilsKt.isLocal(irClass) : false) ? true : (declaration.getOrigin().isSynthetic() ? true : Intrinsics.areEqual(declaration.getOrigin(), JvmLoweredDeclarationOrigin.INSTANCE.getINLINE_CLASS_GENERATED_IMPL_METHOD()) || Intrinsics.areEqual(declaration.getOrigin(), JvmLoweredDeclarationOrigin.INSTANCE.getMULTI_FIELD_VALUE_CLASS_GENERATED_IMPL_METHOD()) || Intrinsics.areEqual(declaration.getOrigin(), IrDeclarationOrigin.Companion.getGENERATED_SAM_IMPLEMENTATION()));
        }

        private final RetentionPolicy getRetentionPolicy(IrClass irClass) {
            KotlinRetention retention = IrUtilsKt.getAnnotationRetention(irClass);
            if (retention != null) {
                Object v = annotationRetentionMap.get((Object)retention);
                Intrinsics.checkNotNull(v);
                return (RetentionPolicy)((Object)v);
            }
            IrAnnotationContainer irAnnotationContainer = irClass;
            String string2 = Retention.class.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation(irAnnotationContainer, new FqName(string2));
            if (irConstructorCall != null) {
                IrSymbol symbol;
                IrConstructorCall retentionAnnotation = irConstructorCall;
                boolean bl = false;
                IrExpression value2 = retentionAnnotation.getValueArgument(0);
                if (value2 instanceof IrDeclarationReference && (symbol = ((IrDeclarationReference)value2).getSymbol()) instanceof IrEnumEntrySymbol) {
                    IrEnumEntry entry = (IrEnumEntry)((IrEnumEntrySymbol)symbol).getOwner();
                    FqName enumClassFqName = IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(entry));
                    FqName fqName = enumClassFqName;
                    if (Intrinsics.areEqual(RetentionPolicy.class.getName(), fqName != null ? fqName.asString() : null)) {
                        String string3 = entry.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
                        return RetentionPolicy.valueOf(string3);
                    }
                }
            }
            return RetentionPolicy.RUNTIME;
        }

        @NotNull
        public final IrClass getAnnotationClass(@NotNull IrConstructorCall $this$annotationClass) {
            Intrinsics.checkNotNullParameter($this$annotationClass, "<this>");
            return IrUtilsKt.getParentAsClass((IrDeclaration)$this$annotationClass.getSymbol().getOwner());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

