searchData={"items":[{"type":"module","title":"snmp","doc":"Interface functions to the SNMP toolkit\n\nThe module `snmp` contains interface functions to the SNMP toolkit.","ref":"snmp.html"},{"type":"module","title":"See Also - snmp","doc":"calendar(3)","ref":"snmp.html#module-see-also"},{"type":"function","title":"snmp.bits_to_octet_string/1","doc":"Utility function for converting a value of type `BITS` to `OCTET-STRING`,\naccording to RFC1906, section 8.","ref":"snmp.html#bits_to_octet_string/1"},{"type":"function","title":"snmp.change_log_size/2","doc":"Changes the log size of the Audit Trail Log. The application must be configured\nto use the audit trail log function. Please refer to disk_log(3) in Kernel\nReference Manual for a description of how to change the log size.\n\nThe change is permanent, as long as the log is not deleted. That means, the log\nsize is remembered across reboots.","ref":"snmp.html#change_log_size/2"},{"type":"function","title":"snmp.config/0","doc":"A simple interactive configuration tool. Simple configuration files can be\ngenerated, but more complex configurations still have to be edited manually.\n\nThe tool is a textual based tool that asks some questions and generates\n`sys.config` and `*.conf` files.\n\n_Note_ that if the application shall support version 3, then the crypto app must\nbe started before running this function (password generation).\n\n_Note_ also that some of the configuration files for the agent and manager share\nthe same names. This means that they have to be stored in _different_\ndirectories\\!","ref":"snmp.html#config/0"},{"type":"function","title":"snmp.date_and_time/0","doc":"Returns current date and time as the data type DateAndTime, as specified in\nRFC1903. This is an OCTET STRING.","ref":"snmp.html#date_and_time/0"},{"type":"function","title":"snmp.date_and_time_to_string2/1","doc":"Converts a DateAndTime list to a printable string, according to the DISPLAY-HINT\ndefinition in RFC2579, with the extension that it also allows the values \"hours\nfrom UTC\" = 14 together with \"minutes from UTC\" = 0.","ref":"snmp.html#date_and_time_to_string2/1"},{"type":"function","title":"snmp.date_and_time_to_string/1","doc":"","ref":"snmp.html#date_and_time_to_string/1"},{"type":"function","title":"snmp.date_and_time_to_string/2","doc":"Converts a DateAndTime list to a printable string, according to the DISPLAY-HINT\ndefinition in RFC2579.\n\nThe validation fun, `Validate`, allows for a more \"flexible\" validation of the\n`DateAndTime` argument. Whenever the data is found to not follow RFC2579, the\nfun is called to allow a more \"lax\" validation. See the\n[`validate_date_and_time/2`](`snmp:validate_date_and_time/2`) function for\nmore info on the `Validate` fun.","ref":"snmp.html#date_and_time_to_string/2"},{"type":"function","title":"snmp.date_and_time_to_universal_time_dst/1","doc":"Converts a DateAndTime list to a list of possible universal time(s). The\nuniversal time value on the same format as defined in calendar(3).","ref":"snmp.html#date_and_time_to_universal_time_dst/1"},{"type":"function","title":"snmp.disable_trace/0","doc":"Stop the tracer.","ref":"snmp.html#disable_trace/0"},{"type":"function","title":"snmp.enable_trace/0","doc":"Starts a dbg tracer that prints trace events to stdout (using plain io:format\nafter a minor formatting).","ref":"snmp.html#enable_trace/0"},{"type":"function","title":"snmp.local_time_to_date_and_time_dst/1","doc":"Converts a local time value to a list of possible DateAndTime list(s). The local\ntime value on the same format as defined in calendar(3).","ref":"snmp.html#local_time_to_date_and_time_dst/1"},{"type":"function","title":"snmp.log_to_io/4","doc":"","ref":"snmp.html#log_to_io/4"},{"type":"function","title":"snmp.log_to_io/5","doc":"","ref":"snmp.html#log_to_io/5"},{"type":"function","title":"snmp.log_to_io/6","doc":"","ref":"snmp.html#log_to_io/6"},{"type":"function","title":"snmp.log_to_io/7","doc":"Converts an Audit Trail Log to a readable format and prints it on stdio. See\n[`log_to_txt/8`](`snmp:log_to_txt/8`) for more info.","ref":"snmp.html#log_to_io/7"},{"type":"function","title":"snmp.log_to_txt/5","doc":"","ref":"snmp.html#log_to_txt/5"},{"type":"function","title":"snmp.log_to_txt/6","doc":"","ref":"snmp.html#log_to_txt/6"},{"type":"function","title":"snmp.log_to_txt/7","doc":"","ref":"snmp.html#log_to_txt/7"},{"type":"function","title":"snmp.log_to_txt/8","doc":"Converts an Audit Trail Log to a readable text file, where each item has a\ntrailing TAB character, and any TAB character in the body of an item has been\nreplaced by ESC TAB.\n\nThe function can be used on a running system, or by copying the entire log\ndirectory and calling this function. SNMP must be running in order to provide\nMIB information.\n\n`LogDir` is the name of the directory where the audit trail log is stored.\n`Mibs` is a list of Mibs to be used. The function uses the information in the\nMibs to convert for example object identifiers to their symbolic name. `OutFile`\nis the name of the generated text-file. `LogName` is the name of the log,\n`LogFile` is the name of the log file. `Start` is the start (first) date and\ntime from which log events will be converted and `Stop` is the stop (last) date\nand time to which log events will be converted. The `Block` argument indicates\nif the log should be blocked during conversion. This could be useful when\nconverting large logs (when otherwise the log could wrap during conversion).\nDefaults to `true`.\n\nThe format of an audit trail log text item is as follows:\n\n`Tag Addr - Community [TimeStamp] Vsn`  \n`PDU`\n\nwhere `Tag` is `request`, `response`, `report`, `trap` or `inform`; Addr is\n`IP:Port` (or comma space separated list of such); `Community` is the community\nparameter (SNMP version v1 and v2), or `SecLevel:\"AuthEngineID\":\"UserName\"`\n(SNMP v3); `TimeStamp` is a date and time stamp, and `Vsn` is the SNMP version.\n`PDU` is a textual version of the protocol data unit. There is a new line\nbetween `Vsn` and `PDU`.\n\nIf the entire log is successfully converted, the function will return `ok`. If\none of more entries fail to convert, the function will instead return\n`{ok, {NumOK, NumERR}}`, where the counters indicate how many valid and\nerroneous entries where found. If instead `{error, Reason}` is returned, the\nconversion encountered a fatal error and where either never done of aborted\nmidway.","ref":"snmp.html#log_to_txt/8"},{"type":"function","title":"snmp.octet_string_to_bits/1","doc":"Utility function for converting a value of type `OCTET-STRING` to `BITS`,\naccording to RFC1906, section 8.","ref":"snmp.html#octet_string_to_bits/1"},{"type":"function","title":"snmp.passwd2localized_key/3","doc":"Generates a key that can be used as an authentication or privacy key using MD5,\nSHA, SHA224, SHA256, SHA384 or SHA512. The key is localized for EngineID.","ref":"snmp.html#passwd2localized_key/3"},{"type":"function","title":"snmp.print_version_info/0","doc":"","ref":"snmp.html#print_version_info/0"},{"type":"function","title":"snmp.print_version_info/1","doc":"Utility function(s) to produce a formatted printout of the versions info\ngenerated by the `versions1` function\n\nThis is the same as doing, e.g.:\n\n```erlang\n           {ok, V} = snmp:versions1(),\n           snmp:print_versions(V).\n```","ref":"snmp.html#print_version_info/1"},{"type":"function","title":"snmp.print_versions/1","doc":"","ref":"snmp.html#print_versions/1"},{"type":"function","title":"snmp.print_versions/2","doc":"Utility function to produce a formatted printout of the versions info generated\nby the `versions1` and `versions2` functions\n\nExample:\n\n```erlang\n           {ok, V} = snmp:versions1(),\n           snmp:print_versions(V).\n```","ref":"snmp.html#print_versions/2"},{"type":"function","title":"snmp.read_mib/1","doc":"Read a compiled mib.","ref":"snmp.html#read_mib/1"},{"type":"function","title":"snmp.reset_trace/1","doc":"This function is used to reset (disable) trace for the given module(s).","ref":"snmp.html#reset_trace/1"},{"type":"function","title":"snmp.set_trace/1","doc":"This function is used to set up default trace on function(s) for the given\nmodule or modules. The scope of the trace will be all _exported_ functions (both\nthe call info and the return value). Timestamp info will also be included.","ref":"snmp.html#set_trace/1"},{"type":"function","title":"snmp.set_trace/2","doc":"This function is used to set up trace on function(s) for the given module or\nmodules.\n\nThe example below sets up trace on the exported functions (default) of module\n`snmp_generic` and all functions of module `snmp_generic_mnesia`. With return\nvalues (which is default) and timestamps in both cases (which is also default):\n\n```erlang\n\t  snmp:enable_trace(),\n\t  snmp:set_trace([snmp_generic,\n                          {snmp_generic_mnesia, [{scope, all_functions}]}]),\n\t  .\n\t  .\n\t  .\n          snmp:set_trace(snmp_generic, disable),\n\t  .\n\t  .\n\t  .\n\t  snmp:disable_trace(),\n```","ref":"snmp.html#set_trace/2"},{"type":"function","title":"snmp.start/0","doc":"","ref":"snmp.html#start/0"},{"type":"function","title":"snmp.start/1","doc":"Starts the SNMP application.\n\nSee `m:application` for more info.","ref":"snmp.html#start/1"},{"type":"function","title":"snmp.start_agent/0","doc":"","ref":"snmp.html#start_agent/0"},{"type":"function","title":"snmp.start_agent/1","doc":"The SNMP application consists of several entities, of which the agent is one.\nThis function starts the agent entity of the application.\n\nNote that the only way to actually start the agent in this way is to add the\nagent related config after starting the application (e.g it cannot be part of\nthe normal application config; sys.config). This is done by calling:\n`application:set_env(snmp, agent, Conf)`.\n\nThe default value for `Type` is `normal`.","ref":"snmp.html#start_agent/1"},{"type":"function","title":"snmp.start_manager/0","doc":"","ref":"snmp.html#start_manager/0"},{"type":"function","title":"snmp.start_manager/1","doc":"The SNMP application consists of several entities, of which the manager is one.\nThis function starts the manager entity of the application.\n\nNote that the only way to actually start the manager in this way is to add the\nmanager related config after starting the application (e.g it cannot be part of\nthe normal application config; sys.config). This is done by calling:\n`application:set_env(snmp, manager, Conf)`.\n\nThe default value for `Type` is `normal`.","ref":"snmp.html#start_manager/1"},{"type":"function","title":"snmp.stop/0","doc":"Stops the SNMP application.\n\nSee `m:application` for more info.\n\nThis function has existed for long time,\nbut not had a proper since tag, so to simplify\nwe set the since tag to when it was documented.","ref":"snmp.html#stop/0"},{"type":"function","title":"snmp.universal_time_to_date_and_time/1","doc":"Converts a universal time value to a DateAndTime list. The universal time value\non the same format as defined in calendar(3).","ref":"snmp.html#universal_time_to_date_and_time/1"},{"type":"function","title":"snmp.validate_date_and_time/1","doc":"","ref":"snmp.html#validate_date_and_time/1"},{"type":"function","title":"snmp.validate_date_and_time/2","doc":"Checks if `DateAndTime` is a correct DateAndTime value, as specified in RFC2579.\nThis function can be used in instrumentation functions to validate a DateAndTime\nvalue.\n\nThe validation fun, `Validate`, allows for a more \"flexible\" validation of the\n`DateAndTime` argument. Whenever the data is found to not follow RFC2579, the\nfun is called to allow a more \"lax\" validation.","ref":"snmp.html#validate_date_and_time/2"},{"type":"function","title":"snmp.versions1/0","doc":"","ref":"snmp.html#versions1/0"},{"type":"function","title":"snmp.versions2/0","doc":"Utility functions used to retrieve some system and application info.\n\nThe difference between the two functions is in how they get the modules to\ncheck. `versions1` uses the app-file and `versions2` uses the function\n`application:get_key`.","ref":"snmp.html#versions2/0"},{"type":"type","title":"snmp.algorithm/0","doc":"","ref":"snmp.html#t:algorithm/0"},{"type":"type","title":"snmp.asn1_type/0","doc":"","ref":"snmp.html#t:asn1_type/0"},{"type":"type","title":"snmp.atl_type/0","doc":"","ref":"snmp.html#t:atl_type/0"},{"type":"type","title":"snmp.bits/0","doc":"The Erlang representation of the SNMP BITS (pseudo) data type.","ref":"snmp.html#t:bits/0"},{"type":"type","title":"snmp.column/0","doc":"","ref":"snmp.html#t:column/0"},{"type":"type","title":"snmp.community/0","doc":"","ref":"snmp.html#t:community/0"},{"type":"type","title":"snmp.context_name/0","doc":"","ref":"snmp.html#t:context_name/0"},{"type":"type","title":"snmp.date_and_time_validator/0","doc":"The input to the validator fun looks like this:\n\n```text\n\t  Kind             Data\n\t  --------------   ----------------------\n\t  year             {Year1, Year2}\n\t  month            Month\n\t  day              Day\n\t  hour             Hour\n\t  minute           Minute\n\t  seconds          Seconds\n\t  deci_seconds     DeciSeconds\n\t  diff             [Sign, Hour, Minute]\n\t  valid_date       {Year, Month, Day}\n```","ref":"snmp.html#t:date_and_time_validator/0"},{"type":"type","title":"snmp.date_and_time_validator_kind/0","doc":"","ref":"snmp.html#t:date_and_time_validator_kind/0"},{"type":"type","title":"snmp.dir/0","doc":"A string, that is a file path to a directory.","ref":"snmp.html#t:dir/0"},{"type":"type","title":"snmp.engine_id/0","doc":"","ref":"snmp.html#t:engine_id/0"},{"type":"type","title":"snmp.error_index/0","doc":"`0` is used when error status is `noError` and when error status is an actual\nerror; error index is `t:pos_integer/0`.","ref":"snmp.html#t:error_index/0"},{"type":"type","title":"snmp.error_status/0","doc":"We should really specify all of these, but they are so numerous... Also,\nnormally all you need to know is that `'noError'` is ok and everything else is\nan error.","ref":"snmp.html#t:error_status/0"},{"type":"type","title":"snmp.ivarbind/0","doc":"","ref":"snmp.html#t:ivarbind/0"},{"type":"type","title":"snmp.log_size/0","doc":"This is basically a copy of the [dlog_size()](`t:disk_log:dlog_size/0`).","ref":"snmp.html#t:log_size/0"},{"type":"type","title":"snmp.log_time/0","doc":"","ref":"snmp.html#t:log_time/0"},{"type":"type","title":"snmp.me/0","doc":"","ref":"snmp.html#t:me/0"},{"type":"type","title":"snmp.mib/0","doc":"","ref":"snmp.html#t:mib/0"},{"type":"type","title":"snmp.mib_name/0","doc":"","ref":"snmp.html#t:mib_name/0"},{"type":"type","title":"snmp.mms/0","doc":"","ref":"snmp.html#t:mms/0"},{"type":"type","title":"snmp.notification/0","doc":"","ref":"snmp.html#t:notification/0"},{"type":"type","title":"snmp.octet/0","doc":"","ref":"snmp.html#t:octet/0"},{"type":"type","title":"snmp.octet_string/0","doc":"","ref":"snmp.html#t:octet_string/0"},{"type":"type","title":"snmp.oid/0","doc":"Represent an ASN.1 OBJECT IDENTIFIER.","ref":"snmp.html#t:oid/0"},{"type":"type","title":"snmp.pdu/0","doc":"","ref":"snmp.html#t:pdu/0"},{"type":"type","title":"snmp.pdu_type/0","doc":"","ref":"snmp.html#t:pdu_type/0"},{"type":"type","title":"snmp.rfc1903_date_and_time/0","doc":"The data type DateAndTime, an OCTET STRING, as specified in RFC1903.","ref":"snmp.html#t:rfc1903_date_and_time/0"},{"type":"type","title":"snmp.row_index/0","doc":"Denotes the last part of the OID which specifies the index of the row in the\ntable (see RFC1212, 4.1.6 for more information about INDEX).","ref":"snmp.html#t:row_index/0"},{"type":"type","title":"snmp.row_pointer/0","doc":"> #### Note {: .info }\n>\n> \"Represents a pointer to a conceptual row. The value is the name of the\n> instance of the first accessible columnar object in the conceptual row.\"\n\n`OBJECT IDENTIFIER`\n\nDefined by SNMPv2-TC.","ref":"snmp.html#t:row_pointer/0"},{"type":"type","title":"snmp.sec_level/0","doc":"","ref":"snmp.html#t:sec_level/0"},{"type":"type","title":"snmp.sec_model/0","doc":"","ref":"snmp.html#t:sec_model/0"},{"type":"type","title":"snmp.sec_name/0","doc":"","ref":"snmp.html#t:sec_name/0"},{"type":"type","title":"snmp.snmp_timer/0","doc":"","ref":"snmp.html#t:snmp_timer/0"},{"type":"type","title":"snmp.table_info/0","doc":"","ref":"snmp.html#t:table_info/0"},{"type":"type","title":"snmp.taddress/0","doc":"","ref":"snmp.html#t:taddress/0"},{"type":"type","title":"snmp.tdomain/0","doc":"","ref":"snmp.html#t:tdomain/0"},{"type":"type","title":"snmp.time_interval/0","doc":"> #### Note {: .info }\n>\n> \"A period of time, measured in units of 0.01 seconds.\"\n\n`INTEGER (0..2147483647)`\n\nDefined by SNMPv2-TC.","ref":"snmp.html#t:time_interval/0"},{"type":"type","title":"snmp.trap/0","doc":"","ref":"snmp.html#t:trap/0"},{"type":"type","title":"snmp.trappdu/0","doc":"","ref":"snmp.html#t:trappdu/0"},{"type":"type","title":"snmp.usm_auth_key/0","doc":"","ref":"snmp.html#t:usm_auth_key/0"},{"type":"type","title":"snmp.usm_auth_protocol/0","doc":"","ref":"snmp.html#t:usm_auth_protocol/0"},{"type":"type","title":"snmp.usm_name/0","doc":"","ref":"snmp.html#t:usm_name/0"},{"type":"type","title":"snmp.usm_priv_key/0","doc":"","ref":"snmp.html#t:usm_priv_key/0"},{"type":"type","title":"snmp.usm_priv_protocol/0","doc":"","ref":"snmp.html#t:usm_priv_protocol/0"},{"type":"type","title":"snmp.varbind/0","doc":"","ref":"snmp.html#t:varbind/0"},{"type":"type","title":"snmp.variable_info/0","doc":"","ref":"snmp.html#t:variable_info/0"},{"type":"type","title":"snmp.verbosity/0","doc":"For the lowest verbosity `silence`, nothing is printed. The higher the\nverbosity, the more is printed.","ref":"snmp.html#t:verbosity/0"},{"type":"type","title":"snmp.version/0","doc":"","ref":"snmp.html#t:version/0"},{"type":"type","title":"snmp.void/0","doc":"The type is used when a functions return is to be ignored.","ref":"snmp.html#t:void/0"},{"type":"module","title":"snmp_community_mib","doc":"Instrumentation Functions for SNMP-COMMUNITY-MIB\n\nThe module `snmp_community_mib` implements the instrumentation functions for the\nSNMP-COMMUNITY-MIB, and functions for configuring the database.\n\nThe configuration files are described in the SNMP User's Manual.\n\n[](){: #configure }","ref":"snmp_community_mib.html"},{"type":"function","title":"snmp_community_mib.add_community/5","doc":"","ref":"snmp_community_mib.html#add_community/5"},{"type":"function","title":"snmp_community_mib.add_community/6","doc":"Adds a community to the agent config. Equivalent to one line in the\n`community.conf` file.\n\nWith the `EngineId` argument it is possible to override the configured engine-id\n(SNMP-FRAMEWORK-MIB).\n\n[](){: #delete_community }","ref":"snmp_community_mib.html#add_community/6"},{"type":"function","title":"snmp_community_mib.configure/1","doc":"This function is called from the supervisor at system start-up.\n\nInserts all data in the configuration files into the database and destroys all\nold rows with StorageType `volatile`. The rows created from the configuration\nfile will have StorageType `nonVolatile`.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error, report module and the function fails with\nreason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `community.conf`.\n\n[](){: #reconfigure }","ref":"snmp_community_mib.html#configure/1"},{"type":"function","title":"snmp_community_mib.delete_community/1","doc":"Delete a community from the agent config.","ref":"snmp_community_mib.html#delete_community/1"},{"type":"function","title":"snmp_community_mib.reconfigure/1","doc":"Inserts all data in the configuration files into the database and destroys all\nold data, including the rows with StorageType `nonVolatile`. The rows created\nfrom the configuration file will have StorageType `nonVolatile`.\n\nThus, the data in the SNMP-COMMUNITY-MIB, after this function has been called,\nis from the configuration files.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nreason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `community.conf`.\n\n[](){: #add_community }","ref":"snmp_community_mib.html#reconfigure/1"},{"type":"type","title":"snmp_community_mib.context_name/0","doc":"A human readable string.\n\n`SnmpAdminString`","ref":"snmp_community_mib.html#t:context_name/0"},{"type":"type","title":"snmp_community_mib.index/0","doc":"`SnmpAdminString (SIZE(1..32))`","ref":"snmp_community_mib.html#t:index/0"},{"type":"type","title":"snmp_community_mib.name/0","doc":"`OCTET STRING (SIZE(1..64))`","ref":"snmp_community_mib.html#t:name/0"},{"type":"type","title":"snmp_community_mib.security_name/0","doc":"`SnmpAdminString`","ref":"snmp_community_mib.html#t:security_name/0"},{"type":"type","title":"snmp_community_mib.transport_tag/0","doc":"`SnmpTagValue`","ref":"snmp_community_mib.html#t:transport_tag/0"},{"type":"module","title":"snmp_framework_mib","doc":"Instrumentation Functions for SNMP-FRAMEWORK-MIB\n\nThe module `snmp_framework_mib` implements instrumentation functions for the\nSNMP-FRAMEWORK-MIB, and functions for initializing and configuring the database.\n\nThe configuration files are described in the SNMP User's Manual.","ref":"snmp_framework_mib.html"},{"type":"function","title":"snmp_framework_mib.add_context/1","doc":"Adds a context to the agent config. Equivalent to one line in the `context.conf`\nfile.\n\n[](){: #delete_context }","ref":"snmp_framework_mib.html#add_context/1"},{"type":"function","title":"snmp_framework_mib.configure/1","doc":"This function is called from the supervisor at system start-up.\n\nInserts all data in the configuration files into the database and destroys all\nold data.\n\nThus, the data in the SNMP-FRAMEWORK-MIB, after this function has been called,\nis from the configuration files.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nreason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `context.conf`.","ref":"snmp_framework_mib.html#configure/1"},{"type":"function","title":"snmp_framework_mib.delete_context/1","doc":"Delete a context from the agent config.","ref":"snmp_framework_mib.html#delete_context/1"},{"type":"function","title":"snmp_framework_mib.init/0","doc":"This function is called from the supervisor at system start-up.\n\nCreates the necessary objects in the database if they do not exist. It does not\ndestroy any old values.\n\n[](){: #add_context }","ref":"snmp_framework_mib.html#init/0"},{"type":"type","title":"snmp_framework_mib.admin_string/0","doc":"`OCTET STRING (SIZE(0..255))`","ref":"snmp_framework_mib.html#t:admin_string/0"},{"type":"type","title":"snmp_framework_mib.engine_id/0","doc":"`OCTET STRING (SIZE(5..32))`","ref":"snmp_framework_mib.html#t:engine_id/0"},{"type":"type","title":"snmp_framework_mib.max_message_size/0","doc":"> #### Note {: .info }\n>\n> \"The maximum length in octets of an SNMP message which this SNMP engine can\n> send or receive and process, determined as the minimum of the maximum message\n> size values supported among all of the transports available to and supported\n> by the engine.\"\n\n`INTEGER (484..2147483647)`","ref":"snmp_framework_mib.html#t:max_message_size/0"},{"type":"type","title":"snmp_framework_mib.message_processing_model/0","doc":"> #### Note {: .info }\n>\n> \"As of this writing, there are several values of messageProcessingModel\n> defined for use with SNMP. They are as follows: \"\n>\n> ```text\n>                         0  reserved for SNMPv1\n>                         1  reserved for SNMPv2c\n>                         2  reserved for SNMPv2u and SNMPv2*\n>                         3  reserved for SNMPv3\n> ```\n\n`INTEGER(0 .. 2147483647)`","ref":"snmp_framework_mib.html#t:message_processing_model/0"},{"type":"type","title":"snmp_framework_mib.security_level/0","doc":"> #### Note {: .info }\n>\n> \"A Level of Security at which SNMP messages can be sent or with which\n> operations are being processed; in particular, one of: \"\n>\n> ```text\n>                       noAuthNoPriv - without authentication and\n>                                      without privacy,\n>                       authNoPriv   - with authentication but\n>                                      without privacy,\n>                       authPriv     - with authentication and\n>                                      with privacy.\n> ```\n>\n> \"These three values are ordered such that noAuthNoPriv is less than authNoPriv\n> and authNoPriv is less than authPriv.\"\n\n`INTEGER { noAuthNoPriv(1), authNoPriv(2), authPriv(3) }`","ref":"snmp_framework_mib.html#t:security_level/0"},{"type":"type","title":"snmp_framework_mib.security_model/0","doc":"> #### Note {: .info }\n>\n> \"As of this writing, there are several values of securityModel defined for use\n> with SNMP or reserved for use with supporting MIB objects. They are as\n> follows: \"\n>\n> ```text\n>                         0  reserved for 'any'\n>                         1  reserved for SNMPv1\n>                         2  reserved for SNMPv2c\n>                         3  User-Based Security Model (USM)\n> ```\n\n`INTEGER(0 .. 2147483647)`","ref":"snmp_framework_mib.html#t:security_model/0"},{"type":"module","title":"snmp_generic","doc":"Generic Functions for Implementing SNMP Objects in a Database\n\n[](){: #description }\n\nThe module `snmp_generic` contains generic functions for implementing tables\n(and variables) using the SNMP built-in database or Mnesia. These default\nfunctions are used if no instrumentation function is provided for a managed\nobject in a MIB. Sometimes, it might be necessary to customize the behaviour of\nthe default functions. For example, in some situations a trap should be sent if\na row is deleted or modified, or some hardware is to be informed, when\ninformation is changed.\n\nThe overall structure is shown in the following figure:\n\n```c\n         +---------------+\n         |   SNMP Agent  |\n         +- - - - - - - -+\n         |      MIB      |\n         +---------------+\n                 |\n         Association file       (associates a MIB object with\n                 |               snmp_generic:table_funct\n                 |               snmp_generic:variable_func)\n+--------------------------------------+\n|           snmp_generic               |  Support for get-next,\n|                                      |  RowStatus operations\n+----------------------+---------------+\n|    snmpa_local_db    |    Mnesia     |  Database\n+--------------+-------+---------------+\n|     dets     |  ets  |\n| (persistent) |       |\n+--------------+-------+\n```\n\nEach function takes the argument `NameDb`, which is a tuple `{Name, Db}`, to\nidentify which database the functions should use. `Name` is the symbolic name of\nthe managed object as defined in the MIB, and `Db` is either `volatile`,\n`persistent`, or `mnesia`. If it is `mnesia`, all variables are stored in the\nMnesia table `snmp_variables` which must be a table with two attributes (not a\nMnesia SNMP table). The SNMP tables are stored in Mnesia tables with the same\nnames as the SNMP tables. All functions assume that a Mnesia table exists with\nthe correct name and attributes. It is the programmer's responsibility to ensure\nthis. Specifically, if variables are stored in Mnesia, the table\n`snmp_variables` must be created by the programmer. The record definition for\nthis table is defined in the file `snmp/include/snmp_types.hrl`.\n\nIf an instrumentation function in the association file for a variable `myVar`\ndoes not have a name when compiling an MIB, the compiler generates an entry.\n\n```erlang\n{myVar, {snmp_generic, variable_func, [{myVar, Db]}}.\n```\n\nAnd for a table:\n\n```erlang\n{myTable, {snmp_generic, table_func, [{myTable, Db]}}.\n```","ref":"snmp_generic.html"},{"type":"module","title":"Example - snmp_generic","doc":"The following example shows an implementation of a table which is stored in\nMnesia, but with some checks performed at set-request operations.\n\n```erlang\nmyTable_func(new, NameDb) ->   % pass unchanged\n  snmp_generic:table_func(new, NameDb).\n\nmyTable_func(delete, NameDb) ->   % pass unchanged\n  snmp_generic:table_func(delete, NameDb).\n\n%% change row\nmyTable_func(is_set_ok, RowIndex, Cols, NameDb) ->\n  case snmp_generic:table_func(is_set_ok, RowIndex,\n                               Cols, NameDb) of\n    {noError, 0} ->\n      myApplication:is_set_ok(RowIndex, Cols);\n    Err ->\n      Err\n  end;\n\nmyTable_func(set, RowIndex, Cols, NameDb) ->\n  case snmp_generic:table_func(set, RowIndex, Cols,\n                               NameDb),\n    {noError, 0} ->\n      % Now the row is updated, tell the application\n      myApplication:update(RowIndex, Cols);\n    Err ->\n      Err\n  end;\n\nmyTable_func(Op, RowIndex, Cols, NameDb) ->   % pass unchanged\n  snmp_generic:table_func(Op, RowIndex, Cols, NameDb).\n```\n\nThe `.funcs` file would look like:\n\n```erlang\n{myTable, {myModule, myTable_func, [{myTable, mnesia}]}}.\n```","ref":"snmp_generic.html#module-example"},{"type":"function","title":"snmp_generic.get_index_types/1","doc":"Gets the index types of `Name`\n\nThis function can be used in instrumentation functions to retrieve the index\ntypes part of the table info.","ref":"snmp_generic.html#get_index_types/1"},{"type":"function","title":"snmp_generic.get_status_col/2","doc":"Gets the value of the status column from `Cols`.\n\nThis function can be used in instrumentation functions for `is_set_ok`, `undo`\nor `set` to check if the status column of a table is modified.","ref":"snmp_generic.html#get_status_col/2"},{"type":"function","title":"snmp_generic.get_table_info/2","doc":"Get a specific table info item or, if `Item` has the\nvalue 'all', a two tuple list (property list) is instead \nreturned with all the items and their respctive values of the \ngiven table.\n\nThis function can be used in instrumentation functions to\nretrieve a given part of the table info.","ref":"snmp_generic.html#get_table_info/2"},{"type":"function","title":"snmp_generic.table_func/2","doc":"This is the default instrumentation function for tables.\n\n- The `new` operation creates the table if it does not exist, but only if the\n  database is the SNMP internal db.\n- The `delete` operation does not delete the table from the database since\n  unloading an MIB does not necessarily mean that the table should be destroyed.\n\nIf it is possible for a manager to create or delete rows in the table, there\nmust be a `RowStatus` column for `is_set_ok`, `set` and `undo` to work properly.\n\nThe function returns according to the specification of an instrumentation\nfunction.","ref":"snmp_generic.html#table_func/2"},{"type":"function","title":"snmp_generic.table_func/4","doc":"This is the default instrumentation function for tables.\n\n- The `is_set_ok` operation checks that a row which is to be modified or deleted\n  exists, and that a row which is to be created does not exist.\n- The `undo` operation does nothing.\n- The `set` operation checks if it has enough information to make the row change\n  its status from `notReady` to `notInService` (when a row has been been set to\n  `createAndWait`). If a row is set to `createAndWait`, columns without a value\n  are set to `noinit`. If Mnesia is used, the set functionality is handled\n  within a transaction.\n\nIf it is possible for a manager to create or delete rows in the table, there\nmust be a `RowStatus` column for `is_set_ok`, `set` and `undo` to work properly.\n\nThe function returns according to the specification of an instrumentation\nfunction.","ref":"snmp_generic.html#table_func/4"},{"type":"function","title":"snmp_generic.table_get_elements/3","doc":"Returns a list with values for all columns in `Cols`. If a column is undefined,\nits value is `noinit`.","ref":"snmp_generic.html#table_get_elements/3"},{"type":"function","title":"snmp_generic.table_next/2","doc":"table_next(NameDb, RestOid) -> RowIndex | endOfTable\n\nFinds the indices of the next row in the table. `RestOid` does not have to\nspecify an existing row.","ref":"snmp_generic.html#table_next/2"},{"type":"function","title":"snmp_generic.table_row_exists/2","doc":"table_row_exists(NameDb, RowIndex) -> bool()\n\nChecks if a row in a table exists.","ref":"snmp_generic.html#table_row_exists/2"},{"type":"function","title":"snmp_generic.table_set_elements/3","doc":"table_set_elements(NameDb, RowIndex, Cols) -> bool()\n\nSets the elements in `Cols` to the row specified by `RowIndex`. No checks are\nperformed on the new values.\n\nIf the Mnesia database is used, this function calls `mnesia:write` to store the\nvalues. This means that this function must be called from within a transaction\n(`mnesia:transaction/1`).","ref":"snmp_generic.html#table_set_elements/3"},{"type":"function","title":"snmp_generic.variable_func/2","doc":"This is the default instrumentation function for variables.\n\n- The `new` opeation creates a new variable in the database with a\n  default value as defined in the MIB, or a zero value (depending on\n  the type).\n- The `delete` function does not delete the variable from the database.\n\nThe function returns according to the specification of an instrumentation\nfunction.","ref":"snmp_generic.html#variable_func/2"},{"type":"function","title":"snmp_generic.variable_func/3","doc":"This is the default instrumentation function for variables with operations;\n`is_set_ok | set | undo`.\n\n- The `is_set_ok` operation does nothing.\n- The `set` operation return `noError` if successful or `commitFailed` otherwise.\n- The `undo` operation does nothing.\n\nThe function returns according to the specification of an instrumentation\nfunction.","ref":"snmp_generic.html#variable_func/3"},{"type":"function","title":"snmp_generic.variable_get/1","doc":"Gets the value of a variable.","ref":"snmp_generic.html#variable_get/1"},{"type":"function","title":"snmp_generic.variable_set/2","doc":"Sets a new value to a variable. The variable is created if it does not exist. No\nchecks are made on the type of the new value.\n\nReturns `false` if the `NameDb` argument is incorrectly specified, otherwise\n`true`.","ref":"snmp_generic.html#variable_set/2"},{"type":"type","title":"snmp_generic.column/0","doc":"","ref":"snmp_generic.html#t:column/0"},{"type":"type","title":"snmp_generic.columns/0","doc":"Is a list of column numbers in the case of a get operation, and a list of column\nnumbers and values in the case of a set operation.","ref":"snmp_generic.html#t:columns/0"},{"type":"type","title":"snmp_generic.table_info_item/0","doc":"For an ordinary table, the types will be the following:\n\n- **`nbr_of_cols`** - Number of columns.\n\n  Value type: [pos_integer()](`t:erlang:pos_integer/0`)\n\n- **`defvals`** - A list of default values, ordered by column.\n\n  Value type: [\\{Col :: [pos_integer()](`t:erlang:pos_integer/0`), DefVal ::\n  [term()](`t:erlang:term/0`)\\}]\n\n- **`status_col`** - Column number of the status column.\n\n  Value type: [pos_integer()](`t:erlang:pos_integer/0`)\n\n- **`not_accessible`** - A sorted list of columns (> first_accessible) that are\n  'not-accessible'.\n\n  Value type: [[pos_integer()](`t:erlang:pos_integer/0`)]\n\n- **`index_types`** - A list of [asn1_type()](`t:snmp:asn1_type/0`) for the\n  index columns, ordered by column number or an \"augment\"-tuple (see below).\n\n  Value type: [[asn1_type()](`t:snmp:asn1_type/0`)]\n\n- **`first_accessible`** - The first accessible column.\n\n  Value type: [pos_integer()](`t:erlang:pos_integer/0`)\n\n- **`first_own_index`** - Column number of the first own index. Will be `0` if\n  there is no such index for this table.\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\nFor a augmented table, it will instead look like this:\n\n- **`index_types`** - Value type: \\{augments, \\{[atom()](`t:erlang:atom/0`),\n  [asn1_type()](`t:snmp:asn1_type/0`)\\}\\}\n\n- **`nbr_of_cols`** - Value type: [pos_integer()](`t:erlang:pos_integer/0`)\n\n- **`not_accessible`** - Value type: [[pos_integer()](`t:erlang:pos_integer/0`)]\n\n- **`first_accessible`** - Value type: [pos_integer()](`t:erlang:pos_integer/0`)","ref":"snmp_generic.html#t:table_info_item/0"},{"type":"module","title":"snmp_index","doc":"Abstract Data Type for SNMP Indexing\n\nThe module `snmp_index` implements an Abstract Data Type (ADT) for an SNMP index\nstructure for SNMP tables. It is implemented as an ets table of the ordered_set\ndata-type, which means that all operations are O(log n). In the table, the key\nis an ASN.1 OBJECT IDENTIFIER.\n\nThis index is used to separate the implementation of the SNMP ordering from the\nactual implementation of the table. The SNMP ordering, that is implementation of\nGET NEXT, is implemented in this module.\n\nFor example, suppose there is an SNMP table, which is best implemented in Erlang\nas one process per SNMP table row. Suppose further that the INDEX in the SNMP\ntable is an OCTET STRING. The index structure would be created as follows:\n\n```text\nsnmp_index:new(string)\n```\n\nFor each new process we create, we insert an item in an `snmp_index` structure:\n\n```erlang\nnew_process(Name, SnmpIndex) ->\n  Pid = start_process(),\n  NewSnmpIndex =\n    snmp_index:insert(SnmpIndex, Name, Pid),\n  <...>\n```\n\nWith this structure, we can now map an OBJECT IDENTIFIER in e.g. a GET NEXT\nrequest, to the correct process:\n\n```erlang\nget_next_pid(Oid, SnmpIndex) ->\n  {ok, {_, Pid}} = snmp_index:get_next(SnmpIndex, Oid),\n  Pid.\n```","ref":"snmp_index.html"},{"type":"module","title":"Warnings - snmp_index","doc":"> #### Warning {: .warning }\n>\n> [](){: #1 } All API functions that update the index return a `NewIndex` term.\n> This is for backward compatibility with a previous implementation that used a\n> B+ tree written purely in Erlang for the index. The `NewIndex` return value\n> can now be ignored. The return value is now the unchanged table identifier for\n> the ets table.\n>\n> The implementation using ets tables introduces a semantic incompatibility with\n> older implementations. In those older implementations, using pure Erlang\n> terms, the index was garbage collected like any other Erlang term and did not\n> have to be deleted when discarded. An ets table is deleted only when the\n> process creating it explicitly deletes it or when the creating process\n> terminates.\n>\n> A new interface [`delete/1`](`delete/1`) is now added to handle the case when\n> a process wants to discard an index table (i.e. to build a completely new).\n> Any application using transient snmp indexes has to be modified to handle\n> this.\n>\n> As an snmp adaption usually keeps the index for the whole of the systems\n> lifetime, this is rarely a problem.","ref":"snmp_index.html#module-warnings"},{"type":"function","title":"snmp_index.delete/1","doc":"Deletes a complete index structure (i.e. the ets table holding the index). The\nindex can no longer be referenced after this call. See the\n[warning note](`m:snmp_index#1`) above.","ref":"snmp_index.html#delete/1"},{"type":"function","title":"snmp_index.delete/2","doc":"Deletes a key and its value from the index structure. Returns a new structure.","ref":"snmp_index.html#delete/2"},{"type":"function","title":"snmp_index.get/2","doc":"Gets the item with key `KeyOid`. Could be used from within an SNMP\ninstrumentation function.","ref":"snmp_index.html#get/2"},{"type":"function","title":"snmp_index.get_last/1","doc":"Gets the last item in the index structure.","ref":"snmp_index.html#get_last/1"},{"type":"function","title":"snmp_index.get_next/2","doc":"Gets the next item in the SNMP lexicographic ordering, after `KeyOid` in the\nindex structure. `KeyOid` does not have to refer to an existing item in the\nindex.","ref":"snmp_index.html#get_next/2"},{"type":"function","title":"snmp_index.insert/3","doc":"Inserts a new key value tuple into the index structure. If an item with the same\nkey already exists, the new `Value` overwrites the old value.","ref":"snmp_index.html#insert/3"},{"type":"function","title":"snmp_index.key_to_oid/2","doc":"Converts `Key` to an OBJECT IDENTIFIER.","ref":"snmp_index.html#key_to_oid/2"},{"type":"function","title":"snmp_index.new/1","doc":"Create an new anonymous snmp index structure.","ref":"snmp_index.html#new/1"},{"type":"function","title":"snmp_index.new/2","doc":"Creates a new named snmp index structure.","ref":"snmp_index.html#new/2"},{"type":"opaque","title":"snmp_index.index/0","doc":"This type denotes an snmp index structure.","ref":"snmp_index.html#t:index/0"},{"type":"type","title":"snmp_index.key/0","doc":"This type correlates to the `t:key_types/0` type. If the `t:key_types/0` is a\nsingle atom, the corresponding `t:key/0` is a single type as well, but if the\n`t:key_types/0` is a tuple, `t:key/0` must be a tuple of the same size.\n\nIn the example above, valid `keys` could be `{\"hi\", \"mom\"}` and\n`{\"no\", \"thanks\"}`, whereas `\"hi\"`, `{\"hi\", 42}` and `{\"hello\", \"there\"}` would\nbe invalid.\n\nThere is no way to propely describe this type in the erlang type language, which\nis why `t:tuple/0` was used above. The proper definition looks like:\n\n`key() = key_spec() | {key_spec(), key_spec(), ...}`","ref":"snmp_index.html#t:key/0"},{"type":"type","title":"snmp_index.key_spec/0","doc":"","ref":"snmp_index.html#t:key_spec/0"},{"type":"type","title":"snmp_index.key_types/0","doc":"This type is used when creating the index structure, and the `t:key/0` type is\nused when inserting and deleting items from the structure.\n\nIf the INDEX column is of type INTEGER, or derived from INTEGER, the\ncorresponding type should be `integer`. If it is a variable length type (e.g.\nOBJECT IDENTIFIER, OCTET STRING), the corresponding type should be `string`.\nFinally, if the type is of variable length, but with a fixed size restriction\n(e.g. IpAddress), the corresponding type should be `fix_string`.\n\nThere is no way to propely describe this type in the erlang type language, which\nis why `t:tuple/0` was used above. The proper definition looks like:\n\n`key_types = type_spec() | {type_spec(), type_spec(), ...}`","ref":"snmp_index.html#t:key_types/0"},{"type":"type","title":"snmp_index.type_spec/0","doc":"","ref":"snmp_index.html#t:type_spec/0"},{"type":"module","title":"snmp_notification_mib","doc":"Instrumentation Functions for SNMP-NOTIFICATION-MIB\n\nThe module `snmp_notification_mib` implements the instrumentation functions for\nthe SNMP-NOTIFICATION-MIB, and functions for configuring the database.\n\nThe configuration files are described in the SNMP User's Manual.","ref":"snmp_notification_mib.html"},{"type":"function","title":"snmp_notification_mib.add_notify/3","doc":"Adds a notify definition to the agent config. Equivalent to one line in the\n`notify.conf` file.","ref":"snmp_notification_mib.html#add_notify/3"},{"type":"function","title":"snmp_notification_mib.configure/1","doc":"This function is called from the supervisor at system start-up.\n\nInserts all data in the configuration files into the database and destroys all\nold rows with StorageType `volatile`. The rows created from the configuration\nfile will have StorageType `nonVolatile`.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nreason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `notify.conf`.","ref":"snmp_notification_mib.html#configure/1"},{"type":"function","title":"snmp_notification_mib.delete_notify/1","doc":"Delete a notify definition from the agent config.","ref":"snmp_notification_mib.html#delete_notify/1"},{"type":"function","title":"snmp_notification_mib.reconfigure/1","doc":"Inserts all data in the configuration files into the database and destroys all\nold data, including the rows with StorageType `nonVolatile`. The rows created\nfrom the configuration file will have StorageType `nonVolatile`.\n\nThus, the data in the SNMP-NOTIFICATION-MIB, after this function has been\ncalled, is from the configuration files.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nreason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `notify.conf`.","ref":"snmp_notification_mib.html#reconfigure/1"},{"type":"type","title":"snmp_notification_mib.notify_name/0","doc":"`SnmpAdminString (SIZE(1..32))`","ref":"snmp_notification_mib.html#t:notify_name/0"},{"type":"type","title":"snmp_notification_mib.notify_tag/0","doc":"","ref":"snmp_notification_mib.html#t:notify_tag/0"},{"type":"type","title":"snmp_notification_mib.notify_type/0","doc":"","ref":"snmp_notification_mib.html#t:notify_type/0"},{"type":"module","title":"snmp_pdus","doc":"Encode and Decode Functions for SNMP PDUs\n\nRFC1157, RFC1905 and/or RFC2272 should be studied carefully before using this\nmodule, `snmp_pdus`.\n\nThe module `snmp_pdus` contains functions for encoding and decoding of SNMP\nprotocol data units (PDUs). In short, this module converts a list of bytes to\nErlang record representations and vice versa. The record definitions can be\nfound in the file `snmp/include/snmp_types.hrl`. If snmpv3 is used, the module\nthat includes `snmp_types.hrl` must define the constant `SNMP_USE_V3` before the\nheader file is included. Example:\n\n```erlang\n-define(SNMP_USE_V3, true).\n-include_lib(\"snmp/include/snmp_types.hrl\").\n```\n\nEncoding and decoding must be done explicitly when writing your own Net if\nprocess.","ref":"snmp_pdus.html"},{"type":"function","title":"snmp_pdus.dec_message/1","doc":"Decodes a list of bytes into an SNMP Message. Note, if there is a v3 message,\nthe `msgSecurityParameters` are not decoded. They must be explicitly decoded by\na call to a security model specific decoding function, e.g.\n[`dec_usm_security_parameters/1`](`dec_usm_security_parameters/1`). Also note,\nif the `scopedPDU` is encrypted, the OCTET STRING encoded `encryptedPDU` will be\npresent in the `data` field.","ref":"snmp_pdus.html#dec_message/1"},{"type":"function","title":"snmp_pdus.dec_message_only/1","doc":"Decodes a list of bytes into an SNMP Message, but does not decode the data part\nof the Message. That means, data is still a list of bytes, normally an encoded\n`PDU` (v1 and V2) or an encoded and possibly encrypted `scopedPDU` (v3).","ref":"snmp_pdus.html#dec_message_only/1"},{"type":"function","title":"snmp_pdus.dec_pdu/1","doc":"Decodes a list of bytes into an SNMP Pdu.","ref":"snmp_pdus.html#dec_pdu/1"},{"type":"function","title":"snmp_pdus.dec_scoped_pdu/1","doc":"Decodes a list of bytes into an SNMP ScopedPdu.","ref":"snmp_pdus.html#dec_scoped_pdu/1"},{"type":"function","title":"snmp_pdus.dec_scoped_pdu_data/1","doc":"Decodes a list of bytes into either a scoped pdu record, or - if the scoped pdu\nwas encrypted - to a list of bytes.","ref":"snmp_pdus.html#dec_scoped_pdu_data/1"},{"type":"function","title":"snmp_pdus.dec_usm_security_parameters/1","doc":"Decodes a list of bytes into an SNMP UsmSecurityParameters.","ref":"snmp_pdus.html#dec_usm_security_parameters/1"},{"type":"function","title":"snmp_pdus.enc_message/1","doc":"Encodes a message record to a list of bytes.","ref":"snmp_pdus.html#enc_message/1"},{"type":"function","title":"snmp_pdus.enc_message_only/1","doc":"`Message` is a record where the `data` field is assumed to be encoded (a list of\nbytes). If there is a v1 or v2 message, the `data` field is an encoded `PDU`,\nand if there is a v3 message, `data` is an encoded and possibly encrypted\n`scopedPDU`.","ref":"snmp_pdus.html#enc_message_only/1"},{"type":"function","title":"snmp_pdus.enc_pdu/1","doc":"Encodes an SNMP Pdu into a list of bytes.","ref":"snmp_pdus.html#enc_pdu/1"},{"type":"function","title":"snmp_pdus.enc_scoped_pdu/1","doc":"Encodes an SNMP ScopedPdu into a list of bytes, which can be encrypted, and\nafter encryption, encoded with a call to `enc_encrypted_scoped_pdu/1`; or it can\nbe used as the `data` field in a `message` record, which then can be encoded\nwith [`enc_message_only/1`](`enc_message_only/1`).","ref":"snmp_pdus.html#enc_scoped_pdu/1"},{"type":"function","title":"snmp_pdus.enc_usm_security_parameters/1","doc":"Encodes SNMP UsmSecurityParameters into a list of bytes.","ref":"snmp_pdus.html#enc_usm_security_parameters/1"},{"type":"type","title":"snmp_pdus.message/0","doc":"The message is version dependent. 'vsn_hdr' is either a community string (v1 and\nv2) or a 'v3_hdr' record (v3). 'data' is either a PDU (v1 and v2c) or a\n(possibly encrypted) 'scopedPdu'.","ref":"snmp_pdus.html#t:message/0"},{"type":"type","title":"snmp_pdus.msg_id/0","doc":"","ref":"snmp_pdus.html#t:msg_id/0"},{"type":"type","title":"snmp_pdus.msg_security_model/0","doc":"","ref":"snmp_pdus.html#t:msg_security_model/0"},{"type":"type","title":"snmp_pdus.pdu/0","doc":"","ref":"snmp_pdus.html#t:pdu/0"},{"type":"type","title":"snmp_pdus.pdu_type/0","doc":"","ref":"snmp_pdus.html#t:pdu_type/0"},{"type":"type","title":"snmp_pdus.scoped_pdu/0","doc":"","ref":"snmp_pdus.html#t:scoped_pdu/0"},{"type":"type","title":"snmp_pdus.trappdu/0","doc":"","ref":"snmp_pdus.html#t:trappdu/0"},{"type":"type","title":"snmp_pdus.usm_security_parameters/0","doc":"","ref":"snmp_pdus.html#t:usm_security_parameters/0"},{"type":"type","title":"snmp_pdus.v3_hdr/0","doc":"","ref":"snmp_pdus.html#t:v3_hdr/0"},{"type":"type","title":"snmp_pdus.version/0","doc":"","ref":"snmp_pdus.html#t:version/0"},{"type":"module","title":"snmp_standard_mib","doc":"Instrumentation Functions for STANDARD-MIB and SNMPv2-MIB\n\nThe module `snmp_standard_mib` implements the instrumentation functions for the\nSTANDARD-MIB and SNMPv2-MIB, and functions for configuring the database.\n\nThe configuration files are described in the SNMP User's Manual.","ref":"snmp_standard_mib.html"},{"type":"function","title":"snmp_standard_mib.configure/1","doc":"This function is called from the supervisor at system start-up.\n\nInserts all data in the configuration files into the database and destroys all\nold rows with StorageType `volatile`. The rows created from the configuration\nfile will have StorageType `nonVolatile`.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nthe reason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `standard.conf`.","ref":"snmp_standard_mib.html#configure/1"},{"type":"function","title":"snmp_standard_mib.inc/1","doc":"","ref":"snmp_standard_mib.html#inc/1"},{"type":"function","title":"snmp_standard_mib.inc/2","doc":"Increments a variable in the MIB with `N`, or one if `N` is not specified.","ref":"snmp_standard_mib.html#inc/2"},{"type":"function","title":"snmp_standard_mib.reconfigure/1","doc":"Inserts all data in the configuration files into the database and destroys all\nold data, including the rows with StorageType `nonVolatile`. The rows created\nfrom the configuration file will have StorageType `nonVolatile`.\n\nThus, the data in the SNMP-STANDARD-MIB and SNMPv2-MIB, after this function has\nbeen called, is from the configuration files.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nthe reason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `standard.conf`.","ref":"snmp_standard_mib.html#reconfigure/1"},{"type":"function","title":"snmp_standard_mib.reset/0","doc":"Resets all `snmp` counters to 0.","ref":"snmp_standard_mib.html#reset/0"},{"type":"function","title":"snmp_standard_mib.sys_up_time/0","doc":"Gets the system up time in hundredth of a second.","ref":"snmp_standard_mib.html#sys_up_time/0"},{"type":"module","title":"snmp_target_mib","doc":"Instrumentation Functions for SNMP-TARGET-MIB\n\nThe module `snmp_target_mib` implements the instrumentation functions for the\nSNMP-TARGET-MIB, and functions for configuring the database.\n\nThe configuration files are described in the SNMP User's Manual.\n\nLegacy API functions [`add_addr/10`](`add_addr/10`) that does not specify\ntransport domain, and `add_addr/11` that has got separate `IpAddr` and\n`PortNumber` arguments still work as before for backwards compatibility reasons.","ref":"snmp_target_mib.html"},{"type":"module","title":"DATA TYPES - snmp_target_mib","doc":"See the [data types in `snmpa_conf`](`m:snmpa_conf#types`).","ref":"snmp_target_mib.html#module-data-types"},{"type":"function","title":"snmp_target_mib.add_addr/10","doc":"Adds a target address definition to the agent config. Equivalent to one line in\nthe `target_addr.conf` file.","ref":"snmp_target_mib.html#add_addr/10"},{"type":"function","title":"snmp_target_mib.add_params/5","doc":"Adds a target parameter definition to the agent config. Equivalent to one line\nin the `target_params.conf` file.","ref":"snmp_target_mib.html#add_params/5"},{"type":"function","title":"snmp_target_mib.configure/1","doc":"This function is called from the supervisor at system start-up.\n\nInserts all data in the configuration files into the database and destroys all\nold rows with StorageType `volatile`. The rows created from the configuration\nfile will have StorageType `nonVolatile`.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nthe reason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration files read are: `target_addr.conf` and `target_params.conf`.","ref":"snmp_target_mib.html#configure/1"},{"type":"function","title":"snmp_target_mib.delete_addr/1","doc":"Delete a target address definition from the agent config.","ref":"snmp_target_mib.html#delete_addr/1"},{"type":"function","title":"snmp_target_mib.delete_params/1","doc":"Delete a target parameter definition from the agent config.","ref":"snmp_target_mib.html#delete_params/1"},{"type":"function","title":"snmp_target_mib.reconfigure/1","doc":"Inserts all data in the configuration files into the database and destroys all\nold data, including the rows with StorageType `nonVolatile`. The rows created\nfrom the configuration file will have StorageType `nonVolatile`.\n\nThus, the data in the SNMP-TARGET-MIB, after this function has been called, is\nthe data from the configuration files.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the , and the function fails with the reason\n`configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration files read are: `target_addr.conf` and `target_params.conf`.","ref":"snmp_target_mib.html#reconfigure/1"},{"type":"function","title":"snmp_target_mib.set_target_engine_id/2","doc":"Changes the engine id for a target in the `snmpTargetAddrTable`. If\nnotifications are sent as Inform requests to a target, its engine id must be\nset.","ref":"snmp_target_mib.html#set_target_engine_id/2"},{"type":"type","title":"snmp_target_mib.mms/0","doc":"> #### Note {: .info }\n>\n> \"The maximum message size value associated with an entry in the\n> snmpTargetAddrTable.\".\n\n`Integer32 (484..65535)`","ref":"snmp_target_mib.html#t:mms/0"},{"type":"type","title":"snmp_target_mib.name/0","doc":"> #### Note {: .info }\n>\n> \"The locally arbitrary, but unique identifier associated with this\n> snmpTargetAddrEntry.\"\n\n`SnmpAdminString (SIZE(1..32))`","ref":"snmp_target_mib.html#t:name/0"},{"type":"type","title":"snmp_target_mib.params/0","doc":"> #### Note {: .info }\n>\n> \"The value of this object identifies an entry in the snmpTargetParamsTable.\"\n\n`SnmpAdminString (SIZE(1..32))`","ref":"snmp_target_mib.html#t:params/0"},{"type":"type","title":"snmp_target_mib.retry_count/0","doc":"> #### Note {: .info }\n>\n> \"This object specifies a default number of retries to be attempted when a\n> response is not received for a generated message.\"\n\n`Integer32 (0..255)`","ref":"snmp_target_mib.html#t:retry_count/0"},{"type":"type","title":"snmp_target_mib.tag_list/0","doc":"> #### Note {: .info }\n>\n> \"An octet string containing a list of tag values. Tag values are preferably in\n> human-readable form.\"\n>\n> \"To facilitate internationalization, this information is represented using the\n> ISO/IEC IS 10646-1 character set, encoded as an octet string using the UTF-8\n> character encoding scheme described in RFC 2279.\"\n\n`OCTET STRING (SIZE (0..255))`","ref":"snmp_target_mib.html#t:tag_list/0"},{"type":"type","title":"snmp_target_mib.tag_value/0","doc":"> #### Note {: .info }\n>\n> \"An octet string containing a tag value. Tag values are preferably in\n> human-readable form.\"\n\n`OCTET STRING (SIZE (0..255))`","ref":"snmp_target_mib.html#t:tag_value/0"},{"type":"type","title":"snmp_target_mib.tmask/0","doc":"> #### Note {: .info }\n>\n> \"The mask value associated with an entry in the snmpTargetAddrTable. The value\n> of this object must have the same length as the corresponding instance of\n> snmpTargetAddrTAddress, or must have length 0.\"\n\n`OCTET STRING (SIZE (0..255))`","ref":"snmp_target_mib.html#t:tmask/0"},{"type":"module","title":"snmp_user_based_sm_mib","doc":"Instrumentation Functions for SNMP-USER-BASED-SM-MIB\n\nThe module `snmp_user_based_sm_mib` implements the instrumentation functions for\nthe SNMP-USER-BASED-SM-MIB, and functions for configuring the database.\n\nNote that authentication has been extended according to RFC 7860\n(SNMP-USM-HMAC-SHA2-MIB).\n\nThe configuration files are described in the SNMP User's Manual.","ref":"snmp_user_based_sm_mib.html"},{"type":"function","title":"snmp_user_based_sm_mib.add_user/13","doc":"Adds a USM security data (user) to the agent config. Equivalent to one line in\nthe `usm.conf` file.","ref":"snmp_user_based_sm_mib.html#add_user/13"},{"type":"function","title":"snmp_user_based_sm_mib.configure/1","doc":"This function is called from the supervisor at system start-up.\n\nInserts all data in the configuration files into the database and destroys all\nold rows with StorageType `volatile`. The rows created from the configuration\nfile will have StorageType `nonVolatile`.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nthe reason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `usm.conf`.","ref":"snmp_user_based_sm_mib.html#configure/1"},{"type":"function","title":"snmp_user_based_sm_mib.delete_user/1","doc":"Delete a USM security data (user) from the agent config.","ref":"snmp_user_based_sm_mib.html#delete_user/1"},{"type":"function","title":"snmp_user_based_sm_mib.reconfigure/1","doc":"Inserts all data in the configuration files into the database and destroys all\nold data, including the rows with StorageType `nonVolatile`. The rows created\nfrom the configuration file will have StorageType `nonVolatile`.\n\nThus, the data in the SNMP-USER-BASED-SM-MIB, after this function has been\ncalled, is the data from the configuration files.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nthe reason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `usm.conf`.","ref":"snmp_user_based_sm_mib.html#reconfigure/1"},{"type":"type","title":"snmp_user_based_sm_mib.auth_key/0","doc":"The size/length of the list depends on auth protocol:\n\n```text\n               Size any for usmNoAuthProtocol\n               Size 16  for usmHMACMD5AuthProtocol\n               Size 20  for usmHMACSHAAuthProtocol\n               Size 28  for usmHMAC128SHA224AuthProtocol\n               Size 32  for usmHMAC192SHA256AuthProtocol\n               Size 48  for usmHMAC256SHA384AuthProtocol\n\t       Size 64  for usmHMAC384SHA512AuthProtocol\n```","ref":"snmp_user_based_sm_mib.html#t:auth_key/0"},{"type":"type","title":"snmp_user_based_sm_mib.auth_protocol/0","doc":"> #### Note {: .info }\n>\n> \"An indication of whether messages sent on behalf of this user to/from the\n> SNMP engine identified by usmUserEngineID, can be authenticated, and if so,\n> the type of authentication protocol which is used.\"\n\n> #### Note {: .info }\n>\n> Some of the entries of this type are actually defined by the\n> SNMP-USM-HMAC-SHA2-MIB mib.\n\n`AutonomousType`","ref":"snmp_user_based_sm_mib.html#t:auth_protocol/0"},{"type":"type","title":"snmp_user_based_sm_mib.clone_from/0","doc":"> #### Note {: .info }\n>\n> \"A pointer to another conceptual row in this usmUserTable. The user in this\n> other conceptual row is called the clone-from user.\"\n\n`RowPointer`","ref":"snmp_user_based_sm_mib.html#t:clone_from/0"},{"type":"type","title":"snmp_user_based_sm_mib.key_change/0","doc":"> #### Note {: .info }\n>\n> \"Every definition of an object with this syntax must identify a protocol P, a\n> secret key K, and a hash algorithm H that produces output of L octets.\"\n\n`OCTET STRING`","ref":"snmp_user_based_sm_mib.html#t:key_change/0"},{"type":"type","title":"snmp_user_based_sm_mib.name/0","doc":"> #### Note {: .info }\n>\n> \"A human readable string representing the name of the user. This is the\n> (User-based Security) Model dependent security ID.\"\n\n`SnmpAdminString (SIZE(1..32))`","ref":"snmp_user_based_sm_mib.html#t:name/0"},{"type":"type","title":"snmp_user_based_sm_mib.priv_key/0","doc":"The size/length of the list depends on priv protocol:\n\n```text\n\t       Size any for usmNoPrivProtocol\n               Size 16  for usmDESPrivProtocol\n               Size 16  for usmAesCfb128Protocol\n```","ref":"snmp_user_based_sm_mib.html#t:priv_key/0"},{"type":"type","title":"snmp_user_based_sm_mib.priv_protocol/0","doc":"> #### Note {: .info }\n>\n> \"An indication of whether messages sent on behalf of this user to/from the\n> SNMP engine identified by usmUserEngineID, can be protected from disclosure,\n> and if so, the type of privacy protocol which is used.\"\n\n> #### Note {: .info }\n>\n> Some of the entries of this tyype are actually defined by the SNMP-USM-AES-MIB\n> mib.\n\n`AutonomousType`","ref":"snmp_user_based_sm_mib.html#t:priv_protocol/0"},{"type":"type","title":"snmp_user_based_sm_mib.public/0","doc":"`OCTET STRING (SIZE(0..32))`","ref":"snmp_user_based_sm_mib.html#t:public/0"},{"type":"type","title":"snmp_user_based_sm_mib.usm_entry/0","doc":"","ref":"snmp_user_based_sm_mib.html#t:usm_entry/0"},{"type":"module","title":"snmp_view_based_acm_mib","doc":"Instrumentation Functions for SNMP-VIEW-BASED-ACM-MIB\n\nThe module `snmp_view_based_acm_mib` implements the instrumentation functions\nfor the SNMP-VIEW-BASED-ACM-MIB, and functions for configuring the database.\n\nThe configuration files are described in the SNMP User's Manual.","ref":"snmp_view_based_acm_mib.html"},{"type":"function","title":"snmp_view_based_acm_mib.add_access/8","doc":"Adds a access definition to the agent config. Equivalent to one vacmAccess-line\nin the `vacm.conf` file.","ref":"snmp_view_based_acm_mib.html#add_access/8"},{"type":"function","title":"snmp_view_based_acm_mib.add_sec2group/3","doc":"Adds a security to group definition to the agent config. Equivalent to one\nvacmSecurityToGroup-line in the `vacm.conf` file.","ref":"snmp_view_based_acm_mib.html#add_sec2group/3"},{"type":"function","title":"snmp_view_based_acm_mib.add_view_tree_fam/4","doc":"Adds a view tree family definition to the agent config. Equivalent to one\nvacmViewTreeFamily-line in the `vacm.conf` file.","ref":"snmp_view_based_acm_mib.html#add_view_tree_fam/4"},{"type":"function","title":"snmp_view_based_acm_mib.configure/1","doc":"This function is called from the supervisor at system start-up.\n\nInserts all data in the configuration files into the database and destroys all\nold rows with StorageType `volatile`. The rows created from the configuration\nfile will have StorageType `nonVolatile`.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction `config_err/2` of the error report module, and the function fails with\nthe reason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `vacm.conf`.","ref":"snmp_view_based_acm_mib.html#configure/1"},{"type":"function","title":"snmp_view_based_acm_mib.delete_access/1","doc":"Delete a access definition from the agent config.","ref":"snmp_view_based_acm_mib.html#delete_access/1"},{"type":"function","title":"snmp_view_based_acm_mib.delete_sec2group/1","doc":"Delete a security to group definition from the agent config.","ref":"snmp_view_based_acm_mib.html#delete_sec2group/1"},{"type":"function","title":"snmp_view_based_acm_mib.delete_view_tree_fam/1","doc":"Delete a view tree family definition from the agent config.","ref":"snmp_view_based_acm_mib.html#delete_view_tree_fam/1"},{"type":"function","title":"snmp_view_based_acm_mib.reconfigure/1","doc":"Inserts all data in the configuration files into the database and destroys all\nold data, including the rows with StorageType `nonVolatile`. The rows created\nfrom the configuration file will have StorageType `nonVolatile`.\n\nThus, the data in the SNMP-VIEW-BASED-ACM-MIB, after this function has been\ncalled, is the data from the configuration files.\n\nAll `snmp` counters are set to zero.\n\nIf an error is found in the configuration file, it is reported using the\nfunction [config_err/2](`m:snmpa_error#config_err`) of the error report module,\nand the function fails with the reason `configuration_error`.\n\n`ConfDir` is a string which points to the directory where the configuration\nfiles are found.\n\nThe configuration file read is: `vacm.conf`.","ref":"snmp_view_based_acm_mib.html#reconfigure/1"},{"type":"type","title":"snmp_view_based_acm_mib.access_notify_view_name/0","doc":"> #### Note {: .info }\n>\n> \"The value of an instance of this object identifies the MIB view of the SNMP\n> context to which this conceptual row authorizes access for notifications.\"\n\n`SnmpAdminString (SIZE(0..32))`","ref":"snmp_view_based_acm_mib.html#t:access_notify_view_name/0"},{"type":"type","title":"snmp_view_based_acm_mib.access_read_view_name/0","doc":"> #### Note {: .info }\n>\n> \"The value of an instance of this object identifies the MIB view of the SNMP\n> context to which this conceptual row authorizes read access.\"\n\n`SnmpAdminString (SIZE(0..32))`","ref":"snmp_view_based_acm_mib.html#t:access_read_view_name/0"},{"type":"type","title":"snmp_view_based_acm_mib.access_write_view_name/0","doc":"> #### Note {: .info }\n>\n> \"The value of an instance of this object identifies the MIB view of the SNMP\n> context to which this conceptual row authorizes write access.\"\n\n`SnmpAdminString (SIZE(0..32))`","ref":"snmp_view_based_acm_mib.html#t:access_write_view_name/0"},{"type":"type","title":"snmp_view_based_acm_mib.context_match/0","doc":"```text\n\t  exact  - exact match of prefix and contextName\n          prefix - Only match to the prefix\n```\n\n`INTEGER { exact (1), prefix (2) }`","ref":"snmp_view_based_acm_mib.html#t:context_match/0"},{"type":"type","title":"snmp_view_based_acm_mib.context_prefix/0","doc":"`SnmpAdminString (SIZE(0..32))`","ref":"snmp_view_based_acm_mib.html#t:context_prefix/0"},{"type":"type","title":"snmp_view_based_acm_mib.group_name/0","doc":"> #### Note {: .info }\n>\n> \"The name of the group to which this entry (e.g., the combination of\n> securityModel and securityName) belongs.\"\n\n`SnmpAdminString (SIZE(1..32))`","ref":"snmp_view_based_acm_mib.html#t:group_name/0"},{"type":"type","title":"snmp_view_based_acm_mib.internal_view_mask/0","doc":"","ref":"snmp_view_based_acm_mib.html#t:internal_view_mask/0"},{"type":"type","title":"snmp_view_based_acm_mib.internal_view_mask_element/0","doc":"","ref":"snmp_view_based_acm_mib.html#t:internal_view_mask_element/0"},{"type":"type","title":"snmp_view_based_acm_mib.internal_view_type/0","doc":"","ref":"snmp_view_based_acm_mib.html#t:internal_view_type/0"},{"type":"type","title":"snmp_view_based_acm_mib.mibview/0","doc":"","ref":"snmp_view_based_acm_mib.html#t:mibview/0"},{"type":"type","title":"snmp_view_based_acm_mib.security_name/0","doc":"> #### Note {: .info }\n>\n> \"The securityName for the principal, represented in a Security Model\n> independent format.\"\n\n`SnmpAdminString (SIZE(1..32))`","ref":"snmp_view_based_acm_mib.html#t:security_name/0"},{"type":"type","title":"snmp_view_based_acm_mib.view_mask/0","doc":"The bit mask which, in combination with the corresponding instance of\nvacmViewTreeFamilySubtree, defines a family of view subtrees.\n\nA '1' indicates that an exact match must occur, a '0' indicates 'wild card' (any\nsub-identifier value matches).\n\n> #### Note {: .info }\n>\n> Note that in the \"external\" format, each bit of each octet is represented by a\n> \"bit\" in this list. That is, each octet \"contains\" 8 bits; so at most 8\\*16 =\n> 128 bits in total.\n\n`OCTET STRING (SIZE (0..16))`","ref":"snmp_view_based_acm_mib.html#t:view_mask/0"},{"type":"type","title":"snmp_view_based_acm_mib.view_name/0","doc":"> #### Note {: .info }\n>\n> \"The human readable name for a family of view subtrees.\"\n\n`SnmpAdminString (SIZE(1..32))`","ref":"snmp_view_based_acm_mib.html#t:view_name/0"},{"type":"type","title":"snmp_view_based_acm_mib.view_type/0","doc":"Does the corresponding instances of subtree and mask define a family of view\nsubtrees which are included in or excluded from the MIB view.\n\n`INTEGER { included(1), excluded(2) }`","ref":"snmp_view_based_acm_mib.html#t:view_type/0"},{"type":"module","title":"snmpa","doc":"Interface Functions to the SNMP toolkit agent\n\nThe module `snmpa` contains interface functions to the SNMP agent.","ref":"snmpa.html"},{"type":"function","title":"snmpa.add_agent_caps/2","doc":"This function can be used to add an AGENT-CAPABILITY statement to the sysORTable\nin the agent. The table is defined in the SNMPv2-MIB.","ref":"snmpa.html#add_agent_caps/2"},{"type":"function","title":"snmpa.backup/1","doc":"","ref":"snmpa.html#backup/1"},{"type":"function","title":"snmpa.backup/2","doc":"Backup persistent/permanent data handled by the agent (such as local-db,\nmib-data and vacm).\n\nData stored by mnesia is not handled.\n\n`BackupDir` cannot be identical to DbDir.\n\nSimultaneous backup calls are _not_ allowed. That is, two different processes\ncannot simultaneously successfully call this function. One of them will be\nfirst, and succeed. The second will fail with the error reason\n`backup_in_progress`.","ref":"snmpa.html#backup/2"},{"type":"function","title":"snmpa.change_log_size/1","doc":"Changes the log size of the Audit Trail Log. The application must be configured\nto use the audit trail log function. Please refer to disk_log(3) in Kernel\nReference Manual for a description of how to change the log size.\n\nThe change is permanent, as long as the log is not deleted. That means, the log\nsize is remembered across reboots.","ref":"snmpa.html#change_log_size/1"},{"type":"function","title":"snmpa.convert_config/1","doc":"This off-line utility function can be used to convert the old snmp application\nconfig (pre snmp-4.0) to the new snmp agent config (as of snmp-4.0).\n\nFor information about the old config (`OldConfig`) see the OTP R9C\ndocumentation.\n\nFor information about the current agent config (`AgentConfig`), see the\n[Configuring the application](snmp_config.md#configuration_params) chapter of\nthe SNMP user's guide.","ref":"snmpa.html#convert_config/1"},{"type":"function","title":"snmpa.current_address/0","doc":"Get the address of the request currently being processed by the agent.\n\nNote that this function is intended to be called by the instrumentation\nfunctions and _only_ if it is executed in the context of the agent process (e.g.\nit _does not work_ if called from a spawned process).","ref":"snmpa.html#current_address/0"},{"type":"function","title":"snmpa.current_community/0","doc":"Get the community of the request currently being processed by the agent.\n\nNote that this function is intended to be called by the instrumentation\nfunctions and _only_ if it is executed in the context of the agent process (e.g.\nit _does not work_ if called from a spawned process).","ref":"snmpa.html#current_community/0"},{"type":"function","title":"snmpa.current_context/0","doc":"Get the context of the request currently being processed by the agent.\n\nNote that this function is intended to be called by the instrumentation\nfunctions and _only_ if it is executed in the context of the agent process (e.g.\nit _does not work_ if called from a spawned process).","ref":"snmpa.html#current_context/0"},{"type":"function","title":"snmpa.current_request_id/0","doc":"Get the request-id of the request currently being processed by the agent.\n\nNote that this function is intended to be called by the instrumentation\nfunctions and _only_ if it is executed in the context of the agent process (e.g.\nit _does not work_ if called from a spawned process).","ref":"snmpa.html#current_request_id/0"},{"type":"function","title":"snmpa.del_agent_caps/1","doc":"This function can be used to delete an AGENT-CAPABILITY statement to the\nsysORTable in the agent. This table is defined in the SNMPv2-MIB.","ref":"snmpa.html#del_agent_caps/1"},{"type":"function","title":"snmpa.disable_mibs_cache/0","doc":"","ref":"snmpa.html#disable_mibs_cache/0"},{"type":"function","title":"snmpa.disable_mibs_cache/1","doc":"Disable the mib server cache.","ref":"snmpa.html#disable_mibs_cache/1"},{"type":"function","title":"snmpa.disable_mibs_cache_autogc/0","doc":"","ref":"snmpa.html#disable_mibs_cache_autogc/0"},{"type":"function","title":"snmpa.disable_mibs_cache_autogc/1","doc":"Disable automatic gc of the mib server cache.","ref":"snmpa.html#disable_mibs_cache_autogc/1"},{"type":"function","title":"snmpa.discovery/2","doc":"","ref":"snmpa.html#discovery/2"},{"type":"function","title":"snmpa.discovery/3","doc":"","ref":"snmpa.html#discovery/3"},{"type":"function","title":"snmpa.discovery/4","doc":"","ref":"snmpa.html#discovery/4"},{"type":"function","title":"snmpa.discovery/5","doc":"","ref":"snmpa.html#discovery/5"},{"type":"function","title":"snmpa.discovery/6","doc":"Initiate the discovery process with the manager identified by `TargetName` using\nthe notification `Notification`.\n\nThis function is synchronous, which means that it will return when the discovery\nprocess has been completed or failed.\n\nThe `DiscoHandler` module is used during the discovery process. See\n[discovery handler](`m:snmpa_discovery_handler`) for more info.\n\nThe `ExtraInfo` argument is passed on to the callback functions of the\n`DiscoHandler`.\n\n> #### Note {: .info }\n>\n> If we are not at security-level `noAuthNoPriv`, this could be complicated,\n> since the agent will then continue with stage 2, before which the usm-related\n> updates must be done.\n\n> #### Note {: .info }\n>\n> The default discovery handler will require additional actions by the caller\n> and the discovery will not work if the security-level is higher then\n> `noAuthNoPriv`.","ref":"snmpa.html#discovery/6"},{"type":"function","title":"snmpa.enable_mibs_cache/0","doc":"","ref":"snmpa.html#enable_mibs_cache/0"},{"type":"function","title":"snmpa.enable_mibs_cache/1","doc":"Enable the mib server cache.","ref":"snmpa.html#enable_mibs_cache/1"},{"type":"function","title":"snmpa.enable_mibs_cache_autogc/0","doc":"","ref":"snmpa.html#enable_mibs_cache_autogc/0"},{"type":"function","title":"snmpa.enable_mibs_cache_autogc/1","doc":"Enable automatic gc of the mib server cache.","ref":"snmpa.html#enable_mibs_cache_autogc/1"},{"type":"function","title":"snmpa.enum_to_int/2","doc":"","ref":"snmpa.html#enum_to_int/2"},{"type":"function","title":"snmpa.enum_to_int/3","doc":"Converts the symbolic value `Enum` to the corresponding integer of the\nenumerated object or type `Name` in a MIB. The MIB must be loaded.\n\n`false` is returned if the object or type is not defined in any loaded MIB, or\nif it does not define the symbolic value as enumerated.\n\n`Db` is a reference to the symbolic store database (retrieved by a call to\n`get_symbolic_store_db/0`).","ref":"snmpa.html#enum_to_int/3"},{"type":"function","title":"snmpa.gc_mibs_cache/0","doc":"","ref":"snmpa.html#gc_mibs_cache/0"},{"type":"function","title":"snmpa.gc_mibs_cache/1","doc":"","ref":"snmpa.html#gc_mibs_cache/1"},{"type":"function","title":"snmpa.gc_mibs_cache/2","doc":"","ref":"snmpa.html#gc_mibs_cache/2"},{"type":"function","title":"snmpa.gc_mibs_cache/3","doc":"Perform mib server cache gc.\n\nManually performs a mib server cache gc. This can be done regardless of the\nvalue of the `autogc` option. The `NumElementsGCed` value indicates how many\nelements where actually removed from the cache.","ref":"snmpa.html#gc_mibs_cache/3"},{"type":"function","title":"snmpa.get/2","doc":"","ref":"snmpa.html#get/2"},{"type":"function","title":"snmpa.get/3","doc":"Performs a GET operation on the agent. All loaded MIB objects are visible in\nthis operation. The agent calls the corresponding instrumentation functions just\nas if it was a GET request coming from a manager.\n\nNote that the request specific parameters (such as\n`current_request_id/0`) are not accessible for the\ninstrumentation functions if this function is used.","ref":"snmpa.html#get/3"},{"type":"function","title":"snmpa.get_agent_caps/0","doc":"Returns all AGENT-CAPABILITY statements in the sysORTable in the agent. This\ntable is defined in the SNMPv2-MIB.\n\nNote that the Erlang type language do not permit us to properly describe what\nthis function returns. The _exact_ return is:\n\n`[[SysORIndex, SysORID, SysORDescr, SysORUpTime]]`","ref":"snmpa.html#get_agent_caps/0"},{"type":"function","title":"snmpa.get_next/2","doc":"","ref":"snmpa.html#get_next/2"},{"type":"function","title":"snmpa.get_next/3","doc":"Performs a GET-NEXT operation on the agent. All loaded MIB objects are visible\nin this operation. The agent calls the corresponding instrumentation functions\njust as if it was a GET request coming from a manager.\n\nNote that the request specific parameters (such as `snmpa:current_request_id/0`\nare not accessible for the instrumentation functions if this function is used.","ref":"snmpa.html#get_next/3"},{"type":"function","title":"snmpa.info/0","doc":"","ref":"snmpa.html#info/0"},{"type":"function","title":"snmpa.info/1","doc":"Returns a list (a dictionary) containing information about the agent.\nInformation includes loaded MIBs, registered sub-agents, some information about\nthe memory allocation.","ref":"snmpa.html#info/1"},{"type":"function","title":"snmpa.int_to_enum/2","doc":"","ref":"snmpa.html#int_to_enum/2"},{"type":"function","title":"snmpa.int_to_enum/3","doc":"Converts the integer `Int` to the corresponding symbolic value of the enumerated\nobject or type `Name` in a MIB. The MIB must be loaded.\n\n`false` is returned if the object or type is not defined in any loaded MIB, or\nif it does not define the symbolic value as enumerated.\n\n`Db` is a reference to the symbolic store database (retrieved by a call to\n`get_symbolic_store_db/0`).","ref":"snmpa.html#int_to_enum/3"},{"type":"function","title":"snmpa.invalidate_mibs_cache/0","doc":"","ref":"snmpa.html#invalidate_mibs_cache/0"},{"type":"function","title":"snmpa.invalidate_mibs_cache/1","doc":"Invalidate the mib server cache.\n\nThe entire contents of the cache will be deleted.","ref":"snmpa.html#invalidate_mibs_cache/1"},{"type":"function","title":"snmpa.load_mib/1","doc":"","ref":"snmpa.html#load_mib/1"},{"type":"function","title":"snmpa.load_mib/2","doc":"Load a single `Mib` into an agent. The `MibName` is the name of the Mib,\nincluding the path to where the compiled mib is found. For example:\n\n```erlang\n          Dir = code:priv_dir(my_app) ++ \"/mibs/\",\n          snmpa:load_mib(snmp_master_agent, Dir ++ \"MY-MIB\").\n```","ref":"snmpa.html#load_mib/2"},{"type":"function","title":"snmpa.load_mibs/1","doc":"","ref":"snmpa.html#load_mibs/1"},{"type":"function","title":"snmpa.load_mibs/2","doc":"","ref":"snmpa.html#load_mibs/2"},{"type":"function","title":"snmpa.load_mibs/3","doc":"Load `Mibs` into an agent. If the agent cannot load all MIBs (the default value\nof the `Force` argument is `false`), it will indicate where loading was aborted.\nThe `MibName` is the name of the Mib, including the path to where the compiled\nmib is found. For example,\n\n```erlang\n          Dir = code:priv_dir(my_app) ++ \"/mibs/\",\n          snmpa:load_mibs(snmp_master_agent, [Dir ++ \"MY-MIB\"]).\n```\n\nIf `Force = true` then the agent will continue attempting to load each mib even\nafter failing to load a previous mib. Use with care.","ref":"snmpa.html#load_mibs/3"},{"type":"function","title":"snmpa.log_to_io/1","doc":"","ref":"snmpa.html#log_to_io/1"},{"type":"function","title":"snmpa.log_to_io/2","doc":"","ref":"snmpa.html#log_to_io/2"},{"type":"function","title":"snmpa.log_to_io/3","doc":"","ref":"snmpa.html#log_to_io/3"},{"type":"function","title":"snmpa.log_to_io/4","doc":"","ref":"snmpa.html#log_to_io/4"},{"type":"function","title":"snmpa.log_to_io/5","doc":"","ref":"snmpa.html#log_to_io/5"},{"type":"function","title":"snmpa.log_to_io/6","doc":"","ref":"snmpa.html#log_to_io/6"},{"type":"function","title":"snmpa.log_to_io/7","doc":"Converts an Audit Trail Log to a readable format and prints it on stdio.\n`LogName` defaults to \"snmpa_log\". `LogFile` defaults to \"snmpa.log\".\n\nThe `Block` option indicates if the log should be blocked during conversion.\nThis could be useful when converting large logs (when otherwise the log could\nwrap during conversion). Defaults to `true`.\n\nSee [`snmp:log_to_io/7`](`snmp:log_to_io/7`) for more info.","ref":"snmpa.html#log_to_io/7"},{"type":"function","title":"snmpa.log_to_txt/1","doc":"","ref":"snmpa.html#log_to_txt/1"},{"type":"function","title":"snmpa.log_to_txt/2","doc":"","ref":"snmpa.html#log_to_txt/2"},{"type":"function","title":"snmpa.log_to_txt/3","doc":"","ref":"snmpa.html#log_to_txt/3"},{"type":"function","title":"snmpa.log_to_txt/4","doc":"","ref":"snmpa.html#log_to_txt/4"},{"type":"function","title":"snmpa.log_to_txt/5","doc":"","ref":"snmpa.html#log_to_txt/5"},{"type":"function","title":"snmpa.log_to_txt/6","doc":"","ref":"snmpa.html#log_to_txt/6"},{"type":"function","title":"snmpa.log_to_txt/7","doc":"","ref":"snmpa.html#log_to_txt/7"},{"type":"function","title":"snmpa.log_to_txt/8","doc":"Converts an Audit Trail Log to a readable text file. `OutFile` defaults to\n\"./snmpa_log.txt\". `LogName` defaults to \"snmpa_log\". `LogFile` defaults to\n\"snmpa.log\".\n\nThe `Block` option indicates if the log should be blocked during conversion.\nThis could be useful when converting large logs (when otherwise the log could\nwrap during conversion). Defaults to `true`.\n\nSee [`snmp:log_to_txt/8`](`snmp:log_to_txt/8`) for more info.","ref":"snmpa.html#log_to_txt/8"},{"type":"function","title":"snmpa.me_of/1","doc":"","ref":"snmpa.html#me_of/1"},{"type":"function","title":"snmpa.me_of/2","doc":"Finds the mib entry corresponding to the `Oid`.\n\nIf it is a variable, the Oid must be  .0 and if it is a table, Oid\nmust be ` . . . `","ref":"snmpa.html#me_of/2"},{"type":"function","title":"snmpa.mib_of/1","doc":"","ref":"snmpa.html#mib_of/1"},{"type":"function","title":"snmpa.mib_of/2","doc":"Finds the mib corresponding to the `Oid`.\n\nIf it is a variable, the Oid must be ` .0` and if it is a table, Oid\nmust be ` . . . `.","ref":"snmpa.html#mib_of/2"},{"type":"function","title":"snmpa.name_to_oid/1","doc":"","ref":"snmpa.html#name_to_oid/1"},{"type":"function","title":"snmpa.name_to_oid/2","doc":"Looks up the OBJECT IDENTIFIER of a MIB object, given the symbolic name. Note,\nthe OBJECT IDENTIFIER is given for the object, not for an instance.\n\n`false` is returned if the object is not defined in any loaded MIB.\n\n`Db` is a reference to the symbolic store database (retrieved by a call to\n`get_symbolic_store_db/0`).","ref":"snmpa.html#name_to_oid/2"},{"type":"function","title":"snmpa.oid_to_name/1","doc":"","ref":"snmpa.html#oid_to_name/1"},{"type":"function","title":"snmpa.oid_to_name/2","doc":"Looks up the symbolic name of a MIB object, given OBJECT IDENTIFIER.\n\n`false` is returned if the object is not defined in any loaded MIB.\n\n`Db` is a reference to the symbolic store database (retrieved by a call to\n`get_symbolic_store_db/0`).","ref":"snmpa.html#oid_to_name/2"},{"type":"function","title":"snmpa.print_mib_info/0","doc":"Prints the content of all the (snmp) tables and variables for all mibs handled\nby the snmp agent.","ref":"snmpa.html#print_mib_info/0"},{"type":"function","title":"snmpa.print_mib_tables/0","doc":"Prints the content of all the (snmp) tables for all mibs handled by the snmp\nagent.","ref":"snmpa.html#print_mib_tables/0"},{"type":"function","title":"snmpa.print_mib_variables/0","doc":"Prints the content of all the (snmp) variables for all mibs handled by the snmp\nagent.","ref":"snmpa.html#print_mib_variables/0"},{"type":"function","title":"snmpa.register_notification_filter/3","doc":"","ref":"snmpa.html#register_notification_filter/3"},{"type":"function","title":"snmpa.register_notification_filter/4","doc":"","ref":"snmpa.html#register_notification_filter/4"},{"type":"function","title":"snmpa.register_notification_filter/5","doc":"Registers a notification filter.\n\n`Mod` is a module implementing the `snmpa_notification_filter` behaviour.\n\n`Data` will be passed on to the filter when calling the functions of the\nbehaviour.","ref":"snmpa.html#register_notification_filter/5"},{"type":"function","title":"snmpa.register_subagent/3","doc":"Registers a sub-agent under a sub-tree of another agent.\n\nIt is easy to make mistakes when registering sub-agents and this activity should\nbe done carefully. For example, a strange behaviour would result from the\nfollowing configuration:\n\n```erlang\nsnmp_agent:register_subagent(MAPid,[1,2,3,4],SA1),\nsnmp_agent:register_subagent(SA1,[1,2,3], SA2).\n```\n\n`SA2` will not get requests starting with object identifier `[1,2,3]` since\n`SA1` does not.","ref":"snmpa.html#register_subagent/3"},{"type":"function","title":"snmpa.restart_set_worker/0","doc":"","ref":"snmpa.html#restart_set_worker/0"},{"type":"function","title":"snmpa.restart_set_worker/1","doc":"Restart the set worker process of a multi-threaded agent.\n\nThis is a utility function, that can be useful when e.g. debugging\ninstrumentation functions.","ref":"snmpa.html#restart_set_worker/1"},{"type":"function","title":"snmpa.restart_worker/0","doc":"","ref":"snmpa.html#restart_worker/0"},{"type":"function","title":"snmpa.restart_worker/1","doc":"Restart the worker process of a multi-threaded agent.\n\nThis is a utility function, that can be useful when e.g. debugging\ninstrumentation functions.","ref":"snmpa.html#restart_worker/1"},{"type":"function","title":"snmpa.send_notification2/3","doc":"Send the notification `Notification` to the management targets defined for\nnotify-name (`name`) in the `snmpNotifyTable` in SNMP-NOTIFICATION-MIB from the\nspecified `context`.\n\nIf no `name` is specified (or if it is `\"\"`), the notification is sent to all\nmanagement targets.\n\nIf no `context` is specified, the default context, `\"\"`, is used.\n\nThe send option `receiver` specifies where information about delivery of\nInform-Requests should be sent. The agent sends Inform-Requests and waits for\nacknowledgments from the management targets. The `receiver` can have three\nvalues:\n\n- `no_receiver` \\- No information is delivered.\n- `t:notification_delivery_info/0` \\- The information is delivered via a\n  function call according to this data.\n- `{tag(), tag_receiver()}` \\- The information is delivered either via messages\n  or via a function call according to the value of `tag_receiver()`.\n\n  Delivery is done differently depending on the value of `tag_receiver()`:\n\n  - `pid() | registered_name()` \\- The info will be delivered in the following\n    messages:\n\n    - `{snmp_targets, tag(), Addresses}`\n\n      This informs the user which target addresses the notification was sent to.\n\n    - `{snmp_notification, tag(), {got_response, Address}}`\n\n      This informs the user that this target address acknowledged the\n      notification.\n\n    - `{snmp_notification, tag(), {no_response, Address}}`\n\n      This informs the user that this target address did not acknowledge the\n      notification.\n\n    The notification is sent as an Inform-Request to each target address in\n    `Addresses` and if there are no targets for which an Inform-Request is sent,\n    `Addresses` is the empty list `[]`.\n\n    The `tag_receiver()` will first be sent the `snmp_targets` message, and then\n    for each address in `Addresses` list, one of the two `snmp_notification`\n    messages.\n\n  - `{Mod, Func, Args}` \\- The info will be delivered via the function call:\n\n    `Mod:Func([Msg | Args])`\n\n    where `Msg` has the same content and purpose as the messages descrived\n    above.\n\nThe 'process oid' \"tag\" that can be provided with the variable name / oids is\nintended to be used for oid post processing. The value '`keep`', which is the\ndefault, leaves the oid as is. The value '`truncate`', will cause the oid to be\n\"truncated\". That is, any trailing \".0\" will be removed.\n\n> #### Note {: .info }\n>\n> There is a way to exclude a varbind from the notification. In the normal\n> `varbinds` list, providing the special value `'$ignore-oid'` (instead of a\n> normal value) will exclude this varbind from the notification.\n>\n> A define for this has been added to the `snmp_types.hrl` include file,\n> `NOTIFICATION_IGNORE_VB_VALUE`.\n\n> #### Note {: .info }\n>\n> The `extra` info is not normally interpreted by the agent, instead it is\n> passed through to the [net-if](snmp_agent_netif.md) process. It is up to the\n> implementor of that process to make use of this data.\n>\n> The version of net-if provided by this application makes no use of this data,\n> with one exception: Any tuple containing the atom\n> `snmpa_default_notification_extra_info` may be used by the agent and is\n> therefore _reserved_.\n>\n> See the net-if incoming messages for sending a\n> [trap](snmp_agent_netif.md#im_send_pdu) and\n> [notification](snmp_agent_netif.md#im_send_pdu_req) for more info.","ref":"snmpa.html#send_notification2/3"},{"type":"function","title":"snmpa.send_notification/3","doc":"","ref":"snmpa.html#send_notification/3"},{"type":"function","title":"snmpa.send_notification/4","doc":"","ref":"snmpa.html#send_notification/4"},{"type":"function","title":"snmpa.send_notification/5","doc":"","ref":"snmpa.html#send_notification/5"},{"type":"function","title":"snmpa.send_notification/6","doc":"","ref":"snmpa.html#send_notification/6"},{"type":"function","title":"snmpa.send_notification/7","doc":"Sends the notification `Notification` to the management targets defined for\n`NotifyName` in the `snmpNotifyTable` in SNMP-NOTIFICATION-MIB from the\nspecified context.\n\nIf no `NotifyName` is specified (or if it is `\"\"`), the notification is sent to\nall management targets (`Addresses` below).\n\nIf no `ContextName` is specified, the default `\"\"` context is used.\n\nThe parameter `Receiver` specifies where information about delivery of\nInform-Requests should be sent. The agent sends Inform-Requests and waits for\nacknowledgments from the managers. `Receiver` can have three values:\n\n- `no_receiver` \\- No information is delivered.\n- `t:notification_delivery_info/0` \\- The information is delivered via a\n  function call according to this data.\n- `{Tag, Recv}` \\- The information is delivered either via messages or via a\n  function call according to the value of `Recv`.\n\nIf `Receiver` has the value `{Tag, Recv}`, the delivery is done according to\n`Recv`:\n\n- `pid() | atom()` \\- The info will be delivered in the following messages:\n\n  - `{snmp_targets, Tag, Addresses}`\n\n    This inform the user which target addresses the notification was sent to.\n\n  - `{snmp_notification, Tag, {got_response, Address}}`\n\n    This informs the user that this target address acknowledged the\n    notification.\n\n  - `{snmp_notification, Tag, {no_response, Address}}`\n\n    This informs the user that this target address did not acknowledge\n    notification.\n\n  The notification is sent as an Inform-Request to each target address in\n  `Addresses` and if there are no targets for which an Inform-Request is sent,\n  `Addresses` is the empty list `[]`.\n\n  The `receiver` will first be sent the `snmp_targets` message, and then for\n  each address in `Addresses` list, one of the two `snmp_notification` messages.\n\n- `{Mod, Func, Args}` \\- The info will be delivered via the function call:\n\n  `Mod:Func([Msg | Args])`\n\n  where `Msg` has the same content and purpose as the messages descrived above.\n\n`Address` is a management target address and `Addresses` is a list of management\ntarget addresses. They are defined as followes:\n\n```erlang\n        Addresses  = [address()]\n        Address    = address()\n        address()  = v1_address() | v3_address()\n        v1_address() = {TDomain, TAddress}\n        v3_address() = {{TDomain, TAddress}, V3MsgData}\n        TDomain    = tdoamin()\n        TAddress   = taddress()\n        tdomain()  = The oid of snmpUDPDomain\n                     This is the only supported transport domain.\n        taddress() = [A1, A2, A3, A4, P1, P3]\n                     The 4 first bytes makes up the IP-address and the last 2,\n                     the UDP-port number.\n        V3MsgData  = v3_msg_data()\n        v3_msg_data() = term()\n```\n\nIf `Receiver` is a `t:notification_delivery_info/0` record, then the information\nabout the notification delivery will be delivered to the `receiver` via the\ncallback functions defined by the `m:snmpa_notification_delivery_info_receiver`\nbehaviour according to the content of the `t:notification_delivery_info/0`\nrecord.\n\nThe optional argument `Varbinds` defines values for the objects in the\nnotification. If no value is given for an object, the `Agent` performs a\nget-operation to retrieve the value.\n\n`Varbinds` is a list of `Varbind`, where each `Varbind` is one of:\n\n- `{Variable, Value}`, where `Variable` is the symbolic name of a scalar\n  variable referred to in the notification specification.\n- `{Column, RowIndex, Value}`, where `Column` is the symbolic name of a column\n  variable. `RowIndex` is a list of indices for the specified element. If this\n  is the case, the OBJECT IDENTIFIER sent in the notification is the `RowIndex`\n  appended to the OBJECT IDENTIFIER for the table column. This is the OBJECT\n  IDENTIFIER which specifies the element.\n- `{OID, Value}`, where `OID` is the OBJECT IDENTIFIER for an instance of an\n  object, scalar variable, or column variable.\n\nFor example, to specify that `sysLocation` should have the value `\"upstairs\"` in\nthe notification, we could use one of:\n\n- `{sysLocation, \"upstairs\"}` or\n- `{[1,3,6,1,2,1,1,6,0], \"upstairs\"}` or\n- `{?sysLocation_instance, \"upstairs\"}` (provided that the generated `.hrl` file\n  is included)\n\nIf a variable in the notification is a table element, the `RowIndex` for the\nelement must be given in the `Varbinds` list. In this case, the OBJECT\nIDENTIFIER sent in the notification is the OBJECT IDENTIFIER that identifies\nthis element. This OBJECT IDENTIFIER could be used in a get operation later.\n\nThis function is asynchronous, and does not return any information. If an error\noccurs, `user_err/2` of the error report module is called and the notification\nis discarded.\n\n> #### Note {: .info }\n>\n> Note that the use of the LocalEngineID argument is only intended for special\n> cases, if the agent is to \"emulate\" multiple EngineIDs\\! By default, the agent\n> uses the value of `SnmpEngineID` (see SNMP-FRAMEWORK-MIB).\n\n`ExtraInfo` is not normally used in any way by the agent. It is intended to be\npassed along to the net-if process, which is a component that a user can\nimplement themself. The users own net-if may then make use of ExtraInfo. The\nnet-if provided with this application does not process ExtraInfo.\n\nThere is one exception. _Any_ tuple containing the atom\n`snmpa_default_notification_extra_info` will, in this context, be considered\nbelonging to this application, and may be processed by the agent.","ref":"snmpa.html#send_notification/7"},{"type":"function","title":"snmpa.set_log_type/1","doc":"","ref":"snmpa.html#set_log_type/1"},{"type":"function","title":"snmpa.set_log_type/2","doc":"Changes the run-time Audit Trail log type.\n\nNote that this has no effect on the application configuration as defined by\nconfiguration files, so a node restart will revert the config to whatever is in\nthose files.\n\nThis function is primarily useful in testing/debugging scenarios.","ref":"snmpa.html#set_log_type/2"},{"type":"function","title":"snmpa.set_request_limit/1","doc":"","ref":"snmpa.html#set_request_limit/1"},{"type":"function","title":"snmpa.set_request_limit/2","doc":"Changes the request limit.\n\nNote that this has no effect on the application configuration as defined by\nconfiguration files, so a node restart will revert the config to whatever is in\nthose files.\n\nThis function is primarily useful in load regulation scenarios.","ref":"snmpa.html#set_request_limit/2"},{"type":"function","title":"snmpa.unload_mib/1","doc":"","ref":"snmpa.html#unload_mib/1"},{"type":"function","title":"snmpa.unload_mib/2","doc":"Unload a single `Mib` from an agent.","ref":"snmpa.html#unload_mib/2"},{"type":"function","title":"snmpa.unload_mibs/1","doc":"","ref":"snmpa.html#unload_mibs/1"},{"type":"function","title":"snmpa.unload_mibs/2","doc":"","ref":"snmpa.html#unload_mibs/2"},{"type":"function","title":"snmpa.unload_mibs/3","doc":"Unload `Mibs` from an agent. If it cannot unload all MIBs (the default value of\nthe `Force` argument is `false`), it will indicate where unloading was aborted.\n\nIf `Force = true` then the agent will continue attempting to unload each mib\neven after failing to unload a previous mib. Use with care.","ref":"snmpa.html#unload_mibs/3"},{"type":"function","title":"snmpa.unregister_notification_filter/1","doc":"","ref":"snmpa.html#unregister_notification_filter/1"},{"type":"function","title":"snmpa.unregister_notification_filter/2","doc":"Unregister a notification filter.","ref":"snmpa.html#unregister_notification_filter/2"},{"type":"function","title":"snmpa.unregister_subagent/2","doc":"Unregister a sub-agent. If the second argument is a pid, then that sub-agent\nwill be unregistered from all trees in `Agent`.","ref":"snmpa.html#unregister_subagent/2"},{"type":"function","title":"snmpa.update_mibs_cache_age/1","doc":"","ref":"snmpa.html#update_mibs_cache_age/1"},{"type":"function","title":"snmpa.update_mibs_cache_age/2","doc":"Change the mib server cache `age` property.","ref":"snmpa.html#update_mibs_cache_age/2"},{"type":"function","title":"snmpa.update_mibs_cache_gclimit/1","doc":"","ref":"snmpa.html#update_mibs_cache_gclimit/1"},{"type":"function","title":"snmpa.update_mibs_cache_gclimit/2","doc":"Change the mib server cache `gclimit` property.","ref":"snmpa.html#update_mibs_cache_gclimit/2"},{"type":"function","title":"snmpa.verbosity/2","doc":"Sets 'verbosity' for the indicated process(s):\n\n- **`all`** -\n  Sets verbosity for all the agent processes; net_if, note_store, mib_server,\nsymbolic_store, local_db and master_agent (and sub-agents).\n\n- **`net_if`** - Sets verbosity for the net-if process.\n\n- **`note_store`** - Sets verbosity for the note store process.\n\n- **`mib_server`** - Sets verbosity for the mib server process.\n\n- **`symbolic_store`** - Sets verbosity for the symbolic store process.\n\n- **`local_db`** - Sets verbosity for the local-db process.\n\n- **`master_agent | pid()`** when `Verbosity = {subagents,` [`snmp:verbosity()`](`t:snmp:verbosity/0`)`}` - \n  Sets verbosity for all sub-agent(s) controlled by this (master) agent.\n\n- **`master_agent | pid()`** - Sets verbosity for the agent process.","ref":"snmpa.html#verbosity/2"},{"type":"function","title":"snmpa.whereis_mib/1","doc":"","ref":"snmpa.html#whereis_mib/1"},{"type":"function","title":"snmpa.whereis_mib/2","doc":"Get the full path to the (compiled) mib-file.","ref":"snmpa.html#whereis_mib/2"},{"type":"function","title":"snmpa.which_aliasnames/0","doc":"Retrieve all alias-names known to the agent.","ref":"snmpa.html#which_aliasnames/0"},{"type":"function","title":"snmpa.which_mibs/0","doc":"","ref":"snmpa.html#which_mibs/0"},{"type":"function","title":"snmpa.which_mibs/1","doc":"Retrieve the list of all the mibs loaded into this agent. Default is the master\nagent.","ref":"snmpa.html#which_mibs/1"},{"type":"function","title":"snmpa.which_mibs_cache_size/0","doc":"","ref":"snmpa.html#which_mibs_cache_size/0"},{"type":"function","title":"snmpa.which_mibs_cache_size/1","doc":"Retrieve the size of the mib server cache.","ref":"snmpa.html#which_mibs_cache_size/1"},{"type":"function","title":"snmpa.which_notification_filter/0","doc":"","ref":"snmpa.html#which_notification_filter/0"},{"type":"function","title":"snmpa.which_notification_filter/1","doc":"List all notification filters in an agent.","ref":"snmpa.html#which_notification_filter/1"},{"type":"function","title":"snmpa.which_notifications/0","doc":"Retrieve all notifications (and traps) known to the agent.","ref":"snmpa.html#which_notifications/0"},{"type":"function","title":"snmpa.which_tables/0","doc":"Retrieve all tables known to the agent.","ref":"snmpa.html#which_tables/0"},{"type":"function","title":"snmpa.which_transports/0","doc":"Retrieve all configured transports.","ref":"snmpa.html#which_transports/0"},{"type":"function","title":"snmpa.which_variables/0","doc":"Retrieve all variables known to the agent.","ref":"snmpa.html#which_variables/0"},{"type":"type","title":"snmpa.db/0","doc":"","ref":"snmpa.html#t:db/0"},{"type":"type","title":"snmpa.discovery_handler/0","doc":"Module implementing the [snmpa_discovery_handler](`m:snmpa_discovery_handler#`)\nbehaviour.","ref":"snmpa.html#t:discovery_handler/0"},{"type":"type","title":"snmpa.me/0","doc":"","ref":"snmpa.html#t:me/0"},{"type":"type","title":"snmpa.mib_storage/0","doc":"","ref":"snmpa.html#t:mib_storage/0"},{"type":"type","title":"snmpa.mib_storage_module/0","doc":"","ref":"snmpa.html#t:mib_storage_module/0"},{"type":"type","title":"snmpa.mib_storage_opt/0","doc":"","ref":"snmpa.html#t:mib_storage_opt/0"},{"type":"type","title":"snmpa.mib_storage_options/0","doc":"","ref":"snmpa.html#t:mib_storage_options/0"},{"type":"type","title":"snmpa.name/0","doc":"","ref":"snmpa.html#t:name/0"},{"type":"type","title":"snmpa.name_db/0","doc":"","ref":"snmpa.html#t:name_db/0"},{"type":"type","title":"snmpa.nfilter_id/0","doc":"","ref":"snmpa.html#t:nfilter_id/0"},{"type":"type","title":"snmpa.nfilter_position/0","doc":"","ref":"snmpa.html#t:nfilter_position/0"},{"type":"type","title":"snmpa.notification_delivery_info/0","doc":"How shall (notification) delivery info be reported.","ref":"snmpa.html#t:notification_delivery_info/0"},{"type":"type","title":"snmpa.pdu_type/0","doc":"","ref":"snmpa.html#t:pdu_type/0"},{"type":"type","title":"snmpa.table_name/0","doc":"","ref":"snmpa.html#t:table_name/0"},{"type":"type","title":"snmpa.transport_kind/0","doc":"","ref":"snmpa.html#t:transport_kind/0"},{"type":"type","title":"snmpa.variable_name/0","doc":"","ref":"snmpa.html#t:variable_name/0"},{"type":"module","title":"snmpa_conf","doc":"Utility functions for handling the agent config files.\n\nThe module `snmpa_conf` contains various utility functions to use for\nmanipulating (write/read/append) the config files of the SNMP agent.","ref":"snmpa_conf.html"},{"type":"function","title":"snmpa_conf.agent_entry/2","doc":"Create an entry for the agent config file, `agent.conf`.\n\nThe type of `Val` depends on the value of `Tag`:\n\n- **`intAgentTransports: `[`snmpa_conf:intAgentTransport()`](`t:intAgentTransport/0`) ` `**{: #intAgentTransports }\n\n- **`intAgentUDPPort: `[`inet:port_number()`](`t:inet:port_number/0`) ` `**{: #intAgentUDPPort }\n\n- **`snmpEngineMaxMessageSize: `[`snmp_framework_mib:max_message_size()`](`t:snmp_framework_mib:max_message_size/0`) ` `**{: #snmpEngineMaxMessageSize }\n\n- **`snmpEngineID: `[`snmp_framework_mib:engine_id()`](`t:snmp_framework_mib:engine_id/0`) ` `**{: #snmpEngineID }\n\nSee [Agent Information](snmp_agent_config_files.md#agent_information) for more\ninfo.","ref":"snmpa_conf.html#agent_entry/2"},{"type":"function","title":"snmpa_conf.append_agent_config/2","doc":"Append the config to the current agent config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Agent Information](snmp_agent_config_files.md#agent_information) for more\ninfo.","ref":"snmpa_conf.html#append_agent_config/2"},{"type":"function","title":"snmpa_conf.append_community_config/2","doc":"Append the community config to the current agent community config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Community](snmp_agent_config_files.md#community) for more info.","ref":"snmpa_conf.html#append_community_config/2"},{"type":"function","title":"snmpa_conf.append_context_config/2","doc":"Append the context config to the current agent context config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Contexts](snmp_agent_config_files.md#context) for more info.","ref":"snmpa_conf.html#append_context_config/2"},{"type":"function","title":"snmpa_conf.append_notify_config/2","doc":"Append the notify config to the current agent notify config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Notify Definitions](snmp_agent_config_files.md#notify) for more info.","ref":"snmpa_conf.html#append_notify_config/2"},{"type":"function","title":"snmpa_conf.append_standard_config/2","doc":"Append the standard config to the current agent standard config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [System Information](snmp_agent_config_files.md#system_information) for more\ninfo.","ref":"snmpa_conf.html#append_standard_config/2"},{"type":"function","title":"snmpa_conf.append_target_addr_config/2","doc":"Append the target_addr config to the current agent target_addr config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Target Address Definitions](snmp_agent_config_files.md#target_addr) for\nmore info.","ref":"snmpa_conf.html#append_target_addr_config/2"},{"type":"function","title":"snmpa_conf.append_target_params_config/2","doc":"Append the target_params config to the current agent target_params config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Target Parameters Definitions](snmp_agent_config_files.md#target_params)\nfor more info.","ref":"snmpa_conf.html#append_target_params_config/2"},{"type":"function","title":"snmpa_conf.append_usm_config/2","doc":"Append the usm config to the current agent usm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Security data for USM](snmp_agent_config_files.md#usm) for more info.","ref":"snmpa_conf.html#append_usm_config/2"},{"type":"function","title":"snmpa_conf.append_vacm_config/2","doc":"Append the vacm config to the current agent vacm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [MIB Views for VACM](snmp_agent_config_files.md#vacm) for more info.","ref":"snmpa_conf.html#append_vacm_config/2"},{"type":"function","title":"snmpa_conf.community_entry/1","doc":"Create an entry for the agent community config file, `community.conf`.\n\n`CommunityIndex` must be a _non-empty_ string.\n\nThis function only accepts the following values of `CommIndex`:\n\n- **`\"public\"`{: #community_index_public }** - Translates to the following call:\n\n  [`community_entry(CommunityIndex, CommunityIndex, \"initial\", \"\", \"\")`](`community_entry/5`).\n\n- **`\"all-rights\"`{: #community_index_all_rights }** - Translates to the\n  following call:\n\n  [`community_entry(CommunityIndex, CommunityIndex, CommunityIndex, \"\", \"\")`](`community_entry/5`).\n\nSee [Community](snmp_agent_config_files.md#community) for more info.","ref":"snmpa_conf.html#community_entry/1"},{"type":"function","title":"snmpa_conf.community_entry/5","doc":"Create an entry for the agent community config file, `community.conf`.\n\n`CommunityIndex` must be a _non-empty_ string.\n\nSee [Community](snmp_agent_config_files.md#community) for more info.","ref":"snmpa_conf.html#community_entry/5"},{"type":"function","title":"snmpa_conf.context_entry/1","doc":"Create an entry for the agent context config file, `context.conf`.\n\nSee [Contexts](snmp_agent_config_files.md#context) for more info.","ref":"snmpa_conf.html#context_entry/1"},{"type":"function","title":"snmpa_conf.notify_entry/3","doc":"Create an entry for the agent notify config file, `notify.conf`.\n\n`Name` must be a _non-empty_ string.\n\nSee [Notify Definitions](snmp_agent_config_files.md#notify) for more info.","ref":"snmpa_conf.html#notify_entry/3"},{"type":"function","title":"snmpa_conf.read_agent_config/1","doc":"Read the current agent config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Agent Information](snmp_agent_config_files.md#agent_information) for more\ninfo.","ref":"snmpa_conf.html#read_agent_config/1"},{"type":"function","title":"snmpa_conf.read_community_config/1","doc":"Read the current agent community config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Communities](snmp_agent_config_files.md#community) for more info.","ref":"snmpa_conf.html#read_community_config/1"},{"type":"function","title":"snmpa_conf.read_context_config/1","doc":"Read the current agent context config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Contexts](snmp_agent_config_files.md#context) for more info.","ref":"snmpa_conf.html#read_context_config/1"},{"type":"function","title":"snmpa_conf.read_notify_config/1","doc":"Read the current agent notify config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Notify Definitions](snmp_agent_config_files.md#notify) for more info.","ref":"snmpa_conf.html#read_notify_config/1"},{"type":"function","title":"snmpa_conf.read_standard_config/1","doc":"Read the current agent standard config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [System Information](snmp_agent_config_files.md#system_information) for more\ninfo.","ref":"snmpa_conf.html#read_standard_config/1"},{"type":"function","title":"snmpa_conf.read_target_addr_config/1","doc":"Read the current agent target_addr config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Target Address Definitions](snmp_agent_config_files.md#target_addr) for\nmore info.","ref":"snmpa_conf.html#read_target_addr_config/1"},{"type":"function","title":"snmpa_conf.read_target_params_config/1","doc":"Read the current agent target_params config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Target Parameters Definitions](snmp_agent_config_files.md#target_params)\nfor more info.","ref":"snmpa_conf.html#read_target_params_config/1"},{"type":"function","title":"snmpa_conf.read_usm_config/1","doc":"Read the current agent usm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Security data for USM](snmp_agent_config_files.md#usm) for more info.","ref":"snmpa_conf.html#read_usm_config/1"},{"type":"function","title":"snmpa_conf.read_vacm_config/1","doc":"Read the current agent vacm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [MIB Views for VACM](snmp_agent_config_files.md#vacm) for more info.","ref":"snmpa_conf.html#read_vacm_config/1"},{"type":"function","title":"snmpa_conf.standard_entry/2","doc":"Create an entry for the agent standard config file, `standard.conf`.\n\nThe type of `Val` depends on the value of `Tag`:\n\n- **`sysDescr: `{: #sysDescr }[`string()`](`t:erlang:string/0`)\n  ` `** - `DisplayString (SIZE(0..255))`\n\n- **`sysObjectID: `{: #sysObjectID }[`snmp:oid()`](`t:snmp:oid/0`) ` `** - `OBJECT IDENTIFIER`\n\n- **`sysContact: `{: #sysContact }[`string()`](`t:erlang:string/0`)\n  ` `** - `DisplayString (SIZE(0..255))`\n\n- **`sysName: `{: #sysName }[`string()`](`t:erlang:string/0`) ` `** -\n  `DisplayString (SIZE(0..255))`\n\n- **`sysLocation: `{: #sysLocation }[`string()`](`t:erlang:string/0`)\n  ` `** - `DisplayString (SIZE(0..255))`\n\n- **`sysLocation: `[`non_neg_integer()`](`t:erlang:non_neg_integer/0`) ` `** - \"A\n  value which indicates the set of services that this entity primarily offers.\"\n\n  `INTEGER (0..127)`\n\n- **`snmpEnableAuthenTraps: `{: #snmpEnableAuthenTraps }`enabled | disabled`\n  ` `** - `INTEGER { enabled(1), disabled(2) }`\n\nSee [System Information](snmp_agent_config_files.md#system_information) for more\ninfo.","ref":"snmpa_conf.html#standard_entry/2"},{"type":"function","title":"snmpa_conf.target_addr_entry/6","doc":"Create an entry for the agent target_addr config file, `target_addr.conf`.\n\n`Name` must be a _non-empty_ string.\n\n[`target_addr_entry/6` (1)](`target_addr_entry/6`) translates to the following call:\n[`target_addr_entry(Name, Domain, Addr, TagList, ParamsName, EngineId, [])`](`target_addr_entry/7`).\n\n[`target_addr_entry/6` (2)](`target_addr_entry/6`) translates to the following call (with `Domain` and `Addr` built from `IP` and the default port number):\n[`target_addr_entry(Name, Domain, Addr, TagList, ParamsName, EngineId, TMask, 2048)`](`target_addr_entry/8`).\n\nSee [Target Address Definitions](snmp_agent_config_files.md#target_addr) for\nmore info.","ref":"snmpa_conf.html#target_addr_entry/6"},{"type":"function","title":"snmpa_conf.target_addr_entry/7","doc":"Create an entry for the agent target_addr config file, `target_addr.conf`.\n\n`Name` must be a _non-empty_ string.\n\n[`target_addr_entry/7` (1)](`target_addr_entry/7`) translates to the following call:\n[`target_addr_entry(Name, Domain, Addr, TagList, ParamsName, EngineId, TMask, 2048)`](`target_addr_entry/8`).\n\n[`target_addr_entry/7` (2)](`target_addr_entry/7`) translates to the following call (with `Domain` and `Addr` built from `IP` and `Port`):\n[`target_addr_entry(Name, Domain, Addr, TagList, ParamsName, EngineId, TMask, 2048)`](`target_addr_entry/8`).\n\nSee [Target Address Definitions](snmp_agent_config_files.md#target_addr) for\nmore info.","ref":"snmpa_conf.html#target_addr_entry/7"},{"type":"function","title":"snmpa_conf.target_addr_entry/8","doc":"Create an entry for the agent target_addr config file, `target_addr.conf`.\n\n`Name` must be a _non-empty_ string.\n\n[`target_addr_entry/8` (1)](`target_addr_entry/8`) translates to the following call:\n[`target_addr_entry(Name, Domain, Addr, 1500, 3, TagList, ParamsName, EngineId, TMask, MaxMessageSize)`](`target_addr_entry/10`).\n\n[`target_addr_entry/8` (2)](`target_addr_entry/8`) translates to the following call (with `Domain` and `Addr` built from `IP` and `Port`):\n[`target_addr_entry(Name, Domain, Addr, 1500, 3, TagList, ParamsName, EngineId, TMask, MaxMessageSize)`](`target_addr_entry/10`).\n\nSee [Target Address Definitions](snmp_agent_config_files.md#target_addr) for\nmore info.","ref":"snmpa_conf.html#target_addr_entry/8"},{"type":"function","title":"snmpa_conf.target_addr_entry/10","doc":"Create an entry for the agent target_addr config file, `target_addr.conf`.\n\n`Name` must be a _non-empty_ string.\n\nSee [Target Address Definitions](snmp_agent_config_files.md#target_addr) for\nmore info.","ref":"snmpa_conf.html#target_addr_entry/10"},{"type":"function","title":"snmpa_conf.target_params_entry/2","doc":"Create an entry for the agent target_params config file, `target_params.conf`.\n\n`Name` must be a _non-empty_ string.\n\n[`target_params_entry/2`](`target_params_entry/2`) translates to the following\ncall:\n\n```text\n\t  target_params_entry(Name, Vsn, \"initial\", noAuthNoPriv)\n```\n\nSee [Target Parameters Definitions](snmp_agent_config_files.md#target_params)\nfor more info.\n\n[](){: #target_params_entry_2 }","ref":"snmpa_conf.html#target_params_entry/2"},{"type":"function","title":"snmpa_conf.target_params_entry/4","doc":"Create an entry for the agent target_params config file, `target_params.conf`.\n\n`Name` must be a _non-empty_ string.\n\n`Vsn` translates into `MPModel` and `SecModel` as follows:\n\n```text\n\t  Vsn = v1 => MPModel = v1,  SecModel = v1\n\t  Vsn = v2 => MPModel = v2c, SecModel = v2c\n\t  Vsn = v3 => MPModel = v3,  SecModel = usm\n```\n\n[`target_params_entry/4`](`target_params_entry/4`) translates to the following\ncall:\n\n```text\n\t  target_params_entry(Name, MPModel, SecModel, SecName, SecLevel)\n```\n\nWhere `MPModel` and `SecModel` is mapped from `Vsn`, see above.\n\nSee [Target Parameters Definitions](snmp_agent_config_files.md#target_params)\nfor more info.\n\n[](){: #target_params_entry_4 }","ref":"snmpa_conf.html#target_params_entry/4"},{"type":"function","title":"snmpa_conf.target_params_entry/5","doc":"Create an entry for the agent target_params config file, `target_params.conf`.\n\n`Name` must be a _non-empty_ string.\n\nSee [Target Parameters Definitions](snmp_agent_config_files.md#target_params)\nfor more info.","ref":"snmpa_conf.html#target_params_entry/5"},{"type":"function","title":"snmpa_conf.usm_entry/1","doc":"Create an entry for the agent usm config file, `usm.conf`.\n\n[`usm_entry/1`](`usm_entry/1`) translates to the following call:\n\n```text\n\t  usm_entry(EngineID,\n\t            \"initial\", \"initial\", zeroDotZero,\n\t\t    usmNoAuthProtocol, \"\", \"\",\n\t\t    usmNoPrivProtocol, \"\", \"\",\n\t\t    \"\", \"\", \"\").\n```\n\nSee [Security data for USM](snmp_agent_config_files.md#usm) for more info.","ref":"snmpa_conf.html#usm_entry/1"},{"type":"function","title":"snmpa_conf.usm_entry/13","doc":"Create an entry for the agent usm config file, `usm.conf`.\n\nSee [Security data for USM](snmp_agent_config_files.md#usm) for more info.","ref":"snmpa_conf.html#usm_entry/13"},{"type":"function","title":"snmpa_conf.vacm_acc_entry/8","doc":"Create an (access) entry for the agent vacm config file, `vacm.conf`.\n\nSee [MIB Views for VACM](snmp_agent_config_files.md#vacm) for more info.\n\n[](){: #vacm_s2g_entry }","ref":"snmpa_conf.html#vacm_acc_entry/8"},{"type":"function","title":"snmpa_conf.vacm_s2g_entry/3","doc":"Create an (security to group) entry for the agent vacm config file, `vacm.conf`.\n\nSee [MIB Views for VACM](snmp_agent_config_files.md#vacm) for more info.","ref":"snmpa_conf.html#vacm_s2g_entry/3"},{"type":"function","title":"snmpa_conf.vacm_vtf_entry/2","doc":"Create an (view tree family) entry for the agent vacm config file, `vacm.conf`.\n\n[`vacm_vtf_entry/2`](`vacm_vtf_entry/2`) translates to the following call:\n\n```text\n\t  vacm_vtf_entry(ViewIndex, ViewSubtree, included, null).\n```\n\nSee [MIB Views for VACM](snmp_agent_config_files.md#vacm) for more info.","ref":"snmpa_conf.html#vacm_vtf_entry/2"},{"type":"function","title":"snmpa_conf.vacm_vtf_entry/4","doc":"Create an (view tree family) entry for the agent vacm config file, `vacm.conf`.\n\nSee [MIB Views for VACM](snmp_agent_config_files.md#vacm) for more info.","ref":"snmpa_conf.html#vacm_vtf_entry/4"},{"type":"function","title":"snmpa_conf.write_agent_config/2","doc":"","ref":"snmpa_conf.html#write_agent_config/2"},{"type":"function","title":"snmpa_conf.write_agent_config/3","doc":"Write the agent config to the agent config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Agent Information](snmp_agent_config_files.md#agent_information) for more\ninfo.","ref":"snmpa_conf.html#write_agent_config/3"},{"type":"function","title":"snmpa_conf.write_community_config/2","doc":"","ref":"snmpa_conf.html#write_community_config/2"},{"type":"function","title":"snmpa_conf.write_community_config/3","doc":"Write the agent community config to the agent community config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Community](snmp_agent_config_files.md#community) for more info.","ref":"snmpa_conf.html#write_community_config/3"},{"type":"function","title":"snmpa_conf.write_context_config/2","doc":"","ref":"snmpa_conf.html#write_context_config/2"},{"type":"function","title":"snmpa_conf.write_context_config/3","doc":"Write the agent context config to the agent context config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Contexts](snmp_agent_config_files.md#context) for more info.","ref":"snmpa_conf.html#write_context_config/3"},{"type":"function","title":"snmpa_conf.write_notify_config/2","doc":"","ref":"snmpa_conf.html#write_notify_config/2"},{"type":"function","title":"snmpa_conf.write_notify_config/3","doc":"Write the agent notify config to the agent notify config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Notify Definitions](snmp_agent_config_files.md#notify) for more info.","ref":"snmpa_conf.html#write_notify_config/3"},{"type":"function","title":"snmpa_conf.write_standard_config/2","doc":"","ref":"snmpa_conf.html#write_standard_config/2"},{"type":"function","title":"snmpa_conf.write_standard_config/3","doc":"Write the agent standard config to the agent standard config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [System Information](snmp_agent_config_files.md#system_information) for more\ninfo.","ref":"snmpa_conf.html#write_standard_config/3"},{"type":"function","title":"snmpa_conf.write_target_addr_config/2","doc":"","ref":"snmpa_conf.html#write_target_addr_config/2"},{"type":"function","title":"snmpa_conf.write_target_addr_config/3","doc":"Write the agent target_addr config to the agent target_addr config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Target Address Definitions](snmp_agent_config_files.md#target_addr) for\nmore info.","ref":"snmpa_conf.html#write_target_addr_config/3"},{"type":"function","title":"snmpa_conf.write_target_params_config/2","doc":"","ref":"snmpa_conf.html#write_target_params_config/2"},{"type":"function","title":"snmpa_conf.write_target_params_config/3","doc":"Write the agent target_params config to the agent target_params config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Target Parameters Definitions](snmp_agent_config_files.md#target_params)\nfor more info.","ref":"snmpa_conf.html#write_target_params_config/3"},{"type":"function","title":"snmpa_conf.write_usm_config/2","doc":"","ref":"snmpa_conf.html#write_usm_config/2"},{"type":"function","title":"snmpa_conf.write_usm_config/3","doc":"Write the agent usm config to the agent usm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Security data for USM](snmp_agent_config_files.md#usm) for more info.","ref":"snmpa_conf.html#write_usm_config/3"},{"type":"function","title":"snmpa_conf.write_vacm_config/2","doc":"","ref":"snmpa_conf.html#write_vacm_config/2"},{"type":"function","title":"snmpa_conf.write_vacm_config/3","doc":"Write the agent vacm config to the agent vacm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [MIB Views for VACM](snmp_agent_config_files.md#vacm) for more info.","ref":"snmpa_conf.html#write_vacm_config/3"},{"type":"opaque","title":"snmpa_conf.agent_entry/0","doc":"An opaque term that represents an entry in the 'agent' config.","ref":"snmpa_conf.html#t:agent_entry/0"},{"type":"opaque","title":"snmpa_conf.community_entry/0","doc":"An opaque term that represents an entry in the 'community' (agent) config.","ref":"snmpa_conf.html#t:community_entry/0"},{"type":"opaque","title":"snmpa_conf.context_entry/0","doc":"An opaque term that represents an entry in the 'context' (agent) config.","ref":"snmpa_conf.html#t:context_entry/0"},{"type":"type","title":"snmpa_conf.extended_transport_address/0","doc":"","ref":"snmpa_conf.html#t:extended_transport_address/0"},{"type":"type","title":"snmpa_conf.intAgentTransport/0","doc":"","ref":"snmpa_conf.html#t:intAgentTransport/0"},{"type":"type","title":"snmpa_conf.ip_address/0","doc":"","ref":"snmpa_conf.html#t:ip_address/0"},{"type":"opaque","title":"snmpa_conf.notify_entry/0","doc":"An opaque term that represents an entry in the 'notify' (agent) config.","ref":"snmpa_conf.html#t:notify_entry/0"},{"type":"type","title":"snmpa_conf.port_info/0","doc":"Port number `0` (zero) cannot be specified directly (it is used internally).\nInstead the atom `'system'` should be used.","ref":"snmpa_conf.html#t:port_info/0"},{"type":"type","title":"snmpa_conf.range/0","doc":"`Min < Max`","ref":"snmpa_conf.html#t:range/0"},{"type":"type","title":"snmpa_conf.ranges/0","doc":"","ref":"snmpa_conf.html#t:ranges/0"},{"type":"type","title":"snmpa_conf.snmp_ip_address/0","doc":"","ref":"snmpa_conf.html#t:snmp_ip_address/0"},{"type":"opaque","title":"snmpa_conf.standard_entry/0","doc":"An opaque term that represents an entry in the 'standard' (agent) config.","ref":"snmpa_conf.html#t:standard_entry/0"},{"type":"opaque","title":"snmpa_conf.target_addr_entry/0","doc":"An opaque term that represents an entry in the 'target address' (agent) config.","ref":"snmpa_conf.html#t:target_addr_entry/0"},{"type":"opaque","title":"snmpa_conf.target_params_entry/0","doc":"An opaque term that represents an entry in the 'target parameters' (agent)\nconfig.","ref":"snmpa_conf.html#t:target_params_entry/0"},{"type":"type","title":"snmpa_conf.transport_address/0","doc":"","ref":"snmpa_conf.html#t:transport_address/0"},{"type":"type","title":"snmpa_conf.transport_opts/0","doc":"","ref":"snmpa_conf.html#t:transport_opts/0"},{"type":"type","title":"snmpa_conf.transportAddress/0","doc":"","ref":"snmpa_conf.html#t:transportAddress/0"},{"type":"type","title":"snmpa_conf.transportAddressIPv4/0","doc":"","ref":"snmpa_conf.html#t:transportAddressIPv4/0"},{"type":"type","title":"snmpa_conf.transportAddressIPv4WithoutPort/0","doc":"Because of limitations of the Erlang type language we cannot define this type in\ndetail. Instead, we describe it here.\n\nThe list variant, 4 bytes for address:\n\n`[byte() x 4]`","ref":"snmpa_conf.html#t:transportAddressIPv4WithoutPort/0"},{"type":"type","title":"snmpa_conf.transportAddressIPv4WithPort/0","doc":"Because of limitations of the Erlang type language we cannot define this type in\ndetail. Instead, we describe it here.\n\nThe list variant, 4 bytes for address + 2 bytes for port:\n\n`[byte() x 4, byte() x 2]`","ref":"snmpa_conf.html#t:transportAddressIPv4WithPort/0"},{"type":"type","title":"snmpa_conf.transportAddressIPv6/0","doc":"","ref":"snmpa_conf.html#t:transportAddressIPv6/0"},{"type":"type","title":"snmpa_conf.transportAddressIPv6WithoutPort/0","doc":"Because of limitations of the Erlang type language we cannot define this type in\ndetail. Instead, we describe it here.\n\nFirst list variant, 8 words for address:\n\n`[word() x 8]`\n\nSecond list variant, 16 bytes for address:\n\n`[byte() x 16]`","ref":"snmpa_conf.html#t:transportAddressIPv6WithoutPort/0"},{"type":"type","title":"snmpa_conf.transportAddressIPv6WithPort/0","doc":"Because of limitations of the Erlang type language we cannot define this type in\ndetail. Instead, we describe it here.\n\nFirst list variant, 8 words for address + 1 word for port:\n\n`[word() x 8, inet:port_number()]`\n\nSecond list variant, 8 words for address + 2 bytes for port:\n\n`[word() x 8, byte() x 2]`\n\nThird list variant, 16 bytes for address + 2 bytes for port:\n\n`[byte() x 16, byte() x 2]`","ref":"snmpa_conf.html#t:transportAddressIPv6WithPort/0"},{"type":"type","title":"snmpa_conf.transportAddressMask/0","doc":"","ref":"snmpa_conf.html#t:transportAddressMask/0"},{"type":"type","title":"snmpa_conf.transportAddressWithoutPort/0","doc":"","ref":"snmpa_conf.html#t:transportAddressWithoutPort/0"},{"type":"type","title":"snmpa_conf.transportAddressWithPort/0","doc":"","ref":"snmpa_conf.html#t:transportAddressWithPort/0"},{"type":"type","title":"snmpa_conf.transportDomain/0","doc":"","ref":"snmpa_conf.html#t:transportDomain/0"},{"type":"opaque","title":"snmpa_conf.usm_entry/0","doc":"An opaque term that represents an entry in the 'user based sm' (agent) config.","ref":"snmpa_conf.html#t:usm_entry/0"},{"type":"opaque","title":"snmpa_conf.vacm_acc_entry/0","doc":"An opaque term that represents an (access) entry in the 'vacm access' (agent)\nconfig.","ref":"snmpa_conf.html#t:vacm_acc_entry/0"},{"type":"type","title":"snmpa_conf.vacm_entry/0","doc":"An basically opaque term that represents an entry in the 'view based acm'\n(agent) config.","ref":"snmpa_conf.html#t:vacm_entry/0"},{"type":"opaque","title":"snmpa_conf.vacm_s2g_entry/0","doc":"An opaque term that represents an (security to group) entry in the 'vacm\nsecurity to group' (agent) config.","ref":"snmpa_conf.html#t:vacm_s2g_entry/0"},{"type":"opaque","title":"snmpa_conf.vacm_vtf_entry/0","doc":"An opaque term that represents an (tree family) entry in the 'vacm tree family'\n(agent) config.","ref":"snmpa_conf.html#t:vacm_vtf_entry/0"},{"type":"type","title":"snmpa_conf.word/0","doc":"","ref":"snmpa_conf.html#t:word/0"},{"type":"behaviour","title":"snmpa_discovery_handler","doc":"Behaviour module for the SNMP agent discovery handler.\n\nThis module defines the behaviour of the agent discovery handler. A\n`snmpa_discovery_handler` compliant module must export the following functions:\n\n- `c:stage1_finish/3`\n\nThe semantics of them and their exact signatures are explained below.","ref":"snmpa_discovery_handler.html"},{"type":"callback","title":"snmpa_discovery_handler.stage1_finish/3","doc":"This function is called at the end of stage 1 of the discovery process. It\nshould return either the atom `ignore` or `{ok, usm_entry() | [usm_entry()]}`.\nSee [usm_entry()](snmp_agent_config_files.md#usm) and\n[usm_entry/1,3](`snmpa_conf:usm_entry/1`) for more info.\n\nIf the function returns `ignore`, then it is assumed that either:\n\n- The caller (of the discovery function) will make the needed updates later.\n- The callback function itself did the updates.\n\nIn either case, the agent will do nothing, but return the retrieved\nManagerEngineID (see `snmpa:discovery/6` for more info) and\npossible continue with stage 2 of the discovery process.\n\nThe `ExtraInfo` argument is passed on from the `snmpa:discovery/6`\nfunction.\n\nThis function may return an updated `NewExtraInfo` that will be used in\nsubsequent calls to the callback functions. Intended for future use.\n\nThe purpose of this function is to generate the usm- related security data\nneeded for usm processing in the agent. Specifically, updating the usmUserTable.\n\nWhen an `usm_entry()` tuple (or a list of such tuples) is returned, this data is\nthen added to the `usmUserTable` by the (master-) agent.\n\nWhen an `usm_entry()` tuple (or a list of such tuples) is returned, this data is\nthen added to the `usmUserTable` by the (master-) agent.\n\n> #### Note {: .info }\n>\n> Note that the function does not check if this entry already exists.\n\n> #### Note {: .info }\n>\n> Note that this function is executed in the context of the master-agent\n> process.","ref":"snmpa_discovery_handler.html#c:stage1_finish/3"},{"type":"module","title":"snmpa_error","doc":"Functions for Reporting SNMP Errors\n\n[](){: #desc }\n\nThe module `snmpa_error` contains two callback functions which are called if an\nerror occurs at different times during agent operation. These functions in turn\ncalls the corresponding function in the configured error report module, which\nimplements the actual report functionality.\n\nTwo simple implementation(s) is provided with the toolkit; the modules\n`m:snmpa_error_logger` which is the default and `m:snmpa_error_io`.\n\nThe error report module is configured using the directive `error_report_mod`,\nsee [configuration parameters](snmp_config.md#configuration_params).","ref":"snmpa_error.html"},{"type":"function","title":"snmpa_error.config_err/2","doc":"The function is called if an error occurs during the configuration phase, for\nexample if a syntax error is found in a configuration file.\n\n`Format` and `Args` are as in `io:format(Format, Args)`.\n\n[](){: #config_err }","ref":"snmpa_error.html#config_err/2"},{"type":"function","title":"snmpa_error.user_err/2","doc":"The function is called if a user related error occurs at run-time, for example\nif a user defined instrumentation function returns erroneous.\n\n`Format` and `Args` are as in `io:format(Format, Args)`.\n\n[](){: #user_err }","ref":"snmpa_error.html#user_err/2"},{"type":"module","title":"snmpa_error_io","doc":"Functions for Reporting SNMP Errors on stdio\n\nThe module `snmpa_error_io` implements the `snmp_error_report` behaviour (see\n`m:snmpa_error_report`) containing two callback functions which are called in\norder to report SNMP errors.\n\nThis module provides a simple mechanism for reporting SNMP errors. Errors are\nwritten to stdout using the `io` module. It is provided as an simple example.\n\nThis module needs to be explicitly configured, see\n[snmpa_error](`m:snmpa_error#desc`) and\n[configuration parameters](snmp_config.md#configuration_params).","ref":"snmpa_error_io.html"},{"type":"function","title":"snmpa_error_io.config_err/2","doc":"The function is called if an error occurs during the configuration phase, for\nexample if a syntax error is found in a configuration file.\n\n`Format` and `Args` are as in `io:format(Format, Args)`.","ref":"snmpa_error_io.html#config_err/2"},{"type":"function","title":"snmpa_error_io.user_err/2","doc":"The function is called if a user related error occurs at run-time, for example\nif a user defined instrumentation function returns erroneous.\n\n`Format` and `Args` are as in `io:format(Format, Args)`.","ref":"snmpa_error_io.html#user_err/2"},{"type":"module","title":"snmpa_error_logger","doc":"Functions for Reporting SNMP Errors through the error_logger\n\nThe module `snmpa_error_logger` implements the `snmpa_error_report` behaviour\n(see `m:snmpa_error_report`) containing two callback functions which are called\nin order to report SNMP errors.\n\nThis module provides a simple mechanism for reporting SNMP errors. Errors are\nsent to the `error_logger` after a size check. Messages are truncated after 1024\nchars. It is provided as an example.\n\nThis module is the default error report module, but can be explicitly\nconfigured, see [snmpa_error](`m:snmpa_error#desc`) and\n[configuration parameters](snmp_config.md#configuration_params).","ref":"snmpa_error_logger.html"},{"type":"module","title":"See Also - snmpa_error_logger","doc":"error_logger(3)","ref":"snmpa_error_logger.html#module-see-also"},{"type":"function","title":"snmpa_error_logger.config_err/2","doc":"The function is called if an error occurs during the configuration phase, for\nexample if a syntax error is found in a configuration file.\n\n`Format` and `Args` are as in `io:format(Format, Args)`.","ref":"snmpa_error_logger.html#config_err/2"},{"type":"function","title":"snmpa_error_logger.user_err/2","doc":"The function is called if a user related error occurs at run-time, for example\nif a user defined instrumentation function returns erroneous.\n\n`Format` and `Args` are as in `io:format(Format, Args)`.","ref":"snmpa_error_logger.html#user_err/2"},{"type":"behaviour","title":"snmpa_error_report","doc":"Behaviour module for reporting SNMP agent errors\n\n[](){: #desc } This module defines the behaviour of the agent error reporting. A\n`snmpa_error_report` compliant module must export the following functions:\n\n- config_err/2\n- user_err/2\n\nThe semantics of them and their exact signatures are explained below.","ref":"snmpa_error_report.html"},{"type":"callback","title":"snmpa_error_report.config_err/2","doc":"The function is called if an error occurs during the configuration phase, for\nexample if a syntax error is found in a configuration file.\n\n`Format` and `Args` are as in `io:format(Format, Args)`.","ref":"snmpa_error_report.html#c:config_err/2"},{"type":"callback","title":"snmpa_error_report.user_err/2","doc":"The function is called if a user related error occurs at run-time, for example\nif a user defined instrumentation function returns erroneous.\n\n`Format` and `Args` are as in `io:format(Format, Args)`.","ref":"snmpa_error_report.html#c:user_err/2"},{"type":"module","title":"snmpa_local_db","doc":"The SNMP built-in database\n\nThe module `snmpa_local_db` contains functions for implementing tables (and\nvariables) using the SNMP built-in database. The database exists in two\ninstances, one volatile and one persistent. The volatile database is implemented\nwith ets. The persistent database is implemented with dets.\n\nThere is a scaling problem with this database.\n\n- Insertions and deletions are inefficient for large tables.\n\nThis problem is best solved by using Mnesia instead.\n\nThe following functions describe the interface to `snmpa_local_db`. Each\nfunction has a Mnesia equivalent. The argument `NameDb` is a tuple `{Name, Db}`\nwhere `Name` is the symbolic name of the managed object (as defined in the MIB),\nand `Db` is either `volatile` or `persistent`. `mnesia` is not possible since\nall these functions are `snmpa_local_db` specific.","ref":"snmpa_local_db.html"},{"type":"module","title":"Common Data Types - snmpa_local_db","doc":"In the functions defined below, the following limitation applies:\n\n- `Db = volatile | persistent`","ref":"snmpa_local_db.html#module-common-data-types"},{"type":"module","title":"See Also - snmpa_local_db","doc":"ets(3), dets(3), snmp_generic(3)","ref":"snmpa_local_db.html#module-see-also"},{"type":"function","title":"snmpa_local_db.dump/0","doc":"This function can be used to manually dump the database to file.","ref":"snmpa_local_db.html#dump/0"},{"type":"function","title":"snmpa_local_db.match/2","doc":"Performs an ets/dets matching on the table.\n\nSee `ets:match/2` for a description of `Pattern` and the return values.","ref":"snmpa_local_db.html#match/2"},{"type":"function","title":"snmpa_local_db.print/0","doc":"","ref":"snmpa_local_db.html#print/0"},{"type":"function","title":"snmpa_local_db.print/1","doc":"","ref":"snmpa_local_db.html#print/1"},{"type":"function","title":"snmpa_local_db.print/2","doc":"Prints the contents of the database on screen. This is useful for debugging\nsince the `STANDARD-MIB` and `OTP-SNMPEA-MIB` (and maybe your own MIBs) are\nstored in `snmpa_local_db`.\n\n`Table` is an atom for a table in the database. When no name is supplied, the\nwhole database is shown.\n\nNote that these functions does not actually print, using io:format/2, instead\nthey (just) return the information. If executed in a shell, the information will\nthen be displayed (probably truncated) there.\n\nA better use would be:\n\n```text\n\t  io:format(\"~p~n\", [snmpa_local_db:print()]).\n```","ref":"snmpa_local_db.html#print/2"},{"type":"function","title":"snmpa_local_db.table_create/1","doc":"Creates a table. If the table already exist, the old copy is destroyed.\n\nReturns `false` if the `NameDb` argument is incorrectly specified, `true`\notherwise.\n\nDatabase (only table name specified) defaults to `volatile`.","ref":"snmpa_local_db.html#table_create/1"},{"type":"function","title":"snmpa_local_db.table_create_row/3","doc":"Creates a row in a table. `Row` is a tuple with values for all columns,\nincluding the index columns.\n\nDatabase (only table name specified) defaults to `volatile`.","ref":"snmpa_local_db.html#table_create_row/3"},{"type":"function","title":"snmpa_local_db.table_delete/1","doc":"Deletes a table.\n\nDatabase (only table name specified) defaults to `volatile`.","ref":"snmpa_local_db.html#table_delete/1"},{"type":"function","title":"snmpa_local_db.table_delete_row/2","doc":"Deletes the row in the table.\n\nDatabase (only table name specified) defaults to `volatile`.","ref":"snmpa_local_db.html#table_delete_row/2"},{"type":"function","title":"snmpa_local_db.table_exists/1","doc":"Checks if a table exists.\n\nDatabase (only table name specified) defaults to `volatile`.","ref":"snmpa_local_db.html#table_exists/1"},{"type":"function","title":"snmpa_local_db.table_get_element/3","doc":"Get a column value (element) from a row of the table.\n\nDatabase (only table name specified) defaults to `volatile`.\n\nThis function has existed for long time,\nbut not had a proper since tag, so to simplify\nwe set the since tag to when it was documented.","ref":"snmpa_local_db.html#table_get_element/3"},{"type":"function","title":"snmpa_local_db.table_get_row/2","doc":"`Row` is a tuple with values for all columns, including the index columns.\n\nDatabase (only table name specified) defaults to `volatile`.","ref":"snmpa_local_db.html#table_get_row/2"},{"type":"function","title":"snmpa_local_db.table_set_elements/3","doc":"Update the specified columnar objects of the row of this table.\n\nDatabase (only table name specified) defaults to `volatile`.\n\nThis function has existed for long time,\nbut not had a proper since tag, so to simplify\nwe set the since tag to when it was documented.","ref":"snmpa_local_db.html#table_set_elements/3"},{"type":"behaviour","title":"snmpa_mib_data","doc":"Behaviour module for the SNMP agent mib-server data module.\n\nThis module defines the behaviour of the SNMP agent mib-server data module. A\n`snmpa_mib_data` compliant module must export the following functions:\n\n- [new/1](`c:snmpa_mib_data:new/1`)\n- [close/1](`c:snmpa_mib_data:close/1`)\n- [sync/1](`c:snmpa_mib_data:sync/1`)\n- [load_mib/4](`c:snmpa_mib_data:load_mib/4`)\n- [unload_mib/4](`c:snmpa_mib_data:unload_mib/4`)\n- [lookup/2](`c:snmpa_mib_data:lookup/2`)\n- [next/3](`c:snmpa_mib_data:next/3`)\n- [register_subagent/3](`c:snmpa_mib_data:register_subagent/3`)\n- [unregister_subagent/2](`c:snmpa_mib_data:unregister_subagent/2`)\n- [which_mib/2](`c:snmpa_mib_data:which_mib/2`)\n- [which_mibs/1](`c:snmpa_mib_data:which_mibs/1`)\n- [whereis_mib/2](`c:snmpa_mib_data:whereis_mib/2`)\n- [dump/2](`c:snmpa_mib_data:dump/2`)\n- [info/1](`c:snmpa_mib_data:info/1`)\n- [backup/2](`c:snmpa_mib_data:backup/2`)\n- [code_change/4](`c:snmpa_mib_data:code_change/4`)\n\nThe semantics of them and their exact signatures are explained below.\n\nNote that the data extracted from the imported (loaded) mibs are stored partly\nby the mib-server and partly by the symbolic-store server. See the default\nmib-server data module, `snmpa_mib_data_tttn` for details.","ref":"snmpa_mib_data.html"},{"type":"callback","title":"snmpa_mib_data.backup/2","doc":"Perform a backup of the mib-server data.\n\nNote that its implementation dependent (and also dependent on mib-storage is\nused) if a backup is possible.","ref":"snmpa_mib_data.html#c:backup/2"},{"type":"callback","title":"snmpa_mib_data.close/1","doc":"Close the mib-storage.","ref":"snmpa_mib_data.html#c:close/1"},{"type":"callback","title":"snmpa_mib_data.code_change/4","doc":"Perform a code-change (upgrade or downgrade).\n\nSee `m:gen_server` for more info regarding the `Vsn` and `Extra` arguments.","ref":"snmpa_mib_data.html#c:code_change/4"},{"type":"callback","title":"snmpa_mib_data.dump/2","doc":"Dump the mib-server data to `stdio` (Destination = `io`) or the specified file.","ref":"snmpa_mib_data.html#c:dump/2"},{"type":"callback","title":"snmpa_mib_data.info/1","doc":"Retrieve misc info for the mib data.\n\nThis is a utility function used to inspect, for instance, memory usage, in a\nsimple way.","ref":"snmpa_mib_data.html#c:info/1"},{"type":"callback","title":"snmpa_mib_data.load_mib/4","doc":"Load the mib specified by the `Filename` argument into the mib-server. The\n`MeOverride` and `TeOverride` arguments specifies how the mib-server shall\nhandle duplicate mib- and trap- entries.","ref":"snmpa_mib_data.html#c:load_mib/4"},{"type":"callback","title":"snmpa_mib_data.lookup/2","doc":"Find the mib-entry corresponding to the `Oid`. If it is a variable, the `Oid`\nmust be  .0 and if it is a table, `Oid` must be","ref":"snmpa_mib_data.html#c:lookup/2"},{"type":"callback","title":"snmpa_mib_data.new/1","doc":"Create a new mib-server data instance.","ref":"snmpa_mib_data.html#c:new/1"},{"type":"callback","title":"snmpa_mib_data.next/3","doc":"Finds the lexicographically next oid.","ref":"snmpa_mib_data.html#c:next/3"},{"type":"callback","title":"snmpa_mib_data.register_subagent/3","doc":"Register the subagent, process, handling part of the mib-tree.","ref":"snmpa_mib_data.html#c:register_subagent/3"},{"type":"callback","title":"snmpa_mib_data.sync/1","doc":"Synchronize (write to disc, if possible) the mib-server data. This depends on\nthe `mib_storage` option, and will only have an effect if the mib-storage option\nhas an actual disc component (such as dets, or ets with a file).","ref":"snmpa_mib_data.html#c:sync/1"},{"type":"callback","title":"snmpa_mib_data.unload_mib/2","doc":"","ref":"snmpa_mib_data.html#c:unload_mib/2"},{"type":"callback","title":"snmpa_mib_data.unload_mib/4","doc":"Unload the mib specified by the `Filename` argument from the mib-server. The\n`MeOverride` and `TeOverride` arguments specifies how the mib-server shall\nhandle duplicate mib- and trap- entries.","ref":"snmpa_mib_data.html#c:unload_mib/4"},{"type":"callback","title":"snmpa_mib_data.unregister_subagent/2","doc":"Unregister the subagent, handling part of the mib-tree, as specified by the\n`oid()` or `t:pid/0` (`PidOrOid`).\n\nWhen unregister the subagent using an `oid()`, the `t:pid/0` of the process\nhandling the sub-tree is also returned.","ref":"snmpa_mib_data.html#c:unregister_subagent/2"},{"type":"callback","title":"snmpa_mib_data.whereis_mib/2","doc":"Retrieve the mib file for the mib.","ref":"snmpa_mib_data.html#c:whereis_mib/2"},{"type":"callback","title":"snmpa_mib_data.which_mib/2","doc":"Retrieve the mib-file to which an given `oid()` belongs.","ref":"snmpa_mib_data.html#c:which_mib/2"},{"type":"callback","title":"snmpa_mib_data.which_mibs/1","doc":"Retrieve all loaded mib-files.","ref":"snmpa_mib_data.html#c:which_mibs/1"},{"type":"type","title":"snmpa_mib_data.filename/0","doc":"","ref":"snmpa_mib_data.html#t:filename/0"},{"type":"type","title":"snmpa_mib_data.mib_view/0","doc":"","ref":"snmpa_mib_data.html#t:mib_view/0"},{"type":"type","title":"snmpa_mib_data.mib_view_elem/0","doc":"","ref":"snmpa_mib_data.html#t:mib_view_elem/0"},{"type":"type","title":"snmpa_mib_data.mib_view_inclusion/0","doc":"","ref":"snmpa_mib_data.html#t:mib_view_inclusion/0"},{"type":"type","title":"snmpa_mib_data.mib_view_mask/0","doc":"","ref":"snmpa_mib_data.html#t:mib_view_mask/0"},{"type":"behaviour","title":"snmpa_mib_storage","doc":"Behaviour module for the SNMP agent mib storage.\n\nThis module defines the behaviour of the SNMP agent mib storage.\n\nThe mib storage is used by the agent to store internal mib- related information.\nThe mib storage module is used by several entities, not just the mib-server.\n\nA `snmpa_mib_storage` compliant module must export the following functions:\n\n- [open/5](`c:snmpa_mib_storage:open/5`)\n- [close/1](`c:snmpa_mib_storage:close/1`)\n- [read/2](`c:snmpa_mib_storage:read/2`)\n- [write/2](`c:snmpa_mib_storage:write/2`)\n- [delete/1](`c:snmpa_mib_storage:delete/1`)\n- [delete/2](`c:snmpa_mib_storage:delete/2`)\n- [match_object/2](`c:snmpa_mib_storage:match_object/2`)\n- [match_delete/2](`c:snmpa_mib_storage:match_delete/2`)\n- [tab2list/1](`c:snmpa_mib_storage:tab2list/1`)\n- [info/1](`c:snmpa_mib_storage:info/1`)\n- [info/2](`c:snmpa_mib_storage:info/2`)\n- [sync/1](`c:snmpa_mib_storage:sync/1`)\n- [backup/2](`c:snmpa_mib_storage:backup/2`)\n\nThe semantics of them and their exact signatures are explained below.","ref":"snmpa_mib_storage.html"},{"type":"callback","title":"snmpa_mib_storage.backup/2","doc":"Perform a backup of the mib-storage table.\n\nWhat this means, if anything, is implementation dependent.","ref":"snmpa_mib_storage.html#c:backup/2"},{"type":"callback","title":"snmpa_mib_storage.close/1","doc":"Close the mib-storage table.","ref":"snmpa_mib_storage.html#c:close/1"},{"type":"callback","title":"snmpa_mib_storage.delete/1","doc":"Delete an entire mib-storage table.","ref":"snmpa_mib_storage.html#c:delete/1"},{"type":"callback","title":"snmpa_mib_storage.delete/2","doc":"Delete a record from the mib-storage table.","ref":"snmpa_mib_storage.html#c:delete/2"},{"type":"callback","title":"snmpa_mib_storage.info/1","doc":"Retrieve implementation dependent mib-storage table information.","ref":"snmpa_mib_storage.html#c:info/1"},{"type":"callback","title":"snmpa_mib_storage.info/2","doc":"","ref":"snmpa_mib_storage.html#c:info/2"},{"type":"callback","title":"snmpa_mib_storage.match_delete/2","doc":"Search the mib-storage table for record that match the specified pattern and\nthen delete them. The records deleted are also returned.","ref":"snmpa_mib_storage.html#c:match_delete/2"},{"type":"callback","title":"snmpa_mib_storage.match_object/2","doc":"Search the mib-storage table for record that match the specified pattern.","ref":"snmpa_mib_storage.html#c:match_object/2"},{"type":"callback","title":"snmpa_mib_storage.open/5","doc":"Create or open a mib storage table.\n\nNote that the `RecordName` and `Fields` arguments my not be used in all\nimplementations (they are actually only needed for mnesia-based\nimplementations).\n\nNote also that the `Options` argument comes from the `options` config option of\nthe mib-storage config option, and is passed on as is.","ref":"snmpa_mib_storage.html#c:open/5"},{"type":"callback","title":"snmpa_mib_storage.read/2","doc":"Read a record from the mib-storage table.","ref":"snmpa_mib_storage.html#c:read/2"},{"type":"callback","title":"snmpa_mib_storage.sync/1","doc":"Synchronize the mib-storage table.\n\nWhat this means, if anything, is implementation dependent.","ref":"snmpa_mib_storage.html#c:sync/1"},{"type":"callback","title":"snmpa_mib_storage.tab2list/1","doc":"Return all records in the mib-storage table in the form of a list.","ref":"snmpa_mib_storage.html#c:tab2list/1"},{"type":"callback","title":"snmpa_mib_storage.write/2","doc":"Write a record to the mib-storage table.","ref":"snmpa_mib_storage.html#c:write/2"},{"type":"type","title":"snmpa_mib_storage.mib_storage_fields/0","doc":"","ref":"snmpa_mib_storage.html#t:mib_storage_fields/0"},{"type":"type","title":"snmpa_mib_storage.mib_storage_table_id/0","doc":"","ref":"snmpa_mib_storage.html#t:mib_storage_table_id/0"},{"type":"type","title":"snmpa_mib_storage.mib_storage_table_type/0","doc":"","ref":"snmpa_mib_storage.html#t:mib_storage_table_type/0"},{"type":"module","title":"snmpa_mpd","doc":"Message Processing and Dispatch module for the SNMP agent\n\nThe module `snmpa_mpd` implements the version independent Message Processing and\nDispatch functionality in SNMP for the agent. It is supposed to be used from a\nNetwork Interface process ([Definition of Agent Net if](snmp_agent_netif.md)).","ref":"snmpa_mpd.html"},{"type":"module","title":"DATA TYPES - snmpa_mpd","doc":"For more information, see the\n[data types in `snmpa_conf`](`m:snmpa_conf#types`).","ref":"snmpa_mpd.html#module-data-types"},{"type":"function","title":"snmpa_mpd.discarded_pdu/1","doc":"Increments the variable associated with a discarded pdu. This function can be\nused when the net_if process receives a `discarded_pdu` message from the agent.","ref":"snmpa_mpd.html#discarded_pdu/1"},{"type":"function","title":"snmpa_mpd.generate_msg/5","doc":"","ref":"snmpa_mpd.html#generate_msg/5"},{"type":"function","title":"snmpa_mpd.generate_msg/6","doc":"Generates a possibly encrypted request packet to be sent to the network.\n\n`MsgData` is the message specific data used in the SNMP message. This value is\nreceived in a [`send_pdu`](snmp_agent_netif.md#im_send_pdu) or\n[`send_pdu_req`](snmp_agent_netif.md#im_send_pdu_req) message from the agent. In\nSNMPv1 and SNMPv2c, this message data is the [community](`t:msg_data_cmy/0`)\nstring. In SNMPv3, it is the [context](`t:msg_data_ctx/0`) information.\n\n`To` is a list of destination addresses and their corresponding security\nparameters. This value is received in the same message from the agent and then\ntransformed through [`process_taddrs`](`process_taddrs/1`) before\npassed to this function.\n\n> #### Note {: .info }\n>\n> Note that the use of the LocalEngineID argument is only intended for special\n> cases, if the agent is to \"emulate\" multiple EngineIDs\\! By default, the agent\n> uses the value of `SnmpEngineID` (see SNMP-FRAMEWORK-MIB).","ref":"snmpa_mpd.html#generate_msg/6"},{"type":"function","title":"snmpa_mpd.generate_response_msg/5","doc":"","ref":"snmpa_mpd.html#generate_response_msg/5"},{"type":"function","title":"snmpa_mpd.generate_response_msg/6","doc":"Generates a possibly encrypted response packet to be sent to the network. `Type`\nis the `#pdu.type` of the original request.\n\n> #### Note {: .info }\n>\n> Note that the use of the LocalEngineID argument is only intended for special\n> cases, if the agent is to \"emulate\" multiple EngineIDs\\! By default, the agent\n> uses the value of `SnmpEngineID` (see SNMP-FRAMEWORK-MIB).","ref":"snmpa_mpd.html#generate_response_msg/6"},{"type":"function","title":"snmpa_mpd.init/1","doc":"This function can be called from the net_if process at start-up. The options\nlist defines which versions to use.\n\nIt also initializes some SNMP counters.","ref":"snmpa_mpd.html#init/1"},{"type":"function","title":"snmpa_mpd.process_packet/5","doc":"","ref":"snmpa_mpd.html#process_packet/5"},{"type":"function","title":"snmpa_mpd.process_packet/6","doc":"Processes an incoming packet. Performs authentication and decryption as\nnecessary. The return values should be passed to the agent.\n\n> #### Note {: .info }\n>\n> Note that the use of the LocalEngineID argument is only intended for special\n> cases, if the agent is to \"emulate\" multiple EngineIDs\\! By default, the agent\n> uses the value of `SnmpEngineID` (see SNMP-FRAMEWORK-MIB).","ref":"snmpa_mpd.html#process_packet/6"},{"type":"function","title":"snmpa_mpd.process_taddrs/1","doc":"Transforms addresses from internal MIB format to one more useful to\n[Agent Net if](snmp_agent_netif.md).\n\nSee also [`generate_msg`.](`generate_msg/6`)","ref":"snmpa_mpd.html#process_taddrs/1"},{"type":"type","title":"snmpa_mpd.acm_data/0","doc":"This is the message specific data used in the SNMP message. This value is\nreceived in a [`send_pdu`](snmp_agent_netif.md#im_send_pdu) or\n[`send_pdu_req`](snmp_agent_netif.md#im_send_pdu_req) message from the agent (by\nthe net-if process).","ref":"snmpa_mpd.html#t:acm_data/0"},{"type":"opaque","title":"snmpa_mpd.acm_data_cmy/0","doc":"This is the message specific data used in the SNMPv1 and SNMPv2c message.","ref":"snmpa_mpd.html#t:acm_data_cmy/0"},{"type":"opaque","title":"snmpa_mpd.acm_data_v3/0","doc":"This is the message specific data used in the SNMPv3 message.","ref":"snmpa_mpd.html#t:acm_data_v3/0"},{"type":"type","title":"snmpa_mpd.logger/0","doc":"A `fun` that handles audit trail logging.","ref":"snmpa_mpd.html#t:logger/0"},{"type":"opaque","title":"snmpa_mpd.mpd_state/0","doc":"","ref":"snmpa_mpd.html#t:mpd_state/0"},{"type":"type","title":"snmpa_mpd.msg_data/0","doc":"This is the message specific data used in the SNMP message. This value is\nreceived in a [`send_pdu`](snmp_agent_netif.md#im_send_pdu) or\n[`send_pdu_req`](snmp_agent_netif.md#im_send_pdu_req) message from the agent (by\nthe net-if process).","ref":"snmpa_mpd.html#t:msg_data/0"},{"type":"opaque","title":"snmpa_mpd.msg_data_cmy/0","doc":"This is the message specific data used in the SNMP message. In SNMPv1 and\nSNMPv2c, this message data is the community string.","ref":"snmpa_mpd.html#t:msg_data_cmy/0"},{"type":"opaque","title":"snmpa_mpd.msg_data_ctx/0","doc":"This is the message specific data used in the SNMP message. In SNMPv3, it is the\ncontext information.","ref":"snmpa_mpd.html#t:msg_data_ctx/0"},{"type":"behaviour","title":"snmpa_network_interface","doc":"Behaviour module for the SNMP agent network interface.\n\nThis module defines the behaviour of the agent network interface. A\n`snmpa_network_interface` compliant module must export the following functions:\n\n- `start_link/4`\n- `info/1`\n- `get_log_type/1`\n- `set_log_type/2`\n- `verbosity/2`\n\nThe semantics of them and their exact signatures are explained below.\n\nBut this is not enough. There is also a set of _mandatory_ messages which the\nnetwork interface entity must be able to receive and be able to send. This is\ndescribed in chapter [snmp_agent_netif](snmp_agent_netif.md).","ref":"snmpa_network_interface.html"},{"type":"callback","title":"snmpa_network_interface.get_log_type/1","doc":"The Audit Trail Log is managed by the network interface process. So, it is this\nprocess that has to retrieve the actual log-type.","ref":"snmpa_network_interface.html#c:get_log_type/1"},{"type":"callback","title":"snmpa_network_interface.get_request_limit/1","doc":"The request limit is the number of simultaneous requests the agent will accept.\nThis function retrieve the current value.","ref":"snmpa_network_interface.html#c:get_request_limit/1"},{"type":"callback","title":"snmpa_network_interface.info/1","doc":"The info returned is basically up to the implementer to decide. This\nimplementation provided by the application provides info about memory allocation\nand various socket information.\n\nThe info returned by this function is returned together with other info\ncollected by the agent when the `info/1` function is called\n(tagged with with the key `net_if`).","ref":"snmpa_network_interface.html#c:info/1"},{"type":"callback","title":"snmpa_network_interface.set_log_type/2","doc":"The Audit Trail Log is managed by the network interface process. So, it is this\nprocess that has to do the actual changing of the type.\n\nSee `snmpa:set_log_type/2` for more info.","ref":"snmpa_network_interface.html#c:set_log_type/2"},{"type":"callback","title":"snmpa_network_interface.set_request_limit/2","doc":"The request limit is the number of simultaneous requests the agent will accept.\nThis function sets a new value.","ref":"snmpa_network_interface.html#c:set_request_limit/2"},{"type":"callback","title":"snmpa_network_interface.start_link/4","doc":"Start-link the network interface process.\n\n`NoteStore` is the pid of the note-store process and `MasterAgent` is the pid of\nthe master-agent process.\n\n`Opts` is an (basically) implementation dependent list of options to the network\ninterface process. There are however a number of options which _must_ be\nhandled: `versions` and `verbosity`.","ref":"snmpa_network_interface.html#c:start_link/4"},{"type":"callback","title":"snmpa_network_interface.verbosity/2","doc":"Change the verbosity of a running network interface process.","ref":"snmpa_network_interface.html#c:verbosity/2"},{"type":"behaviour","title":"snmpa_network_interface_filter","doc":"Behaviour module for the SNMP agent network-interface filter.\n\nThis module defines the behaviour of the agent network interface filter. A\n`snmpa_network_interface_filter` compliant module must export the following\nfunctions:\n\n- `accept_recv/2`\n- `accept_send/2`\n- `accept_recv_pdu/3`\n- `accept_send_pdu/2`\n\nThe semantics of them and their exact signatures are explained below.\n\nThe purpose of the network interface filter is to allow for filtering of\nmessages (accept or reject) receive and send. This is done on two levels:\n\n- The first level is at the transport entry / exit point, i.e. immediately after\n  the receipt of the message before any message processing is done (accept_recv)\n  and immediately before sending the message after all message processing is\n  done (accept_send).\n- The second level is at the MPD entry / exit point, i.e. immediately after the\n  basic message processing (accept_recv_pdu) / immediately before the basic\n  message processing (accept_send_pdu).\n\nNote that the network interface filter is something which is used by the network\ninterface implementation provided by the application (`snmpa_net_if`). The\ndefault filter accepts all messages.\n\nA network interface filter can e.g. be used during testing or for load\nregulation. If the intended use is load regulation, see also\n[req_limit](snmp_config.md#agent_ni_req_limit) and the function\n[register_notification_filter](`snmpa:register_notification_filter/5`).\n\nLegacy network interface filter modules used arguments on the form\n`(IpAddr, PortNumber,...)` instead of `(Domain, Addr, ...)`, and if the SNMP\nagent is run without changing the configuration to use transport domains the\nnetwork interface filter will still get the old arguments and work as before.\n\nSee also the [data types in `snmpa_conf`](`m:snmpa_conf#types`).","ref":"snmpa_network_interface_filter.html"},{"type":"callback","title":"snmpa_network_interface_filter.accept_recv/2","doc":"Called at the reception of a message (before _any_ processing has been done).\n\nFor the message to be discarded, the function _must_ return _false_.","ref":"snmpa_network_interface_filter.html#c:accept_recv/2"},{"type":"callback","title":"snmpa_network_interface_filter.accept_recv_pdu/3","doc":"Called after the basic message processing (MPD) has been done, but before the\npdu is handed over to the master-agent for primary processing.\n\nFor the pdu to be discarded, the function _must_ return _false_.","ref":"snmpa_network_interface_filter.html#c:accept_recv_pdu/3"},{"type":"callback","title":"snmpa_network_interface_filter.accept_send/2","doc":"Called before the sending of a message (after _all_ processing has been done).\n\nFor the message to be discarded, the function _must_ return _false_.","ref":"snmpa_network_interface_filter.html#c:accept_send/2"},{"type":"callback","title":"snmpa_network_interface_filter.accept_send_pdu/2","doc":"Called before the basic message processing (MPD) is done, when a pdu has been\nreceived from the master-agent.\n\nFor the message to be discarded all together, the function _must_ return\n_false_.\n\nNote that it is possible for this function to filter out targets (but _not_ to\nadd its own) by returning an updated `Targets` list (`NewTargets`).","ref":"snmpa_network_interface_filter.html#c:accept_send_pdu/2"},{"type":"type","title":"snmpa_network_interface_filter.pdu_type/0","doc":"","ref":"snmpa_network_interface_filter.html#t:pdu_type/0"},{"type":"type","title":"snmpa_network_interface_filter.transportAddressWithPort/0","doc":"","ref":"snmpa_network_interface_filter.html#t:transportAddressWithPort/0"},{"type":"type","title":"snmpa_network_interface_filter.transportDomain/0","doc":"","ref":"snmpa_network_interface_filter.html#t:transportDomain/0"},{"type":"behaviour","title":"snmpa_notification_delivery_info_receiver","doc":"Behaviour module for the SNMP agent notification delivery information receiver.\n\nThis module defines the behaviour of the notification delivery information\nreceiver.\n\nWhen the user sends a notification (see `snmpa:send_notification2/3`),\nthe user can (optionally) choose to receive delivery information\n(was the message received and acknowledged by the target(s)).\nThis behaviour describes a way for the user to get such (delivery) information.\n\nA `snmpa_notification_delivery_info_receiver` compliant module must export the\nfollowing functions:\n\n- `c:delivery_targets/3`\n- `c:delivery_info/4`\n\nThe semantics of them and their exact signatures are explained below.\n\nLegacy notification delivery information receiver modules used a target argument\non the form `{IpAddr, PortNumber}` instead of `{Domain, Addr}`, and if the SNMP\nAgent is run without changing the configuration to use transport domains the\nnotification delivery information receiver will still get the old arguments and\nwork as before.","ref":"snmpa_notification_delivery_info_receiver.html"},{"type":"callback","title":"snmpa_notification_delivery_info_receiver.delivery_info/4","doc":"Inform about delivery result.\n\nThis function is called for each target in the `Targets` argument of the\n[`delivery_targets/3`](`c:delivery_targets/3`) function, see above.\n\nThe purpose is to inform the `receiver` of the result of the delivery (was the\nnotification acknowledged or not) for each target.","ref":"snmpa_notification_delivery_info_receiver.html#c:delivery_info/4"},{"type":"callback","title":"snmpa_notification_delivery_info_receiver.delivery_targets/3","doc":"Inform about target addresses.\n\nThis is the first function called when a notification delivery is in progress.\nIt informs the `receiver` which targets will get the notification. The result of\nthe delivery will be provided via successive calls to\n[`delivery_info/4`](`c:delivery_info/4`) function, see below.","ref":"snmpa_notification_delivery_info_receiver.html#c:delivery_targets/3"},{"type":"type","title":"snmpa_notification_delivery_info_receiver.notification_delivery_info/0","doc":"How shall (notification) delivery info be reported.\n\nThis record defines the info related to inform delivery info. That is, when\nsending an inform, info about the delivery (such if it was acknowledged) will be\ndelivered using the info in this record.\n\nThe delivery will be performed according to:\n\n```text\n\tMod:delivery_targets(Tag, Addresses, Extra)\n\tMod:delivery_info(Tag, Address, DeliveryResult, Extra)\n```\n\nThe Extra is any term, provided by the user.\n\nThe fields of this record has the following meaning:\n\n- **`tag = term()`** - Value selected by the user to identify this sending\n\n- **`mod = module()`** - A module implementing the\n  `m:snmpa_notification_delivery_info_receiver` behaviour.\n\n- **`extra = term()`** - This is any extra info the user wants to have supplied\n  when the functions in the callback module is called. Provided when calling the\n  send function.","ref":"snmpa_notification_delivery_info_receiver.html#t:notification_delivery_info/0"},{"type":"type","title":"snmpa_notification_delivery_info_receiver.transportAddressWithPort/0","doc":"","ref":"snmpa_notification_delivery_info_receiver.html#t:transportAddressWithPort/0"},{"type":"type","title":"snmpa_notification_delivery_info_receiver.transportDomain/0","doc":"","ref":"snmpa_notification_delivery_info_receiver.html#t:transportDomain/0"},{"type":"behaviour","title":"snmpa_notification_filter","doc":"Behaviour module for the SNMP agent notification filters.\n\nThis module defines the behaviour of the agent notification filters. A\n`snmpa_notification_filter` compliant module must export the following\nfunctions:\n\n- handle_notification/2\n\nThe semantics of them and their exact signatures are explained below.\n\nThe purpose of notification filters is to allow for modification and/or\nsuppression of a notification.\n\nA misbehaving filter will be removed.","ref":"snmpa_notification_filter.html"},{"type":"callback","title":"snmpa_notification_filter.handle_notification/2","doc":"Handle a notification to be sent. The filter can either accept the notification\nas is, return `send`, modify the notification, return `{send, NewNotif}` or\nsuppress the notification, return `dont_send`.\n\n`Data` is supplied at filter registration time, see\n`snmpa:register_notification_filter/5`.","ref":"snmpa_notification_filter.html#c:handle_notification/2"},{"type":"type","title":"snmpa_notification_filter.notification/0","doc":"","ref":"snmpa_notification_filter.html#t:notification/0"},{"type":"type","title":"snmpa_notification_filter.trap/0","doc":"","ref":"snmpa_notification_filter.html#t:trap/0"},{"type":"module","title":"snmpa_supervisor","doc":"A supervisor for the SNMP agent Processes\n\nThis is the top supervisor for the agent part of the SNMP application. There is\nalways one supervisor at each node with an SNMP agent (master agent or\nsub-agent).","ref":"snmpa_supervisor.html"},{"type":"function","title":"snmpa_supervisor.start_master_sup/1","doc":"Starts a supervisor for the SNMP agent system. The supervisor starts all\ninvolved SNMP processes, including the master agent. Sub-agents should be\nstarted by calling `start_subagent/3`.\n\n`db_dir` is mandatory.\n\n`dir` in config is mandatory.\n\nSee [snmp config](snmp_config.md) for a description of the options.","ref":"snmpa_supervisor.html#start_master_sup/1"},{"type":"function","title":"snmpa_supervisor.start_sub_agent/3","doc":"Starts a sub-agent on the node where the function is called. The\n`snmpa_supervisor` must be running.\n\nIf the supervisor is not running, the function fails with the reason `badarg`.","ref":"snmpa_supervisor.html#start_sub_agent/3"},{"type":"function","title":"snmpa_supervisor.start_sub_sup/1","doc":"Starts a supervisor for the SNMP agent system without a master agent. The\nsupervisor starts all involved SNMP agent processes, but no agent processes.\nSub-agents should be started by calling\n[`start_sub_agent/3`](`start_sub_agent/3`).\n\n`db_dir` is mandatory.\n\nSee [configuration parameters](snmp_config.md#configuration_params) for a\ndescription of the options.","ref":"snmpa_supervisor.html#start_sub_sup/1"},{"type":"function","title":"snmpa_supervisor.stop_sub_agent/1","doc":"Stops the sub-agent on the node where the function is called. The\n`snmpa_supervisor` must be running.\n\nIf the supervisor is not running, the function fails with the reason `badarg`.","ref":"snmpa_supervisor.html#stop_sub_agent/1"},{"type":"module","title":"snmpc","doc":"Interface Functions to the SNMP toolkit MIB compiler\n\nThe module `snmpc` contains interface functions to the SNMP toolkit MIB\ncompiler.","ref":"snmpc.html"},{"type":"module","title":"See Also - snmpc","doc":"erlc(1)\n\nsnmpc(command)","ref":"snmpc.html#module-see-also"},{"type":"function","title":"snmpc.compile/1","doc":"","ref":"snmpc.html#compile/1"},{"type":"function","title":"snmpc.compile/2","doc":"[](){: #compiler_opts } Compiles the specified MIB file ` .mib`. The\ncompiled file `BinFileName` is called ` .bin`.\n\n- The option `agent_capabilities`, if present, specifies that the\n  AGENT-CAPABILITIES statement of the MIB shall be included (with a mib-entry\n  record) in the compiled mib. The mib-entry record of the agent-capabilitie\n  will contain `reference` and `modules` part(s) this info in the `assocList`\n  field).\n- The option `db` specifies which database should be used for the default\n  instrumentation.\n\n  Default is `volatile`.\n\n- The option `deprecated` specifies if a deprecated definition should be kept or\n  not. If the option is false the MIB compiler will ignore all deprecated\n  definitions.\n\n  Default is `true`.\n\n- The option `description` specifies if the text of the DESCRIPTION field will\n  be included or not.\n\n  By default it is not included, but if this option is present it will be.\n\n- The option `group_check` specifies whether the mib compiler should check the\n  OBJECT-GROUP macro and the NOTIFICATION-GROUP macro for correctness or not.\n\n  Default is `true`.\n\n- The option `i` specifies the path to search for imported (compiled) MIB files.\n  The directories should be strings with a trailing directory delimiter.\n\n  Default is `[\"./\"]`.\n\n- The option `il` (include_lib) also specifies a list of directories to search\n  for imported MIBs. It assumes that the first element in the directory name\n  corresponds to an OTP application. The compiler will find the current\n  installed version. For example, the value \\[\"snmp/mibs/\"] will be replaced by\n  \\[\"snmp-3.1.1/mibs/\"] (or what the current version may be in the system). The\n  current directory and the ` /priv/mibs/` are always listed last in\n  the include path.\n- The option `imports`, if present, specifies that the IMPORT statement of the\n  MIB shall be included in the compiled mib.\n- The option `module`, if present, specifies the name of a module which\n  implements all instrumentation functions for the MIB.\n\n  The name of all instrumentation functions must be the same as the\n  corresponding managed object it implements.\n\n- The option `module_identity`, if present, specifies that the info part of the\n  MODULE-IDENTITY statement of the MIB shall be included in the compiled mib.\n- The option `module_compliance`, if present, specifies that the\n  MODULE-COMPLIANCE statement of the MIB shall be included (with a mib-entry\n  record) in the compiled mib. The mib-entry record of the module-compliance\n  will contain `reference` and `module` part(s) this info in the `assocList`\n  field).\n- The option `no_defs`, if present, specifies that if a managed object does not\n  have an instrumentation function, the default instrumentation function should\n  NOT be used, instead this is reported as an error, and the compilation aborts.\n- The option `reference` specifies if the text of the REFERENCE field, when\n  found in a table definition, will be included or not.\n\n  By default it is not included, but if this option is present it will be. The\n  reference text will be placed in the allocList field of the mib-entry record\n  (#me\\{\\}) for the table.\n\n- The option `relaxed_row_name_assign_check`, if present, specifies that the row\n  name assign check shall not be done strictly according to the SMI (which\n  allows only the value 1). With this option, all values greater than zero is\n  allowed (>= 1). This means that the error will be converted to a warning.\n\n  By default it is not included, but if this option is present it will be.\n\n- The option `verbosity` specifies the verbosity of the SNMP mib compiler. I.e.\n  if warning, info, log, debug and trace messages shall be shown.\n\n  Default is `silence`.\n\n  Note that if the option `warnings` is `true` and the option `verbosity` is\n  `silence`, warning messages will still be shown.\n\n- The option `warnings` specifies whether warning messages should be shown.\n\n  Default is `true`.\n\n- The option `warnings_as_errors`, if present, specifies whether warnings should\n  be treated as errors.\n\nThe MIB compiler understands both SMIv1 and SMIv2 MIBs. It uses the\n`MODULE-IDENTITY` statement to determine if the MIB is version 1 or 2.\n\nThe MIB compiler can also be invoked from the OS command line by these two\ncommands; `erlc` and `snmpc`.\n\n- **`erlc`** - `erlc` recognizes the extension `.mib`, and invokes the SNMP MIB\n  compiler for files with that extension. The options `db`, `group_check`,\n  `deprecated`, `description`, `verbosity`, `imports` and `module_identity` have\n  to be specified to `erlc` using the syntax `+term`.\n\n  See [`erlc(1)`](`e:erts:erlc_cmd.md`) for details.\n\n- **`snmpc`** - `snmpc` is an escript that provides a more traditional interface\n  to the MIB compiler.\n\n  See [snmpc(command)](snmpc_cmd.md) for details.","ref":"snmpc.html#compile/2"},{"type":"function","title":"snmpc.is_consistent/1","doc":"Checks for multiple usage of object identifiers and traps between MIBs.","ref":"snmpc.html#is_consistent/1"},{"type":"function","title":"snmpc.mib_to_hrl/1","doc":"Generates a `.hrl` file with definitions of Erlang constants for the objects in\nthe MIB. The `.hrl` file is called ` .hrl`. The MIB must be compiled,\nand present in the current directory.\n\nThe `mib_to_hrl` generator can be invoked from the OS command line by using the\ncommand `erlc`. `erlc` recognizes the extension `.bin`, and invokes this\nfunction for files with that extension.","ref":"snmpc.html#mib_to_hrl/1"},{"type":"module","title":"snmpm","doc":"Interface functions to the SNMP toolkit manager\n\nThe module `snmpm` contains interface functions to the SNMP manager.","ref":"snmpm.html"},{"type":"function","title":"snmpm.agent_info/2","doc":"Retrieve agent config.","ref":"snmpm.html#agent_info/2"},{"type":"function","title":"snmpm.async_get2/3","doc":"","ref":"snmpm.html#async_get2/3"},{"type":"function","title":"snmpm.async_get2/4","doc":"Asynchronous `get-request`.\n\nThe reply, if it arrives, will be delivered to the user through a call to the\n`m:snmpm_user` callback function [`handle_pdu`](`c:snmpm_user:handle_pdu/4`).\n\nThe send option `timeout` specifies for how long the request is valid (after\nwhich the manager is free to delete it).\n\nThe send option `extra` specifies an opaque data structure passed on to the\nnet-if process. The net-if process included in this application makes, with one\nexception, no use of this info, so the only use for it (when using the built in\nnet-if) would be tracing. The one usage exception is: _Any_ tuple with\n`snmpm_extra_info_tag` as its first element is reserved for internal use.\n\nSome of the send options (`community`, `sec_model`, `sec_name`, `sec_level` and\n`max_message_size`) are `override options`. That is, for _this_ request, they\noverride any configuration done when the agent was registered.","ref":"snmpm.html#async_get2/4"},{"type":"function","title":"snmpm.async_get_bulk2/5","doc":"","ref":"snmpm.html#async_get_bulk2/5"},{"type":"function","title":"snmpm.async_get_bulk2/6","doc":"Asynchronous `get-bulk-request` (See RFC1905).\n\nThe reply, if it arrives, will be delivered to the user through a call to the\n`m:snmpm_user` callback function [`handle_pdu`](`c:snmpm_user:handle_pdu/4`).\n\nThe send option `timeout` specifies for how long the request is valid (after\nwhich the manager is free to delete it).\n\nThe send option `extra` specifies an opaque data structure passed on to the\n`net-if` process.\nThe `net-if` process included in this application makes no use of\nthis info, so the only use for it in such a configuration (when using the built\nin `net-if`) would be tracing.\n\nSome of the send options (`community`, `sec_model`, `sec_name`, `sec_level` and\n`max_message_size`) are `override options`. That is, for _this_ request, they\noverride any configuration done when the agent was registered.","ref":"snmpm.html#async_get_bulk2/6"},{"type":"function","title":"snmpm.async_get_next2/3","doc":"","ref":"snmpm.html#async_get_next2/3"},{"type":"function","title":"snmpm.async_get_next2/4","doc":"Asynchronous `get-next-request`.\n\nThe reply, if it arrives, will be delivered to the user through a call to the\n`m:snmpm_user` callback function [`handle_pdu`](`c:snmpm_user:handle_pdu/4`).\n\nThe send option `timeout` specifies for how long the request is valid (after\nwhich the manager is free to delete it).\n\nThe send option `extra` specifies an opaque data structure passed on to the\n`net-if` process.\nThe `net-if` process included in this application makes, with one\nexception, no use of this info, so the only use for it (when using the built in\n`net-if`) would be tracing. The one usage exception is: _Any_ tuple with\n`snmpm_extra_info_tag` as its first element is reserved for internal use.\n\nSome of the send options (`community`, `sec_model`, `sec_name`, `sec_level` and\n`max_message_size`) are `override options`. That is, for _this_ request, they\noverride any configuration done when the agent was registered.","ref":"snmpm.html#async_get_next2/4"},{"type":"function","title":"snmpm.async_set2/3","doc":"","ref":"snmpm.html#async_set2/3"},{"type":"function","title":"snmpm.async_set2/4","doc":"Asynchronous `set-request`.\n\nThe reply will be delivered to the user through a call to the\n`m:snmpm_user` callback function [`handle_pdu`](`c:snmpm_user:handle_pdu/4`).\n\nThe send option `timeout` specifies for how long the request is valid (after\nwhich the manager is free to delete it).\n\nWhen _var_and_val()_ is _\\{oid(), value()\\}_, the manager makes an educated\nguess based on the loaded mibs.\n\nThe send option `extra` specifies an opaque data structure passed on to the\nnet-if process. The net-if process included in this application makes, with one\nexception, no use of this info, so the only use for it (when using the built in\nnet-if) would be tracing. The one usage exception is: _Any_ tuple with\n`snmpm_extra_info_tag` as its first element is reserved for internal use.\n\nSome of the send options (`community`, `sec_model`, `sec_name`, `sec_level` and\n`max_message_size`) are `override options`. That is, for _this_ request, they\noverride any configuration done when the agent was registered.","ref":"snmpm.html#async_set2/4"},{"type":"function","title":"snmpm.backup/1","doc":"Backup persistent data handled by the manager.\n\nBackupDir cannot be identical to DbDir.","ref":"snmpm.html#backup/1"},{"type":"function","title":"snmpm.cancel_async_request/2","doc":"Cancel a previous asynchronous request.","ref":"snmpm.html#cancel_async_request/2"},{"type":"function","title":"snmpm.cancel_notify_started/1","doc":"Cancel a previous request to be notified of SNMP manager start.","ref":"snmpm.html#cancel_notify_started/1"},{"type":"function","title":"snmpm.change_log_size/1","doc":"Changes the log size of the Audit Trail Log. The application must be configured\nto use the audit trail log function. Please refer to disk_log(3) in Kernel\nReference Manual for a description of how to change the log size.\n\nThe change is permanent, as long as the log is not deleted. That means, the log\nsize is remembered across reboots.","ref":"snmpm.html#change_log_size/1"},{"type":"function","title":"snmpm.demonitor/1","doc":"Turn off monitoring of the SNMP manager.","ref":"snmpm.html#demonitor/1"},{"type":"function","title":"snmpm.format_reason/1","doc":"","ref":"snmpm.html#format_reason/1"},{"type":"function","title":"snmpm.format_reason/2","doc":"This utility function is used to create a formatted (pretty printable) string of\nthe error reason received from either:\n\n- The `Reason` returned value if any of the sync/async get/get-next/set/get-bulk\n  functions returns `{error, Reason}`\n- The `Reason` parameter in the [handle_error](`c:snmpm_user:handle_error/3`) user\n  callback function.\n\n`Prefix` should either be an indentation string (e.g. a list of spaces) or a\npositive integer (which will be used to create the indentation string of that\nlength).","ref":"snmpm.html#format_reason/2"},{"type":"function","title":"snmpm.info/0","doc":"Returns a list (a dictionary) containing information about the manager.\nInformation includes statistics counters, miscellaneous info about each process\n(e.g. memory allocation), and so on.","ref":"snmpm.html#info/0"},{"type":"function","title":"snmpm.load_mib/1","doc":"Load a `Mib` into the manager. The `MibName` is the name of the Mib, including\nthe path to where the compiled mib is found. For example,\n\n```erlang\n          Dir = code:priv_dir(my_app) ++ \"/mibs/\",\n          snmpm:load_mib(Dir ++ \"MY-MIB\").\n```","ref":"snmpm.html#load_mib/1"},{"type":"function","title":"snmpm.log_to_io/1","doc":"","ref":"snmpm.html#log_to_io/1"},{"type":"function","title":"snmpm.log_to_io/2","doc":"","ref":"snmpm.html#log_to_io/2"},{"type":"function","title":"snmpm.log_to_io/3","doc":"","ref":"snmpm.html#log_to_io/3"},{"type":"function","title":"snmpm.log_to_io/4","doc":"","ref":"snmpm.html#log_to_io/4"},{"type":"function","title":"snmpm.log_to_io/5","doc":"","ref":"snmpm.html#log_to_io/5"},{"type":"function","title":"snmpm.log_to_io/6","doc":"","ref":"snmpm.html#log_to_io/6"},{"type":"function","title":"snmpm.log_to_io/7","doc":"Converts an Audit Trail Log to a readable format and prints it on stdio.\n`LogName` defaults to \"snmpm_log\". `LogFile` defaults to \"snmpm.log\".\n\nThe `Block` argument indicates if the log should be blocked during conversion.\nThis could be useful when converting large logs (when otherwise the log could\nwrap during conversion). Defaults to `true`.\n\n`Start` and `Stop` indicates which log entries should be converted,\nfrom when (`Start`) to when (`Stop`). `Start = null` => Start from the\nbeginning of the log. `Stop = null` => Stop the conversion at the end\nof the log. Defaults to `Start = null` and `Stop = null` (the entire log).\n\nSee [`snmp:log_to_io/7`](`snmp:log_to_io/7`) for more info.","ref":"snmpm.html#log_to_io/7"},{"type":"function","title":"snmpm.log_to_txt/1","doc":"","ref":"snmpm.html#log_to_txt/1"},{"type":"function","title":"snmpm.log_to_txt/2","doc":"","ref":"snmpm.html#log_to_txt/2"},{"type":"function","title":"snmpm.log_to_txt/3","doc":"","ref":"snmpm.html#log_to_txt/3"},{"type":"function","title":"snmpm.log_to_txt/4","doc":"","ref":"snmpm.html#log_to_txt/4"},{"type":"function","title":"snmpm.log_to_txt/5","doc":"","ref":"snmpm.html#log_to_txt/5"},{"type":"function","title":"snmpm.log_to_txt/6","doc":"","ref":"snmpm.html#log_to_txt/6"},{"type":"function","title":"snmpm.log_to_txt/7","doc":"","ref":"snmpm.html#log_to_txt/7"},{"type":"function","title":"snmpm.log_to_txt/8","doc":"Converts an Audit Trail Log to a readable text file. `OutFile` defaults to\n\"./snmpm_log.txt\". `LogName` defaults to \"snmpm_log\". `LogFile` defaults to\n\"snmpm.log\".\n\nThe `Block` argument indicates if the log should be blocked during conversion.\nThis could be useful when converting large logs (when otherwise the log could\nwrap during conversion). Defaults to `true`.\n\n`Start` and `Stop` indicates which log entries should be converted,\nfrom when (`Start`) to when (`Stop`). `Start = null` => Start from the\nbeginning of the log. `Stop = null` => Stop the conversion at the end\nof the log. Defaults to `Start = null` and `Stop = null` (the entire log).\n\nSee [`snmp:log_to_txt/8`](`snmp:log_to_txt/8`) for more info.","ref":"snmpm.html#log_to_txt/8"},{"type":"function","title":"snmpm.monitor/0","doc":"Monitor the SNMP manager. In case of a crash, the calling (monitoring) process\nwill get a 'DOWN' message (see the erlang module for more info).","ref":"snmpm.html#monitor/0"},{"type":"function","title":"snmpm.name_to_oid/1","doc":"Transform a alias-name to its oid.\n\nNote that an alias-name is only unique within the mib, so when loading several\nmib's into a manager, there might be several instances of the same aliasname.","ref":"snmpm.html#name_to_oid/1"},{"type":"function","title":"snmpm.notify_started/1","doc":"Request a notification (message) when the SNMP manager has started.\n\nThe `Timeout` is the time the request is valid. The value has to be greater then\nzero.\n\nThe `Pid` is the process handling the supervision of the SNMP manager start.\nWhen the manager has started a completion message will be sent to the client\nfrom this process: `{snmpm_started, Pid}`. If the SNMP manager was not started\nin time, a timeout message will be sent to the client:\n`{snmpm_start_timeout, Pid}`.\n\nA client application that is dependent on the SNMP manager will use this\nfunction in order to be notified of when the manager has started. There are two\nsituations when this is useful:\n\n- During the start of a system, when a client application _could_ start prior to\n  the SNMP manager but is dependent upon it, and therefore has to wait for it to\n  start.\n- When the SNMP manager has crashed, the dependent client application has to\n  wait for the SNMP manager to be restarted before it can _reconnect_.\n\nThe function returns the pid() of a handler process, that does the supervision\non behalf of the client application. Note that the client application is linked\nto this handler.\n\nThis function is used in conjunction with the monitor function.","ref":"snmpm.html#notify_started/1"},{"type":"function","title":"snmpm.oid_to_name/1","doc":"Transform a oid to its aliasname.","ref":"snmpm.html#oid_to_name/1"},{"type":"function","title":"snmpm.oid_to_type/1","doc":"Retrieve the type (asn1 bertype) of an oid.","ref":"snmpm.html#oid_to_type/1"},{"type":"function","title":"snmpm.register_agent/3","doc":"Explicitly instruct the manager to handle this agent, with `UserId` as the\nresponsible user.\n\nCalled to instruct the manager that this agent shall be handled. This function\nis used when the user knows in advance which agents the manager shall handle.\nNote that there is an alternate way to do the same thing: Add the agent to the\nmanager config files (see [agents.conf](snmp_manager_config_files.md#agents)).\n\n`TargetName` is a non-empty string, uniquely identifying the agent.\n\nThe type of `Val` depends on `Item`:\n\n```text\n[mandatory] engine_id = engine_id()\n[mandatory] address = inet:ip_address()  % Depends on tdomain\n[optional]  port = inet:port_number()\n[optional]  tdomain = snmp:tdomain()\n[optional]  community = snmp:community()\n[optional]  timeout = register_timeout()\n[optional]  max_message_size = snmp:mms()\n[optional]  version = snmp:version()\n[optional]  sec_model = snmp:sec_model()\n[optional]  sec_name = snmp:sec_name()\n[optional]  sec_level = snmp:sec_level()\n```\n\nNote that if no `tdomain` is given, the default value, `transportDomainUdpIpv4`,\nis used.\n\nNote that if no `port` is given and if `taddress` does not contain a port\nnumber, the default value is used.","ref":"snmpm.html#register_agent/3"},{"type":"function","title":"snmpm.register_user/3","doc":"","ref":"snmpm.html#register_user/3"},{"type":"function","title":"snmpm.register_user/4","doc":"Register the manager entity (=user) responsible for specific agent(s).\n\n`Module` is the callback module (`m:snmpm_user` behaviour) which will be called\nwhenever something happens (detected agent, incoming reply or incoming\ntrap/notification).\n\n`Data` is an opaque data structure, not inspected by the manager, that will be\nincluded in all callback calls to the `Module` callback module (`m:snmpm_user`\nbehaviour).\n\nThe argument `DefaultAgentConfig` is used as default values when this user\nregister agents.\n\nNote that this operation (register user) could have already been done as a\nconsequence of the node config. (see users.conf).","ref":"snmpm.html#register_user/4"},{"type":"function","title":"snmpm.register_user_monitor/3","doc":"","ref":"snmpm.html#register_user_monitor/3"},{"type":"function","title":"snmpm.register_user_monitor/4","doc":"Register the monitored manager entity (=user) responsible for specific agent(s).\n\nThe process performing the registration will be monitored. Which means that if\nthat process should die, all agents registered by that user process will be\nunregistered. All outstanding requests will be canceled.\n\n`Module` is the callback module (`m:snmpm_user` behaviour) which will be called\nwhenever something happens (detected agent, incoming reply or incoming\ntrap/notification).\n\n`Data` is an opaque data structure, not inspected by the manager, that will be\nincluded in all callback calls to the `Module` callback module (`m:snmpm_user` \nbehaviour).\n\nThe argument `DefaultAgentConfig` is used as default values when this user\nregister agents.","ref":"snmpm.html#register_user_monitor/4"},{"type":"function","title":"snmpm.register_usm_user/3","doc":"Explicitly instruct the manager to handle this USM user. Note that there is an\nalternate way to do the same thing: Add the usm user to the manager config files\n(see [usm.conf](snmp_manager_config_files.md#security-data-for-usm)).","ref":"snmpm.html#register_usm_user/3"},{"type":"function","title":"snmpm.restart/1","doc":"Restart the indicated process (`What`). Note that its not without risk to\nrestart a process, and should therefore be used with care.","ref":"snmpm.html#restart/1"},{"type":"function","title":"snmpm.set_log_type/1","doc":"Changes the run-time Audit Trail log type.\n\nNote that this has no effect on the application configuration as defined by\nconfiguration files, so a node restart will revert the config to whatever is in\nthose files.\n\nThis function is primarily useful in testing/debugging scenarios.","ref":"snmpm.html#set_log_type/1"},{"type":"function","title":"snmpm.sync_get2/3","doc":"","ref":"snmpm.html#sync_get2/3"},{"type":"function","title":"snmpm.sync_get2/4","doc":"Synchronous `get-request`.\n\n`Remaining` is the remaining time of the given (or default) timeout time.\n\nWhen _Reason_ is _\\{send_failed, ...\\}_ it means that the `net-if` process\nfailed to send the (`get-request` ) message.\nThis could happen because of any number of reasons, i.e. encoding error.\n_ActualReason_ is the actual reason in this case.\n\nThe send option `extra` specifies an opaque data structure passed on to the\n`net-if` process.\nThe `net-if` process included in this application makes, with one\nexception, no use of this info, so the only use for it (when using the built in\n`net-if`) would be tracing. The one usage exception is: _Any_ tuple with\n`snmpm_extra_info_tag` as its first element is reserved for internal use.\n\nSome of the send options (`community`, `sec_model`, `sec_name`, `sec_level` and\n`max_message_size`) are `override options`. That is, for _this_ request, they\noverride any configuration done when the agent was registered.\n\nFor `SnmpInfo`, see the user callback function\n[handle_report](`c:snmpm_user:handle_report/3`).","ref":"snmpm.html#sync_get2/4"},{"type":"function","title":"snmpm.sync_get_bulk2/5","doc":"","ref":"snmpm.html#sync_get_bulk2/5"},{"type":"function","title":"snmpm.sync_get_bulk2/6","doc":"Synchronous `get-bulk-request` (See RFC1905).\n\n`Remaining` is the remaining time of the given (or default) timeout time.\n\nWhen _Reason_ is _\\{send_failed, ...\\}_ it means that the `net-if` process\nfailed to send the message. This could happen because of any number of reasons,\ni.e. encoding error. _ActualReason_ is the actual reason in this case.\n\nThe send option `extra` specifies an opaque data structure passed on to the\n`net-if` process.\nThe `net-if` process included in this application makes, with one\nexception, no use of this info, so the only use for it (when using the built in\n`net-if`) would be tracing. The one usage exception is: _Any_ tuple with\n`snmpm_extra_info_tag` as its first element is reserved for internal use.\n\nSome of the send options (`community`, `sec_model`, `sec_name`, `sec_level` and\n`max_message_size`) are `override options`. That is, for _this_ request, they\noverride any configuration done when the agent was registered.\n\nFor `SnmpInfo`, see the user callback function\n[`snmpm_user:handle_report/3`](`c:snmpm_user:handle_report/3`).","ref":"snmpm.html#sync_get_bulk2/6"},{"type":"function","title":"snmpm.sync_get_next2/3","doc":"","ref":"snmpm.html#sync_get_next2/3"},{"type":"function","title":"snmpm.sync_get_next2/4","doc":"Synchronous `get-next-request`.\n\n`Remaining` is the remaining time of the given (or default) timeout time.\n\nWhen _Reason_ is _\\{send_failed, ...\\}_ it means that the `net-if` process\nfailed to send the message.\nThis could happen because of any number of reasons, i.e.\nencoding error. _ActualReason_ is the actual reason in this case.\n\nThe send option `extra` specifies an opaque data structure passed on to the\n`net-if` process.\nThe `net-if` process included in this application makes, with one\nexception, no use of this info, so the only use for it (when using the built in\n`net-if`) would be tracing. The one usage exception is: _Any_ tuple with\n`snmpm_extra_info_tag` as its first element is reserved for internal use.\n\nSome of the send options (`community`, `sec_model`, `sec_name`, `sec_level` and\n`max_message_size`) are `override options`. That is, for _this_ request, they\noverride any configuration done when the agent was registered.\n\nFor `SnmpInfo`, see the user callback function\n[handle_report](`c:snmpm_user:handle_report/3`).","ref":"snmpm.html#sync_get_next2/4"},{"type":"function","title":"snmpm.sync_set2/3","doc":"","ref":"snmpm.html#sync_set2/3"},{"type":"function","title":"snmpm.sync_set2/4","doc":"Synchronous `set-request`.\n\n`Remaining` is the remaining time of the given (or default) timeout time.\n\nWhen _Reason_ is _\\{send_failed, ...\\}_ it means that the `net-if` process\nfailed to send the message.\nThis could happen because of any number of reasons, i.e.\nencoding error. _ActualReason_ is the actual reason in this case.\n\nWhen _var_and_val()_ is _\\{oid(), value()\\}_, the manager makes an educated\nguess based on the loaded mibs.\n\nThe send option `extra` specifies an opaque data structure passed on to the\n`net-if` process.\nThe `net-if` process included in this application makes, with one\nexception, no use of this info, so the only use for it (when using the built in\n`net-if`) would be tracing. The one usage exception is: _Any_ tuple with\n`snmpm_extra_info_tag` as its first element is reserved for internal use.\n\nSome of the send options (`community`, `sec_model`, `sec_name`, `sec_level` and\n`max_message_size`) are `override options`. That is, for _this_ request, they\noverride any configuration done when the agent was registered.\n\nFor `SnmpInfo`, see the user callback function\n[`snmpm_user:handle_report/3`](`c:snmpm_user:handle_report/3`).","ref":"snmpm.html#sync_set2/4"},{"type":"function","title":"snmpm.unload_mib/1","doc":"Unload a `Mib` from the manager. The `MibName` is the name of the Mib, including\nthe path to where the compiled mib is found. For example,\n\n```erlang\n          Dir = code:priv_dir(my_app) ++ \"/mibs/\",\n          snmpm:unload_mib(Dir ++ \"MY-MIB\").\n```","ref":"snmpm.html#unload_mib/1"},{"type":"function","title":"snmpm.unregister_agent/2","doc":"Unregister the agent.","ref":"snmpm.html#unregister_agent/2"},{"type":"function","title":"snmpm.unregister_user/1","doc":"Unregister the user.","ref":"snmpm.html#unregister_user/1"},{"type":"function","title":"snmpm.unregister_usm_user/2","doc":"Unregister this USM user.","ref":"snmpm.html#unregister_usm_user/2"},{"type":"function","title":"snmpm.update_agent_info/3","doc":"Update agent config.\n\nThis function, [`update_agent_info/3`](`update_agent_info/3`), should be used when several\nvalues needs to be updated atomically.\n\nSee function `register_agent/3` for more info about what kind of items are allowed.","ref":"snmpm.html#update_agent_info/3"},{"type":"function","title":"snmpm.update_agent_info/4","doc":"Update agent config.\n\nSee function `register_agent/3` for more info about what\nkind of items are allowed.","ref":"snmpm.html#update_agent_info/4"},{"type":"function","title":"snmpm.update_usm_user_info/4","doc":"Update usm user config.","ref":"snmpm.html#update_usm_user_info/4"},{"type":"function","title":"snmpm.usm_user_info/3","doc":"Retrieve usm user config.","ref":"snmpm.html#usm_user_info/3"},{"type":"function","title":"snmpm.verbosity/2","doc":"Sets verbosity for the designated process. For the lowest verbosity `silence`,\nnothing is printed. The higher the verbosity, the more is printed.","ref":"snmpm.html#verbosity/2"},{"type":"function","title":"snmpm.which_agents/0","doc":"","ref":"snmpm.html#which_agents/0"},{"type":"function","title":"snmpm.which_agents/1","doc":"Get a list of all registered agents or all agents registered by a specific user.","ref":"snmpm.html#which_agents/1"},{"type":"function","title":"snmpm.which_mibs/0","doc":"Get a list of all the mib's loaded into the manager.","ref":"snmpm.html#which_mibs/0"},{"type":"function","title":"snmpm.which_users/0","doc":"Get a list of the identities of all registered users.","ref":"snmpm.html#which_users/0"},{"type":"function","title":"snmpm.which_usm_users/0","doc":"Get a list of all registered usm users.","ref":"snmpm.html#which_usm_users/0"},{"type":"function","title":"snmpm.which_usm_users/1","doc":"Get a list of all registered usm users with engine-id `EngineID`.","ref":"snmpm.html#which_usm_users/1"},{"type":"type","title":"snmpm.agent_config/0","doc":"","ref":"snmpm.html#t:agent_config/0"},{"type":"type","title":"snmpm.agent_config_item/0","doc":"Value type depend on the item according to:\n\n- **`engine_id`** - Engine ID of the agent.\n\n  Value type: [engine_id()](`t:snmp:engine_id/0`)\n\n- **`address`** - The IP address of the agent.\n\n  Value type: [ip_address()](`t:inet:ip_address/0`)\n\n- **`port`** - Port number of the agent.\n\n  Value type: [port_number()](`t:inet:port_number/0`)\n\n- **`tdomain`** - Transport domain.\n\n  Value type: [tdomain()](`t:snmp:tdomain/0`)\n\n- **`community`** - Community.\n\n  Value type: [community()](`t:snmp:community/0`)\n\n- **`timeout`** - Registration timeout.\n\n  Value type: `t:register_timeout/0`\n\n- **`max_message_size`** - Max Message Size of a message.\n\n  Value type: [mms()](`t:snmp:mms/0`)\n\n- **`version`** - What SNMP version is used when communicating with this agent.\n\n  Value type: [version()](`t:snmp:version/0`)\n\n- **`sec_model`** - Security Model.\n\n  Value type: [sec_model()](`t:snmp:sec_model/0`)\n\n- **`sec_name`** - Security Name.\n\n  Value type: [sec_name()](`t:snmp:sec_name/0`)\n\n- **`sec_level`** - Security Level.\n\n  Value type: [sec_level()](`t:snmp:sec_level/0`)","ref":"snmpm.html#t:agent_config_item/0"},{"type":"type","title":"snmpm.pdu_type/0","doc":"","ref":"snmpm.html#t:pdu_type/0"},{"type":"type","title":"snmpm.register_timeout/0","doc":"The time to complete a (agent) registration.","ref":"snmpm.html#t:register_timeout/0"},{"type":"opaque","title":"snmpm.request_id/0","doc":"Is a unique term that identifies a request.","ref":"snmpm.html#t:request_id/0"},{"type":"type","title":"snmpm.snmp_reply/0","doc":"","ref":"snmpm.html#t:snmp_reply/0"},{"type":"type","title":"snmpm.snmpm_user/0","doc":"Module implementing the [snmpm_user](`m:snmpm_user#`) behaviour.","ref":"snmpm.html#t:snmpm_user/0"},{"type":"type","title":"snmpm.target_name/0","doc":"Is a unique _non-empty_ string.","ref":"snmpm.html#t:target_name/0"},{"type":"type","title":"snmpm.user_id/0","doc":"Is a unique term that identifies a user.","ref":"snmpm.html#t:user_id/0"},{"type":"type","title":"snmpm.usm_config_item/0","doc":"Value type depend on the item according to:\n\n- **`sec_name`** - Security Name.\n\n  Value type: [`snmp:sec_name()`](`t:snmp:sec_name/0`)\n\n- **`auth`** - Authentication protocol.\n\n  Value type: [`snmp:usm_auth_protocol()`](`t:snmp:usm_auth_protocol/0`)\n\n- **`auth_key`** - Authentication key.\n\n  Value type: [`snmp:usm_auth_key()`](`t:snmp:usm_auth_key/0`)\n\n- **`priv`** - Privacy protocol.\n\n  Value type: [`snmp:usm_priv_protocol()`](`t:snmp:usm_priv_protocol/0`)\n\n- **`priv_key`** - Privacy key.\n\n  Value type: [`snmp:usm_priv_key()`](`t:snmp:usm_priv_key/0`)","ref":"snmpm.html#t:usm_config_item/0"},{"type":"type","title":"snmpm.value_type/0","doc":"- **`o - 'OBJECT IDENTIFIER'`**\n\n- **`i - 'INTEGER'`**\n\n- **`u - 'Unsigned32`**\n\n- **`g - 'Unsigned32'`**\n\n- **`s - 'OCTET STRING'`**\n\n- **`b - 'BITS'`**\n\n- **`ip - 'IpAddress'`**\n\n- **`op - 'Opaque'`**\n\n- **`c32 - 'Counter32'`**\n\n- **`c64 - 'Counter64'`**\n\n- **`tt - 'TimeTicks'`**","ref":"snmpm.html#t:value_type/0"},{"type":"type","title":"snmpm.var_and_val/0","doc":"","ref":"snmpm.html#t:var_and_val/0"},{"type":"module","title":"snmpm_conf","doc":"Utility functions for handling the manager config files.\n\nThe module `snmpm_conf` contains various utility functions to used for\nmanipulating (write/append/read) the config files of the SNMP manager.","ref":"snmpm_conf.html"},{"type":"function","title":"snmpm_conf.agents_entry/12","doc":"Create an entry for the manager agents config file, `agents.conf`.\n\nSee [Agents](snmp_manager_config_files.md#agents) for more info.","ref":"snmpm_conf.html#agents_entry/12"},{"type":"function","title":"snmpm_conf.append_agents_config/2","doc":"Append the agents config to the current manager agents config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Agents](snmp_manager_config_files.md#agents) for more info.","ref":"snmpm_conf.html#append_agents_config/2"},{"type":"function","title":"snmpm_conf.append_manager_config/2","doc":"Append the config to the current manager config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Manager Information](snmp_manager_config_files.md#manager-information) for\nmore info.","ref":"snmpm_conf.html#append_manager_config/2"},{"type":"function","title":"snmpm_conf.append_users_config/2","doc":"Append the users config to the current manager users config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Users](snmp_manager_config_files.md#users) for more info.","ref":"snmpm_conf.html#append_users_config/2"},{"type":"function","title":"snmpm_conf.append_usm_config/2","doc":"Append the usm config to the current manager usm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Security data for USM](snmp_manager_config_files.md#security-data-for-usm) for more info.","ref":"snmpm_conf.html#append_usm_config/2"},{"type":"function","title":"snmpm_conf.manager_entry/2","doc":"Create an entry for the manager config file, `manager.conf`.\n\nThe type of `Val` depends on the value of `Tag`, see\n[Manager Information](snmp_manager_config_files.md#manager-information) for more\ninfo.","ref":"snmpm_conf.html#manager_entry/2"},{"type":"function","title":"snmpm_conf.read_agents_config/1","doc":"Read the current manager agents config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Agents](snmp_manager_config_files.md#agents) for more info.","ref":"snmpm_conf.html#read_agents_config/1"},{"type":"function","title":"snmpm_conf.read_manager_config/1","doc":"Read the current manager config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Manager Information](snmp_manager_config_files.md#manager-information) for\nmore info.","ref":"snmpm_conf.html#read_manager_config/1"},{"type":"function","title":"snmpm_conf.read_users_config/1","doc":"Read the current manager users config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Users](snmp_manager_config_files.md#users) for more info.","ref":"snmpm_conf.html#read_users_config/1"},{"type":"function","title":"snmpm_conf.read_usm_config/1","doc":"Read the current manager usm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\nSee [Security data for USM](snmp_manager_config_files.md#security-data-for-usm) for more info.","ref":"snmpm_conf.html#read_usm_config/1"},{"type":"function","title":"snmpm_conf.users_entry/1","doc":"","ref":"snmpm_conf.html#users_entry/1"},{"type":"function","title":"snmpm_conf.users_entry/2","doc":"","ref":"snmpm_conf.html#users_entry/2"},{"type":"function","title":"snmpm_conf.users_entry/3","doc":"","ref":"snmpm_conf.html#users_entry/3"},{"type":"function","title":"snmpm_conf.users_entry/4","doc":"Create an entry for the manager users config file, `users.conf`.\n\nSee the [`Users`](snmp_manager_config_files.md#users) chapter of the\n(SNMP) `Manager Configuration` User Guide for more info.","ref":"snmpm_conf.html#users_entry/4"},{"type":"function","title":"snmpm_conf.usm_entry/6","doc":"","ref":"snmpm_conf.html#usm_entry/6"},{"type":"function","title":"snmpm_conf.usm_entry/7","doc":"Create an entry for the agent community config file, `community.conf`.\n\nSee\n[`Security data for USM`](snmp_manager_config_files.md#security-data-for-usm)\nfor more info.","ref":"snmpm_conf.html#usm_entry/7"},{"type":"function","title":"snmpm_conf.write_agents_config/2","doc":"","ref":"snmpm_conf.html#write_agents_config/2"},{"type":"function","title":"snmpm_conf.write_agents_config/3","doc":"Write the manager agents config to the manager agents config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Agents](snmp_manager_config_files.md#agents) for more info.","ref":"snmpm_conf.html#write_agents_config/3"},{"type":"function","title":"snmpm_conf.write_manager_config/2","doc":"","ref":"snmpm_conf.html#write_manager_config/2"},{"type":"function","title":"snmpm_conf.write_manager_config/3","doc":"Write the manager config to the manager config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Manager Information](snmp_manager_config_files.md#manager-information) for\nmore info.","ref":"snmpm_conf.html#write_manager_config/3"},{"type":"function","title":"snmpm_conf.write_users_config/2","doc":"","ref":"snmpm_conf.html#write_users_config/2"},{"type":"function","title":"snmpm_conf.write_users_config/3","doc":"Write the manager users config to the manager users config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Users](snmp_manager_config_files.md#users) for more info.","ref":"snmpm_conf.html#write_users_config/3"},{"type":"function","title":"snmpm_conf.write_usm_config/2","doc":"","ref":"snmpm_conf.html#write_usm_config/2"},{"type":"function","title":"snmpm_conf.write_usm_config/3","doc":"Write the manager usm config to the manager usm config file.\n\n`Dir` is the path to the directory where to store the config file.\n\n`Hdr` is an optional file header (note that this text is written to the file as\nis).\n\nSee [Security data for USM](snmp_manager_config_files.md#security-data-for-usm) for more info.","ref":"snmpm_conf.html#write_usm_config/3"},{"type":"opaque","title":"snmpm_conf.agent_entry/0","doc":"An opaque data structure containg all configuration for one agent for the\nmanager.","ref":"snmpm_conf.html#t:agent_entry/0"},{"type":"opaque","title":"snmpm_conf.manager_entry/0","doc":"An opaque data structure that represents one configuration entry for the\nmanager.","ref":"snmpm_conf.html#t:manager_entry/0"},{"type":"opaque","title":"snmpm_conf.user_entry/0","doc":"An opaque data structure containg all configuration for one user for the\nmanager.","ref":"snmpm_conf.html#t:user_entry/0"},{"type":"opaque","title":"snmpm_conf.usm_entry/0","doc":"An opaque data structure containg information about security data for usm for\nthe manager.","ref":"snmpm_conf.html#t:usm_entry/0"},{"type":"module","title":"snmpm_mpd","doc":"Message Processing and Dispatch module for the SNMP manager\n\nThe module `snmpm_mpd` implements the version independent Message Processing and\nDispatch functionality in SNMP for the manager. It is supposed to be used from a\nNetwork Interface process\n([Definition of Manager Net if](snmp_manager_netif.md)).\n\nLegacy API function `process_msg/7` that has got separate `IpAddr` and\n`PortNumber` arguments still works as before for backwards compatibility\nreasons.","ref":"snmpm_mpd.html"},{"type":"function","title":"snmpm_mpd.generate_msg/5","doc":"Generates a possibly encrypted packet to be sent to the network.\n\n`NoteStore` is the [`pid()`](`t:pid/0`) of the `note-store` process.\n\n`MsgData` is the message specific data used in the SNMP message. In SNMPv1 and\nSNMPv2c, this message data is the community string. In SNMPv3, it is the context\ninformation.\n\n`Logger` is the function used for audit trail logging.","ref":"snmpm_mpd.html#generate_msg/5"},{"type":"function","title":"snmpm_mpd.generate_response_msg/4","doc":"Generates a possibly encrypted response packet to be sent to the network.\n\n`MsgData` is the message specific data used in the SNMP message. This value is\nreceived from the [`process_msg/6`](`snmpm_mpd:process_msg/6`) function.","ref":"snmpm_mpd.html#generate_response_msg/4"},{"type":"function","title":"snmpm_mpd.init/1","doc":"This function can be called from the `net-if` process at start-up.\nThe options list defines which versions to use.\n\nIt also initializes some SNMP counters.","ref":"snmpm_mpd.html#init/1"},{"type":"function","title":"snmpm_mpd.process_msg/6","doc":"Processes an incoming message. Performs authentication and decryption as\nnecessary. The return values should be passed the manager server.\n\n`NoteStore` is the [`pid()`](`t:pid/0`) of the `note-store` process.\n\n`Logger` is the function used for audit trail logging.\n\nIn the case when the pdu type is `report`, `MsgData` is either `ok` or\n`{error, ReqId, Reason}`.","ref":"snmpm_mpd.html#process_msg/6"},{"type":"type","title":"snmpm_mpd.logger/0","doc":"A `fun` that handles audit trail logging.","ref":"snmpm_mpd.html#t:logger/0"},{"type":"opaque","title":"snmpm_mpd.mpd_state/0","doc":"","ref":"snmpm_mpd.html#t:mpd_state/0"},{"type":"opaque","title":"snmpm_mpd.msg_data_acm/0","doc":"Is an opaque data structure containing necessary security information for\n(incoming) v3 messages.","ref":"snmpm_mpd.html#t:msg_data_acm/0"},{"type":"opaque","title":"snmpm_mpd.msg_data_cmy/0","doc":"Is an opaque data structure containing necessary security information for v1 and\nv2 messages.","ref":"snmpm_mpd.html#t:msg_data_cmy/0"},{"type":"opaque","title":"snmpm_mpd.msg_data_cmyt/0","doc":"Is an opaque data structure containing necessary security and transport\ninformation for v1 and v2 messages.","ref":"snmpm_mpd.html#t:msg_data_cmyt/0"},{"type":"opaque","title":"snmpm_mpd.msg_data_v3/0","doc":"Is an opaque data structure containing necessary security information for v3\nmessages.","ref":"snmpm_mpd.html#t:msg_data_v3/0"},{"type":"behaviour","title":"snmpm_network_interface","doc":"Behaviour module for the SNMP manager network interface.\n\nThis module defines the behaviour of the manager network interface. A\n`snmpm_network_interface` compliant module must export the following functions:\n\n- `c:start_link/2`\n- `c:stop/1`\n- `c:send_pdu/7`\n- `c:inform_response/4`\n- `c:note_store/2`\n- `c:info/1`\n- `c:get_log_type/1`\n- `c:set_log_type/2`\n- `c:verbosity/2`\n\nThe semantics of them and their exact signatures are explained below.\n\nLegacy API function `c:send_pdu/7` that has got separate\n`IpAddr` and `PortNumber` arguments still works as before for backwards\ncompatibility reasons.","ref":"snmpm_network_interface.html"},{"type":"callback","title":"snmpm_network_interface.get_log_type/1","doc":"The Audit Trail Log is managed by the network interface process. So, it is this\nprocess that has to return the actual log-type.","ref":"snmpm_network_interface.html#c:get_log_type/1"},{"type":"callback","title":"snmpm_network_interface.info/1","doc":"The info returned is basically up to the implementer to decide. The\nimplementation provided by this application provides info about memory\nallocation and various socket information.\n\nThe info returned by this function is returned together with other info\ncollected by the manager when the [`snmpm:info()`](`snmpm:info/0`)\nfunction is called (tagged with the key `net_if`).","ref":"snmpm_network_interface.html#c:info/1"},{"type":"callback","title":"snmpm_network_interface.inform_response/4","doc":"Instruct the network interface process to send the response (acknowledgment) to\nan inform-request.\n\n`Ref` is something that can be used to identify the inform-request, e.g.\nrequest-id of the inform-request.\n\n`Addr` and `Port` identifies the agent, from which the inform-request\noriginated.","ref":"snmpm_network_interface.html#c:inform_response/4"},{"type":"callback","title":"snmpm_network_interface.note_store/2","doc":"Change the pid of the note-store process. This is used when the server restarts\nthe `note-store` (e.g. after a crach).","ref":"snmpm_network_interface.html#c:note_store/2"},{"type":"callback","title":"snmpm_network_interface.send_pdu/7","doc":"Request the network interface process (`Pid`) to send this pdu (`Pdu`).\n\n`ExtraInfo` is some opaque data that is passed to the `net-if` process. It\noriginates from the `ExtraInfo` parameter in the calls to the\n[`synchronous get-request`](`snmpm:sync_get2/4`),\n[`asynchronous get-request`](`snmpm:async_get2/4`),\n[`synchronous get-next-request`](`snmpm:sync_get_next2/4`),\n[`asynchronous get-next-request`](`snmpm:async_get_next2/4`),\n[`synchronous set-request`](`snmpm:sync_set2/4`) and\n[`asynchronous set-request`](`snmpm:async_set2/4`) functions.\nWhether the `net-if` process chooses to use this is implementation dependent.\nThe `net-if` process included in this application ignores it.","ref":"snmpm_network_interface.html#c:send_pdu/7"},{"type":"callback","title":"snmpm_network_interface.set_log_type/2","doc":"The Audit Trail Log is managed by the network interface process. So, it is this\nprocess that has to do the actual changing of the type.\n\nSee `snmpm:set_log_type/1` for more info.","ref":"snmpm_network_interface.html#c:set_log_type/2"},{"type":"callback","title":"snmpm_network_interface.start_link/2","doc":"Start-link the network interface process.\n\n`Server` is the pid of the managing process.\n\n`NoteStore` is the pid of the `note-store` process.","ref":"snmpm_network_interface.html#c:start_link/2"},{"type":"callback","title":"snmpm_network_interface.stop/1","doc":"Stop the network interface process.","ref":"snmpm_network_interface.html#c:stop/1"},{"type":"callback","title":"snmpm_network_interface.verbosity/2","doc":"Change the verbosity of the network interface process.","ref":"snmpm_network_interface.html#c:verbosity/2"},{"type":"behaviour","title":"snmpm_network_interface_filter","doc":"Behaviour module for the SNMP manager network-interface filter.\n\nThis module defines the behaviour of the manager network interface filter. A\n`snmpm_network_interface_filter` compliant module must export the following\nfunctions:\n\n- [`accept_recv/2`](`c:accept_recv/2`)\n- [`accept_send/2`](`c:accept_send/2`)\n- [`accept_recv_pdu/3`](`c:accept_recv_pdu/3`)\n- [`accept_send_pdu/3`](`c:accept_send_pdu/3`)\n\nThe semantics of them and their exact signatures are explained below.\n\nThe purpose of the network interface filter is to allow for filtering of\nmessages (accept or reject) receive and send. This is done on two levels:\n\n- The first level is at the UDP entry / exit point, i.e. immediately after the\n  receipt of the message, before any message processing is done (accept_recv)\n  and immediately before sending the message, after all message processing is\n  done (accept_send).\n- The second level is at the MPD entry / exit point, i.e. immediately after the\n  basic message processing (accept_recv_pdu) / immediately before the basic\n  message processing (accept_send_pdu).\n\nNote that the network interface filter is something which is used by the network\ninterface implementation provided by the application (`snmpm_net_if` and\n`snmpm_net_if_mt`). The default filter accepts all messages.\n\nA network interface filter can e.g. be used during testing or for load\nregulation.\n\nLegacy network interface filter modules used arguments on the form\n`(IpAddr, PortNumber,...)` instead of `(Domain, Addr, ...)`, and if the SNMP\nmanager is run without changing the configuration to use transport domains the\nnetwork interface filter will still get the old arguments and work as before.","ref":"snmpm_network_interface_filter.html"},{"type":"callback","title":"snmpm_network_interface_filter.accept_recv/2","doc":"Called at the reception of a message (before _any_ processing has been done).\n\nFor the message to be rejected, the function _must_ return _false_.","ref":"snmpm_network_interface_filter.html#c:accept_recv/2"},{"type":"callback","title":"snmpm_network_interface_filter.accept_recv_pdu/3","doc":"Called after the basic message processing (MPD) has been done, but before the\npdu is handed over to the server for primary processing.\n\nFor the pdu to be rejected, the function _must_ return _false_.","ref":"snmpm_network_interface_filter.html#c:accept_recv_pdu/3"},{"type":"callback","title":"snmpm_network_interface_filter.accept_send/2","doc":"Called before the sending of a message (after _all_ processing has been done).\n\nFor the message to be rejected, the function _must_ return _false_.","ref":"snmpm_network_interface_filter.html#c:accept_send/2"},{"type":"callback","title":"snmpm_network_interface_filter.accept_send_pdu/3","doc":"Called before the basic message processing (MPD) is done, when a pdu has been\nreceived from the master-agent.\n\nFor the message to be rejected, the function _must_ return _false_.","ref":"snmpm_network_interface_filter.html#c:accept_send_pdu/3"},{"type":"type","title":"snmpm_network_interface_filter.pdu_type/0","doc":"","ref":"snmpm_network_interface_filter.html#t:pdu_type/0"},{"type":"type","title":"snmpm_network_interface_filter.transportAddressWithPort/0","doc":"","ref":"snmpm_network_interface_filter.html#t:transportAddressWithPort/0"},{"type":"type","title":"snmpm_network_interface_filter.transportDomain/0","doc":"","ref":"snmpm_network_interface_filter.html#t:transportDomain/0"},{"type":"behaviour","title":"snmpm_user","doc":"Behaviour module for the SNMP manager user.\n\nThis module defines the behaviour of the manager user. A `snmpm_user` compliant\nmodule must export the following functions:\n\n- `c:handle_error/3`\n- `c:handle_agent/5`\n- `c:handle_pdu/4`\n- `c:handle_trap/3`\n- `c:handle_inform/3`\n- `c:handle_report/3`\n- `c:handle_invalid_result/2`\n\nThe semantics of them and their exact signatures are explained below.\n\nSome of the function has no defined return value (`void()`), they can of course\nreturn anything. But the functions that do have specified return value(s) _must_\nadhere to this. None of the functions can use exit of throw to return.\n\nIf the manager is not configured to use any particular transport domain, the\nbehaviour `handle_agent/5` will for backwards copmpatibility reasons be called\nwith the old `IpAddr` and `PortNumber` arguments","ref":"snmpm_user.html"},{"type":"callback","title":"snmpm_user.handle_agent/5","doc":"This function is called when a message is received from an unknown agent.\n\nNote that this will always be the default user that is called.\n\nFor more info about the `agent_config()`, see `snmpm:register_agent/3`.\n\nThe arguments `Type` and `SnmpInfo` relates in the following way:\n\n- `pdu` \\- `SnmpPduInfo` (see `c:handle_pdu/4` for more\n  info).\n- `trap` \\- `SnmpTrapInfo` (see `c:handle_trap/3` for\n  more info).\n- `report` \\- `SnmpReportInfo` (see `c:handle_report/3` for more info).\n- `inform` \\- `SnmpInformInfo` (see `c:handle_inform/3` for more info).\n\nThe only user which would return `{register, UserId, TargetName, AgentConfig}`\nis the _default user_.","ref":"snmpm_user.html#c:handle_agent/5"},{"type":"callback","title":"snmpm_user.handle_error/3","doc":"This function is called when the manager needs to communicate an \"asynchronous\"\nerror to the user: e.g. failure to send an asynchronous message (i.e. encoding\nerror), a received message was discarded due to security error, the manager\nfailed to generate a response message to a received inform-request, or when\nreceiving an unexpected PDU from an agent (could be an expired async request).\n\nIf `ReqId` is less then 0, it means that this information was not available to\nthe manager (that info was never retrieved before the message was discarded).\n\nFor `SnmpInfo` see handle_agent below.\n\nNote that there is a special case when the value of `ReqId` has the value of the\natom `netif`. This means that the NetIF process has suffered a \"fatal\" error and\nbeen restarted. With possible loss of traffic\\!","ref":"snmpm_user.html#c:handle_error/3"},{"type":"callback","title":"snmpm_user.handle_inform/3","doc":"Handle a inform message.\n\nFor more info about the `agent_config()`, see `snmpm:register_agent/3`.\n\nThe only user which would return `{register, UserId, TargetName2, AgentConfig}`\nis the _default user_.\n\nIf the [inform request behaviour](snmp_config.md#manager_irb) configuration\noption is set to `user` or `{user, integer()}`, the response (acknowledgment) to\nthis inform-request will be sent when this function returns.","ref":"snmpm_user.html#c:handle_inform/3"},{"type":"callback","title":"snmpm_user.handle_invalid_result/2","doc":"If _any_ of the _other_ callback functions crashes (exit, throw or a plain\ncrash) or return an invalid result (if a valid return has been specified), this\nfunction is called. The purpose is to allow the user handle this error (for\ninstance to issue an error report).\n\n`IN` reprecents the function called (and its arguments). `OUT` represents the\nunexpected/invalid result.","ref":"snmpm_user.html#c:handle_invalid_result/2"},{"type":"callback","title":"snmpm_user.handle_pdu/4","doc":"Handle the reply to an asynchronous request, such as\n[async_get](`snmpm:async_get2/4`), [async_get_next](`snmpm:async_get_next2/4`)\nor [async_set](`snmpm:async_set2/4`).\n\nIt could also be a late reply to a synchronous request.\n\n`ReqId` is returned by the asynchronous request function.","ref":"snmpm_user.html#c:handle_pdu/4"},{"type":"callback","title":"snmpm_user.handle_report/3","doc":"Handle a report message.\n\nFor more info about the `agent_config()`, see `snmpm:register_agent/3`.\n\nThe only user which would return `{register, UserId, TargetName2, AgentConfig}`\nis the _default user_.","ref":"snmpm_user.html#c:handle_report/3"},{"type":"callback","title":"snmpm_user.handle_trap/3","doc":"Handle a trap/notification message from an agent.\n\nFor more info about the `agent_config()`, see `snmpm:register_agent/3`.\n\nThe only user which would return `{register, UserId, TargetName2, agent_info()}`\nis the _default user_.","ref":"snmpm_user.html#c:handle_trap/3"},{"type":"type","title":"snmpm_user.ip_address/0","doc":"","ref":"snmpm_user.html#t:ip_address/0"},{"type":"type","title":"snmpm_user.port_number/0","doc":"","ref":"snmpm_user.html#t:port_number/0"},{"type":"type","title":"snmpm_user.snmp_gen_info/0","doc":"General error information (does not _have_ to indicate an error)..","ref":"snmpm_user.html#t:snmp_gen_info/0"},{"type":"type","title":"snmpm_user.snmp_v1_trap_info/0","doc":"Trap related information.","ref":"snmpm_user.html#t:snmp_v1_trap_info/0"},{"type":"extras","title":"SNMP Application","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SNMP Application","ref":"snmp_app.html"},{"type":"extras","title":"Description - SNMP Application","doc":"This chapter describes the `snmp` application in OTP. The SNMP application\nprovides the following services:\n\n- a multilingual extensible SNMP agent\n- a SNMP manager\n- a MIB compiler","ref":"snmp_app.html#description"},{"type":"extras","title":"Configuration - SNMP Application","doc":"The following configuration parameters are defined for the SNMP application.\nRefer to application(3) for more information about configuration parameters.\n\nThe snmp part of the config file specifying the configuration parameters is\nbasically the following tuple:\n\n```text\n      {snmp, snmp_components_config()}\n```\n\nA minimal config file for starting a node with both a manager and an agent:\n\n```erlang\n      [{snmp,\n        [{agent, [{db_dir, \"/tmp/snmp/agent/db\"},\n                  {config, [{dir, \"/tmp/snmp/agent/conf\"}]}]},\n         {manager, [{config, [{dir, \"/tmp/snmp/manager/conf\"},\n                              {db_dir, \"/tmp/snmp/manager/db\"}]}]}]}\n        ]\n       }\n      ].\n```\n\nEach snmp component has its own set of configuration parameters, even though\nsome of the types are common to both components.\n\n```erlang\n      snmp_components_config() -> [snmp_component_config()]\n      snmp_component_config() -> {agent, agent_options()} | {manager, manager_options()}\n      agent_options() = [agent_option()]\n      agent_option() = {restart_type,     restart_type()}     |\n                       {agent_type,       agent_type()}       |\n                       {agent_verbosity,  verbosity()}        |\n                       {discovery,        agent_discovery()}  |\n                       {versions,         versions()}         |\n                       {gb_max_vbs,       gb_max_vbs()}       |\n                       {priority,         priority()}         |\n                       {multi_threaded,   multi_threaded()}   |\n                       {db_dir,           db_dir()}           |\n                       {db_init_error,    db_init_error()}    |\n                       {local_db,         local_db()}         |\n                       {net_if,           agent_net_if()}     |\n                       {mibs,             mibs()}             |\n                       {mib_storage,      mib_storage()}      |\n                       {mib_server,       mib_server()}       |\n                       {audit_trail_log,  audit_trail_log()}  |\n                       {error_report_mod, error_report_mod()} |\n                       {note_store,       note_store()}       |\n                       {symbolic_store,   symbolic_store()}   |\n                       {target_cache,     target_cache()}     |\n                       {config,           agent_config()}\n      manager_options() = [manager_option()]\n      manager_option() = {restart_type,             restart_type()}    |\n                         {net_if,                   manager_net_if()}  |\n                         {server,                   server()}          |\n                         {note_store,               note_store()}      |\n                         {config,                   manager_config()}  |\n                         {inform_request_behaviour, manager_irb()}     |\n                         {mibs,                     manager_mibs()}    |\n                         {priority,                 priority()}        |\n                         {audit_trail_log,          audit_trail_log()} |\n                         {versions,                 versions()}        |\n                         {def_user_mod,             def_user_module()  |\n                         {def_user_data,            def_user_data()}\n```\n\n[](){: #agent_opts_and_types }\n\nAgent specific config options and types:\n\n- **`agent_type() = master | sub  `{: #agent_type }** - If `master`,\n  one master agent is started. Otherwise, no agents are started.\n\n  Default is `master`.\n\n- **`agent_discovery() = [agent_discovery_opt()]  `{: #agent_disco }** -\n  `agent_discovery_opt() = {terminating, agent_terminating_discovery_opts()} | {originating, agent_originating_discovery_opts()}`\n\n  The `terminating` options effects discovery initiated by a manager.\n\n  The `originating` options effects discovery initiated by this agent.\n\n  For defaults see the options in `agent_discovery_opt()`.\n\n- **`agent_terminating_discovery_opts() = [agent_terminating_discovery_opt()]  `{:  #agent_term_disco_opts }** -\n  `agent_terminating_discovery_opt() = {enable, boolean()} | {stage2, discovery | plain} | {trigger_username, string()}`\n\n  These are options effecting discovery `terminating` in this agent (i.e.\n  initiated by a manager).\n\n  The default values for the `terminating` discovery options are:\n\n  - enable: `true`\n  - stage2: `discovery`\n  - trigger_username: `\"\"`\n\n- **`agent_originating_discovery_opts() = [agent_originating_discovery_opt()]  `{:  #agent_orig_disco_opts }** -\n  `agent_originating_discovery_opt() = {enable, boolean()}`\n\n  These are options effecting discovery `originating` in this agent.\n\n  The default values for the `originating` discovery options are:\n\n  - enable: `true`\n\n- **`multi_threaded() = bool() | extended  `{: #agent_mt }** - If\n  `true` (or `extended`), the agent is multi-threaded, with one thread for each\n  get request.\n\n  The value `extended` means that a special 'process' is also created intended\n  to handle _all_ notifications.\n\n  - `true` \\- One worker dedicated to 'set-requests' and one (main) worker for\n    all other requests ('get-request' and notifications).\n\n    If the 'main' worker is busy, a temporary process is spawned to handle that\n    job ('get-request' or notification).\n\n  - `extended` \\- One worker dedicated to 'set-requests', one worker dedicated\n    to notifications and one (main) worker for all 'get-requests'.\n\n    If the 'main' worker is busy, a temporary process is spawned to handle that\n    'get-request'.\n\n  > #### Note {: .info }\n  >\n  > Even with multi-threaded set to `extended` there is still a risk for\n  > 'reorder' when sending inform-requsts, which require a response (and may\n  > therefore require resending).\n  >\n  > Also, there is of course no way to guarantee order once the package is on\n  > the network.\n\n  Default is `false`.\n\n- **`db_dir() = string()  `{: #agent_data_dir }** - Defines where the\n  SNMP agent internal db files are stored.\n\n- **`gb_max_vbs() = pos_integer() | infinity  `{: #agent_gb_max_vbs }** - Defines the maximum number of varbinds allowed in a Get-BULK response.\n\n  Default is `1000`.\n\n- **`local_db() = [local_db_opt()]  `{: #agent_local_db }** -\n  `local_db_opt() = {repair, agent_repair()} | {auto_save, agent_auto_save()} | {verbosity, verbosity()}`\n\n  Defines options specific for the SNMP agent local database.\n\n  For defaults see the options in `local_db_opt()`.\n\n- **`agent_repair() = false | true | force  `{: #agent_ldb_repair }** -\n  When starting snmpa_local_db it always tries to open an existing database. If\n  `false`, and some errors occur, a new database is created instead. If `true`,\n  an existing file will be repaired. If `force`, the table will be repaired even\n  if it was properly closed.\n\n  Default is `true`.\n\n- **`agent_auto_save() = integer() | infinity  `{: #agent_ldb_auto_save }** - The auto save interval. The table is flushed to disk whenever not\n  accessed for this amount of time.\n\n  Default is `5000`.\n\n- **`agent_net_if() = [agent_net_if_opt()]  `{: #agent_net_if }** -\n  `agent_net_if_opt() = {module, agent_net_if_module()} | {verbosity, verbosity()} | {options, agent_net_if_options()}`\n\n  Defines options specific for the SNMP agent network interface entity.\n\n  For defaults see the options in `agent_net_if_opt()`.\n\n- **`agent_net_if_module() = atom()  `{: #agent_ni_module }** - Module\n  which handles the network interface part for the SNMP agent. Must implement\n  the `m:snmpa_network_interface` behaviour.\n\n  Default is `snmpa_net_if`.\n\n- **`agent_net_if_options() = [agent_net_if_option()]  `{:  #agent_ni_opts }** -\n  `agent_net_if_option() = {bind_to, bind_to()} | {sndbuf, sndbuf()} | {recbuf, recbuf()} | {no_reuse, no_reuse()} | {req_limit, req_limit()} | {filter, agent_net_if_filter_options()} | {open_err_filters, agent_net_if_open_err_filters()} | {extra_sock_opts, extra_socket_options()} | {inet_backend, inet_backend()}`\n\n  These options are actually specific to the used module. The ones shown here\n  are applicable to the default `agent_net_if_module()`.\n\n  > #### Note {: .info }\n  >\n  > If the user has configured transports _with_ options then those will take\n  > precedence over these options. See\n  > [agent information](snmp_agent_config_files.md#agent_information) for more\n  > info.\n\n  For defaults see the options in `agent_net_if_option()`.\n\n- **`req_limit() = integer() | infinity  `{: #agent_ni_req_limit }** -\n  Max number of simultaneous requests handled by the agent.\n\n  Default is `infinity`.\n\n- **`agent_net_if_filter_options() = [agent_net_if_filter_option()]  `{:  #agent_ni_filter_opts }** -\n  `agent_net_if_filter_option() = {module, agent_net_if_filter_module()}`\n\n  These options are actually specific to the used module. The ones shown here\n  are applicable to the default `agent_net_if_filter_module()`.\n\n  For defaults see the options in `agent_net_if_filter_option()`.\n\n- **`agent_net_if_filter_module() = atom()  `{: #agent_ni_filter_module }** - Module which handles the network interface filter part for the SNMP\n  agent. Must implement the `m:snmpa_network_interface_filter` behaviour.\n\n  Default is `snmpa_net_if_filter`.\n\n- **`agent_net_if_open_err_filters() = [agent_net_if_open_err_filter()]  `{:  #agent_ni_open_err_filters }** - `agent_net_if_open_err_filter() = atom()`\n\n  During agent initiation, the transports UDP sockets are opened. If this\n  operation fails, the net-if (and the agent) fails to start (crash). This\n  (filter) list contains error (reasons) that will make net-if fail \"nicely\".\n  This (filter) list, is supposed to contain errors that can be returned by\n  [gen_udp:open/1,2](`gen_udp:open/1`). The effect is that any error returned by\n  [gen_udp:open](`gen_udp:open/1`) which _are_ in this list, will be considered\n  \"non-fatal\" and will only result in an info message, rather than an error\n  message. Net If, and the agent, will still crash, but will produce a less\n  obnoxious message.\n\n- **`agent_mibs() = [string()]  `{: #agent_mibs }** - Specifies a list\n  of MIBs (including path) that defines which MIBs are initially loaded into the\n  SNMP master agent.\n\n  Note that the following mibs will always be loaded:\n\n  - version v1: `STANDARD-MIB`\n  - version v2: `SNMPv2`\n  - version v3: `SNMPv2`, `SNMP-FRAMEWORK-MIB` and `SNMP-MPD-MIB`\n\n  Default is `[]`.\n\n- **`mib_storage() = [mib_storage_opt()]  `{: #agent_mib_storage }** -\n  `mib_storage_opt() = {module, mib_storage_module()} | {options, mib_storage_options()}`\n\n  This option specifies how basic mib data is stored. This option is used by two\n  parts of the snmp agent: The mib-server and the symbolic-store.\n\n  Default is `[{module, snmpa_mib_storage_ets}]`.\n\n- **`mib_storage_module() = snmpa_mib_data_ets | snmpa_mib_data_dets | snmpa_mib_data_mnesia | module()`{:  #agent_mst_module }** - Defines the mib storage module of the SNMP agent as\n  defined by the `m:snmpa_mib_storage` behaviour.\n\n  Several entities (`mib-server` via the its data module and the\n  `symbolic-store`) of the snmp agent uses this for storage of miscellaneous mib\n  related data retrieved while loading a mib.\n\n  There are several implementations provided with the agent:\n  `snmpa_mib_storage_ets`, `snmpa_mib_storage_dets` and\n  `snmpa_mib_storage_mnesia`.\n\n  Default module is `snmpa_mib_storage_ets`.\n\n- **`mib_storage_options() = list()  `{: #agent_mst_options }** - This\n  is implementation depended. That is, it depends on the module. For each module\n  a specific set of options are valid. For the module provided with the app,\n  these options are supported:\n\n  - `snmpa_mib_storage_ets`:\n    `{dir, filename()} | {action, keep | clear}, {checksum, boolean()}`\n\n    - `dir` \\- If present, points to a directory where a file to which all data\n      in the ets table is \"synced\".\n\n      Also, when a table is opened this file is read, if it exists.\n\n      By default, this will _not_ be used.\n\n    - `action` \\- Specifies the behaviour when a non-empty file is found: Keep\n      its content or clear it out.\n\n      Default is `keep`.\n\n    - `checksum` \\- Defines if the file is checksummed or not.\n\n      Default is `false`.\n\n  - `snmpa_mib_storage_dets`:\n    `{dir, filename()} | {action, keep | clear}, {auto_save, default | pos_integer()} | {repair, force | boolean()}`\n\n    - `dir` \\- This _mandatory_ option points to a directory where to place the\n      file of a dets table.\n    - `action` \\- Specifies the behaviour when a non-empty file is found: Keep\n      its content or clear it out.\n\n      Default is `keep`.\n\n    - `auto_save` \\- Defines the dets auto-save frequency.\n\n      Default is `default`.\n\n    - `repair` \\- Defines the dets repair behaviour.\n\n      Default is `false`.\n\n  - `snmpa_mib_storage_mnesia`: `{action, keep | clear}, {nodes, [node()]}`\n\n    - `action` \\- Specifies the behaviour when a non-empty, already existing,\n      table: Keep its content or clear it out.\n\n      Default is `keep`.\n\n    - `nodes` \\- A list of node names (or an atom describing a list of nodes)\n      defining where to open the table. Its up to the user to ensure that mnesia\n      is actually running on the specified nodes.\n\n      The following distinct values are recognised:\n\n      - `[]` \\- Translated into a list of the own node: `[node()]`\n      - `all` \\- `erlang:nodes()`\n      - `visible` \\- `erlang:nodes(visible)`\n      - `connected` \\- `erlang:nodes(connected)`\n      - `db_nodes` \\- `mnesia:system_info(db_nodes)`\n\n      Default is the result of the call: `erlang:nodes()`.\n\n- **`mib_server() = [mib_server_opt()]  `{: #agent_mib_server }** -\n  `mib_server_opt() = {mibentry_override, mibentry_override()} | {trapentry_override, trapentry_override()} | {verbosity, verbosity()} | {cache, mibs_cache()} | {data_module, mib_server_data_module()}`\n\n  Defines options specific for the SNMP agent mib server.\n\n  For defaults see the options in `mib_server_opt()`.\n\n- **`mibentry_override() = bool()  `{: #agent_ms_meo }** - If this\n  value is false, then when loading a mib each mib- entry is checked prior to\n  installation of the mib. The purpose of the check is to prevent that the same\n  symbolic mibentry name is used for different oid's.\n\n  Default is `false`.\n\n- **`trapentry_override() = bool()  `{: #agent_ms_teo }** - If this\n  value is false, then when loading a mib each trap is checked prior to\n  installation of the mib. The purpose of the check is to prevent that the same\n  symbolic trap name is used for different trap's.\n\n  Default is `false`.\n\n- **`mib_server_data_module() = snmpa_mib_data_tttn | module()  `{:  #agent_ms_data_module }** - Defines the backend data module of the SNMP agent\n  mib-server as defined by the `m:snmpa_mib_data` behaviour.\n\n  At present only the default module is provided with the agent,\n  `snmpa_mib_data_tttn`.\n\n  Default module is `snmpa_mib_data_tttn`.\n\n- **`mibs_cache() = bool() | mibs_cache_opts()  `{: #agent_ms_cache }** - Shall the agent utilize the mib server lookup cache or not.\n\n  Default is `true` (in which case the `mibs_cache_opts()` default values\n  apply).\n\n- **`mibs_cache_opts() = [mibs_cache_opt()]  `{: #agent_ms_cache_opts }** -\n  `mibs_cache_opt() = {autogc, mibs_cache_autogc()} | {gclimit, mibs_cache_gclimit()} | {age, mibs_cache_age()}`\n\n  Defines options specific for the SNMP agent mib server cache.\n\n  For defaults see the options in `mibs_cache_opt()`.\n\n- **`mibs_cache_autogc() = bool()  `{: #agent_ms_cache_autogc }** -\n  Defines if the mib server shall perform cache gc automatically or leave it to\n  the user (see [gc_mibs_cache/0,1,2,3](`snmpa:gc_mibs_cache/0`)).\n\n  Default is `true`.\n\n- **`mibs_cache_age() = integer() > 0  `{: #agent_ms_cache_age }** -\n  Defines how old the entries in the cache will be allowed to become before they\n  are GC'ed (assuming GC is performed). Each entry in the cache is \"touched\"\n  whenever it is accessed.\n\n  The age is defined in milliseconds.\n\n  Default is `10 timutes`.\n\n- **`mibs_cache_gclimit() = infinity | integer() > 0  `{:  #agent_ms_cache_gclimit }** - When performing a GC, this is the max number of\n  cache entries that will be deleted from the cache.\n\n  The reason why its possible to set a limit, is that if the cache is large, the\n  GC can potentially take a long time, during which the agent is \"busy\". _But_\n  on a heavily loaded system, we also risk not removing enough elements in the\n  cache, instead causing it to grow over time. This is the reason the default\n  value is `infinity`, which will ensure that _all_ candidates are removed as\n  soon as possible.\n\n  Default is `infinity`.\n\n- **`error_report_mod() = atom()  `{: #agent_error_report_mod }** -\n  Defines an error report module, implementing the `m:snmpa_error_report`\n  behaviour. Two modules are provided with the toolkit: `snmpa_error_logger` and\n  `snmpa_error_io`.\n\n  Default is `snmpa_error_logger`.\n\n- **`symbolic_store() = [symbolic_store_opt()]`{: #agent_symbolic_store }** -\n  `symbolic_store_opt() = {verbosity, verbosity()}`\n\n  Defines options specific for the SNMP agent symbolic store.\n\n  For defaults see the options in `symbolic_store_opt()`.\n\n- **`target_cache() = [target_cache_opt()]`{: #agent_target_cache }** -\n  `target_cache_opt() = {verbosity, verbosity()}`\n\n  Defines options specific for the SNMP agent target cache.\n\n  For defaults see the options in `target_cache_opt()`.\n\n- **`agent_config() = [agent_config_opt()]  `{: #agent_config }** -\n  `agent_config_opt() = {dir, agent_config_dir()} | {force_load, force_load()} | {verbosity, verbosity()}`\n\n  Defines specific config related options for the SNMP agent.\n\n  For defaults see the options in `agent_config_opt()`.\n\n- **`agent_config_dir = dir()  `{: #agent_config_dir }** - Defines\n  where the SNMP agent configuration files are stored.\n\n- **`force_load() = bool()  `{: #agent_force_load }** - If `true` the\n  configuration files are re-read during start-up, and the contents of the\n  configuration database ignored. Thus, if `true`, changes to the configuration\n  database are lost upon reboot of the agent.\n\n  Default is `false`.\n\n[](){: #manager_opts_and_types }\n\nManager specific config options and types:\n\n- **`server() = [server_opt()]  `{: #manager_server }** -\n  `server_opt() = {timeout, server_timeout()} | {verbosity, verbosity()} | {cbproxy, server_cbproxy()} | {netif_sup, server_nis()}`\n\n  Specifies the options for the manager server process.\n\n  Default is `silence`.\n\n- **`server_timeout() = integer()  `{: #manager_server_timeout }** -\n  Asynchronous request cleanup time. For every requests, some info is stored\n  internally, in order to be able to deliver the reply (when it arrives) to the\n  proper destination. If the reply arrives, this info will be deleted. But if\n  there is no reply (in time), the info has to be deleted after the _best\n  before_ time has been passed. This cleanup will be performed at regular\n  intervals, defined by the `server_timeout()` time. The information will have\n  an _best before_ time, defined by the `Expire` time given when calling the\n  request function (see [async_get](`snmpm:async_get2/4`),\n  [async_get_next](`snmpm:async_get_next2/4`) and\n  [async_set](`snmpm:async_set2/4`)).\n\n  Time in milli-seconds.\n\n  Default is `30000`.\n\n- **`server_cbproxy() = temporary (default) | permanent  `{: #manager_server_cbproxy }** - This option specifies how the server will handle\n  callback calls.\n\n  - **`temporary (default)`{: #manager_server_cbproxy_temporary }** - A\n    temporary process will be created for each callback call.\n\n  - **`permanent`{: #manager_server_cbproxy_permanent }** - With this the server\n    will create a permanent (named) process that in effect serializes all\n    callback calls.\n\n  Default is `temporary`.\n\n- **`server_nis() = none (default) | {PingTO, PongTO}  `{: #manager_server_nis }** - This option specifies if the server should actively\n  supervise the net-if process. Note that this will only work if the used net-if\n  process actually supports the protocol. See `m:snmpm_network_interface`\n  behaviour for more info.\n\n  - **`none (default)`{: #manager_server_nis_none }** - No active supervision of\n    the net-if process.\n\n  - **`{PingTO :: pos_integer(), PongTO :: pos_integer()}`{: #manager_server_nis_active }** - The `PingTO` time specifies the between a\n    successful ping (or start) and the time when a ping message is to be sent to\n    the net-if process (basically the time between ping).\n\n    The `PongTO` time specifies how long time the net-if process has to respond\n    to a ping message, with a _pong_ message. Its starts counting when the ping\n    message has been sent.\n\n    Both times are in milli seconds.\n\n  Default is `none`.\n\n- **`manager_config() = [manager_config_opt()]  `{: #manager_config }** -\n  `manager_config_opt() = {dir, manager_config_dir()} | {db_dir, manager_db_dir()} | {db_init_error, db_init_error()} | {repair, manager_repair()} | {auto_save, manager_auto_save()} | {verbosity, verbosity()}`\n\n  Defines specific config related options for the SNMP manager.\n\n  For defaults see the options in `manager_config_opt()`.\n\n- **`manager_config_dir = dir()  `{: #manager_config_dir }** - Defines\n  where the SNMP manager configuration files are stored.\n\n- **`manager_db_dir = dir()  `{: #manager_config_db_dir }** - Defines\n  where the SNMP manager store persistent data.\n\n- **`manager_repair() = false | true | force  `{:  #manager_config_repair }** - Defines the repair option for the persistent\n  database (if and how the table is repaired when opened).\n\n  Default is `true`.\n\n- **`manager_auto_save() = integer() | infinity  `{:  #manager_config_auto_save }** - The auto save interval. The table is flushed\n  to disk whenever not accessed for this amount of time.\n\n  Default is `5000`.\n\n- **`manager_irb() = auto | user | {user, integer()}  `{: #manager_irb }** - This option defines how the manager will handle the sending of response\n  (acknowledgment) to received inform-requests.\n\n  - `auto` \\- The manager will autonomously send response (acknowledgment> to\n    inform-request messages.\n  - `{user, integer()}` \\- The manager will send response (acknowledgment) to\n    inform-request messages when the\n    [handle_inform](`c:snmpm_user:handle_inform/3`) function completes. The\n    integer is the time, in milli-seconds, that the manager will consider the\n    stored inform-request info valid.\n  - `user` \\- Same as `{user, integer()}`, except that the default time, 15\n    seconds (15000), is used.\n\n  See `m:snmpm_network_interface`, [handle_inform](`m:snmpm_user`) and\n  [definition of the manager net if](snmp_manager_netif.md) for more info.\n\n  Default is `auto`.\n\n- **`manager_mibs() = [string()]  `{: #manager_mibs }** - Specifies a\n  list of MIBs (including path) and defines which MIBs are initially loaded into\n  the SNMP manager.\n\n  Default is `[]`.\n\n- **`manager_net_if() = [manager_net_if_opt()]  `{: #manager_net_if }** -\n  `manager_net_if_opt() = {module, manager_net_if_module()} | {verbosity, verbosity()} | {options, manager_net_if_options()}`\n\n  Defines options specific for the SNMP manager network interface entity.\n\n  For defaults see the options in `manager_net_if_opt()`.\n\n- **`manager_net_if_options() = [manager_net_if_option()]  `{:  #manager_ni_opts }** -\n  `manager_net_if_option() = {bind_to, bind_to()} | {sndbuf, sndbuf()} | {recbuf, recbuf()} | {no_reuse, no_reuse()} | {filter, manager_net_if_filter_options()} | {extra_sock_opts, extra_socket_options()}} | {inet_backend, inet_backend()}`\n\n  These options are actually specific to the used module. The ones shown here\n  are applicable to the default `manager_net_if_module()`.\n\n  For defaults see the options in `manager_net_if_option()`.\n\n- **`manager_net_if_module() = atom()  `{: #manager_ni_module }** - The\n  module which handles the network interface part for the SNMP manager. It must\n  implement the `m:snmpm_network_interface` behaviour.\n\n  Default is `snmpm_net_if`.\n\n- **`manager_net_if_filter_options() = [manager_net_if_filter_option()]  `{:  #manager_ni_filter_opts }** -\n  `manager_net_if_filter_option() = {module, manager_net_if_filter_module()}`\n\n  These options are actually specific to the used module. The ones shown here\n  are applicable to the default `manager_net_if_filter_module()`.\n\n  For defaults see the options in `manager_net_if_filter_option()`.\n\n- **`manager_net_if_filter_module() = atom()  `{:  #manager_ni_filter_module }** - Module which handles the network interface\n  filter part for the SNMP manager. Must implement the\n  `m:snmpm_network_interface_filter` behaviour.\n\n  Default is `snmpm_net_if_filter`.\n\n- **`def_user_module() = atom()  `{: #manager_def_user_module }** - The\n  module implementing the default user. See the `m:snmpm_user` behaviour.\n\n  Default is `snmpm_user_default`.\n\n- **`def_user_data() = term()  `{: #manager_def_user_data }** - Data\n  for the default user. Passed to the user module when calling the callback\n  functions.\n\n  Default is `undefined`.\n\n[](){: #common_types }\n\nCommon config types:\n\n- **`restart_type() = permanent | transient | temporary`{: #restart_type }** -\n  See [supervisor](`m:supervisor#child_spec`) documentation for more info.\n\n  Default is `permanent` for the agent and `transient` for the manager.\n\n- **`db_init_error() = terminate | create | create_db_and_dir`{: #db_init_error }** - Defines what to do if the agent or manager is unable to open an existing\n  database file. `terminate` means that the agent/manager will terminate and\n  `create` means that the agent/manager will remove the faulty file(s) and\n  create new ones, and `create_db_and_dir` means that the agent/manager will\n  create the database file along with any missing parent directories for the\n  database file.\n\n  Default is `terminate`.\n\n- **`priority() = atom()  `{: #prio }** - Defines the Erlang priority\n  for all SNMP processes.\n\n  Default is `normal`.\n\n- **`versions() = [version()]  `{: #versions }** -\n  `version() = v1 | v2 | v3`\n\n  Which SNMP versions shall be accepted/used.\n\n  Default is `[v1,v2,v3]`.\n\n- **`verbosity() = silence | info | log | debug | trace  `{: #verbosity }** - Verbosity for a SNMP process. This specifies now much debug info is\n  printed.\n\n  Default is `silence`.\n\n- **`bind_to() = bool()  `{: #bind_to }** - If `true`, net_if binds to\n  the IP address. If `false`, net_if listens on any IP address on the host where\n  it is running.\n\n  Default is `false`.\n\n- **`no_reuse() = bool()  `{: #no_reuse }** - If `true`, net_if does\n  not specify that the IP and port address should be reusable. If `false`, the\n  address is set to reusable.\n\n  Default is `false`.\n\n- **`recbuf() = integer()  `{: #recbuf }** - Receive buffer size.\n\n  Default value is defined by `gen_udp`.\n\n- **`sndbuf() = integer()  `{: #sndbuf }** - Send buffer size.\n\n  Default value is defined by `gen_udp`.\n\n- **`extra_socket_options() = list()  `{: #extra_sock_opts }** - A list\n  of arbitrary socket options.\n\n  This list is not inspected by snmp (other then checking that its a list). Its\n  the users responsibility to ensure that these are valid options and does not\n  conflict with the \"normal\" options.\n\n  Default is `[]`.\n\n- **`inet_backend() = inet | socket  `{: #inet_backend }** - Choose the\n  inet-backend.\n\n  This option make it possible to use net_if (gen_udp) with a different\n  inet-backend ('inet' or 'socket').\n\n  Default is `inet`.\n\n- **`note_store() = [note_store_opt()]  `{: #note_store }** -\n  `note_store_opt() = {timeout, note_store_timeout()} | {verbosity, verbosity()}`\n\n  Specifies the start-up verbosity for the SNMP note store.\n\n  For defaults see the options in `note_store_opt()`.\n\n- **`note_store_timeout() = integer()  `{: #ns_timeout }** - Note\n  cleanup time. When storing a note in the note store, each note is given\n  lifetime. Every `timeout` the note_store process performs a GC to remove the\n  expired note's. Time in milli-seconds.\n\n  Default is `30000`.\n\n- **`audit_trail_log() = [audit_trail_log_opt()]  `{: #audit_trail_log }** -\n  `audit_trail_log_opt() = {type, atl_type()} | {dir, atl_dir()} | {size, atl_size()} | {repair, atl_repair()} | {seqno, atl_seqno()}`\n\n  If present, this option specifies the options for the audit trail logging. The\n  `disk_log` module is used to maintain a wrap log. If present, the `dir` and\n  `size` options are mandatory.\n\n  If not present, audit trail logging is not used.\n\n- **`atl_type() = read | write | read_write  `{: #atl_type }** -\n  Specifies what type of an audit trail log should be used. The effect of the\n  type is actually different for the the agent and the manager.\n\n  For the agent:\n\n  - If `write` is specified, only set requests are logged.\n  - If `read` is specified, only get requests are logged.\n  - If `read_write`, all requests are logged.\n\n  For the manager:\n\n  - If `write` is specified, only sent messages are logged.\n  - If `read` is specified, only received messages are logged.\n  - If `read_write`, both outgoing and incoming messages are logged.\n\n  Default is `read_write`.\n\n- **`atl_dir = dir()  `{: #atl_dir }** - Specifies where the audit\n  trail log should be stored.\n\n  If `audit_trail_log` specifies that logging should take place, this parameter\n  _must_ be defined.\n\n- **`atl_size() = {integer(), integer()}  `{: #atl_size }** -\n  Specifies the size of the audit trail log. This parameter is sent to\n  `disk_log`.\n\n  If `audit_trail_log` specifies that logging should take place, this parameter\n  _must_ be defined.\n\n- **`atl_repair() = true | false | truncate | snmp_repair  `{:  #atl_repair }** - Specifies if and how the audit trail log shall be repaired\n  when opened. Unless this parameter has the value `snmp_repair` it is sent to\n  `disk_log`. If, on the other hand, the value is `snmp_repair`, snmp attempts\n  to handle certain faults on its own. And even if it cannot repair the file, it\n  does not truncate it directly, but instead _moves it aside_ for later off-line\n  analysis.\n\n  Default is `true`.\n\n- **`atl_seqno() = true | false  `{: #atl_seqno }** - Specifies if the\n  audit trail log entries will be (sequence) numbered or not. The range of the\n  sequence numbers are according to RFC 5424, i.e. 1 through 2147483647.\n\n  Default is `false`.","ref":"snmp_app.html#configuration"},{"type":"extras","title":"See Also - SNMP Application","doc":"application(3), disk_log(3)","ref":"snmp_app.html#see-also"},{"type":"extras","title":"SNMP Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SNMP Release Notes","ref":"notes.html"},{"type":"extras","title":"SNMP 5.16 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-16"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- `-callback` attributes have been added to modules `m:snmpa_network_interface_filter`, `m:snmpa_notification_filter`, `m:snmpm_network_interface_filter`, `m:snmpm_user`, and `m:snmpa_notification_delivery_info_receiver`.\n  \n  New `-type` attributes have also been added to modules `m:snmp`, `m:snmpa`, `m:snmpm`, and `m:snmpa_conf` to support the previously mentioned callbacks.\n\n  Own Id: OTP-18785 Aux Id: [PR-7702]\n\n- Updated types and specs for all API modules.\n\n  Own Id: OTP-18934 Aux Id: BL-312\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-7702]: https://github.com/erlang/otp/pull/7702\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.15 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-15"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Make snmp handle gen_udp with socket backend on Windows (completion).\n\n  Own Id: OTP-18598 Aux Id: OTP-18029","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.14 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-14"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- The implementation has been fixed to use `proc_lib:init_fail/2,3` where\n  appropriate, instead of `proc_lib:init_ack/1,2`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18490 Aux Id: OTP-18471, GH-6339, PR-6843","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.13.5 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-13-5"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Attempts to minimize the number of the error reports during a failed agent\n  init.\n\n  Own Id: OTP-18422 Aux Id: ERIERL-873","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.13.4 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-13-4"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18432 Aux Id:\n  GH-6672,PR-6793,PR-6784,PR-6787,PR-6785,PR-6682,PR-6800,PR-6797,PR-6798,PR-6799,PR-6796,PR-6813,PR-6671,PR-6673,PR-6684,PR-6694,GH-6677,PR-6696,PR-6670,PR-6674","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.13.3 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-13-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Single threaded agent crash when vacm table not properly initiated.\n\n  Own Id: OTP-18379 Aux Id: ERIERL-904","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.13.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-13-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Explicitly close the socket(s) when terminating (default-) net-if process.\n\n  Own Id: OTP-18352 Aux Id: ERIERL-881","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.13.1.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-13-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Single threaded agent crash when vacm table not properly initiated.\n\n  Own Id: OTP-18379 Aux Id: ERIERL-904","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.13.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-13-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Improved the get-bulk response max size calculation. Its now possible to\n  configure 'empty pdu size', see appendix c for more info.\n\n  Own Id: OTP-17115 Aux Id: ERIERL-456\n\n- Fix various example dialyzer issues\n\n  Own Id: OTP-18180 Aux Id: ERIERL-837","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.13 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-13"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Input for `configure` scripts adapted to `autoconf` 2\\.71.\n\n  Own Id: OTP-17414 Aux Id: PR-4967\n\n- Removed deprecated functions slated for removal in OTP-25. Also removed \"dead\"\n  code, kept for backward compatibility reasons.\n\n  Own Id: OTP-17612","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.12.0.3 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-12-0-3"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Attempts to minimize the number of the error reports during a failed agent\n  init.\n\n  Own Id: OTP-18422 Aux Id: ERIERL-873","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.12.0.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-12-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Single threaded agent crash when vacm table not properly initiated.\n\n  Own Id: OTP-18379 Aux Id: ERIERL-904","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.12.0.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-12-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Explicitly close the socket(s) when terminating (default-) net-if process.\n\n  Own Id: OTP-18352 Aux Id: ERIERL-881","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.12 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- The compilation time is no longer recorded in BEAM files. There remained\n  several undocumented functions that attempted to retrieve compilation times.\n  Those have now been removed.\n\n  Own Id: OTP-17962","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- \\[agent] Remove expectation of socket being a port.\n\n  Own Id: OTP-16559","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.11 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Handling of test config flag when starting \"empty\".\n\n  Own Id: OTP-17671","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Add support for new authentication algorithms (SHA-224, SHA-256, SHA-384 and\n  SHA-512), according to RFC 7860.\n\n  Own Id: OTP-17615 Aux Id: MR9501-1\n\n- Improve debug info for (snmp) manager.\n\n  Own Id: OTP-17783","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.10.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Sockets are monitored, but the handling of the 'DOWN' message expected a new\n  style socket ('socket'), old style (port) was not handled.\n\n  Own Id: OTP-17641 Aux Id: OTP-17640","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.10 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-10"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- It is now possible to configure the built-in net-if processes (both agent and\n  manager) to use the new (gen_udp-) option 'inet_backend'.\n\n  Own Id: OTP-17526","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.9.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.9 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-9"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Removed deprecated functions marked for removal.\n\n  Own Id: OTP-17049\n\n- Removed timestamps from files generated by `snmp` to enable deterministic\n  builds.\n\n  Own Id: OTP-17354\n\n- Fixed warnings in code matching on underscore prefixed variables.\n\n  Own Id: OTP-17385 Aux Id: OTP-17123","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.8.0.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-8-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.8 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-8"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Add function to get a list of configured agent transports. Also improved agent\n  info with regards to transports.\n\n  Own Id: OTP-17109 Aux Id: ERIERL-583","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.7.3 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- \\[manager] In a function handling snmp errors, an unused result (\\_Error)\n  could result in matching issues and therefore case clause runtime errors\n  (crash). Note that this would only happen in _very_ unusual error cases.\n\n  Own Id: OTP-17161","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.7.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- \\[manager] Misspelled priv protocol (atom) made it impossible to update usm\n  user 'priv_key' configuration for usmAesCfb128Protocol via function calls.\n\n  Own Id: OTP-17110 Aux Id: ERIERL-586","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.7.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Fixed usage of `AC_CONFIG_AUX_DIRS()` macros in configure script sources.\n\n  Own Id: OTP-17093 Aux Id: ERL-1447, PR-2948","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.7 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- If an attempt was made to send a v1 trap on a IPv6 transport this could cause\n  a master agent crash (if the agent was _not_ multi-threaded).\n\n  Own Id: OTP-16920 Aux Id: OTP-16649\n\n- The deprecation info for a couple of the deprecated MIB compiler functions\n  where incorrect. Referred to functions in the 'snmpa' module instead of\n  'snmpc'.\n\n  Own Id: OTP-17056 Aux Id: OTP-17049","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Make it possible for the agent to configure separate transports (sockets) for\n  request-responder and trap-sender.\n\n  Own Id: OTP-16649\n\n- The mib server cache handling has been improved. First, the default gclimit\n  has been changed from 100 to infinity (to ensure the size is as small as\n  possible). Also, the method of removing old elements has been optimized.\n\n  Own Id: OTP-16989 Aux Id: ERIERL-544\n\n- It is now possible to configure the agent in such a way that the order of\n  outgoing notifications are processed in order in the agent. What happens after\n  the notification message has left the agent (been sent) is of course still out\n  of our control.\n\n  Own Id: OTP-17022 Aux Id: ERIERL-492\n\n- Improve handling of the udp_error message. Basically an improved error/warning\n  message.\n\n  Own Id: OTP-17033","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.6.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- For agent fix PrivParams for SNMPv3 USM with AES privacy, as earlier fixed for\n  the manager in OTP_16541.\n\n  Own Id: OTP-15130 Aux Id: ERIERL-524, OTP-16541\n\n- The SNMP Agent missed to re-activate datagram reception in an odd timeout case\n  and went deaf. This bug has been fixed.\n\n  Own Id: OTP-15767 Aux Id: ERIERL-523\n\n- Use of deprecated functions in example 2 has been removed (no more compiler\n  warnings).\n\n  Own Id: OTP-16716\n\n- A file descriptor leak has been plugged. When calling the reconfigure function\n  of a mib, it opened the config file(s) but never closed them on successful\n  read.\n\n  Own Id: OTP-16760 Aux Id: ERIERL-511","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.6 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- For manager, fix PrivParams for SNMPv3 USM with AES privacy; _ In\n  \\`snmp_usm:do_decrypt/3\\`, pass full UsmSecParams to\n  \\`snmp_usm:try_decrypt/5\\` as expected by AES clause. _ Change\n  \\`snmpm_usm:aes_encrypt/3\\` to use EngineBoots and EngineTime as cached by\n  \\`snmpm_config:get_usm_eboots/1\\` and \\`snmpm_config:get_usm_etime/1\\` instead\n  of \\`snmpm_config:get_engine_boots/0\\` and \\`snmpm_config:get_engine_time/0\\`.\n  This ensures correct msgPrivacyParameters are sent when AES is used. \\* Add\n  test \\`snmp.snmp_manager_SUITE.usm_priv_aes/1\\` to avoid regression.\n\n  Own Id: OTP-16541 Aux Id: #2544\n\n- Invalid character in (manager) usm config entry generator function.\n\n  Own Id: OTP-16552 Aux Id: ERL-1196","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Remove usage and documentation of old requests of the I/O-protocol.\n\n  Own Id: OTP-15695\n\n- Calls of deprecated functions in the\n  [Old Crypto API](`e:crypto:new_api.md#the-old-api`) are replaced by calls of\n  their [substitutions](`e:crypto:new_api.md#the-new-api`).\n\n  Own Id: OTP-16346\n\n- Finalize deprecation. Already deprecated functions has a \"remove version 24\"\n  set and \"new\" functions added to list of deprecated functions.\n\n  Own Id: OTP-16463\n\n- Refactored the internal handling of deprecated and removed functions.\n\n  Own Id: OTP-16469","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.5.0.5 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-5-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.5.0.4 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-5-0-4"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- The mib server cache handling has been improved. First, the default gclimit\n  has been changed from 100 to infinity (in order to ensure the size is as small\n  as possible). Also the method of removing old elements has been optimized.\n\n  Own Id: OTP-16989 Aux Id: ERIERL-544\n\n- It is now possible to configure the agent in such a way that the order of\n  outgoing notifications are processed in order in the agent. What happens after\n  the notification message has left the agent (been sent) is of course still out\n  of our control.\n\n  Own Id: OTP-17022 Aux Id: ERIERL-492","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.5.0.3 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-5-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- For agent fix PrivParams for SNMPv3 USM with AES privacy, as earlier fixed for\n  the manager in OTP_16541.\n\n  Own Id: OTP-15130 Aux Id: ERIERL-524, OTP-16541","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.5.0.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-5-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- The SNMP Agent missed to re-activate datagram reception in an odd timeout case\n  and went deaf. This bug has been fixed.\n\n  Own Id: OTP-15767 Aux Id: ERIERL-523","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.5.0.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-5-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- A file descriptor leak has been plugged. When calling the reconfigure function\n  of a mib, it opened the config file(s) but never closed them on successful\n  read.\n\n  Own Id: OTP-16760 Aux Id: ERIERL-511","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.5 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-5"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- A simple supervision of the snmp manager net-if process has been added. Also,\n  a way to forcibly restart the net-if process has been added. This could be\n  useful if the net-if process hangs for some reason.\n\n  Own Id: OTP-16447 Aux Id: ERIERL-455, OTP-16382\n\n- Misc documentation corrections\n\n  Own Id: OTP-16450","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.4.5 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-4-5"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Its now possible to remove selected varbinds (from the final message) when\n  sending a notification. This is done by setting the 'value' (in the varbind(s)\n  of the varbinds list) to '?NOTIFICATION_IGNORE_VB_VALUE'.\n\n  Own Id: OTP-16349 Aux Id: ERIERL-444\n\n- Its now possible to specify that an oid shall be \"truncated\" (trailing \".0\" to\n  be removed) when sending an notification.\n\n  Own Id: OTP-16360 Aux Id: ERIERL-451","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.4.4 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-4-4"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- \\[manager] The callbacks where executed in a (new) 'temporary' process, that\n  executed the callback call and then exited. This has now been made\n  configurable so that is also possible to specify a 'permanent' callback proxy\n  process. All callback calls will then be executed in this (permanent) process\n  (in sequence).\n\n  Own Id: OTP-15947 Aux Id: ERIERL-378","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.4.3.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-4-3-1"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Its now possible to remove selected varbinds (from the final message) when\n  sending a notification. This is done by setting the 'value' (in the varbind(s)\n  of the varbinds list) to '?NOTIFICATION_IGNORE_VB_VALUE'.\n\n  Own Id: OTP-16349 Aux Id: ERIERL-444\n\n- Its now possible to specify that an oid shall be \"truncated\" (trailing \".0\" to\n  be removed) when sending an notification.\n\n  Own Id: OTP-16360 Aux Id: ERIERL-451","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.4.3 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Agent discovery cleanup. If there is no receiver of INFORM then #state.reqs in\n  snmpa_net_if keeps on growing for DISCOVERY.\n\n  Own Id: OTP-16228 Aux Id: ERIERL-427","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.4.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- The agent discovery process has been made to work with snmptrapd..\n\n  Own Id: OTP-16207 Aux Id: ERIERL-427","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.4.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-4-1"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Made it possible to add 'extra socket options' to the (gen_udp) socket open\n  call (for both manager and agent). A new option has been added,\n  extra_sock_opts, which makes it possible for the user to add a list of extra\n  socket options that will be appended to the other socket options for the open\n  call. See the snmp application config man page (erl -man 6 snmp) or the\n  \"Configuring the application\" chapter of the Users Guide for more info.\n\n  Own Id: OTP-16092 Aux Id: ERIERL-410","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.4 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Fix various minor issues related to Dialyzer. Mostly these are dialyzer\n  warnings, but there was also some minor bugs detected by Dialyzer.\n\n  Own Id: OTP-15932","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Fixed a dets usage problem detected by dialyzer.\n\n  Own Id: OTP-10400 Aux Id: kunagi-253 \\[164]\n\n- The function snmp:print_version_info() prints various version info. For each\n  module a number of items are printed, such as app vsn and md5 digest. And an\n  attempt was also made to print \"compile time\". This used to be available in\n  the module_info for each module, but has now been removed.\n\n  Own Id: OTP-15330\n\n- The use of the deprecated random module has been replaced the with rand\n  module.\n\n  Own Id: OTP-15331\n\n- Removed use of the deprecated function erlang:get_stacktrace(). Instead make\n  use of the 'catch Class:Error:Stacktrace' feature.\n\n  Own Id: OTP-15332","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.3 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-3"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- The application otp_mibs has been removed from OTP. Some of its components\n  (mibs) have been moved to other apps (snmp), or removed completely (os_mon).\n\n  Own Id: OTP-14984 Aux Id: OTP-15329\n\n- \\[snmp|agent] Add a get-mechanism callback module (and a corresponding\n  behaviour). The agent calls this module to handle each get (get, get-next and\n  get-bulk) request.\n\n  Own Id: OTP-15691 Aux Id: ERIERL-324","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.2.12 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Conversion of (agent) Audit Trail Log (ATL) failed due to invalid log entries.\n\n  The conversion aborted completely midway because the ATL contained invalid\n  entries. The conversion has been improved so that it now firstly handles\n  encountered errors and write an informative message (into the converted\n  stream) and secondly keeps count of the number of successful or failed entry\n  conversions. See [log_to_txt](`snmpa:log_to_txt/8`) for more info.\n\n  The reason the ATL contained invalid entries have also been fixed. The reason\n  was that for some outgoing messages (not response):\n\n  - encrypted (v3 messages)\n\n    Was logged \"as is\" (encrypted) without the info to decrypt, making\n    conversion impossible (which was the reason the log contained bad entries).\n\n  - un-encrypted\n\n    Was not logged at all.\n\n  Own Id: OTP-15287 Aux Id: ERIERL-206\n\n- \\[compiler] Spurious version message removed. The snmp mib compiler printed an\n  spurious version message if the 'version' option was provided.\n\n  Own Id: OTP-15290","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.11.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-11-2"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- \\[manager] The callbacks where executed in a (new) 'temporary' process, that\n  executed the callback call and then exited. This has now been made\n  configurable so that is also possible to specify a 'permanent' callback proxy\n  process. All callback calls will then be executed in this (permanent) process\n  (in sequence).\n\n  Own Id: OTP-15947 Aux Id: ERIERL-378","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.2.11.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-11-1"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- \\[snmp|agent] Add a get-mechanism callback module (and a corresponding\n  behaviour). The agent calls this module to handle each get (get, get-next and\n  get-bulk) request.\n\n  Own Id: OTP-15691 Aux Id: ERIERL-324","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.2.11 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- The Snmp MIB compiler now allows using a TEXTUAL-CONVENTION type before\n  defining it.\n\n  Own Id: OTP-14196 Aux Id: ERIERL-161","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.10 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- The example MIB EX1-MIB in the SNMP application has been corrected to match\n  its example.\n\n  Own Id: OTP-14204 Aux Id: PR-1726","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.9 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.8 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- The `recbuf` configuration option was not propagated correctly to the socket\n  for the SNMP Manager.\n\n  Own Id: OTP-13372 Aux Id: ERIERL-73","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.7 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- A bug in the SNMP MIB compiler has been fixed. An AUGMENTS referring to a\n  table defined later in the MIB did not work.\n\n  Own Id: OTP-13014 Aux Id: ERL-375","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.6 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Internal code change: Calls to `catch` followed by a call to\n  `erlang:get_stacktrace/0` has been rewritten to use `try` instead of `catch`\n  to make the code future-proof.\n\n  Own Id: OTP-14400","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.5 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- The SNMP MIB compiler has been fixed to compile MIBS with refinements on user\n  types such as in RFC 4669 RADIUS-AUTH-SERVER-MIB.mib. Problem reported and\n  researched by Kenneth Lakin and Daniel Goertzen.\n\n  See also: https://bugs.erlang.org/browse/ERL-325\n\n  Own Id: OTP-14145 Aux Id: ERL-325","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.4 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Correct bugs when path to mib or idl spec files contains UTF-8 characters.\n\n  Own Id: OTP-13718 Aux Id: ERL-179","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Solves snmp config string handling as reported by ERL-164 and solved by\n  PR-1100\n\n  Own Id: OTP-13706","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.2.3 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-3"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Internal changes\n\n  Own Id: OTP-13551","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.2.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Snmp agent now properly handles `vacmViewTreeFamily` masks.\n\n  Own Id: OTP-13264","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"SNMP 5.2.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- Small documentation fixes\n\n  Own Id: OTP-13017","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Update configuration check of imask ( list of ones and zeros) to allow the\n  empty list.\n\n  Own Id: OTP-13101","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-2"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- The runtime dependencies in the application resource file have been updated.\n\n  Own Id: OTP-12762","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.1.2 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"- A bug in the SNMP Agent has been corrected; when opening a port using the\n  command line argument -snmpa_fd the Port should be 0 when calling\n  gen_udp:open.\n\n  A bug in the SNMP manager has been corrected; it should not look at the\n  -snmp_fd command line argument, but instead at -snmpm_fd.\n\n  Own Id: OTP-12669 Aux Id: seq12841","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- Improved cryptographic capability.\n\n  Own Id: OTP-12452","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP Development Toolkit 5.1.1 - SNMP Release Notes","doc":"Version 5.1.1 supports code replacement in runtime from/to version 5.1.","ref":"notes.html#snmp-development-toolkit-5-1-1"},{"type":"extras","title":"Improvements and new features - SNMP Release Notes","doc":"- \\[compiler] Refinement of type Opaque was not allowed.\n\n  MIB constructs such as '`SYNTAX Opaque (SIZE(0..65535))`' was previously not\n  allowed, see the standard `ALARM-MIB` for eaxmple.\n\n  Own Id: OTP-12066\n\n  Aux Id: Seq 12669","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SNMP Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Incompatibilities - SNMP Release Notes","doc":"-","ref":"notes.html#incompatibilities"},{"type":"extras","title":"SNMP 5.1 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-1"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- The SNMP manager has been enhanced with dual stack IPv4+IPv6, as the agent\n  just was. The documentation is also now updated for both the agent and the\n  manager.\n\n  Own Id: OTP-12108 Aux Id: OTP-12020","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP 5.0 - SNMP Release Notes","doc":"","ref":"notes.html#snmp-5-0"},{"type":"extras","title":"Improvements and New Features - SNMP Release Notes","doc":"- SNMP has been improved to handle IPv6. The agent can handle dual stack IPv4 +\n  IPv6, but not yet the manager. The documentation also still lags behind... If\n  you do such advanced stuff like writing a custom net_if module, the interface\n  for it has changed, but other than that SNMP is backwards compatible.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12020 Aux Id: OTP-11518\n\n-","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SNMP Introduction","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SNMP Introduction\n\nThe SNMP development toolkit contains the following parts:\n\n- An Extensible multi-lingual SNMP agent, which understands SNMPv1 (RFC1157),\n  SNMPv2c (RFC1901, 1905, 1906 and 1907), SNMPv3 (RFC2271, 2272, 2273, 2274 and\n  2275), or any combination of these protocols.\n- A multi-lingual SNMP manager.\n- A MIB compiler, which understands SMIv1 (RFC1155, 1212, and 1215) and SMIv2\n  (RFC1902, 1903, and 1904).\n\nThe SNMP development tool provides an environment for rapid agent/manager\nprototyping and construction. With the following information provided, this tool\nis used to set up a running multi-lingual SNMP agent/manager:\n\n- a description of a Management Information Base (MIB) in Abstract Syntax\n  Notation One (ASN.1)\n- instrumentation functions for the managed objects in the MIB, written in\n  Erlang.\n\nThe advantage of using an extensible (agent/manager) toolkit is to remove\ndetails such as type-checking, access rights, Protocol Data Unit (PDU),\nencoding, decoding, and trap distribution from the programmer, who only has to\nwrite the instrumentation functions, which implement the MIBs. The `get-next`\nfunction only has to be implemented for tables, and not for every variable in\nthe global naming tree. This information can be deduced from the ASN.1 file.","ref":"snmp_intro.html"},{"type":"extras","title":"Scope and Purpose - SNMP Introduction","doc":"This manual describes the SNMP development tool, as a component of the\nErlang/Open Telecom Platform development environment. It is assumed that the\nreader is familiar with the Erlang Development Environment, which is described\nin a separate User's Guide.","ref":"snmp_intro.html#scope-and-purpose"},{"type":"extras","title":"Prerequisites - SNMP Introduction","doc":"The following prerequisites are required for understanding the material in the\nSNMP User's Guide:\n\n- the basics of the Simple Network Management Protocol version 1 (SNMPv1)\n- the basics of the community-based Simple Network Management Protocol version 2\n  (SNMPv2c)\n- the basics of the Simple Network Management Protocol version 3 (SNMPv3)\n- the knowledge of defining MIBs using SMIv1 and SMIv2\n- familiarity with the Erlang system and Erlang programming\n\nThe tool requires Erlang release 4.7 or later.","ref":"snmp_intro.html#prerequisites"},{"type":"extras","title":"Definitions - SNMP Introduction","doc":"The following definitions are used in the SNMP User's Guide.\n\n- **MIB** - The conceptual repository for management information is called the\n  Management Information Base (MIB). It does not hold any data, merely a\n  definition of what data can be accessed. A definition of an MIB is a\n  description of a collection of managed objects.\n\n- **SMI** - The MIB is specified in an adapted subset of the Abstract Syntax\n  Notation One (ASN.1) language. This adapted subset is called the Structure of\n  Management Information (SMI).\n\n- **ASN.1** - ASN.1 is used in two different ways in SNMP. The SMI is based on\n  ASN.1, and the messages in the protocol are defined by using ASN.1.\n\n- **Managed object** - A resource to be managed is represented by a managed\n  object, which resides in the MIB. In an SNMP MIB, the managed objects are\n  either:\n\n  - _scalar variables_, which have only one instance per context. They have\n    single values, not multiple values like vectors or structures.\n  - _tables_, which can grow dynamically.\n  - a _table element_, which is a special type of scalar variable.\n\n- **Operations** - SNMP relies on the three basic operations: get (object), set\n  (object, value) and get-next (object).\n\n- **Instrumentation function** - An instrumentation function is associated with\n  each managed object. This is the function, which actually implements the\n  operations and will be called by the agent when it receives a request from the\n  management station.\n\n- **Manager** - A manager generates commands and receives notifications from\n  agents. There usually are only a few managers in a system.\n\n- **Agent** - An agent responds to commands from the manager, and sends\n  notification to the manager. There are potentially many agents in a system.","ref":"snmp_intro.html#definitions"},{"type":"extras","title":"About This Manual - SNMP Introduction","doc":"In addition to this introductory chapter, the SNMP User's Guide contains the\nfollowing chapters:\n\n- Chapter 2: \"Functional Description\" describes the features and operation of\n  the SNMP development toolkit. It includes topics on Sub-agents and MIB\n  loading, Internal MIBs, and Traps.\n- Chapter 3: \"The MIB Compiler\" describes the features and the operation of the\n  MIB compiler.\n- Chapter 4: \"Running the application\" describes how to start and configure the\n  application. Topics on how to debug the application are also included.\n- Chapter 5: \"Definition of Agent Configuration Files\" is a reference chapter,\n  which contains more detailed information about the agent configuration files.\n- Chapter 6: \"Definition of Manager Configuration Files\" is a reference chapter,\n  which contains more detailed information about the manager configuration\n  files.\n- Chapter 7: \"Agent Implementation Example\" describes how an MIB can be\n  implemented with the SNMP Development Toolkit. Implementation examples are\n  included.\n- Chapter 8: \"Instrumentation Functions\" describes how instrumentation functions\n  should be defined in Erlang for the different operations.\n- Chapter 9: \"Definition of Instrumentation Functions\" is a reference chapter\n  which contains more detailed information about the instrumentation functions.\n- Chapter 10: \"Definition of Agent Net if\" is a reference chapter, which\n  describes the Agent Net if function in detail.\n- Chapter 11: \"Definition of Manager Net if\" is a reference chapter, which\n  describes the Manager Net if function in detail.\n- Chapter 12: \"Advanced Agent Topics\" describes sub-agents, agent semantics,\n  audit trail logging, and the consideration of distributed tables.\n- Appendix A describes the conversion of SNMPv2 to SNMPv1 error messages.\n- Appendix B contains the RFC1903 text on `RowStatus`.","ref":"snmp_intro.html#about-this-manual"},{"type":"extras","title":"Where to Find More Information - SNMP Introduction","doc":"Refer to the following documentation for more information about SNMP and about\nthe Erlang/OTP development system:\n\n- Marshall T. Rose (1991), \"The Simple Book - An Introduction to Internet\n  Management\", Prentice-Hall\n- Evan McGinnis and David Perkins (1997), \"Understanding SNMP MIBs\",\n  Prentice-Hall\n- RFC1155, 1157, 1212 and 1215 (SNMPv1)\n- RFC1901-1907 (SNMPv2c)\n- RFC1908, 2089 (coexistence between SNMPv1 and SNMPv2)\n- RFC2271, RFC2273 (SNMP std MIBs)\n- the Mnesia User's Guide\n- the Erlang 4.4 Extensions User's Guide\n- the Reference Manual\n- the Erlang Embedded Systems User's Guide\n- the System Architecture Support Libraries (SASL) User's Guide\n- the Installation Guide\n- the Asn1 User's Guide\n- Concurrent Programming in Erlang, 2nd Edition (1996), Prentice-Hall, ISBN\n  0-13-508301-X.","ref":"snmp_intro.html#where-to-find-more-information"},{"type":"extras","title":"Agent Functional Description","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Agent Functional Description\n\nThe SNMP agent system consists of one Master Agent and optional Sub-agents.\n\nThe tool makes it easy to dynamically extend an SNMP agent in run-time. MIBs can\nbe loaded and unloaded at any time. It is also easy to change the implementation\nof an MIB in run-time, without having to recompile the MIB. The MIB\nimplementation is clearly separated from the agent.\n\nTo facilitate incremental MIB implementation, the tool can generate a prototype\nimplementation for a whole MIB, or parts thereof. This allows different MIBs and\nmanagement applications to be developed at the same time.","ref":"snmp_agent_funct_descr.html"},{"type":"extras","title":"Features - Agent Functional Description","doc":"To implement an agent, the programmer writes instrumentation functions for the\nvariables and the tables in the MIBs that the agent is going to support. A\nrunning prototype which handles `set`, `get`, and `get-next` can be created\nwithout any programming.\n\nThe toolkit provides the following:\n\n- multi-lingual multi-threaded extensible SNMP agent\n- easy writing of instrumentation functions with a high-level programming\n  language\n- basic fault handling such as automatic type checking\n- access control\n- authentication\n- privacy through encryption\n- loading and unloading of MIBs in run-time\n- the ability to change instrumentation functions without recompiling the MIB\n- rapid prototyping environment where the MIB compiler can use generic\n  instrumentation functions, which later can be refined by the programmer\n- a simple and extensible model for transaction handling and consistency\n  checking of set-requests\n- support of the sub-agent concept via distributed Erlang\n- a mechanism for sending notifications (traps and informs)\n- support for implementing SNMP tables in the Mnesia DBMS.","ref":"snmp_agent_funct_descr.html#features"},{"type":"extras","title":"SNMPv1, SNMPv2 and SNMPv3 - Agent Functional Description","doc":"[](){: #versions }\n\nThe SNMP development toolkit works with all three versions of Standard Internet\nManagement Framework; SNMPv1, SNMPv2 and SNMPv3. They all share the same basic\nstructure and components. And they follow the same architecture.\n\nThe versions are defined in following RFCs\n\n- SNMPv1 RFC 1555, 1157 1212, 1213 and 1215\n- SNMPv2 RFC 1902 - 1907\n- SNMPv3 RFC 2570 - 2575\n\nOver time, as the Framework has evolved from SNMPv1 , through SNMPv2, to SNMPv3\nthe definitions of each of these architectural components have become richer and\nmore clearly defined, but the fundamental architecture has remained consistent.\n\nThe main features of SNMPv2 compared to SNMPv1 are:\n\n- The `get-bulk` operation for transferring large amounts of data.\n- Enhanced error codes.\n- A more precise language for MIB specification\n\nThe standard documents that define SNMPv2 are incomplete, in the sense that they\ndo not specify how an SNMPv2 message looks like. The message format and security\nissues are left to a special Administrative Framework. One such framework is the\nCommunity-based SNMPv2 Framework (SNMPv2c), which uses the same message format\nand framework as SNMPv1. Other experimental frameworks as exist, e.g. SNMPv2u\nand SNMPv2\\*.\n\nThe SNMPv3 specifications take a modular approach to SNMP. All modules are\nseparated from each other, and can be extended or replaced individually.\nExamples of modules are Message definition, Security and Access Control. The\nmain features of SNMPv3 are:\n\n- Encryption and authentication is added.\n- MIBs for agent configuration are defined.\n\nAll these specifications are commonly referred to as \"SNMPv3\", but it is\nactually only the Message module, which defines a new message format, and\nSecurity module, which takes care of encryption and authentication, that cannot\nbe used with SNMPv1 or SNMPv2c. In this version of the agent toolkit, all the\nstandard MIBs for agent configuration are used. This includes MIBs for\ndefinition of management targets for notifications. These MIBs are used\nregardless of which SNMP version the agent is configured to use.\n\nThe extensible agent in this toolkit understands the SNMPv1, SNMPv2c and SNMPv3.\nRecall that SNMP consists of two separate parts, the MIB definition language\n(SMI), and the protocol. On the protocol level, the agent can be configured to\nspeak v1, v2c, v3 or any combination of them at the same time, i.e. a v1 request\ngets an v1 reply, a v2c request gets a v2c reply, and a v3 request gets a v3\nreply. On the MIB level, the MIB compiler can compile both SMIv1 and SMIv2 MIBs.\nOnce compiled, any of the formats can be loaded into the agent, regardless of\nwhich protocol version the agent is configured to use. This means that the agent\ntranslates from v2 notifications to v1 traps, and vice versa. For example, v2\nMIBs can be loaded into an agent that speaks v1 only. The procedures for the\ntranslation between the two protocols are described in RFC 1908 and RFC 2089.\n\nIn order for an implementation to make full use of the enhanced SNMPv2 error\ncodes, it is essential that the instrumentation functions always return SNMPv2\nerror codes, in case of error. These are translated into the corresponding\nSNMPv1 error codes by the agent, if necessary.\n\n> #### Note {: .info }\n>\n> The translation from an SMIv1 MIB to an SNMPv2c or SNMPv3 reply is always very\n> straightforward, but the translation from a v2 MIB to a v1 reply is somewhat\n> more complicated. There is one data type in SMIv2, called `Counter64`, that an\n> SNMPv1 manager cannot decode correctly. Therefore, an agent may never send a\n> `Counter64` object to an SNMPv1 manager. The common practice in these\n> situations is to simple ignore any `Counter64` objects, when sending a reply\n> or a trap to an SNMPv1 manager. For example, if an SNMPv1 manager tries to GET\n> an object of type `Counter64`, he will get a `noSuchName` error, while an\n> SNMPv2 manager would get a correct value.","ref":"snmp_agent_funct_descr.html#snmpv1-snmpv2-and-snmpv3"},{"type":"extras","title":"Operation - Agent Functional Description","doc":"The following steps are needed to get a running agent:\n\n1. Write your MIB in SMI in a text file.\n1. Write the instrumentation functions in Erlang and compile them.\n1. Put their names in the association file.\n1. Run the MIB together with the association file through the MIB compiler.\n1. Configure the application (agent).\n1. Start the application (agent).\n1. Load the compiled MIB into the agent.\n\nThe figures in this section illustrate the steps involved in the development of\nan SNMP agent.\n\n[](){: #image-1 }\n\n![MIB Compiler Principles](assets/snmp-um-1-image-1.gif \"MIB Compiler Principles\")\n\nThe compiler parses the SMI file and associates each table or variable with an\ninstrumentation function (see the figure\n[MIB Compiler Principles](snmp_agent_funct_descr.md#image-1)). The actual\ninstrumentation functions are not needed at MIB compile time, only their names.\n\nThe binary output file produced by the compiler is read by the agent at MIB load\ntime (see the figure [Starting the Agent](snmp_agent_funct_descr.md#image-2)).\nThe instrumentation is ordinary Erlang code which is loaded explicitly or\nautomatically the first time it is called.\n\n[](){: #image-2 }\n\n![Starting the Agent](assets/snmp-um-1-image-2.gif \"Starting the Agent\")\n\nThe SNMP agent system consists of one Master Agent and optional sub-agents. The\nMaster Agent can be seen as a special kind of sub-agent. It implements the core\nagent functionality, UDP packet processing, type checking, access control, trap\ndistribution, and so on. From a user perspective, it is used as an ordinary\nsub-agent.\n\nSub-agents are only needed if your application requires special support for\ndistribution from the SNMP toolkit. A sub-agent can also be used if the\napplication requires a more complex set transaction scheme than is found in the\nmaster agent.\n\nThe following illustration shows how a system can look in runtime.\n\n[](){: #snmp_ch2_fig3 }\n\n![Architecture](assets/snmp-um-1-image-3.gif \"Architecture\")\n\nA typical operation could include the following steps:\n\n1. The Manager sends a request to the Agent.\n1. The Master Agent decodes the incoming UDP packet.\n1. The Master Agent determines which items in the request that should be\n   processed here and which items should be forwarded to its subagent.\n1. Step 3 is repeated by all subagents.\n1. Each sub-agent calls the instrumentation for its loaded MIBs.\n1. The results of calling the instrumentation are propagated back to the Master\n   Agent.\n1. The answer to the request is encoded to a UDP Protocol Data Unit (PDU).\n\nThe sequence of steps shown is probably more complex than normal, but it\nillustrates the amount of functionality which is available. The following points\nshould be noted:\n\n- An agent can have many MIBs loaded at the same time.\n- Sub-agents can also have sub-agents. Each sub-agent can have an arbitrary\n  number of child sub-agents registered, forming a hierarchy.\n- One MIB can communicate with many applications.\n- Instrumentation can use Distributed Erlang to communicate with an application.\n\nMost applications only need the Master Agent because an agent can have multiple\nMIBs loaded at the same time.","ref":"snmp_agent_funct_descr.html#operation"},{"type":"extras","title":"Sub-agents and MIB Loading - Agent Functional Description","doc":"[](){: #sub_agent_mib_loading }\n\nSince applications tend to be transient (they are dynamically loaded and\nunloaded), the management of these applications must be dynamic as well. For\nexample, if we have an equipment MIB for a rack and different MIBs for boards,\nwhich can be installed in the rack, the MIB for a card should be loaded when the\ncard is inserted, and unloaded when the card is removed.\n\nIn this agent system, there are two ways to dynamically install management\ninformation. The most common way is to load an MIB into an agent. The other way\nis to use a sub-agent, which is controlled by the application and is able to\nregister and unregister itself. A sub-agent can register itself for managing a\nsub-tree (not to be mixed up with `erlang:register`). The sub-tree is identified\nby an Object Identifier. When a sub-agent is registered, it receives all\nrequests for this particular sub-tree and it is responsible for answering them.\nIt should also be noted that a sub-agent can be started and stopped at any time.\n\nCompared to other SNMP agent packages, there is a significant difference in this\nway of using sub-agents. Other packages normally use sub-agents to load and\nunload MIBs in run-time. In Erlang, it is easy to load code in run-time and it\nis possible to load an MIB into an existing sub-agent. It is not necessary to\ncreate a new process for handling a new MIB.\n\nSub-agents are used for the following reasons:\n\n- to provide a more complex set-transaction scheme than master agent\n- to avoid unnecessary process communication\n- to provide a more lightweight mechanism for loading and unloading MIBs in\n  run-time\n- to provide interaction with other SNMP agent toolkits.\n\nRefer to the chapter [Advanced Agent Topics](snmp_advanced_agent.md) in this\nUser's Guide for more information about these topics.\n\nThe communication protocol between sub-agents is the normal message passing\nwhich is used in distributed Erlang systems. This implies that sub-agent\ncommunication is very efficient compared to SMUX, DPI, AgentX, and similar\nprotocols.","ref":"snmp_agent_funct_descr.html#sub-agents-and-mib-loading"},{"type":"extras","title":"Contexts and Communities - Agent Functional Description","doc":"[](){: #context_and_communities }\n\nA context is a collection of management information accessible by an SNMP\nentity. An instance of a management object may exist in more than one context.\nAn SNMP entity potentially has access to many contexts.\n\nEach managed object can exist in many instances within a SNMP entity. To\nidentify the instances, specified by an MIB module, a method to distinguish the\nactual instance by its 'scope' or context is used. Often the context is a\nphysical or a logical device. It can include multiple devices, a subset of a\nsingle device or a subset of multiple devices, but the context is always defined\nas a subset of a single SNMP entity. To be able to identify a specific item of\nmanagement information within an SNMP entity, the context, the object type and\nits instance must be used.\n\nFor example, the managed object type `ifDescr` from RFC1573, is defined as the\ndescription of a network interface. To identify the description of device-X's\nfirst network interface, four pieces of information are needed: the snmpEngineID\nof the SNMP entity which provides access to the management information at\ndevice-X, the `contextName` (device-X), the managed object type (`ifDescr`), and\nthe instance (\"1\").\n\nIn SNMPv1 and SNMPv2c, the community string in the message was used for (at\nleast) three different purposes:\n\n- to identify the context\n- to provide authentication\n- to identify a set of trap targets\n\nIn SNMPv3, each of these usage areas has its own unique mechanism. A context is\nidentified by the name of the SNMP entity, `contextEngineID`, and the name of\nthe context, `contextName`. Each SNMPv3 message contains values for these two\nparameters.\n\nThere is a MIB, SNMP-COMMUNITY-MIB, which maps a community string to a\n`contextEngineID` and `contextName`. Thus, each message, an SNMPv1, SNMPv2c or\nan SNMPv3 message, always uniquely identifies a context.\n\nFor an agent, the `contextEngineID` identified by a received message, is always\nequal to the `snmpEngineID` of the agent. Otherwise, the message was not\nintended for the agent. If the agent is configured with more than one context,\nthe instrumentation code must be able to figure out for which context the\nrequest was intended. There is a function `snmpa:current_context/0` provided for\nthis purpose.\n\nBy default, the agent has no knowledge of any other contexts than the default\ncontext, `\"\"`. If it is to support more contexts, these must be explicitly\nadded, by using an appropriate configuration file\n[Agent Configuration Files](snmp_agent_config_files.md).","ref":"snmp_agent_funct_descr.html#contexts-and-communities"},{"type":"extras","title":"Management of the Agent - Agent Functional Description","doc":"[](){: #management }\n\nThere is a set of standard MIBs, which are used to control and configure an SNMP\nagent. All of these MIBs, with the exception of the optional SNMP-PROXY-MIB\n(which is only used for proxy agents), are implemented in this agent. Further,\nit is configurable which of these MIBs are actually loaded, and thus made\nvisible to SNMP managers. For example, in a non-secure environment, it might be\na good idea to not make MIBs that define access control visible. Note, the data\nthe MIBs define is used internally in the agent, even if the MIBs not are\nloaded. This chapter describes these standard MIBs, and some aspects of their\nimplementation.\n\nAny SNMP agent must implement the `system` group and the `snmp` group, defined\nin MIB-II. The definitions of these groups have changed from SNMPv1 to SNMPv2.\nMIBs and implementations for both of these versions are Provided in the\ndistribution. The MIB file for SNMPv1 is called STANDARD-MIB, and the\ncorresponding for SNMPv2 is called SNMPv2-MIB. If the agent is configured for\nSNMPv1 only, the STANDARD-MIB is loaded by default; otherwise, the SNMPv2-MIB is\nloaded by default. It is possible to override this default behavior, by\nexplicitly loading another version of this MIB, for example, you could choose to\nimplement the union of all objects in these two MIBs.\n\nAn SNMPv3 agent must implement the SNMP-FRAMEWORK-MIB and SNMP-MPD-MIB. These\nMIBs are loaded by default, if the agent is configured for SNMPv3. These MIBs\ncan be loaded for other versions as well.\n\nThere are five other standard MIBs, which also may be loaded into the agent.\nThese MIBs are:\n\n- SNMP-TARGET-MIB and SNMP-NOTIFICATION-MIB, which defines managed objects for\n  configuration of management targets, i.e. receivers of notifications (traps\n  and informs). These MIBs can be used with any SNMP version.\n- SNMP-VIEW-BASED-ACM-MIB, which defined managed objects for access control.\n  This MIB can be used with any SNMP version.\n- SNMP-COMMUNITY-MIB, which defines managed objects for coexistence of SNMPv1\n  and SNMPv2c with SNMPv3. This MIB is only useful if SNMPv1 or SNMPv2c is used,\n  possibly in combination with SNMPv3.\n- SNMP-USER-BASED-SM-MIB, which defines managed objects for authentication and\n  privacy. This MIB is only useful with SNMPv3.\n\nAll of these MIBs should be loaded into the Master Agent. Once loaded, these\nMIBs are always available in all contexts.\n\nThe ASN.1 code, the Erlang source code, and the generated `.hrl` files for them\nare provided in the distribution and are placed in the directories `mibs`,\n`src`, and `include`, respectively, in the `snmp` application.\n\nThe `.hrl` files are generated with `snmpc:mib_to_hrl/1`. Include these files in\nyour code as in the following example:\n\n```erlang\n-include_lib(\"snmp/include/SNMPv2-MIB.hrl\").\n```\n\nThe initial values for the managed objects defined in these tables, are read at\nstart-up from a set of configuration files. These are described in\n[Configuration Files](snmp_config.md).","ref":"snmp_agent_funct_descr.html#management-of-the-agent"},{"type":"extras","title":"STANDARD-MIB and SNMPv2-MIB - Agent Functional Description","doc":"These MIBs contain the `snmp-` and `system` groups from MIB-II which is defined\nin RFC1213 (STANDARD-MIB) or RFC1907 (SNMPv2-MIB). They are implemented in the\n`snmp_standard_mib` module. The `snmp` counters all reside in volatile memory\nand the `system` and `snmpEnableAuthenTraps` variables in persistent memory,\nusing the SNMP built-in database (refer to the Reference Manual, section `snmp`,\nmodule `snmpa_local_db` for more details).\n\nIf another implementation of any of these variables is needed, e.g. to store the\npersistent variables in a Mnesia database, an own implementation of the\nvariables must be made. That MIB will be compiled and loaded instead of the\ndefault MIB. The new compiled MIB must have the same name as the original MIB\n(i.e. STANDARD-MIB or SNMPv2-MIB), and be located in the SNMP configuration\ndirectory (see [Configuration Files](snmp_config.md).)\n\nOne of these MIBs is always loaded. If only SNMPv1 is used, STANDARD-MIB is\nloaded, otherwise SNMPv2-MIB is loaded.\n\n#### Data Types\n\nThere are some new data types in SNMPv2 that are useful in SNMPv1 as well. In\nthe STANDARD-MIB, three data types are defined, `RowStatus`, `TruthValue` and\n`DateAndTime`. These data types are originally defined as textual conventions in\nSNMPv2-TC (RFC1903).","ref":"snmp_agent_funct_descr.html#standard-mib-and-snmpv2-mib"},{"type":"extras","title":"SNMP-FRAMEWORK-MIB and SNMP-MPD-MIB - Agent Functional Description","doc":"The SNMP-FRAMEWORK-MIB and SNMP-MPD-MIB define additional read-only managed\nobjects, which is used in the generic SNMP framework defined in RFC2271 and the\ngeneric message processing and dispatching module defined in RFC2272. They are\ngeneric in the sense that they are not tied to any specific SNMP version.\n\nThe objects in these MIBs are implemented in the modules `snmp_framework_mib`\nand `snmp_standard_mib`, respectively. All objects reside in volatile memory,\nand the configuration files are always reread at start-up.\n\nIf SNMPv3 is used, these MIBs are loaded by default.","ref":"snmp_agent_funct_descr.html#snmp-framework-mib-and-snmp-mpd-mib"},{"type":"extras","title":"SNMP-TARGET-MIB and SNMP-NOTIFICATION-MIB - Agent Functional Description","doc":"The SNMP-TARGET-MIB and SNMP-NOTIFICATION-MIB define managed objects for\nconfiguration of notification receivers. They are described in detail in\nRFC2273. Only a brief description is given here.\n\nAll tables in these MIBs have a column of type `StorageType`. The value of this\ncolumn specifies how each row is stored, and what happens in case of a restart\nof the agent. The implementation supports the values `volatile` and\n`nonVolatile`. When the tables are initially filled with data from the\nconfiguration files, these rows will automatically have storage type\n`nonVolatile`. Should the agent restart, all `nonVolatile` rows survive the\nrestart, while the `volatile` rows are lost. The configuration files are not\nread at restart, by default.\n\nThese MIBs are not loaded by default.\n\n#### snmpNotifyTable\n\nAn entry in the `snmpNotifyTable` selects a set of management targets, which\nshould receive notifications, as well as the type (trap or inform) of\nnotification that should be sent to each selected management target. When an\napplication sends a notification using the function `send_notification/5` or the\nfunction `send_trap` the parameter `NotifyName`, specified in the call, is used\nas an index in the table. The notification is sent to the management targets\nselected by that entry.\n\n#### snmpTargetAddrTable\n\nAn entry in the `snmpTargetAddrTable` defines transport parameters (such as IP\naddress and UDP port) for each management target. Each row in the\n`snmpNotifyTable` refers to potentially many rows in the `snmpTargetAddrTable`.\nEach row in the `snmpTargetAddrTable` refers to an entry in the\n`snmpTargetParamsTable`.\n\n#### snmpTargetParamsTable\n\nAn entry in the `snmpTargetParamsTable` defines which SNMP version to use, and\nwhich security parameters to use.\n\nWhich SNMP version to use is implicitly defined by specifying the Message\nProcessing Model. This version of the agent handles the models `v1`, `v2c` and\n`v3`.\n\nEach row specifies which security model to use, along with security level and\nsecurity parameters.","ref":"snmp_agent_funct_descr.html#snmp-target-mib-and-snmp-notification-mib"},{"type":"extras","title":"SNMP-VIEW-BASED-ACM-MIB - Agent Functional Description","doc":"The SNMP-VIEW-BASED-ACM-MIB defines managed objects to control access to the the\nmanaged objects for the managers. The View Based Access Control Module (VACM)\ncan be used with any SNMP version. However, if it is used with SNMPv1 or\nSNMPv2c, the SNMP-COMMUNITY-MIB defines additional objects to map community\nstrings to VACM parameters.\n\nAll tables in this MIB have a column of type `StorageType`. The value of this\ncolumn specifies how each row is stored, and what happens in case of a restart\nof the agent. The implementation supports the values `volatile` and\n`nonVolatile`. When the tables are initially filled with data from the\nconfiguration files, these rows will automatically have storage type\n`nonVolatile`. Should the agent restart, all `nonVolatile` rows survive the\nrestart, while the `volatile` rows are lost. The configuration files are not\nread at restart by default.\n\nThis MIB is not loaded by default.\n\nVACM is described in detail in RFC2275. Here is only a brief description given.\n\nThe basic concept is that of a _MIB view_. An MIB view is a subset of all the\nobjects implemented by an agent. A manager has access to a certain MIB view,\ndepending on which security parameters are used, in which context the request is\nmade, and which type of request is made.\n\nThe following picture gives an overview of the mechanism to select an MIB view:\n\n![Overview of the mechanism of MIB selection](assets/MIB_mechanism.gif \"Overview of the mechanism of MIB selection\")\n\n#### vacmContextTable\n\nThe `vacmContextTable` is a read-only table that lists all available contexts.\n\n#### vacmSecurityToGroupTable\n\nThe `vacmSecurityToGroupTable` maps a `securityModel` and a `securityName` to a\n`groupName`.\n\n#### vacmAccessTable\n\nThe `vacmAccessTable` maps the `groupName` (found in\n`vacmSecurityToGroupTable`), `contextName`, `securityModel`, and `securityLevel`\nto an MIB view for each type of operation (read, write, or notify). The MIB view\nis represented as a `viewName`. The definition of the MIB view represented by\nthe `viewName` is found in the `vacmViewTreeFamilyTable`\n\n#### vacmViewTreeFamilyTable\n\nThe `vacmViewTreeFamilyTable` is indexed by the `viewName`, and defines which\nobjects are included in the MIB view.\n\nThe MIB definition for the table looks as follows:\n\n```text\nVacmViewTreeFamilyEntry ::= SEQUENCE\n    {\n        vacmViewTreeFamilyViewName     SnmpAdminString,\n        vacmViewTreeFamilySubtree      OBJECT IDENTIFIER,\n        vacmViewTreeFamilyMask         OCTET STRING,\n        vacmViewTreeFamilyType         INTEGER,\n        vacmViewTreeFamilyStorageType  StorageType,\n        vacmViewTreeFamilyStatus       RowStatus\n    }\n\nINDEX { vacmViewTreeFamilyViewName,\n        vacmViewTreeFamilySubtree\n      }\n```\n\nEach `vacmViewTreeFamilyViewName` refers to a collection of sub-trees.\n\n##### MIB View Semantics\n\nAn MIB view is a collection of included and excluded sub-trees. A sub-tree is\nidentified by an OBJECT IDENTIFIER. A mask is associated with each sub-tree.\n\nFor each possible MIB object instance, the instance belongs to a sub-tree if:\n\n- the OBJECT IDENTIFIER name of that MIB object instance comprises at least as\n  many sub-identifiers as does the sub-tree, and\n- each sub-identifier in the name of that MIB object instance matches the\n  corresponding sub-identifier of the sub-tree whenever the corresponding bit of\n  the associated mask is 1 (0 is a wild card that matches anything).\n\nMembership of an object instance in an MIB view is determined by the following\nalgorithm:\n\n- If an MIB object instance does not belong to any of the relevant sub-trees,\n  then the instance is not in the MIB view.\n- If an MIB object instance belongs to exactly one sub-tree, then the instance\n  is included in, or excluded from, the relevant MIB view according to the type\n  of that entry.\n- If an MIB object instance belongs to more than one sub-tree, then the sub-tree\n  which comprises the greatest number of sub-identifiers, and is the\n  lexicographically greatest, is used.\n\n> #### Note {: .info }\n>\n> If the OBJECT IDENTIFIER is longer than an OBJECT IDENTIFIER of an object type\n> in the MIB, it refers to object instances. Because of this, it is possible to\n> control whether or not particular rows in a table shall be visible.","ref":"snmp_agent_funct_descr.html#snmp-view-based-acm-mib"},{"type":"extras","title":"SNMP-COMMUNITY-MIB - Agent Functional Description","doc":"The SNMP-COMMUNITY-MIB defines managed objects that is used for coexistence\nbetween SNMPv1 and SNMPv2c with SNMPv3. Specifically, it contains objects for\nmapping between community strings and version-independent SNMP message\nparameters. In addition, this MIB provides a mechanism for performing source\naddress validation on incoming requests, and for selecting community strings\nbased on target addresses for outgoing notifications.\n\nAll tables in this MIB have a column of type `StorageType`. The value of this\ncolumn specifies how each row is stored, and what happens in case of a restart\nof the agent. The implementation supports the values `volatile` and\n`nonVolatile`. When the tables are initially filled with data from the\nconfiguration files, these rows will automatically have storage type\n`nonVolatile`. Should the agent restart, all `nonVolatile` rows survive the\nrestart, while the `volatile` rows are lost. The configuration files are not\nread at restart, by default.\n\nThis MIB is not loaded by default.","ref":"snmp_agent_funct_descr.html#snmp-community-mib"},{"type":"extras","title":"SNMP-USER-BASED-SM-MIB - Agent Functional Description","doc":"The SNMP-USER-BASED-SM-MIB defines managed objects that is used for the\nUser-Based Security Model.\n\nAll tables in this MIB have a column of type `StorageType`. The value of the\ncolumn specifies how each row is stored, and what happens in case of a restart\nof the agent. The implementation supports the values `volatile` and\n`nonVolatile`. When the tables are initially filled with data from the\nconfiguration files, these rows will automatically have storage type\n`nonVolatile`. Should the agent restart, all `nonVolatile` rows survive the\nrestart, while the `volatile` rows are lost. The configuration files are not\nread at restart, by default.\n\nThis MIB is not loaded by default.","ref":"snmp_agent_funct_descr.html#snmp-user-based-sm-mib"},{"type":"extras","title":"OTP-SNMPEA-MIB - Agent Functional Description","doc":"The OTP-SNMPEA-MIB was used in earlier versions of the agent, before standard\nMIBs existed for access control, MIB views, and trap target specification. All\nobjects in this MIB are now obsolete.","ref":"snmp_agent_funct_descr.html#otp-snmpea-mib"},{"type":"extras","title":"Notifications - Agent Functional Description","doc":"Notifications are defined in SMIv1 with the TRAP-TYPE macro in the definition of\nan MIB (see RFC1215). The corresponding macro in SMIv2 is NOTIFICATION-TYPE.\nWhen an application decides to send a notification, it calls one of the\nfollowing functions:\n\n```erlang\nsnmpa:send_notification(Agent, Notification, Receiver\n                       [, NotifyName, ContextName, Varbinds])\nsnmpa:send_trap(Agent, Notification, Community [, Receiver, Varbinds])\n```\n\nproviding the registered name or process identifier of the agent where the MIB,\nwhich defines the notification is loaded and the symbolic name of the\nnotification.\n\nIf the `send_notification/3,4` function is used, all management targets are\nselected, as defined in RFC2273. The `Receiver` parameter defines where the\nagent should send information about the delivery of inform requests.\n\nIf the `send_notification/5` function is used, an `NotifyName` must be provided.\nThis parameter is used as an index in the `snmpNotifyTable`, and the management\ntargets defined by that single entry is used.\n\nThe `send_notification/6` function is the most general version of the function.\nA `ContextName` must be specified, from which the notification will be sent. If\nthis parameter is not specified, the default context (`\"\"`) is used.\n\nThe function `send_trap` is kept for backwards compatibility and should not be\nused in new code. Applications that use this function will continue to work. The\n`snmpNotifyName` is used as the community string by the agent when a\nnotification is sent.","ref":"snmp_agent_funct_descr.html#notifications"},{"type":"extras","title":"Notification Sending - Agent Functional Description","doc":"The simplest way to send a notification is to call the function\n`snmpa:send_notification(Agent, Notification, no_receiver)`. In this case, the\nagent performs a get-operation to retrieve the object values that are defined in\nthe notification specification (with the TRAP-TYPE or NOTIFICATION-TYPE macros).\nThe notification is sent to all managers defined in the target and notify\ntables, either unacknowledged as traps, or acknowledged as inform requests.\n\nIf the caller of the function wants to know whether or not acknowledgments are\nreceived for a certain notification (provided it is sent as an inform), the\n`Receiver` parameter can be specified as `{Tag, ProcessName}` (refer to the\nReference Manual, section snmp, module `snmp` for more details). In this case,\nthe agent send a message `{snmp_notification, Tag, {got_response, ManagerAddr}}`\nor `{snmp_notification, Tag, {no_response, ManagerAddr}}` for each management\ntarget.\n\nSometimes it is not possible to retrieve the values for some of the objects in\nthe notification specification with a get-operation. However, they are known\nwhen the `send_notification` function is called. This is the case if an object\nis an element in a table. It is possible to give the values of some objects to\nthe `send_notification` function\n`snmpa:send_notification(Agent, Notification, Receiver, Varbinds)`. In this\nfunction, `Varbinds` is a list of `Varbind`, where each `Varbind` is one of:\n\n- `{Variable, Value}`, where `Variable` is the symbolic name of a scalar\n  variable referred to in the notification specification.\n- `{Column, RowIndex, Value}`, where `Column` is the symbolic name of a column\n  variable. `RowIndex` is a list of indices for the specified element. If this\n  is the case, the OBJECT IDENTIFIER sent in the trap is the `RowIndex` appended\n  to the OBJECT IDENTIFIER for the table column. This is the OBJECT IDENTIFIER\n  which specifies the element.\n- `{OID, Value}`, where `OID` is the OBJECT IDENTIFIER for an instance of an\n  object, scalar variable or column variable.\n\nFor example, to specify that `sysLocation` should have the value `\"upstairs\"` in\nthe notification, we could use one of:\n\n- `{sysLocation, \"upstairs\"}` or\n- `{[1,3,6,1,2,1,1,6,0], \"upstairs\"}`\n\nIt is also possible to specify names and values for extra variables that should\nbe sent in the notification, but were not defined in the notification\nspecification.\n\nThe notification is sent to all management targets found in the tables. However,\nmake sure that each manager has access to the variables in the notification. If\na variable is outside a manager's MIB view, this manager will not receive the\nnotification.\n\n> #### Note {: .info }\n>\n> By definition, it is not possible to send objects with ACCESS `not-accessible`\n> in notifications. However, historically this is often done and for this reason\n> we allow it in notification sending. If a variable has ACCESS\n> `not-accessible`, the user must provide a value for the variable in the\n> `Varbinds` list. It is not possible for the agent to perform a get-operation\n> to retrieve this value.","ref":"snmp_agent_funct_descr.html#notification-sending"},{"type":"extras","title":"Notification Filters - Agent Functional Description","doc":"It is possible to add _notification filters_ to an agent. These filters will be\ncalled when a notification is to be sent. Their purpose is to allow\nmodification, suppression or other type of actions.\n\nA notification filter is a module implementing the `m:snmpa_notification_filter`\nbehaviour. A filter is added/deleted using the functions:\n`snmpa:register_notification_filter/5` and\n`snmpa:unregister_notification_filter/2`.\n\nUnless otherwise specified, the order of the registered filters will be the\norder in which they are registered.","ref":"snmp_agent_funct_descr.html#notification-filters"},{"type":"extras","title":"Sub-agent Path - Agent Functional Description","doc":"If a value for an object is not given to the `send_notification` function, the\nsub-agent will perform a get-operation to retrieve it. If the object is not\nimplemented in this sub-agent, its parent agent tries to perform a get-operation\nto retrieve it. If the object is not implemented in this agent either, it\nforwards the object to its parent, and so on. Eventually the Master Agent is\nreached and at this point all unknown object values must be resolved. If some\nobject is unknown even to the Master Agent, this is regarded as an error and is\nreported with a call to `user_err/2` of the error report module. No\nnotifications are sent in this case.\n\nFor a given notification, the variables, which are referred to in the\nnotification specification, must be implemented by the agent that has the MIB\nloaded, or by some parent to this agent. If not, the application must provide\nvalues for the unknown variables. The application must also provide values for\nall elements in tables.","ref":"snmp_agent_funct_descr.html#sub-agent-path"},{"type":"extras","title":"Discovery - Agent Functional Description","doc":"The _sender_ is _authoritative_ for messages containing payload which does _not_\nexpect a response (for example SNMPv2-Trap, Response or Report PDU).\n\nThe _receiver_ is _authoritative_ for messages containing payload which expects\na response (for example Get, GetNext, Get-Bulk, Set or Inform PDU).\n\nThe agent can both perform and respond to discovery.\n\nThe agent responds to discovery autonomously, without interaction by the user.\n\nInitiating discovery towards a manager is done by calling the\n`snmpa:discovery/6` function. The `EngineId` field of the target (manager) entry in the\n[target_addr.conf](snmp_agent_config_files.md#target_addr) file has to have the\nvalue `discovery`. Note that if the manager does not respond, the `Timeout` and\n`RetryCount` fields decide how long the function will hang before it returns.\n\nDiscovery can only be performed towards one manager at a time.","ref":"snmp_agent_funct_descr.html#discovery"},{"type":"extras","title":"Manager Functional Description","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Manager Functional Description","ref":"snmp_manager_funct_descr.html"},{"type":"extras","title":"Features - Manager Functional Description","doc":"The manager provided with the tool is a lightweight manager that basically\nprovides a means to communicate with agents.\n\nIt does not really implement any management capabilities by itself. That is up\nto the _user_.\n\nA _user_ in this context is basically a module implementing the `m:snmpm_user`\nbehaviour. A _user_ can issue snmp requests and receive notification/traps.\n\nAgents to be accessed by the manager needs to be registered by a user. Once\nregistered, they can be accessed by all registered users.\n\nNotifications/traps from an agent is delivered to the user that did the\nregistration.\n\nAny message from an agent that is not registered is delivered to the _default\nuser_.\n\nBy default, the _default user_ is set to the `snmpm_user_default` module, which\nsimply sends an info message to the error_logger. It is however highly\nrecommended that this module be replaced by another that does something useful\n(see [configuration params](snmp_config.md#configuration_params) for more info).\n\nWhen using version 3, then (at least one) _usm user_ has to be registered.\n\nRequests can be issued in two different ways. Synchronous (see\n[sync_set](`snmpm:sync_set2/4`), [sync_get](`snmpm:sync_get2/4`),\n[sync_get_next](`snmpm:sync_get_next2/4`) and\n[sync_get_bulk](`snmpm:sync_get_bulk2/6`)) and asynchronous (see\n[async_set](`snmpm:async_set2/4`), [async_get](`snmpm:async_get2/4`),\n[async_get_next](`snmpm:async_get_next2/4`) and\n[async_get_bulk](`snmpm:async_get_bulk2/6`)). With synchronous the snmp reply is\nreturned by the function. With asynchronous, the reply will instead be delivered\nthrough a call to one of the `handle_pdu` callback function defined by the\n[handle_pdu](`c:snmpm_user:handle_pdu/4`) behaviour.","ref":"snmp_manager_funct_descr.html#features"},{"type":"extras","title":"Operation - Manager Functional Description","doc":"The following steps are needed to get the manager running:\n\n1. \\[optional] Implement the default user.\n1. Implement the user(s).\n1. Configure the application (manager).\n1. Start the application (manager).\n1. Register the user(s).\n1. The user(s) register their agents.","ref":"snmp_manager_funct_descr.html#operation"},{"type":"extras","title":"MIB loading - Manager Functional Description","doc":"It is possible to load mibs into the manager, but this is not necessary for\nnormal operation, and not recommended.","ref":"snmp_manager_funct_descr.html#mib-loading"},{"type":"extras","title":"The MIB Compiler","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# The MIB Compiler\n\nThe chapter _The MIB Compiler_ describes the MIB compiler and contains the\nfollowing topics:\n\n- Operation\n- Import\n- Consistency checking between MIBs\n- .hrl file generation\n- Emacs integration\n- Deviations from the standard\n\n> #### Note {: .info }\n>\n> When importing MIBs, ensure that the imported MIBs as well as the importing\n> MIB are compiled using the same version of the SNMP-compiler.","ref":"snmp_mib_compiler.html"},{"type":"extras","title":"Operation - The MIB Compiler","doc":"The MIB must be written as a text file in SMIv1 or SMIv2 using an ASN.1 notation\nbefore it will be compiled. This text file must have the same name as the MIB,\nbut with the suffix `.mib`. This is necessary for handling the `IMPORT`\nstatement.\n\nThe association file, which contains the names of instrumentation functions for\nthe MIB, should have the suffix `.funcs`. If the compiler does not find the\nassociation file, it gives a warning message and uses default instrumentation\nfunctions. (See [Default Instrumentation](snmp_instr_functions.md#snmp_3) for\nmore details).\n\nThe MIB compiler is started with a call to `snmpc:compile( ).` For\nexample:\n\n```erlang\nsnmpc:compile(\"RFC1213-MIB\").\n```\n\nThe output is a new file which is called ` .bin`.\n\nThe MIB compiler understands both SMIv1 and SMIv2 MIBs. It uses the\nMODULE-IDENTITY statement to determinate if the MIB is written in SMI version 1\nor 2.","ref":"snmp_mib_compiler.html#operation"},{"type":"extras","title":"Importing MIBs - The MIB Compiler","doc":"The compiler handles the `IMPORT` statement. It is important to import the\ncompiled file and not the ASN.1 (source) file. A MIB must be recompiled to make\nchanges visible to other MIBs importing it.\n\nThe compiled files of the imported MIBs must be present in the current\ndirectory, or a directory in the current path. The path is supplied with the\n`{i, Path}` option, for example:\n\n```erlang\nsnmpc:compile(\"MY-MIB\",\n       [{i, [\"friend_mibs/\", \"../standard_mibs/\"]}]).\n```\n\nIt is also possible to import MIBs from OTP applications in an `\"include_lib\"`\nlike fashion with the `il` option. Example:\n\n```erlang\nsnmpc:compile(\"MY-MIB\",\n       [{il, [\"snmp/priv/mibs/\", \"myapp/priv/mibs/\"]}]).\n```\n\nfinds the latest version of the `snmp` and `myapp` applications in the OTP\nsystem and uses the expanded paths as include paths.\n\nNote that an SMIv2 MIB can import an SMIv1 MIB and vice versa.\n\nThe following MIBs are built-ins of the Erlang SNMP compiler: SNMPv2-SMI,\nRFC-1215, RFC-1212, SNMPv2-TC, SNMPv2-CONF, and RFC1155-SMI. They cannot\ntherefore be compiled separately.","ref":"snmp_mib_compiler.html#importing-mibs"},{"type":"extras","title":"MIB Consistency Checking - The MIB Compiler","doc":"When an MIB is compiled, the compiler detects if several managed objects use the\nsame `OBJECT IDENTIFIER`. If that is the case, it issues an error message.\nHowever, the compiler cannot detect Oid conflicts between different MIBs. These\nkinds of conflicts generate an error at load time. To avoid this, the following\nfunction can be used to do consistency checking between MIBs:\n\n```text\n\nerl>snmpc:is_consistent(ListOfMibNames).\n```\n\n`ListOfMibNames` is a list of compiled MIBs, for example\n`[\"RFC1213-MIB\", \"MY-MIB\"]`. The function also performs consistency checking of\ntrap definitions.\n\n## .hrl File Generation\n\nIt is possible to generate an `.hrl` file which contains definitions of Erlang\nconstants from a compiled MIB file. This file can then be included in Erlang\nsource code. The file will contain constants for:\n\n- object Identifiers for tables, table entries and variables\n- column numbers\n- enumerated values\n- default values for variables and table columns.\n\nUse the following command to generate a .hrl file from an MIB:\n\n```text\nerl>snmpc:mib_to_hrl(MibName).\n```","ref":"snmp_mib_compiler.html#mib-consistency-checking"},{"type":"extras","title":"Emacs Integration - The MIB Compiler","doc":"With the Emacs editor, the `next-error` (`` C-X ` ``) function can be used\nindicate where a compilation error occurred, provided the error message is\ndescribed by a line number.\n\nUse `M-x compile` to compile an MIB from inside Emacs, and enter:\n\n```text\n erl -s snmpc compile   -noshell\n```\n\nAn example of ` ` is `RFC1213-MIB`.","ref":"snmp_mib_compiler.html#emacs-integration"},{"type":"extras","title":"Compiling from a Shell or a Makefile - The MIB Compiler","doc":"The `erlc` commands can be used to compile SNMP MIBs. Example:\n\n```text\n erlc MY-MIB.mib\n```\n\nAll the standard `erlc` flags are supported, e.g.\n\n```text\n erlc -I mymibs -o mymibs -W MY-MIB.mib\n```\n\nThe flags specific to the MIB compiler can be specified by using the `+` syntax:\n\n```text\n erlc +'{group_check,false}' MY-MIB.mib\n```","ref":"snmp_mib_compiler.html#compiling-from-a-shell-or-a-makefile"},{"type":"extras","title":"Deviations from the Standard - The MIB Compiler","doc":"In some aspects the Erlang MIB compiler does not follow or implement the SMI\nfully. Here are the differences:\n\n- Tables must be written in the following order: `tableObject`, `entryObject`,\n  `column1`, ..., `columnN` (in order).\n- Integer values, for example in the `SIZE` expression must be entered in\n  decimal syntax, not in hex or bit syntax.\n- Symbolic names must be unique within a MIB and within a system.\n- Hyphens are allowed in SMIv2 (a pragmatic approach). The reason for this is\n  that according to SMIv2, hyphens are allowed for objects converted from SMIv1,\n  but not for others. This is impossible to check for the compiler.\n- If a word is a keyword in any of SMIv1 or SMIv2, it is a keyword in the\n  compiler (deviates from SMIv1 only).\n- Indexes in a table must be objects, not types (deviates from SMIv1 only).\n- A subset of all semantic checks on types are implemented. For example,\n  strictly the `TimeTicks` may not be sub-classed but the compiler allows this\n  (standard MIBs must pass through the compiler) (deviates from SMIv2 only).\n- The `MIB.Object` syntax is not implemented (since all objects must be unique\n  anyway).\n- Two different names cannot define the same OBJECT IDENTIFIER.\n- The type checking in the SEQUENCE construct is non-strict (i.e. subtypes may\n  be specified). The reason for this is that some standard MIBs use this.\n- A definition has normally a status field. When the status field has the value\n  deprecated, then the MIB-compiler will ignore this definition. With the\n  MIB-compiler option `{deprecated,true}` the MIB-compiler does not ignore the\n  deprecated definitions.\n- An object has a DESCRIPTIONS field. The descriptions-field will not be\n  included in the compiled mib by default. In order to get the description, the\n  mib must be compiled with the option `description`.","ref":"snmp_mib_compiler.html#deviations-from-the-standard"},{"type":"extras","title":"Running the application","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Running the application\n\nThe chapter _Running the application_ describes how the application is\nconfigured and started. The topics include:\n\n- configuration directories and parameters\n- modifying the configuration files\n- starting the application (agent and/or manager)\n- debugging the application (agent and/or manager)\n\nRefer also to the chapter(s)\n[Definition of Agent Configuration Files](snmp_agent_config_files.md) and\n[Definition of Manager Configuration Files](snmp_manager_config_files.md) which\ncontains more detailed information about the agent and manager configuration\nfiles.\n\n[](){: #configuration_params }","ref":"snmp_config.html"},{"type":"extras","title":"Configuring the application - Running the application","doc":"The following two directories must exist in the system to run the agent:\n\n- the _configuration directory_ stores all configuration files used by the agent\n  (refer to the chapter\n  [Definition of Agent Configuration Files](snmp_agent_config_files.md) for more\n  information).\n- the _database directory_ stores the internal database files.\n\nThe following directory must exist in the system to run the manager:\n\n- the _configuration directory_ stores all configuration files used by the\n  manager (refer to the chapter\n  [Definition of Manager Configuration Files](snmp_manager_config_files.md) for\n  more information).\n- the _database directory_ stores the internal database files.\n\nThe agent and manager uses (application) configuration parameters to find out\nwhere these directories are located. The parameters should be defined in an\nErlang system configuration file. The following configuration parameters are\ndefined for the SNMP application:\n\n```erlang\n      agent_options() = [agent_option()]\n      agent_option() = {restart_type,     restart_type()}     |\n                       {agent_type,       agent_type()}       |\n                       {agent_verbosity,  verbosity()}        |\n                       {versions,         versions()}         |\n                       {discovery,        agent_discovery()}  |\n                       {gb_max_vbs,       gb_max_vbs()}       |\n                       {priority,         priority()}         |\n                       {multi_threaded,   multi_threaded()}   |\n                       {db_dir,           db_dir()}           |\n                       {db_init_error,    db_init_error()}    |\n                       {local_db,         local_db()}         |\n                       {net_if,           agent_net_if()}     |\n                       {mibs,             mibs()}             |\n                       {mib_storage,      mib_storage()}      |\n                       {mib_server,       mib_server()}       |\n                       {audit_trail_log,  audit_trail_log()}  |\n                       {error_report_mod, error_report_mod()} |\n                       {note_store,       note_store()}       |\n                       {symbolic_store,   symbolic_store()}   |\n                       {target_cache,     target_cache()}     |\n                       {config,           agent_config()}\n      manager_options() = [manager_option()]\n      manager_option() = {restart_type,             restart_type()}    |\n                         {net_if,                   manager_net_if()}  |\n                         {server,                   server()}          |\n                         {note_store,               note_store()}      |\n                         {config,                   manager_config()}  |\n                         {inform_request_behaviour, manager_irb()}     |\n                         {mibs,                     manager_mibs()}    |\n                         {priority,                 priority()}        |\n                         {audit_trail_log,          audit_trail_log()} |\n                         {versions,                 versions()}        |\n                         {def_user_mod,             def_user_module()  |\n                         {def_user_data,            def_user_data()}\n```\n\n[](){: #agent_opts_and_types }\n\nAgent specific config options and types:\n\n- **`agent_type() = master | sub  `{: #agent_type }** - If `master`,\n  one master agent is started. Otherwise, no agents are started.\n\n  Default is `master`.\n\n- **`agent_discovery() = [agent_discovery_opt()]  `{: #agent_disco }** -\n  `agent_discovery_opt() = {terminating, agent_terminating_discovery_opts()} | {originating, agent_originating_discovery_opts()}`\n\n  The `terminating` options effects discovery initiated by a manager.\n\n  The `originating` options effects discovery initiated by this agent.\n\n  For defaults see the options in `agent_discovery_opt()`.\n\n- **`agent_terminating_discovery_opts() = [agent_terminating_discovery_opt()]  `{: #agent_term_disco_opts }** -\n  `agent_terminating_discovery_opt() = {enable, boolean()} | {stage2, discovery | plain} | {trigger_username, string()}`\n\n  These are options effecting discovery `terminating` in this agent (i.e.\n  initiated by a manager).\n\n  The default values for the `terminating` discovery options are:\n\n  - enable: `true`\n  - stage2: `discovery`\n  - trigger_username: `\"\"`\n\n- **`agent_originating_discovery_opts() = [agent_originating_discovery_opt()]  `{: #agent_orig_disco_opts }** -\n  `agent_originating_discovery_opt() = {enable, boolean()}`\n\n  These are options effecting discovery `originating` in this agent.\n\n  The default values for the `originating` discovery options are:\n\n  - enable: `true`\n\n- **`multi_threaded() = bool() | extended `{: #agent_mt }** - If `true`\n  (or `extended`), the agent is multi-threaded, with one thread for each get\n  request.\n\n  The value `extended` means that a special 'process' is also created intended\n  to handle _all_ notifications.\n\n  - `true` \\- One worker dedicated to 'set-requests' and one (main) worker for\n    all other requests ('get-request' and notifications).\n\n    If the 'main' worker is busy, a temporary process is spawned to handle that\n    job ('get-request' or notification).\n\n  - `extended` \\- One worker dedicated to 'set-requests', one worker dedicated\n    to notifications and one (main) worker for all 'get-requests'.\n\n    If the 'main' worker is busy, a temporary process is spawned to handle that\n    'get-request'.\n\n  > #### Note {: .info }\n  >\n  > Even with multi-threaded set to `extended` there is still a risk for\n  > 'reorder' when sending inform-requsts, which require a response (and may\n  > therefore require resending).\n  >\n  > Also, there is of course no way to guarantee order once the package is on\n  > the network.\n\n  Default is `false`.\n\n- **`db_dir() = string()  `{: #agent_data_dir }** - Defines where the\n  SNMP agent internal db files are stored.\n\n- **`gb_max_vbs() = pos_integer() | infinity  `{: #agent_gb_max_vbs }** - Defines the maximum number of varbinds allowed in a Get-BULK response.\n\n  Default is `1000`.\n\n- **`local_db() = [local_db_opt()]  `{: #agent_local_db }** -\n  `local_db_opt() = {repair, agent_repair()} | {auto_save, agent_auto_save()} | {verbosity, verbosity()}`\n\n  Defines options specific for the SNMP agent local database.\n\n  For defaults see the options in `local_db_opt()`.\n\n- **`agent_repair() = false | true | force  `{: #agent_ldb_repair }** -\n  When starting snmpa_local_db it always tries to open an existing database. If\n  `false`, and some errors occur, a new database is created instead. If `true`,\n  an existing file will be repaired. If `force`, the table will be repaired even\n  if it was properly closed.\n\n  Default is `true`.\n\n- **`agent_auto_save() = integer() | infinity  `{: #agent_ldb_auto_save }** - The auto save interval. The table is flushed to disk whenever not\n  accessed for this amount of time.\n\n  Default is `5000`.\n\n- **`agent_net_if() = [agent_net_if_opt()]  `{: #agent_net_if }** -\n  `agent_net_if_option() = {module, agent_net_if_module()} | {verbosity, verbosity()} | {options, agent_net_if_options()}`\n\n  Defines options specific for the SNMP agent network interface entity.\n\n  For defaults see the options in `agent_net_if_opt()`.\n\n- **`agent_net_if_module() = atom()  `{: #agent_ni_module }** - Module\n  which handles the network interface part for the SNMP agent. Must implement\n  the `m:snmpa_network_interface` behaviour.\n\n  Default is `snmpa_net_if`.\n\n- **`agent_net_if_options() = [agent_net_if_option()]  `{: #agent_ni_opts }** -\n  `agent_net_if_option() = {bind_to, bind_to()} | {sndbuf, sndbuf()} | {recbuf, recbuf()} | {no_reuse, no_reuse()} | {req_limit, req_limit()} | {filter, agent_net_if_filter_options()} | {open_err_filters, agent_net_if_open_err_filters()} | {extra_sock_opts, extra_socket_options()} | {inet_backend, inet_backend()}`\n\n  These options are actually specific to the used module. The ones shown here\n  are applicable to the default `agent_net_if_module()`.\n\n  > #### Note {: .info }\n  >\n  > If the user has configured transports _with_ options then those will take\n  > precedence over these options. See\n  > [agent information](snmp_agent_config_files.md#agent_information) for more\n  > info.\n\n  For defaults see the options in `agent_net_if_option()`.\n\n- **`req_limit() = integer() | infinity  `{: #agent_ni_req_limit }** -\n  Max number of simultaneous requests handled by the agent.\n\n  Default is `infinity`.\n\n- **`agent_net_if_filter_options() = [agent_net_if_filter_option()]  `{: #agent_ni_filter_opts }** -\n  `agent_net_if_filter_option() = {module, agent_net_if_filter_module()}`\n\n  These options are actually specific to the used module. The ones shown here\n  are applicable to the default `agent_net_if_filter_module()`.\n\n  For defaults see the options in `agent_net_if_filter_option()`.\n\n- **`agent_net_if_filter_module() = atom()  `{: #agent_ni_filter_module }** - Module which handles the network interface filter part for the SNMP\n  agent. Must implement the\n  [snmpa_network_interface_filter ](`m:snmpa_network_interface_filter`)behaviour.\n\n  Default is `snmpa_net_if_filter`.\n\n- **`agent_net_if_open_err_filters() = [agent_net_if_open_err_filter()]  `{: #agent_ni_open_err_filters }** - `agent_net_if_open_err_filter() = atom()`\n\n  During agent initiation, the transports UDP sockets are opened. If this\n  operation fails, the net-if (and the agent) fails to start (crash). This\n  (filter) list contains error (reasons) that will make net-if fail \"nicely\".\n  This (filter) list, is supposed to contain errors that can be returned by\n  [gen_udp:open/1,2](`gen_udp:open/1`). The effect is that any error returned by\n  [gen_udp:open](`gen_udp:open/1`) which _are_ in this list, will be considered\n  \"non-fatal\" and will only result in an info message, rather than an error\n  message. Net If, and the agent, will still crash, but will produce a less\n  obnoxious message.\n\n- **`agent_mibs() = [string()]  `{: #agent_mibs }** - Specifies a list\n  of MIBs (including path) that defines which MIBs are initially loaded into the\n  SNMP master agent.\n\n  Note that the following will always be loaded:\n\n  - version v1: `STANDARD-MIB`\n  - version v2: `SNMPv2`\n  - version v3: `SNMPv2`, `SNMP-FRAMEWORK-MIB` and `SNMP-MPD-MIB`\n\n  Default is `[]`.\n\n- **`mib_storage() = [mib_storage_opt()]  `{: #agent_mib_storage }** -\n  `mib_storage_opt() = {module, mib_storage_module()} | {options, mib_storage_options()}`\n\n  This option specifies how basic mib data is stored. This option is used by two\n  parts of the snmp agent: The mib-server and the symbolic-store.\n\n  Default is `[{module, snmpa_mib_storage_ets}]`.\n\n- **`mib_storage_module() = snmpa_mib_data_ets | snmpa_mib_data_dets | snmpa_mib_data_mnesia | module()`{: #agent_mst_module }** - Defines the mib storage module of the SNMP agent as\n  defined by the `m:snmpa_mib_storage` behaviour.\n\n  Several entities (`mib-server` via the its data module and the\n  `symbolic-store`) of the snmp agent uses this for storage of miscellaneous mib\n  related data data retrieved while loading a mib.\n\n  There are several implementations provided with the agent:\n  `snmpa_mib_storage_ets`, `snmpa_mib_storage_dets` and\n  `snmpa_mib_storage_mnesia`.\n\n  Default module is `snmpa_mib_storage_ets`.\n\n- **`mib_storage_options() = list()  `{: #agent_mst_options }** - This\n  is implementation depended. That is, it depends on the module. For each module\n  a specific set of options are valid. For the module provided with the app,\n  these options are supported:\n\n  - `snmpa_mib_storage_ets`:\n    `{dir, filename()} | {action, keep | clear}, {checksum, boolean()}`\n\n    - `dir` \\- If present, points to a directory where a file to which all data\n      in the ets table is \"synced\".\n\n      Also, when a table is opened this file is read, if it exists.\n\n      By default, this will _not_ be used.\n\n    - `action` \\- Specifies the behaviour when a non-empty file is found: Keep\n      its content or clear it out.\n\n      Default is `keep`.\n\n    - `checksum` \\- Defines if the file is checksummed or not.\n\n      Default is `false`.\n\n  - `snmpa_mib_storage_dets`:\n    `{dir, filename()} | {action, keep | clear}, {auto_save, default | pos_integer()} | {repair, force | boolean()}`\n\n    - `dir` \\- This _mandatory_ option points to a directory where to place the\n      file of a dets table.\n    - `action` \\- Specifies the behaviour when a non-empty file is found: Keep\n      its content or clear it out.\n\n      Default is `keep`.\n\n    - `auto_save` \\- Defines the dets auto-save frequency.\n\n      Default is `default`.\n\n    - `repair` \\- Defines the dets repair behaviour.\n\n      Default is `false`.\n\n  - `snmpa_mib_storage_mnesia`: `{action, keep | clear}, {nodes, [node()]}`\n\n    - `action` \\- Specifies the behaviour when a non-empty, already existing,\n      table: Keep its content or clear it out.\n\n      Default is `keep`.\n\n    - `nodes` \\- A list of node names (or an atom describing a list of nodes)\n      defining where to open the table. Its up to the user to ensure that mnesia\n      is actually running on the specified nodes.\n\n      The following distinct values are recognised:\n\n      - `[]` \\- Translated into a list of the own node: `[node()]`\n      - `all` \\- `erlang:nodes()`\n      - `visible` \\- `erlang:nodes(visible)`\n      - `connected` \\- `erlang:nodes(connected)`\n      - `db_nodes` \\- `mnesia:system_info(db_nodes)`\n\n      Default is the result of the call: `erlang:nodes()`.\n\n- **`mib_server() = [mib_server_opt()]  `{: #agent_mib_server }** -\n  `mib_server_opt() = {mibentry_override, mibentry_override()} | {trapentry_override, trapentry_override()} | {verbosity, verbosity()} | {cache, mibs_cache()} | {data_module, mib_server_data_module()}`\n\n  Defines options specific for the SNMP agent mib server.\n\n  For defaults see the options in `mib_server_opt()`.\n\n- **`mibentry_override() = bool()  `{: #agent_ms_meo }** - If this\n  value is false, then when loading a mib each mib- entry is checked prior to\n  installation of the mib. The purpose of the check is to prevent that the same\n  symbolic mibentry name is used for different oid's.\n\n  Default is `false`.\n\n- **`trapentry_override() = bool()  `{: #agent_ms_teo }** - If this\n  value is false, then when loading a mib each trap is checked prior to\n  installation of the mib. The purpose of the check is to prevent that the same\n  symbolic trap name is used for different trap's.\n\n  Default is `false`.\n\n- **`mib_server_data_module() = snmpa_mib_data_tttn | module()  `{: #agent_ms_data_module }** - Defines the backend data module of the SNMP agent\n  mib-server as defined by the `m:snmpa_mib_data` behaviour.\n\n  At present only the default module is provided with the agent,\n  `snmpa_mib_data_tttn`.\n\n  Default module is `snmpa_mib_data_tttn`.\n\n- **`mibs_cache() = bool() | mibs_cache_opts()  `{: #agent_ms_cache }** - Shall the agent utilize the mib server lookup cache or not.\n\n  Default is `true` (in which case the `mibs_cache_opts()` default values\n  apply).\n\n- **`mibs_cache_opts() = [mibs_cache_opt()]  `{: #agent_ms_cache_opts }** -\n  `mibs_cache_opt() = {autogc, mibs_cache_autogc()} | {gclimit, mibs_cache_gclimit()} | {age, mibs_cache_age()}`\n\n  Defines options specific for the SNMP agent mib server cache.\n\n  For defaults see the options in `mibs_cache_opt()`.\n\n- **`mibs_cache_autogc() = bool()  `{: #agent_ms_cache_autogc }** -\n  Defines if the mib server shall perform cache gc automatically or leave it to\n  the user (see [gc_mibs_cache/0,1,2,3](`snmpa:gc_mibs_cache/0`)).\n\n  Default is `true`.\n\n- **`mibs_cache_age() = integer() > 0  `{: #agent_ms_cache_age }** -\n  Defines how old the entries in the cache will be allowed to become before they\n  are GC'ed (assuming GC is performed). Each entry in the cache is \"touched\"\n  whenever it is accessed.\n\n  The age is defined in milliseconds.\n\n  Default is `10 timutes`.\n\n- **`mibs_cache_gclimit() = infinity | integer() > 0  `{: #agent_ms_cache_gclimit }** - When performing a GC, this is the max number of\n  cache entries that will be deleted from the cache.\n\n  The reason why its possible to set a limit, is that if the cache is large, the\n  GC can potentially take a long time, during which the agent is \"busy\". _But_\n  on a heavily loaded system, we also risk not removing enough elements in the\n  cache, instead causing it to grow over time. This is the reason the default\n  value is `infinity`, which will ensure that _all_ candidates are removed as\n  soon as possible.\n\n  Default is `infinity`.\n\n- **`error_report_mod() = atom()  `{: #agent_error_report_mod }** -\n  Defines an error report module, implementing the `m:snmpa_error_report`\n  behaviour. Two modules are provided with the toolkit: `snmpa_error_logger` and\n  `snmpa_error_io`.\n\n  Default is `snmpa_error_logger`.\n\n- **`symbolic_store() = [symbolic_store_opt()]`{: #agent_symbolic_store }** -\n  `symbolic_store_opt() = {verbosity, verbosity()}`\n\n  Defines options specific for the SNMP agent symbolic store.\n\n  For defaults see the options in `symbolic_store_opt()`.\n\n- **`target_cache() = [target_cache_opt()]`{: #agent_target_cache }** -\n  `target_cache_opt() = {verbosity, verbosity()}`\n\n  Defines options specific for the SNMP agent target cache.\n\n  For defaults see the options in `target_cache_opt()`.\n\n- **`agent_config() = [agent_config_opt()]  `{: #agent_config }** -\n  `agent_config_opt() = {dir, agent_config_dir()} | {force_load, force_load()} | {verbosity, verbosity()}`\n\n  Defines specific config related options for the SNMP agent.\n\n  For defaults see the options in `agent_config_opt()`.\n\n- **`agent_config_dir = dir()  `{: #agent_config_dir }** - Defines\n  where the SNMP agent configuration files are stored.\n\n- **`force_load() = bool()  `{: #agent_force_load }** - If `true` the\n  configuration files are re-read during start-up, and the contents of the\n  configuration database ignored. Thus, if `true`, changes to the configuration\n  database are lost upon reboot of the agent.\n\n  Default is `false`.\n\n[](){: #manager_opts_and_types }\n\nManager specific config options and types:\n\n- **`server() = [server_opt()]  `{: #manager_server }** -\n  `server_opt() = {timeout, server_timeout()} | {verbosity, verbosity()} | {cbproxy, server_cbproxy()} | {netif_sup, server_nis()}`\n\n  Specifies the options for the manager server process.\n\n  Default is `silence`.\n\n- **`server_timeout() = integer()  `{: #manager_server_timeout }** -\n  Asynchronous request cleanup time. For every request, some info is stored\n  internally, in order to be able to deliver the reply (when it arrives) to the\n  proper destination. If the reply arrives, this info will be deleted. But if\n  there is no reply (in time), the info has to be deleted after the _best\n  before_ time has been passed. This cleanup will be performed at regular\n  intervals, defined by the `server_timeout()` time. The information will have a\n  _best before_ time, defined by the `Expire` time given when calling the\n  request function (see [async_get](`snmpm:async_get2/4`),\n  [async_get_next](`snmpm:async_get_next2/4`) and\n  [async_set](`snmpm:async_set2/4`)).\n\n  Time in milli-seconds.\n\n  Default is `30000`.\n\n- **`server_cbproxy() = temporary (default) | permanent  `{: #manager_server_cbproxy }** - This option specifies how the server will handle\n  callback calls.\n\n  - **`temporary (default)`{: #manager_server_cbproxy_temporary }** - A\n    temporary process will be created for each callback call.\n\n  - **`permanent`{: #manager_server_cbproxy_permanent }** - With this the server\n    will create a permanent (named) process that in effect serializes all\n    callback calls.\n\n  Default is `temporary`.\n\n- **`server_nis() = none (default) | {PingTO, PongTO}  `{: #manager_server_nis }** - This option specifies if the server should actively\n  supervise the net-if process. Note that this will only work if the used net-if\n  process actually supports the protocol. See `m:snmpm_network_interface`\n  behaviour for more info.\n\n  - **`none (default)`{: #manager_server_nis_none }** - No active supervision of\n    the net-if process.\n\n  - **`{PingTO :: pos_integer(), PongTO :: pos_integer()}`{: #manager_server_nis_active }** - The `PingTO` time specifies the between a\n    successful ping (or start) and the time when a\n    [ping](snmp_manager_netif.md#im_ping) message is to be sent to the net-if\n    process (basically the time between ping:s).\n\n    The `PongTO` time specifies how long time the net-if process has to respond\n    to a ping message, with a [pong](snmp_manager_netif.md#om_pong) message. It\n    starts counting when the ping message has been sent.\n\n    Both times are in milli seconds.\n\n  Default is `none`.\n\n- **`manager_config() = [manager_config_opt()]  `{: #manager_config }** -\n  `manager_config_opt() = {dir, manager_config_dir()} | {db_dir, manager_db_dir()} | {db_init_error, db_init_error()} | {repair, manager_repair()} | {auto_save, manager_auto_save()} | {verbosity, verbosity()}`\n\n  Defines specific config related options for the SNMP manager.\n\n  For defaults see the options in `manager_config_opt()`.\n\n- **`manager_config_dir = dir()  `{: #manager_config_dir }** - Defines\n  where the SNMP manager configuration files are stored.\n\n- **`manager_db_dir = dir()  `{: #manager_config_db_dir }** - Defines\n  where the SNMP manager store persistent data.\n\n- **`manager_repair() = false | true | force  `{: #manager_config_repair }** - Defines the repair option for the persistent\n  database (if and how the table is repaired when opened).\n\n  Default is `true`.\n\n- **`manager_auto_save() = integer() | infinity  `{: #manager_config_auto_save }** - The auto save interval. The table is flushed\n  to disk whenever not accessed for this amount of time.\n\n  Default is `5000`.\n\n- **`manager_irb() = auto | user | {user, integer()}  `{: #manager_irb }** - This option defines how the manager will handle the sending of response\n  (acknowledgment) to received inform-requests.\n\n  - `auto` \\- The manager will autonomously send response (acknowledgment> to\n    inform-request messages.\n  - `{user, integer()}` \\- The manager will send response (acknowledgment) to\n    inform-request messages when the\n    [handle_inform](`c:snmpm_user:handle_inform/3`) function completes. The\n    integer is the time, in milli-seconds, that the manager will consider the\n    stored inform-request info valid.\n  - `user` \\- Same as `{user, integer()}`, except that the default time, 15000\n    milli-seconds, is used.\n\n  See `m:snmpm_network_interface`, [handle_inform](`m:snmpm_user`) and\n  [definition of the manager net if](snmp_manager_netif.md) for more info.\n\n  Default is `auto`.\n\n- **`manager_mibs() = [string()]  `{: #manager_mibs }** - Specifies a\n  list of MIBs (including path) and defines which MIBs are initially loaded into\n  the SNMP manager.\n\n  Default is `[]`.\n\n- **`manager_net_if() = [manager_net_if_opt()]  `{: #manager_net_if }** -\n  `manager_net_if_opt() = {module, manager_net_if_module()} | {verbosity, verbosity()} | {options, manager_net_if_options()}`\n\n  Defines options specific for the SNMP manager network interface entity.\n\n  For defaults see the options in `manager_net_if_opt()`.\n\n- **`manager_net_if_options() = [manager_net_if_option()]  `{: #manager_ni_opts }** -\n  `manager_net_if_option() = {bind_to, bind_to()} | {sndbuf, sndbuf()} | {recbuf, recbuf()} | {no_reuse, no_reuse()} | {filter, manager_net_if_filter_options()} | {extra_sock_opts, extra_socket_options()} | {inet_backend, inet_backend()}`\n\n  These options are actually specific to the used module. The ones shown here\n  are applicable to the default `manager_net_if_module()`.\n\n  For defaults see the options in `manager_net_if_option()`.\n\n- **`manager_net_if_module() = atom()  `{: #manager_ni_module }** - The\n  module which handles the network interface part for the SNMP manager. It must\n  implement the `m:snmpm_network_interface` behaviour.\n\n  Default is `snmpm_net_if`.\n\n- **`manager_net_if_filter_options() = [manager_net_if_filter_option()]  `{: #manager_ni_filter_opts }** -\n  `manager_net_if_filter_option() = {module, manager_net_if_filter_module()}`\n\n  These options are actually specific to the used module. The ones shown here\n  are applicable to the default `manager_net_if_filter_module()`.\n\n  For defaults see the options in `manager_net_if_filter_option()`.\n\n- **`manager_net_if_filter_module() = atom()  `{: #manager_ni_filter_module }** - Module which handles the network interface\n  filter part for the SNMP manager. Must implement the\n  `m:snmpm_network_interface_filter` behaviour.\n\n  Default is `snmpm_net_if_filter`.\n\n- **`def_user_module() = atom()  `{: #manager_def_user_module }** - The\n  module implementing the default user. See the `m:snmpm_user` behaviour.\n\n  Default is `snmpm_user_default`.\n\n- **`def_user_data() = term()  `{: #manager_def_user_data }** - Data\n  for the default user. Passed to the user when calling the callback functions.\n\n  Default is `undefined`.\n\n[](){: #common_types }\n\nCommon config types:\n\n- **`restart_type() = permanent | transient | temporary`{: #restart_type }** -\n  See [supervisor](`m:supervisor#child_spec`) documentation for more info.\n\n  Default is `permanent` for the agent and `transient` for the manager.\n\n- **`db_init_error() = terminate | create | create_db_and_dir`{: #db_init_error }** - Defines what to do if the agent is unable to open an existing database\n  file. `terminate` means that the agent/manager will terminate, `create` means\n  that the agent/manager will remove the faulty file(s) and create new ones, and\n  `create_db_and_dir` means that the agent/manager will create the database file\n  along with any missing parent directories for the database file.\n\n  Default is `terminate`.\n\n- **`priority() = atom()  `{: #prio }** - Defines the Erlang priority\n  for all SNMP processes.\n\n  Default is `normal`.\n\n- **`versions() = [version()]  `{: #versions }** -\n  `version() = v1 | v2 | v3`\n\n  Which SNMP versions shall be accepted/used.\n\n  Default is `[v1,v2,v3]`.\n\n- **`verbosity() = silence | info | log | debug | trace  `{: #verbosity }** - Verbosity for a SNMP process. This specifies now much debug info is\n  printed.\n\n  Default is `silence`.\n\n- **`bind_to() = bool()  `{: #bind_to }** - If `true`, net_if binds to\n  the IP address. If `false`, net_if listens on any IP address on the host where\n  it is running.\n\n  Default is `false`.\n\n- **`no_reuse() = bool()  `{: #no_reuse }** - If `true`, net_if does\n  not specify that the IP and port address should be reusable. If `false`, the\n  address is set to reusable.\n\n  Default is `false`.\n\n- **`recbuf() = integer()  `{: #recbuf }** - Receive buffer size.\n\n  Default value is defined by `gen_udp`.\n\n- **`sndbuf() = integer()  `{: #sndbuf }** - Send buffer size.\n\n  Default value is defined by `gen_udp`.\n\n- **`extra_socket_options() = list()  `{: #extra_sock_opts }** - A list\n  of arbitrary socket options.\n\n  This list is not inspected by snmp (other then checking that its a list). Its\n  the users responsibility to ensure that these are valid options and does not\n  conflict with the \"normal\" options.\n\n  Default is `[]`.\n\n- **`inet_backend() = inet | socket  `{: #inet_backend }** - Choose the\n  inet-backend.\n\n  This option make it possible to use net_if (gen_udp) with a different\n  inet-backend ('inet' or 'socket').\n\n  Default is `inet`.\n\n- **`note_store() = [note_store_opt()]  `{: #note_store }** -\n  `note_store_opt() = {timeout, note_store_timeout()} | {verbosity, verbosity()}`\n\n  Specifies the options for the SNMP note store.\n\n  For defaults see the options in `note_store_opt()`.\n\n- **`note_store_timeout() = integer()  `{: #ns_timeout }** - Note\n  cleanup time. When storing a note in the note store, each note is given\n  lifetime. Every `timeout` the note_store process performs a GC to remove the\n  expired note's. Time in milli-seconds.\n\n  Default is `30000`.\n\n- **`audit_trail_log() [audit_trail_log_opt()]  `{: #audit_trail_log }** -\n  `audit_trail_log_opt() = {type, atl_type()} | {dir, atl_dir()} | {size, atl_size()} | {repair, atl_repair()} | {seqno, atl_seqno()}`\n\n  If present, this option specifies the options for the _audit trail logging_.\n  The `disk_log` module is used to maintain a wrap log. If present, the `dir`\n  and `size` options are mandatory.\n\n  If not present, audit trail logging is not used.\n\n- **`atl_type() = read | write | read_write  `{: #atl_type }** -\n  Specifies what type of an audit trail log should be used. The effect of the\n  type is actually different for the the agent and the manager.\n\n  For the agent:\n\n  - If `write` is specified, only set requests are logged.\n  - If `read` is specified, only get requests are logged.\n  - If `read_write`, all requests are logged.\n\n  For the manager:\n\n  - If `write` is specified, only sent messages are logged.\n  - If `read` is specified, only received messages are logged.\n  - If `read_write`, both outgoing and incoming messages are logged.\n\n  Default is `read_write`.\n\n- **`atl_dir = dir()  `{: #atl_dir }** - Specifies where the audit\n  trail log should be stored.\n\n  If `audit_trail_log` specifies that logging should take place, this parameter\n  _must_ be defined.\n\n- **`atl_size() = {integer(), integer()}  `{: #atl_size }** -\n  Specifies the size of the audit trail log. This parameter is sent to\n  `disk_log`.\n\n  If `audit_trail_log` specifies that logging should take place, this parameter\n  _must_ be defined.\n\n- **`atl_repair() = true | false | truncate | snmp_repair  `{: #atl_repair }** - Specifies if and how the audit trail log shall be repaired\n  when opened. Unless this parameter has the value `snmp_repair` it is sent to\n  `disk_log`. If, on the other hand, the value is `snmp_repair`, snmp attempts\n  to handle certain faults on its own. And even if it cannot repair the file, it\n  does not truncate it directly, but instead _moves it aside_ for later off-line\n  analysis.\n\n  Default is `true`.\n\n- **`atl_seqno() = true | false  `{: #atl_seqno }** - Specifies if the\n  audit trail log entries will be (sequence) numbered or not. The range of the\n  sequence numbers are according to RFC 5424, i.e. 1 through 2147483647.\n\n  Default is `false`.","ref":"snmp_config.html#configuring-the-application"},{"type":"extras","title":"Modifying the Configuration Files - Running the application","doc":"To to start the application (agent and/or manager), the configuration files must\nbe modified and there are two ways of doing this. Either edit the files\nmanually, or run the configuration tool as follows.\n\nIf authentication or encryption is used (SNMPv3 only), start the `crypto`\napplication.\n\n```text\n1> snmp:config().\n\nSimple SNMP configuration tool (version 4.0)\n------------------------------------------------\nNote: Non-trivial configurations still has to be\n      done manually. IP addresses may be entered\n      as dront.ericsson.se (UNIX only) or\n      123.12.13.23\n------------------------------------------------\n\nConfigure an agent (y/n)? [y]\n\nAgent system config:\n--------------------\n1. Agent process priority (low/normal/high) [normal]\n2. What SNMP version(s) should be used (1,2,3,1&2,1&2&3,2&3)? [3] 1&2&3\n3. Configuration directory (absolute path)? [/ldisk/snmp] /ldisk/snmp/agent/conf\n4. Config verbosity (silence/info/log/debug/trace)? [silence]\n5. Database directory (absolute path)? [/ldisk/snmp] /ldisk/snmp/agent/db\n6. Mib storage type (ets/dets/mnesia)? [ets]\n7. Target cache verbosity (silence/info/log/debug/trace)? [silence]\n8. Symbolic store verbosity (silence/info/log/debug/trace)? [silence]\n9. Local DB verbosity (silence/info/log/debug/trace)? [silence]\n10. Local DB repair (true/false/force)? [true]\n11. Local DB auto save (infinity/milli seconds)? [5000]\n12. Error report module? [snmpa_error_logger]\n13. Agent type (master/sub)? [master]\n14. Master-agent verbosity (silence/info/log/debug/trace)? [silence] log\n15. Shall the agent re-read the configuration files during startup\n    (and ignore the configuration database) (true/false)? [true]\n16. Multi threaded agent (true/false)? [false] true\n17. Check for duplicate mib entries when installing a mib (true/false)? [false]\n18. Check for duplicate trap names when installing a mib (true/false)? [false]\n19. Mib server verbosity (silence/info/log/debug/trace)? [silence]\n20. Mib server cache (true/false)? [true]\n21. Note store verbosity (silence/info/log/debug/trace)? [silence]\n22. Note store GC timeout? [30000]\n23. Shall the agent use an audit trail log (y/n)? [n] y\n23b. Audit trail log type (write/read_write)? [read_write]\n23c. Where to store the audit trail log? [/ldisk/snmp] /ldisk/snmp/agent/log\n23d. Max number of files? [10]\n23e. Max size (in bytes) of each file? [10240]\n23f. Audit trail log repair (true/false/truncate)? [true]\n24. Which network interface module shall be used? [snmpa_net_if]\n25. Network interface verbosity (silence/info/log/debug/trace)? [silence] log\n25a. Bind the agent IP address (true/false)? [false]\n25b. Shall the agents IP address and port be not reusable (true/false)? [false]\n25c. Agent request limit (used for flow control) (infinity/pos integer)? [infinity] 32\n25d. Receive buffer size of the agent (in bytes) (default/pos integer)? [default]\n25e. Send buffer size of the agent (in bytes) (default/pos integer)? [default]\n25f. Do you wish to specify a network interface filter module (or use default) [default]\n\nAgent snmp config:\n------------------\n1. System name (sysName standard variable) [bmk's agent]\n2. Engine ID (snmpEngineID standard variable) [bmk's engine]\n3. Max message size? [484]\n4. The UDP port the agent listens to. (standard 161) [4000]\n5. IP address for the agent (only used as id\n   when sending traps) [127.0.0.1]\n6. IP address for the manager (only this manager\n   will have access to the agent, traps are sent\n   to this one) [127.0.0.1]\n7. To what UDP port at the manager should traps\n   be sent (standard 162)? [5000]\n8. Do you want a none- minimum- or semi-secure configuration?\n   Note that if you chose v1 or v2, you won't get any security for these\n   requests (none, minimum, semi_des, semi_aes) [minimum]\nmaking sure crypto server is started...\n8b. Give a password of at least length 8. It is used to generate\n    private keys for the configuration:  kalle-anka\n9. Current configuration files will now be overwritten. Ok (y/n)? [y]\n\n- - - - - - - - - - - - -\nInfo: 1. SecurityName \"initial\" has noAuthNoPriv read access\n         and authenticated write access to the \"restricted\"\n         subtree.\n      2. SecurityName \"all-rights\" has noAuthNoPriv read/write\n         access to the \"internet\" subtree.\n      3. Standard traps are sent to the manager.\n      4. Community \"public\" is mapped to security name \"initial\".\n      5. Community \"all-rights\" is mapped to security name \"all-rights\".\nThe following agent files were written: agent.conf, community.conf,\nstandard.conf, target_addr.conf, target_params.conf,\nnotify.conf, vacm.conf and usm.conf\n- - - - - - - - - - - - -\n\nConfigure a manager (y/n)? [y]\n\nManager system config:\n----------------------\n1. Manager process priority (low/normal/high) [normal]\n2. What SNMP version(s) should be used (1,2,3,1&2,1&2&3,2&3)? [3] 1&2&3\n3. Configuration directory (absolute path)? [/ldisk/snmp] /ldisk/snmp/manager/conf\n4. Config verbosity (silence/info/log/debug/trace)? [silence] log\n5. Database directory (absolute path)? [/ldisk/snmp] /ldisk/snmp/manager/db\n6. Database repair (true/false/force)? [true]\n7. Database auto save (infinity/milli seconds)? [5000]\n8. Inform request behaviour (auto/user)? [auto]\n9. Server verbosity (silence/info/log/debug/trace)? [silence] log\n10. Server GC timeout? [30000]\n11. Note store verbosity (silence/info/log/debug/trace)? [silence]\n12. Note store GC timeout? [30000]\n13. Which network interface module shall be used? [snmpm_net_if]\n14. Network interface verbosity (silence/info/log/debug/trace)? [silence] log\n15. Bind the manager IP address (true/false)? [false]\n16. Shall the manager IP address and port be not reusable (true/false)? [false]\n17. Receive buffer size of the manager (in bytes) (default/pos integer)? [default]\n18. Send buffer size of the manager (in bytes) (default/pos integer)? [default]\n19. Shall the manager use an audit trail log (y/n)? [n] y\n19b. Where to store the audit trail log? [/ldisk/snmp] /ldisk/snmp/manager/log\n19c. Max number of files? [10]\n19d. Max size (in bytes) of each file? [10240]\n19e. Audit trail log repair (true/false/truncate)? [true]\n20. Do you wish to assign a default user [yes] or use\n    the default settings [no] (y/n)? [n]\n\nManager snmp config:\n--------------------\n1. Engine ID (snmpEngineID standard variable) [bmk's engine]\n2. Max message size? [484]\n3. IP address for the manager (only used as id\n   when sending requests) [127.0.0.1]\n4. Port number (standard 162)? [5000]\n5. Configure a user of this manager (y/n)? [y]\n5b. User id? kalle\n5c. User callback module? snmpm_user_default\n5d. User (callback) data? [undefined]\n5. Configure a user of this manager (y/n)? [y] n\n6. Configure an agent handled by this manager (y/n)? [y]\n6b. User id? kalle\n6c. Target name? [bmk's agent]\n6d. Version (1/2/3)? [1] 3\n6e. Community string ? [public]\n6f. Engine ID (snmpEngineID standard variable) [bmk's engine]\n6g. IP address for the agent [127.0.0.1]\n6h. The UDP port the agent listens to. (standard 161) [4000]\n6i. Retransmission timeout (infinity/pos integer)? [infinity]\n6j. Max message size? [484]\n6k. Security model (any/v1/v2c/usm)? [any] usm\n6l. Security name? [\"initial\"]\n6m. Security level (noAuthNoPriv/authNoPriv/authPriv)? [noAuthNoPriv] authPriv\n6. Configure an agent handled by this manager (y/n)? [y] n\n7. Configure an usm user handled by this manager (y/n)? [y]\n7a. Engine ID [bmk's engine]\n7b. User name? hobbes\n7c. Security name? [hobbes]\n7d. Authentication protocol (no/sha/md5)? [no] sha\n7e  Authentication [sha] key (length 0 or 20)? [\"\"] [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16, \\\n    17,18,19,20]\n7d. Priv protocol (no/des/aes)? [no] des\n7f  Priv [des] key (length 0 or 16)? [\"\"] 10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25\n7. Configure an usm user handled by this manager (y/n)? [y] n\n8. Current configuration files will now be overwritten. Ok (y/n)? [y]\n\n- - - - - - - - - - - - -\nThe following manager files were written: manager.conf, agents.conf , users.conf and usm.conf\n- - - - - - - - - - - - -\n\n--------------------\nConfiguration directory for system file (absolute path)? [/ldisk/snmp]\nok\n```","ref":"snmp_config.html#modifying-the-configuration-files"},{"type":"extras","title":"Starting the application - Running the application","doc":"Start Erlang with the command:\n\n```text\nerl -config /tmp/snmp/sys\n```\n\nIf authentication or encryption is used (SNMPv3 only), start the `crypto`\napplication. If this step is forgotten, the agent will not start, but report a\n`{config_error,{unsupported_crypto,_}}` error.\n\n```text\n1> application:start(crypto).\nok\n```\n\n```text\n2> application:start(snmp).\nok\n```","ref":"snmp_config.html#starting-the-application"},{"type":"extras","title":"Debugging the application - Running the application","doc":"It is possible to debug every (non-supervisor) process of the application (both\nagent and manager), possibly with the exception of the net_if module(s), which\ncould be supplied by a user of the application). This is done by calling the\n`snmpa:verbosity/2` and `snmpm:verbosity/2` function(s) and/or using\n[configuration parameters](snmp_config.md#configuration_params). The verbosity\nitself has several _levels_: `silence | info | log | debug | trace`. For the\nlowest verbosity `silence`, nothing is printed. The higher the verbosity, the\nmore is printed. Default value is always `silence`.\n\n```c\n3> snmpa:verbosity(master_agent, log).\nok\n5> snmpa:verbosity(net_if, log).\nok\n6>\n%% Example of output from the agent when a get-next-request arrives:\n** SNMP NET-IF LOG:\n   got packet from {147,12,12,12}:5000\n\n** SNMP NET-IF MPD LOG:\n   v1, community: all-rights\n\n** SNMP NET-IF LOG:\n   got pdu from {147,12,12,12}:5000 {pdu, 'get-next-request',\n                                          62612569,noError,0,\n                                          [{varbind,[1,1],'NULL','NULL',1}]}\n\n** SNMP MASTER-AGENT LOG:\n   apply: snmp_generic,variable_func,[get,{sysDescr,persistent}]\n\n** SNMP MASTER-AGENT LOG:\n   returned: {value,\"Erlang SNMP agent\"}\n\n** SNMP NET-IF LOG:\n   reply pdu: {pdu,'get-response',62612569,noError,0,\n                   [{varbind,[1,3,6,1,2,1,1,1,0],\n                             'OCTET STRING',\n                             \"Erlang SNMP agent\",1}]}\n\n** SNMP NET-IF INFO: time in agent: 19711 mysec\n```\n\nOther useful function(s) for debugging the agent are:\n\n- **`snmpa:info/0,1`** - [info](`snmpa:info/0`) is used to retrieve a list of\n  miscellaneous agent information.\n\n- **`snmpa:which_aliasnames/0`** -\n  [which_aliasnames](`snmpa:which_aliasnames/0`) is used to retrieve a list of\n  all alias-names known to the agent.\n\n- **`snmpa:which_tables/0`** - [which_tables](`snmpa:which_tables/0`) is used to\n  retrieve a list of all (MIB) tables known to the agent.\n\n- **`snmpa:which_variables/0`** - [which_variables](`snmpa:which_variables/0`)\n  is used to retrieve a list of all (MIB) variables known to the agent.\n\n- **`snmpa:which_notifications/0`** -\n  [which_notifications](`snmpa:which_notifications/0`) is used to retrieve a\n  list of all (MIB) notifications/traps known to the agent.\n\n- **`snmpa:restart_worker/0,1`** - [restart_worker](`snmpa:restart_worker/0`) is\n  used to restart the worker process of a multi-threaded agent.\n\n- **`snmpa:restart_set_worker/0,1`** -\n  [restart_set_worker](`snmpa:restart_set_worker/0`) is used to restart the\n  set-worker process of a multi-threaded agent.\n\n- **`snmpa_local_db:print/0,1,2`** - For example, this function can show the\n  counters `snmpInPkts` and `snmpOutPkts`.\n\nAnother useful way to debug the agent is to pretty-print the content of all the\ntables and/or variables handled directly by the agent. This can be done by\nsimply calling:\n\n`snmpa:print_mib_info/0`\n\nSee `snmpa:print_mib_info/0`, `snmpa:print_mib_tables/0` or\n`snmpa:print_mib_variables/0` for more info.","ref":"snmp_config.html#debugging-the-application"},{"type":"extras","title":"Definition of Agent Configuration Files","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Definition of Agent Configuration Files\n\nAll configuration data must be included in configuration files that are located\nin the configuration directory. The name of this directory is given in the\n`config_dir` configuration parameter. These files are read at start-up, and are\nused to initialize the SNMPv2-MIB or STANDARD-MIB, SNMP-FRAMEWORK-MIB,\nSNMP-MPD-MIB, SNMP-VIEW-BASED-ACM-MIB, SNMP-COMMUNITY-MIB,\nSNMP-USER-BASED-SM-MIB (adjusted according to SNMP-USM-HMAC-SHA2-MIB),\nSNMP-TARGET-MIB and SNMP-NOTIFICATION-MIB (refer to the\n[Management of the Agent](snmp_agent_funct_descr.md#management) for a\ndescription of the MIBs).\n\nThe files are:\n\n- `agent.conf`: see\n  [Agent Information](snmp_agent_config_files.md#agent_information)\n- `standard.conf`: see\n  [System Information](snmp_agent_config_files.md#system_information)\n- `context.conf`: see [Contexts](snmp_agent_config_files.md#context)\n- `community.conf`: see [Communities](snmp_agent_config_files.md#community)\n- `target_addr.conf`: see\n  [Target Address Definitions](snmp_agent_config_files.md#target_addr)\n- `target_params.conf`: see\n  [Target Parameters Definitions](snmp_agent_config_files.md#target_params)\n- `vacm.conf`: see [MIB Views for VACM](snmp_agent_config_files.md#vacm)\n- `usm.conf`: see [Security data for USM](snmp_agent_config_files.md#usm)\n- `notify.conf`: see [Notify Definitions](snmp_agent_config_files.md#notify)\n\nThe directory where the configuration files are found is given as a parameter to\nthe agent.\n\nThe entry format in all files are Erlang terms, separated by a '_._' and a\n_newline_. In the following sections, the formats of these terms are described.\nComments may be specified as ordinary Erlang comments.\n\nSyntax errors in these files are discovered and reported with the function\n`config_err/2` of the error report module at start-up.\n\n[](){: #agent_information }","ref":"snmp_agent_config_files.html"},{"type":"extras","title":"Agent Information - Definition of Agent Configuration Files","doc":"The agent information should be stored in a file called `agent.conf`.\n\nEach entry is a tuple of size two:\n\n`{AgentVariable, Value}.`\n\n- `AgentVariable` is one of the variables in SNMP-FRAMEWORK-MIB or one of the\n  internal variables `intAgentUDPPort`, which defines which UDP port the agent\n  listens to, or `intAgentTransports`, which defines the transport domains and\n  addresses of the agent.\n- `Value` is the value for the variable.\n\nThe following example shows an `agent.conf` file:\n\n```erlang\n{intAgentUDPPort, 4000}.\n{intAgentTransports,\n [{transportDomainUdpIpv4, {141,213,11,24}},\n  {transportDomainUdpIpv6, {0,0,0,0,0,0,0,1}}]}.\n{snmpEngineID, \"mbj's engine\"}.\n{snmpEngineMaxMessageSize, 484}.\n```\n\nThese are the supported entries and their value types:\n\n```erlang\n      {snmpEngine,               string()}.                     % Mandatory\n      {snmpEngineMaxMessageSize, snmp_framework_mib:max_message_size()}.  % Mandatory\n      {intAgentUDPPort,          inet:port_number()}.                      % Optional\n      {intAgentTransports,       [snmpa_conf:intAgentTransport()]}.   % Mandatory\n```\n\nIf a \"traditional\" transport is specified (without explicit `Kind`, handling\nboth requests and traps) for a transport domain, its _not_ possible to also\nspecify a transport (for that domain) with a specific `Kind`. This is for\nexample, _not_ allowed:\n\n```erlang\n [{transportDomainUdpIpv4, {{141,213,11,24}, 4000}},\n  {transportDomainUdpIpv4, {{141,213,11,24}, 4001}, trap_sender}].\n```\n\nNote that only one transport per kind for each transport domain can be\nconfigured.\n\n`PortInfo` `system` is used to indicate that the 'system' should choose (the way\nport number '0' (zero) is normally used). Port info '0' (zero) cannot be used\nfor this, since it is (internally) used to represent the 'default' port number.\n\nIn the traditional transport entries, when the `Addr` value does not contain a\nport number, the value of `intAgentUDPPort` is used.\n\nNote that the (new) extended transport entries (including `Kind` and `Opts`)\n_must_ specify port-info as they ignore any value specified by\n`intAgentUDPPort`.\n\n`Opts` is the same as for the [net-if](snmp_config.md#agent_ni_opts) process\n_and_ takes precedence (for that transport) if present. The point is that each\ntransport can have its own socket options.\n\nThe value of `snmpEngineID` is a string, which for a deployed agent should have\na very specific structure. See RFC 2271/2571 for details.\n\n> #### Note {: .info }\n>\n> The legacy and intermediate variables `intAgentIpAddress` and\n> `intAgentTransportDomain` are still supported so old `agent.conf` files will\n> work.\n>\n> But they _cannot_ be combined with intAgentTransports.\n\n[](){: #context }","ref":"snmp_agent_config_files.html#agent-information"},{"type":"extras","title":"Contexts - Definition of Agent Configuration Files","doc":"The context information should be stored in a file called `context.conf`. The\ndefault context `\"\"` need not be present.\n\nEach row defines a context in the agent. This information is used in the table\n`vacmContextTable` in the SNMP-VIEW-BASED-ACM-MIB.\n\nEach entry is a term:\n\n`ContextName.`\n\n- `ContextName` is a string.\n\n[](){: #system_information }","ref":"snmp_agent_config_files.html#contexts"},{"type":"extras","title":"System Information - Definition of Agent Configuration Files","doc":"The system information should be stored in a file called `standard.conf`.\n\nEach entry is a tuple of size two:\n\n`{SystemVariable, Value}.`\n\n- `SystemVariable` is one of the variables in the system group, or\n  `snmpEnableAuthenTraps`.\n- `Value` is the value for the variable.\n\nThe following example shows a valid `standard.conf` file:\n\n```erlang\n{sysDescr, \"Erlang SNMP agent\"}.\n{sysObjectID, [1,2,3]}.\n{sysContact, \"(mbj,eklas)@erlang.ericsson.se\"}.\n{sysName, \"test\"}.\n{sysServices, 72}.\n{snmpEnableAuthenTraps, enabled}.\n```\n\nA value must be provided for all variables, which lack default values in the\nMIB.\n\n[](){: #community }","ref":"snmp_agent_config_files.html#system-information"},{"type":"extras","title":"Communities - Definition of Agent Configuration Files","doc":"The community information should be stored in a file called `community.conf`. It\nmust be present if the agent is configured for SNMPv1 or SNMPv2c.\n\nAn SNMP _community_ is a relationship between an SNMP agent and a set of SNMP\nmanagers that defines authentication, access control and proxy characteristics.\n\nThe corresponding table is `snmpCommunityTable` in the SNMP-COMMUNITY-MIB.\n\nEach entry is a term:\n\n`{CommunityIndex, CommunityName, SecurityName, ContextName, TransportTag}.`\n\n- `CommunityIndex` is a non-empty string.\n- `CommunityName` is a string.\n- `SecurityName` is a string.\n- `ContextName` is a string.\n- `TransportTag` is a string.\n\n[](){: #vacm }","ref":"snmp_agent_config_files.html#communities"},{"type":"extras","title":"MIB Views for VACM - Definition of Agent Configuration Files","doc":"The information about MIB Views for VACM should be stored in a file called\n`vacm.conf`.\n\nThe corresponding tables are `vacmSecurityToGroupTable`, `vacmAccessTable` and\n`vacmViewTreeFamilyTable` in the SNMP-VIEW-BASED-ACM-MIB.\n\nEach entry is one of the terms, one entry corresponds to one row in one of the\ntables.\n\n`{vacmSecurityToGroup, SecModel, SecName, GroupName}.`\n\n`{vacmAccess, GroupName, Prefix, SecModel, SecLevel, Match, ReadView, WriteView, NotifyView}.`\n\n`{vacmViewTreeFamily, ViewIndex, ViewSubtree, ViewStatus, ViewMask}.`\n\n- `SecModel` is `any`, `v1`, `v2c`, or `usm`.\n- `SecName` is a string.\n- `GroupName` is a string.\n- `Prefix` is a string.\n- `SecLevel` is `noAuthNoPriv`, `authNoPriv`, or `authPriv`\n- `Match` is `prefix` or `exact`.\n- `ReadView` is a string.\n- `WriteView` is a string.\n- `NotifyView` is a string.\n- `ViewIndex` is an integer.\n- `ViewSubtree` is a list of integer.\n- `ViewStatus` is either `included` or `excluded`\n- `ViewMask` is either `null` or a list of ones and zeros. Ones nominate that an\n  exact match is used for this sub-identifier. Zeros are wild-cards which match\n  any sub-identifier. If the mask is shorter than the sub-tree, the tail is\n  regarded as all ones. `null` is shorthand for a mask with all ones.\n\n[](){: #usm }","ref":"snmp_agent_config_files.html#mib-views-for-vacm"},{"type":"extras","title":"Security data for USM - Definition of Agent Configuration Files","doc":"The information about Security data for USM should be stored in a file called\n`usm.conf`, which must be present if the agent is configured for SNMPv3.\n\nThe corresponding table is `usmUserTable` in the SNMP-USER-BASED-SM-MIB\n(adjusted according to SNMP-USM-HMAC-SHA2-MIB).\n\nEach entry is a term:\n\n`{EngineID, UserName, SecName, Clone, AuthP, AuthKeyC, OwnAuthKeyC, PrivP, PrivKeyC, OwnPrivKeyC, Public, AuthKey, PrivKey}.`\n\n- `EngineID` is a string.\n- `UserName` is a string.\n- `SecName` is a string.\n- `Clone` is `zeroDotZero` or a list of integers.\n- `AuthP` is a `usmNoAuthProtocol`, `usmHMACMD5AuthProtocol`,\n  `usmHMACSHAAuthProtocol`, `usmHMAC128SHA224AuthProtocol`,\n  `usmHMAC192SH256AuthProtocol`, `usmHMAC256SHA384AuthProtocol` or\n  `usmHMAC384SHA512AuthProtocol`.\n- `AuthKeyC` is a string.\n- `OwnAuthKeyC` is a string.\n- `PrivP` is a `usmNoPrivProtocol`, `usmDESPrivProtocol` or\n  `usmAesCfb128Protocol`.\n- `PrivKeyC` is a string.\n- `OwnPrivKeyC` is a string.\n- `Public` is a string.\n- `AuthKey` is a list (of integer). This is the User's secret localized\n  authentication key. It is not visible in the MIB. The length (number of\n  octets) of this key needs to be:\n\n  - 16 if `usmHMACMD5AuthProtocol`.\n  - 20 if `usmHMACSHAAuthProtocol`.\n  - 28 if `usmHMAC128SHA224AuthProtocol`.\n  - 32 if `usmHMAC192SHA256AuthProtocol`.\n  - 48 if `usmHMAC256SHA384AuthProtocol`.\n  - 64 if `usmHMAC384SHA512AuthProtocol`.\n\n- `PrivKey` is a list (of integer). This is the User's secret localized\n  encryption key. It is not visible in the MIB. The length of this key needs to\n  be 16 if `usmDESPrivProtocol` or `usmAesCfb128Protocol` is used.\n\n[](){: #notify }","ref":"snmp_agent_config_files.html#security-data-for-usm"},{"type":"extras","title":"Notify Definitions - Definition of Agent Configuration Files","doc":"The information about Notify Definitions should be stored in a file called\n`notify.conf`.\n\nThe corresponding table is `snmpNotifyTable` in the SNMP-NOTIFICATION-MIB.\n\nEach entry is a term:\n\n`{NotifyName, Tag, Type}.`\n\n- `NotifyName` is a unique non-empty string.\n- `Tag` is a string.\n- `Type` is `trap` or `inform`.\n\n[](){: #target_addr }","ref":"snmp_agent_config_files.html#notify-definitions"},{"type":"extras","title":"Target Address Definitions - Definition of Agent Configuration Files","doc":"The information about Target Address Definitions should be stored in a file\ncalled `target_addr.conf`.\n\nThe corresponding tables are `snmpTargetAddrTable` in the SNMP-TARGET-MIB and\n`snmpTargetAddrExtTable` in the SNMP-COMMUNITY-MIB.\n\nEach entry is a term:\n\n`{TargetName, Domain, Addr, Timeout, RetryCount, TagList, ParamsName, EngineId}.`  \nor  \n`{TargetName, Domain, Addr, Timeout, RetryCount, TagList, ParamsName, EngineId, TMask, MaxMessageSize}.`\n\n- `TargetName` is a unique non-empty string.\n- `Domain` is one of the atoms: `transportDomainUdpIpv4` |\n  `transportDomainUdpIpv6`.\n- `Addr` is either an `IpAddr` or an `{IpAddr, IpPort}` tuple. `IpAddr` is\n  either a regular Erlang/OTP [`ip_address()`](`t:inet:ip_address/0`) or a\n  traditional SNMP integer list, and `IpPort` is an integer.\n\n  If `IpPort` is omitted `162` is used.\n\n- `Timeout` is an integer.\n- `RetryCount` is an integer.\n- `TagList` is a string.\n- `ParamsName` is a string.\n- `EngineId` is a string or the atom `discovery`.\n- `TMask` is specified just as `Addr` or as `[]`. Note in particular that using\n  a list of 6 bytes for IPv4 or 8 words plus 2 bytes for IPv6 are still valid\n  address formats so old configurations will work.\n- `MaxMessageSize` is an integer (default: 2048).\n\nThe old tuple formats with `Ip` address and `Udp` port number found in old\nconfigurations still work.\n\nNote that if `EngineId` has the value `discovery`, the agent cannot send\n`inform` messages to that manager until it has performed the _discovery_ process\nwith that manager.\n\n[](){: #target_params }","ref":"snmp_agent_config_files.html#target-address-definitions"},{"type":"extras","title":"Target Parameters Definitions - Definition of Agent Configuration Files","doc":"The information about Target Parameters Definitions should be stored in a file\ncalled `target_params.conf`.\n\nThe corresponding table is `snmpTargetParamsTable` in the SNMP-TARGET-MIB.\n\nEach entry is a term:\n\n`{ParamsName, MPModel, SecurityModel, SecurityName, SecurityLevel}.`\n\n- `ParamsName` is a unique non-empty string.\n- `MPModel` is `v1`, `v2c` or `v3`\n- `SecurityModel` is `v1`, `v2c`, or `usm`.\n- `SecurityName` is a string.\n- `SecurityLevel` is `noAuthNoPriv`, `authNoPriv` or `authPriv`.","ref":"snmp_agent_config_files.html#target-parameters-definitions"},{"type":"extras","title":"Definition of Manager Configuration Files","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Definition of Manager Configuration Files\n\nConfiguration data may be included in configuration files that is located in the\nconfiguration directory. The name of this directory is given in the `config_dir`\nconfiguration parameter. These files are read at start-up.\n\nThe directory where the configuration files are found is given as a parameter to\nthe manager.\n\nThe entry format in all files are Erlang terms, separated by a '_._' and a\n_newline_. In the following sections, the formats of these terms are described.\nComments may be specified as ordinary Erlang comments.\n\nIf syntax errors are discovered in these files they are reported with the\nfunction `config_err/2` of the [error report module](`m:snmpa_error_report`) at\nstart-up.","ref":"snmp_manager_config_files.html"},{"type":"extras","title":"Manager Information - Definition of Manager Configuration Files","doc":"The manager information should be stored in a file called `manager.conf`.\n\nEach entry is a tuple of size two:\n\n`{Variable, Value}.`\n\n- `Variable` is one of the following:\n\n  - `transports` \\- which defines the transport domains and their addresses for\n    the manager. _Mandatory_\n\n    `Value` is a list of `{Domain, Addr}` tuples or `Domain` atoms.\n\n    - `Domain` is one of `transportDomainUdpIpv4` or `transportDomainUdpIpv6`.\n    - `Addr` is for the currently supported domains either an `IpAddr` or an\n      `{IpAddr, IpPort}` tuple.`IpAddr` is either a regular Erlang/OTP\n      [`ip_address()`](`t:inet:ip_address/0`) or a traditional SNMP integer list\n      and `IpPort` is an integer.\n\n      When `Addr` does not contain a port number, the value of `port` is used.\n\n      When a `Addr` is not specified i.e by using only a `Domain` atom, the\n      host's name is resolved to find the IP address, and the value of `port` is\n      used.\n\n  - `port` \\- which defines which UDP port the manager uses for communicating\n    with agents. _Mandatory_ if `transports` does not define a port number for\n    every transport.\n  - `engine_id` \\- The `SnmpEngineID` as defined in SNMP-FRAMEWORK-MIB.\n    _Mandatory_.\n  - `max_message_size` \\- The `snmpEngineMaxMessageSize` as defined in\n    SNMP-FRAMEWORK-MIB. _Mandatory_.\n\n- `Value` is the value for the variable.\n\nThe legacy and intermediate variables `address` and `domain` are still supported\nso old configurations will work.\n\nThe following example shows a `manager.conf` file:\n\n```erlang\n{transports,       [{transportDomainUdpIpv4, {{141,213,11,24}, 5000}},\n                    {transportDomainUdpIpv6, {{0,0,0,0,0,0,0,1}, 5000}}]}.\n{engine_id,        \"mgrEngine\"}.\n{max_message_size, 484}.\n```\n\nThe value of `engine_id` is a string, which should have a very specific\nstructure. See RFC 2271/2571 for details.","ref":"snmp_manager_config_files.html#manager-information"},{"type":"extras","title":"Users - Definition of Manager Configuration Files","doc":"For each _manager user_, the manager needs some information. This information is\neither added in the `users.conf` config file or by calling the\n[register_user](`snmpm:register_user/4`) function in run-time.\n\nEach row defines a _manager user_ of the manager.\n\nEach entry is a tuple of size four:\n\n`{UserId, UserMod, UserData, DefaultAgentConfig}.`\n\n- `UserId` is any term (used to uniquely identify the user).\n- `UserMod` is the user callback module (atom).\n- `UserData` is any term (passed on to the user when calling the `UserMod`.\n- `DefaultAgentConfig` is a list of default agent config's. These values are\n  used as default values when this user registers agents.","ref":"snmp_manager_config_files.html#users"},{"type":"extras","title":"Agents - Definition of Manager Configuration Files","doc":"The information needed to handle agents should be stored in a file called\n`agents.conf`. It is also possible to add agents in run-time by calling the\n[register_agent](`snmpm:register_agent/3`).\n\nEach entry is a tuple:\n\n`{UserId, TargetName, Comm, Domain, Addr, EngineID, Timeout, MaxMessageSize, Version, SecModel, SecName, SecLevel}.`\n\n- `UserId` is the identity of the _manager user_ responsible for this agent\n  (term).\n- `TargetName` is a _unique_ _non-empty_ string.\n- `Comm` is the community string (string).\n- `Domain` is the transport domain, either `transportDomainUdpIpv4` or\n  `transportDomainUdpIpv6`.\n- `Addr` is the address in the transport domain, either an `{IpAddr, IpPort}`\n  tuple or a traditional SNMP integer list containing port number. `IpAddr` is\n  either a regular Erlang/OTP [`ip_address()`](`t:inet:ip_address/0`) or a\n  traditional SNMP integer list not containing port number, and `IpPort` is an\n  integer.\n- `EngineID` is the engine-id of the agent (string).\n- `Timeout` is re-transmission timeout (`infinity` | integer).\n- `MaxMessageSize` is the max message size for outgoing messages to this agent\n  (integer).\n- `Version` is the version (v1 | v2 | v3).\n- `SecModel` is the security model (any | v1 | v2c | usm).\n- `SecName` is the security name (string).\n- `SecLevel` is security level (noAuthNoPriv | authNoPriv | authPriv).\n\nLegacy configurations using tuples without `Domain` element, as well as with all\n`TDomain`, `Ip` and `Port` elements still work.","ref":"snmp_manager_config_files.html#agents"},{"type":"extras","title":"Security data for USM - Definition of Manager Configuration Files","doc":"The information about Security data for USM should be stored in a file called\n`usm.conf`, which must be present if the manager wishes to use SNMPv3 when\ncommunicating with agents. It is also possible to add usm data in run-time by\ncalling the [register_usm_user](`snmpm:register_usm_user/3`).\n\nThe corresponding table is `usmUserTable` in the SNMP-USER-BASED-SM-MIB\n(adjusted according to SNMP-USM-HMAC-SHA2-MIB).\n\nEach entry is a term:\n\n`{EngineID, UserName, AuthP, AuthKey, PrivP, PrivKey}.`  \n`{EngineID, UserName, SecName, AuthP, AuthKey, PrivP, PrivKey}.`\n\nThe first case is when we have the identity-function (`SecName` = `UserName`).\n\n- `EngineID` is a string.\n- `UserName` is a string.\n- `SecName` is a string.\n- `AuthP` is a `usmNoAuthProtocol`, `usmHMACMD5AuthProtocol`,\n  `usmHMACSHAAuthProtocol`, `usmHMAC128SHA224AuthProtocol`,\n  `usmHMAC192SH256AuthProtocol`, `usmHMAC256SHA384AuthProtocol` or\n  `usmHMAC384SHA512AuthProtocol`.\n- `AuthKey` is a list (of integer). This is the User's secret localized\n  authentication key. It is not visible in the MIB. The length (number of\n  octets) of this key needs to be:\n\n  - 16 if `usmHMACMD5AuthProtocol`.\n  - 20 if `usmHMACSHAAuthProtocol`.\n  - 28 if `usmHMAC128SHA224AuthProtocol`.\n  - 32 if `usmHMAC192SHA256AuthProtocol`.\n  - 48 if `usmHMAC256SHA384AuthProtocol`.\n  - 64 if `usmHMAC384SHA512AuthProtocol`.\n\n- `PrivP` is a `usmNoPrivProtocol`, `usmDESPrivProtocol` or\n  `usmAesCfb128Protocol`.\n- `PrivKey` is a list (of integer). This is the User's secret localized\n  encryption key. It is not visible in the MIB. The length of this key needs to\n  be 16 if `usmDESPrivProtocol` or `usmAesCfb128Protocol` is used.","ref":"snmp_manager_config_files.html#security-data-for-usm"},{"type":"extras","title":"Agent Implementation Example","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Agent Implementation Example\n\nThis _Implementation Example_ section describes how an MIB can be implemented\nwith the SNMP Development Toolkit.\n\nThe example shown can be found in the toolkit distribution.\n\nThe agent is configured with the configuration tool, using default suggestions\nfor everything but the manager node.","ref":"snmp_impl_example_agent.html"},{"type":"extras","title":"MIB - Agent Implementation Example","doc":"The MIB used in this example is called EX1-MIB. It contains two objects, a\nvariable with a name and a table with friends.\n\n```text\nEX1-MIB DEFINITIONS ::= BEGIN\n\n          IMPORTS\n                  experimental   FROM RFC1155-SMI\n                  RowStatus      FROM STANDARD-MIB\n                  DisplayString  FROM RFC1213-MIB\n                  OBJECT-TYPE    FROM RFC-1212\n                  ;\n\n          example1       OBJECT IDENTIFIER ::= { experimental 7 }\n\n          myName OBJECT-TYPE\n              SYNTAX  DisplayString (SIZE (0..255))\n              ACCESS  read-write\n              STATUS  mandatory\n              DESCRIPTION\n                      \"My own name\"\n              ::= { example1 1 }\n\n          friendsTable OBJECT-TYPE\n              SYNTAX  SEQUENCE OF FriendsEntry\n              ACCESS  not-accessible\n              STATUS  mandatory\n              DESCRIPTION\n                      \"A list of friends.\"\n              ::= { example1 4 }\n\n          friendsEntry OBJECT-TYPE\n              SYNTAX  FriendsEntry\n              ACCESS  not-accessible\n              STATUS  mandatory\n              DESCRIPTION\n                      \"\"\n              INDEX   { fIndex }\n              ::= { friendsTable 1 }\n\n          FriendsEntry ::=\n              SEQUENCE {\n                   fIndex\n                      INTEGER,\n                   fName\n                      DisplayString,\n                   fAddress\n                      DisplayString,\n                   fStatus\n                      RowStatus              }\n\n          fIndex OBJECT-TYPE\n              SYNTAX  INTEGER\n              ACCESS  not-accessible\n              STATUS  mandatory\n               DESCRIPTION\n                      \"number of friend\"\n              ::= { friendsEntry 1 }\n\n          fName OBJECT-TYPE\n              SYNTAX  DisplayString (SIZE (0..255))\n              ACCESS  read-write\n              STATUS  mandatory\n              DESCRIPTION\n                      \"Name of friend\"\n              ::= { friendsEntry 2 }\n\n          fAddress OBJECT-TYPE\n              SYNTAX  DisplayString (SIZE (0..255))\n              ACCESS  read-write\n              STATUS  mandatory\n              DESCRIPTION\n                      \"Address of friend\"\n              ::= { friendsEntry 3 }\n\n           fStatus OBJECT-TYPE\n              SYNTAX      RowStatus\n              ACCESS      read-write\n              STATUS      mandatory\n              DESCRIPTION\n                      \"The status of this conceptual row.\"\n              ::= { friendsEntry 4 }\n\n          fTrap TRAP-TYPE\n              ENTERPRISE  example1\n              VARIABLES   { myName, fIndex }\n              DESCRIPTION\n                      \"This trap is sent when something happens to\n                      the friend specified by fIndex.\"\n              ::= 1\nEND\n```","ref":"snmp_impl_example_agent.html#mib"},{"type":"extras","title":"Default Implementation - Agent Implementation Example","doc":"Without writing any instrumentation functions, we can compile the MIB and use\nthe default implementation of it. Recall that MIBs imported by \"EX1-MIB.mib\"\nmust be present and compiled in the current directory\n(\"./STANDARD-MIB.bin\",\"./RFC1213-MIB.bin\") when compiling.\n\n```erlang\nunix> erl -config ./sys\n1> application:start(snmp).\nok\n2> snmpc:compile(\"EX1-MIB\").\nNo accessfunction for 'friendsTable', using default.\nNo accessfunction for 'myName', using default.\n{ok, \"EX1-MIB.bin\"}\n3> snmpa:load_mibs(snmp_master_agent, [\"EX1-MIB\"]).\nok\n```\n\nThis MIB is now loaded into the agent, and a manager can ask questions. As an\nexample of this, we start another Erlang system and the simple Erlang manager in\nthe toolkit:\n\n```erlang\n1> snmp_test_mgr:start_link([{agent,\"dront.ericsson.se\"},{community,\"all-rights\"},\n %% making it understand symbolic names: {mibs,[\"EX1-MIB\",\"STANDARD-MIB\"]}]).\n{ok, <0.89.0>}\n%% a get-next request with one OID.\n2> snmp_test_mgr:gn([[1,3,6,1,3,7]]).\nok\n* Got PDU:\n[myName,0] = []\n%% A set-request (now using symbolic names for convenience)\n3> snmp_test_mgr:s([{[myName,0], \"Martin\"}]).\nok\n* Got PDU:\n[myName,0] = \"Martin\"\n%% Try the same get-next request again\n4> snmp_test_mgr:gn([[1,3,6,1,3,7]]).\nok\n* Got PDU:\n[myName,0] = \"Martin\"\n%% ... and we got the new value.\n%% you can event do row operations. How to add a row:\n5> snmp_test_mgr:s([{[fName,0], \"Martin\"}, {[fAddress,0],\"home\"}, {[fStatus,0],4}]).\n %% createAndGo\nok\n* Got PDU:\n[fName,0] = \"Martin\"\n[fAddress,0] = \"home\"\n[fStatus,0] = 4\n6> snmp_test_mgr:gn([[myName,0]]).\nok\n* Got PDU:\n[fName,0] = \"Martin\"\n7> snmp_test_mgr:gn().\nok\n* Got PDU:\n[fAddress,0] = \"home\"\n8> snmp_test_mgr:gn().\nok\n* Got PDU:\n[fStatus,0] = 1\n9>\n```","ref":"snmp_impl_example_agent.html#default-implementation"},{"type":"extras","title":"Manual Implementation - Agent Implementation Example","doc":"The following example shows a \"manual\" implementation of the EX1-MIB in Erlang.\nIn this example, the values of the objects are stored in an Erlang server. The\nserver has a 2-tuple as loop data, where the first element is the value of\nvariable `myName`, and the second is a sorted list of rows in the table\n`friendsTable`. Each row is a 4-tuple.\n\n> #### Note {: .info }\n>\n> There are more efficient ways to create tables manually, i.e. to use the\n> module `snmp_index`.","ref":"snmp_impl_example_agent.html#manual-implementation"},{"type":"extras","title":"Code - Agent Implementation Example","doc":"```erlang\n-module(ex1).\n-author('dummy@flop.org').\n%% External exports\n-export([start/0, my_name/1, my_name/2, friends_table/3]).\n%% Internal exports\n-export([init/0]).\n-define(status_col, 4).\n-define(active, 1).\n-define(notInService, 2).\n-define(notReady, 3).\n-define(createAndGo, 4).   % Action; written, not read\n-define(createAndWait, 5). % Action; written, not read\n-define(destroy, 6).       % Action; written, not read\nstart() ->\n    spawn(ex1, init, []).\n%%----------------------------------------------------------------\n%% Instrumentation function for variable myName.\n%% Returns: (get) {value, Name}\n%%          (set) noError\n%%----------------------------------------------------------------\nmy_name(get) ->\n    ex1_server ! {self(), get_my_name},\n    Name = wait_answer(),\n    {value, Name}.\nmy_name(set, NewName) ->\n    ex1_server ! {self(), {set_my_name, NewName}},\n    noError.\n%%----------------------------------------------------------------\n%% Instrumentation function for table friendsTable.\n%%----------------------------------------------------------------\nfriends_table(get, RowIndex, Cols) ->\n    case get_row(RowIndex) of\n   {ok, Row} ->\n        get_cols(Cols, Row);\n   _  ->\n        {noValue, noSuchInstance}\n    end;\nfriends_table(get_next, RowIndex, Cols) ->\n    case get_next_row(RowIndex) of\n   {ok, Row} ->\n        get_next_cols(Cols, Row);\n   _  ->\n       case get_next_row([]) of\n     {ok, Row} ->\n         % Get next cols from first row.\n         NewCols = add_one_to_cols(Cols),\n         get_next_cols(NewCols, Row);\n     _  ->\n        end_of_table(Cols)\n        end\n    end;\n%%----------------------------------------------------------------\n%% If RowStatus is set, then:\n%%    *) If set to destroy, check that row does exist\n%%    *) If set to createAndGo, check that row does not exist AND\n%%         that all columns are given values.\n%%    *) Otherwise, error (for simplicity).\n%% Otherwise, row is modified; check that row exists.\n%%----------------------------------------------------------------\nfriends_table(is_set_ok, RowIndex, Cols) ->\n    RowExists =\n   case get_row(RowIndex) of\n        {ok, _Row} -> true;\n       _ -> false\n   end,\n    case is_row_status_col_changed(Cols) of\n   {true, ?destroy} when RowExists == true ->\n        {noError, 0};\n   {true, ?createAndGo} when RowExists == false,\n                                 length(Cols) == 3 ->\n        {noError, 0};\n   {true, _} ->\n       {inconsistentValue, ?status_col};\n   false when RowExists == true ->\n        {noError, 0};\n   _ ->\n        [{Col, _NewVal} | _Cols] = Cols,\n       {inconsistentName, Col}\n      end;\nfriends_table(set, RowIndex, Cols) ->\n    case is_row_status_col_changed(Cols) of\n   {true, ?destroy} ->\n        ex1_server ! {self(), {delete_row, RowIndex}};\n   {true, ?createAndGo} ->\n       NewRow = make_row(RowIndex, Cols),\n        ex1_server ! {self(), {add_row, NewRow}};\n   false ->\n       {ok, Row} = get_row(RowIndex),\n        NewRow = merge_rows(Row, Cols),\n    ex1_server ! {self(), {delete_row, RowIndex}},\n       ex1_server ! {self(), {add_row, NewRow}}\n   end,\n    {noError, 0}.\n\n%%----------------------------------------------------------------\n%% Make a list of {value, Val} of the Row and Cols list.\n%%----------------------------------------------------------------\nget_cols([Col | Cols], Row) ->\n    [{value, element(Col, Row)} | get_cols(Cols, Row)];\nget_cols([], _Row) ->\n    [].\n%%----------------------------------------------------------------\n%% As get_cols, but the Cols list may contain invalid column\n%% numbers. If it does, we must find the next valid column,\n%% or return endOfTable.\n%%----------------------------------------------------------------\nget_next_cols([Col | Cols], Row) when Col < 2 ->\n    [{[2, element(1, Row)], element(2, Row)} |\n     get_next_cols(Cols, Row)];\nget_next_cols([Col | Cols], Row) when Col > 4 ->\n    [endOfTable |\n     get_next_cols(Cols, Row)];\nget_next_cols([Col | Cols], Row) ->\n    [{[Col, element(1, Row)], element(Col, Row)} |\n     get_next_cols(Cols, Row)];\nget_next_cols([], _Row) ->\n    [].\n%%----------------------------------------------------------------\n%% Make a list of endOfTable with as many elems as Cols list.\n%%----------------------------------------------------------------\nend_of_table([Col | Cols]) ->\n    [endOfTable | end_of_table(Cols)];\nend_of_table([]) ->\n    [].\nadd_one_to_cols([Col | Cols]) ->\n    [Col + 1 | add_one_to_cols(Cols)];\nadd_one_to_cols([]) ->\n    [].\nis_row_status_col_changed(Cols) ->\n    case lists:keysearch(?status_col, 1, Cols) of\n   {value, {?status_col, StatusVal}} ->\n        {true, StatusVal};\n   _ -> false\n    end.\nget_row(RowIndex) ->\n    ex1_server ! {self(), {get_row, RowIndex}},\n    wait_answer().\nget_next_row(RowIndex) ->\n    ex1_server ! {self(), {get_next_row, RowIndex}},\n    wait_answer().\nwait_answer() ->\n    receive\n   {ex1_server, Answer} ->\n     Answer\n    end.\n%%%---------------------------------------------------------------\n%%% Server code follows\n%%%---------------------------------------------------------------\ninit() ->\n    register(ex1_server, self()),\n    loop(\"\", []).\n\nloop(MyName, Table) ->\n    receive\n   {From, get_my_name} ->\n        From ! {ex1_server, MyName},\n       loop(MyName, Table);\n   {From, {set_my_name, NewName}} ->\n        loop(NewName, Table);\n   {From, {get_row, RowIndex}} ->\n       Res = table_get_row(Table, RowIndex),\n       From ! {ex1_server, Res},\n       loop(MyName, Table);\n   {From, {get_next_row, RowIndex}} ->\n       Res = table_get_next_row(Table, RowIndex),\n        From ! {ex1_server, Res},\n       loop(MyName, Table);\n   {From, {delete_row, RowIndex}} ->\n    NewTable = table_delete_row(Table, RowIndex),\n       loop(MyName, NewTable);\n   {From, {add_row, NewRow}} ->\n       NewTable = table_add_row(Table, NewRow),\n       loop(MyName, NewTable)\n    end.\n%%%---------------------------------------------------------------\n%%% Functions for table operations. The table is represented as\n%%% a list of rows.\n%%%---------------------------------------------------------------\ntable_get_row([{Index, Name, Address, Status} | _], [Index]) ->\n    {ok, {Index, Name, Address, Status}};\ntable_get_row([H | T], RowIndex) ->\n    table_get_row(T, RowIndex);\ntable_get_row([], _RowIndex) ->\n    no_such_row.\ntable_get_next_row([Row | T], []) ->\n    {ok, Row};\ntable_get_next_row([Row | T], [Index | _])\nwhen element(1, Row) > Index ->\n    {ok, Row};\ntable_get_next_row([Row | T], RowIndex) ->\n    table_get_next_row(T, RowIndex);\ntable_get_next_row([], RowIndex) ->\n    endOfTable.\ntable_delete_row([{Index, _, _, _} | T], [Index]) ->\n    T;\ntable_delete_row([H | T], RowIndex) ->\n    [H | table_delete_row(T, RowIndex)];\ntable_delete_row([], _RowIndex) ->\n    [].\ntable_add_row([Row | T], NewRow)\n  when element(1, Row) > element(1, NewRow) ->\n    [NewRow, Row | T];\ntable_add_row([H | T], NewRow) ->\n    [H | table_add_row(T, NewRow)];\ntable_add_row([], NewRow) ->\n    [NewRow].\nmake_row([Index], [{2, Name}, {3, Address} | _]) ->\n    {Index, Name, Address, ?active}.\nmerge_rows(Row, [{Col, NewVal} | T]) ->\n    merge_rows(setelement(Col, Row, NewVal), T);\nmerge_rows(Row, []) ->\n    Row.\n```","ref":"snmp_impl_example_agent.html#code"},{"type":"extras","title":"Association File - Agent Implementation Example","doc":"The association file `EX1-MIB.funcs` for the real implementation looks as\nfollows:\n\n```erlang\n{myName, {ex1, my_name, []}}.\n{friendsTable, {ex1, friends_table, []}}.\n```","ref":"snmp_impl_example_agent.html#association-file"},{"type":"extras","title":"Transcript - Agent Implementation Example","doc":"To use the real implementation, we must recompile the MIB and load it into the\nagent.\n\n```erlang\n1> application:start(snmp).\nok\n2> snmpc:compile(\"EX1-MIB\").\n{ok,\"EX1-MIB.bin\"}\n3> snmpa:load_mibs(snmp_master_agent, [\"EX1-MIB\"]).\nok\n4> ex1:start().\n<0.115.0>\n%% Now all requests operates on this \"real\" implementation.\n%% The output from the manager requests will *look* exactly the\n%% same as for the default implementation.\n```","ref":"snmp_impl_example_agent.html#transcript"},{"type":"extras","title":"Trap Sending - Agent Implementation Example","doc":"How to send a trap by sending the `fTrap` from the master agent is shown in this\nsection. The master agent has the MIB `EX1-MIB` loaded, where the trap is\ndefined. This trap specifies that two variables should be sent along with the\ntrap, `myName` and `fIndex`. `fIndex` is a table column, so we must provide its\nvalue and the index for the row in the call to `snmpa:send_notification2/3`. In the\nexample below, we assume that the row in question is indexed by 2 (the row with\n`fIndex` 2).\n\nwe use a simple Erlang SNMP manager, which can receive traps.\n\n```erlang\n[MANAGER]\n1> snmp_test_mgr:start_link([{agent,\"dront.ericsson.se\"},{community,\"public\"}\n %% does not have write-access\n1>{mibs,[\"EX1-MIB\",\"STANDARD-MIB\"]}]).\n{ok, <0.100.0>}\n2> snmp_test_mgr:s([{[myName,0], \"Klas\"}]).\nok\n* Got PDU:\nReceived a trap:\n      Generic: 4       %% authenticationFailure\n   Enterprise: [iso,2,3]\n     Specific: 0\n   Agent addr: [123,12,12,21]\n    TimeStamp: 42993\n2>\n[AGENT]\n3> SendOpts = [{receiver, no_receiver}, {varbinds, [{fIndex,[2],2}]}, {name, \"standard trap\"}, {context, \"\"}],\n4> snmpa:send_notification2(snmp_master_agent, fTrap, SendOpts).\n[MANAGER]\n2>\n* Got PDU:\nReceived a trap:\n      Generic: 6\n   Enterprise: [example1]\n     Specific: 1\n   Agent addr: [123,12,12,21]\n    TimeStamp: 69649\n[myName,0] = \"Martin\"\n[fIndex,2] = 2\n2>\n```","ref":"snmp_impl_example_agent.html#trap-sending"},{"type":"extras","title":"Manager Implementation Example","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Manager Implementation Example\n\nThis _Implementation Example_ section describes how a simple manager can be\nimplemented with the SNMP Development Toolkit.\n\nThe example shown, _ex2_, can be found in the toolkit distribution.\n\nThis example has two functions:\n\n- A simple example of how to use the manager component of the SNMP Development\n  Toolkit.\n- A simple example of how to write agent test cases, using the new manager.","ref":"snmp_impl_example_manager.html"},{"type":"extras","title":"The example manager - Manager Implementation Example","doc":"The example manager, `snmp_ex2_manager`, is a simple example of how to implement\nan snmp manager using the manager component of the SNMP Development Toolkit.\n\nThe module exports the following functions:\n\n- start_link/0, start_link/1\n- stop/0\n- agent/2, agent/3\n- sync_get/2, sync_get/3\n- sync_get_next/2, sync_get_next/3\n- sync_get_bulk/4, sync_get_bulk/5\n- sync_set/2, sync_set/3\n- oid_to_name/1\n\nThis module is also used by the test module described in the next section.","ref":"snmp_impl_example_manager.html#the-example-manager"},{"type":"extras","title":"A simple standard test - Manager Implementation Example","doc":"This simple standard test, `snmp_ex2_simple_standard_test`, a module which,\nusing the `snmp_ex2_manager` described in the previous section, implements a\nsimple agent test utility.","ref":"snmp_impl_example_manager.html#a-simple-standard-test"},{"type":"extras","title":"Instrumentation Functions","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Instrumentation Functions\n\nA user-defined instrumentation function for each object attaches the managed\nobjects to real resources. This function is called by the agent on a `get` or\n`set` operation. The function could read some hardware register, perform a\ncalculation, or whatever is necessary to implement the semantics associated with\nthe conceptual variable. These functions must be written both for scalar\nvariables and for tables. They are specified in the association file, which is a\ntext file. In this file, the `OBJECT IDENTIFIER`, or symbolic name for each\nmanaged object, is associated with an Erlang tuple `{Module,``Function`,\n`ListOfExtraArguments}`.\n\nWhen a managed object is referenced in an SNMP operation, the associated\n`{Module, Function, ListOfExtraArguments}` is called. The function is applied to\nsome standard arguments (for example, the operation type) and the extra\narguments supplied by the user.\n\nInstrumentation functions must be written for `get` and `set` for scalar\nvariables and tables, and for `get-next` for tables only. The `get-bulk`\noperation is translated into a series of calls to `get-next`.","ref":"snmp_instr_functions.html"},{"type":"extras","title":"Instrumentation Functions - Instrumentation Functions","doc":"The following sections describe how the instrumentation functions should be\ndefined in Erlang for the different operations. In the following, `RowIndex` is\na list of key values for the table, and `Column` is a column number.\n\nThese functions are described in detail in\n[Definition of Instrumentation Functions](snmp_def_instr_functions.md).","ref":"snmp_instr_functions.html#instrumentation-functions"},{"type":"extras","title":"New / Delete Operations - Instrumentation Functions","doc":"For scalar variables:\n\n```c\nvariable_access(new [, ExtraArg1, ...])\nvariable_access(delete [, ExtraArg1, ...])\n```\n\nFor tables:\n\n```text\ntable_access(new [, ExtraArg1, ...])\ntable_access(delete [, ExtraArg1, ...])\n```\n\nThese functions are called for each object in an MIB when the MIB is unloaded or\nloaded, respectively.","ref":"snmp_instr_functions.html#new-delete-operations"},{"type":"extras","title":"Get Operation - Instrumentation Functions","doc":"For scalar variables:\n\n```text\nvariable_access(get [, ExtraArg1, ...])\n```\n\nFor tables:\n\n```text\ntable_access(get,RowIndex,Cols [,ExtraArg1, ...])\n```\n\n`Cols` is a list of `Column`. The agent will sort incoming variables so that all\noperations on one row (same index) will be supplied at the same time. The reason\nfor this is that a database normally retrieves information row by row.\n\nThese functions must return the current values of the associated variables.","ref":"snmp_instr_functions.html#get-operation"},{"type":"extras","title":"Set Operation - Instrumentation Functions","doc":"For scalar variables:\n\n```text\nvariable_access(set, NewValue [, ExtraArg1, ...])\n```\n\nFor tables:\n\n```text\ntable_access(set, RowIndex, Cols [, ExtraArg1,..])\n```\n\n`Cols` is a list of tuples `{Column, NewValue}`.\n\nThese functions returns `noError` if the assignment was successful, otherwise an\nerror code.","ref":"snmp_instr_functions.html#set-operation"},{"type":"extras","title":"Is-set-ok Operation - Instrumentation Functions","doc":"As a complement to the `set` operation, it is possible to specify a test\nfunction. This function has the same syntax as the set operation above, except\nthat the first argument is `is_set_ok` instead of `set`. This function is called\nbefore the variable is set. Its purpose is to ensure that it is permissible to\nset the variable to the new value.\n\n```text\nvariable_access(is_set_ok, NewValue [, ExtraArg1, ...])\n```\n\nFor tables:\n\n```text\ntable_access(set, RowIndex, Cols [, ExtraArg1,..])\n```\n\n`Cols` is a list of tuples `{Column, NewValue}`.","ref":"snmp_instr_functions.html#is-set-ok-operation"},{"type":"extras","title":"Undo Operation - Instrumentation Functions","doc":"A function which has been called with `is_set_ok` will be called again, either\nwith `set` if there was no error, or with `undo`, if an error occurred. In this\nway, resources can be reserved in the `is_set_ok` operation, released in the\n`undo` operation, or made permanent in the `set` operation.\n\n```text\nvariable_access(undo, NewValue [, ExtraArg1, ...])\n```\n\nFor tables:\n\n```text\ntable_access(set, RowIndex, Cols [, ExtraArg1,..])\n```\n\n`Cols` is a list of tuples `{Column, NewValue}`.","ref":"snmp_instr_functions.html#undo-operation"},{"type":"extras","title":"GetNext Operation - Instrumentation Functions","doc":"The GetNext Operation operation should only be defined for tables since the\nagent can find the next instance of plain variables in the MIB and call the\ninstrumentation with the `get` operation.\n\n```text\ntable_access(get_next, RowIndex, Cols [, ExtraArg1, ...])\n```\n\n`Cols` is a list of integers, all greater than or equal to zero. This indicates\nthat the instrumentation should find the next accessible instance. This function\nreturns the tuple `{NextOid, NextValue}`, or `endOfTable`. `NextOid` should be\nthe lexicographically next accessible instance of a managed object in the table.\nIt should be a list of integers, where the first integer is the column, and the\nrest of the list is the indices for the next row. If `endOfTable` is returned,\nthe agent continues to search for the next instance among the other variables\nand tables.\n\n`RowIndex` may be an empty list, an incompletely specified row index, or the\nindex for an unspecified row.\n\nThis operation is best described with an example.\n\n#### GetNext Example\n\nA table called `myTable` has five columns. The first two are keys (not\naccessible), and the table has three rows. The instrumentation function for this\ntable is called `my_table`.\n\n[](){: #getnext1 }\n\n![Contents of my_table](assets/getnext1.gif \"Contents of my_table\")\n\n> #### Note {: .info }\n>\n> N/A means not accessible.\n\nThe manager issues the following `getNext` request:\n\n```text\ngetNext{ myTable.myTableEntry.3.1.1,\n         myTable.myTableEntry.5.1.1 }\n```\n\nSince both operations involve the 1.1 index, this is transformed into one call\nto `my_table`:\n\n```text\nmy_table(get_next, [1, 1], [3, 5])\n```\n\nIn this call, `[1, 1]` is the `RowIndex`, where key 1 has value 1, and key 2 has\nvalue 1, and `[3, 5]` is the list of requested columns. The function should now\nreturn the lexicographically next elements:\n\n```text\n[{[3, 1, 2], d}, {[5, 1, 2], f}]\n```\n\nThis is illustrated in the following table:\n\n[](){: #getnext2 }\n\n![GetNext from [3,1,1] and [5,1,1].](assets/getnext2.gif \"GetNext from [3,1,1] and [5,1,1].\")\n\nThe manager now issues the following `getNext` request:\n\n```text\ngetNext{ myTable.myTableEntry.3.2.1,\n         myTable.myTableEntry.5.2.1 }\n```\n\nThis is transformed into one call to `my_table`:\n\n```text\nmy_table(get_next, [2, 1], [3, 5])\n```\n\nThe function should now return:\n\n```text\n[{[4, 1, 1], b}, endOfTable]\n```\n\nThis is illustrated in the following table:\n\n[](){: #getnext3 }\n\n![GetNext from [3,2,1] and [5,2,1].](assets/getnext3.gif \"GetNext from [3,2,1] and [5,2,1].\")\n\n\nThe manager now issues the following `getNext` request:\n\n```text\ngetNext{ myTable.myTableEntry.3.1.2,\n         myTable.myTableEntry.4.1.2 }\n```\n\nThis will be transform into one call to `my_table`:\n\n```text\nmy_table(get_next, [1, 2], [3, 4])\n```\n\nThe function should now return:\n\n```erlang\n[{[3, 2, 1], g}, {[5, 1, 1], c}]\n```\n\nThis is illustrated in the following table:\n\n[](){: #getnext4 }\n\n![GetNext from [3,1,2] and [4,1,2].](assets/getnext4.gif \"GetNext from [3,1,2] and [4,1,2].\")\n\n\nThe manager now issues the following `getNext` request:\n\n```text\ngetNext{ myTable.myTableEntry,\n         myTable.myTableEntry.1.3.2 }\n```\n\nThis will be transform into two calls to `my_table`:\n\n```erlang\nmy_table(get_next, [], [0]) and\nmy_table(get_next, [3, 2], [1])\n```\n\nThe function should now return:\n\n```text\n[{[3, 1, 1], a}] and\n[{[3, 1, 1], a}]\n```\n\nIn both cases, the first accessible element in the table should be returned. As\nthe key columns are not accessible, this means that the third column is the\nfirst row.\n\n> #### Note {: .info }\n>\n> Normally, the functions described above behave exactly as shown, but they are\n> free to perform other actions. For example, a get-request may have side\n> effects such as setting some other variable, perhaps a global `lastAccessed`\n> variable.","ref":"snmp_instr_functions.html#getnext-operation"},{"type":"extras","title":"Using the ExtraArgument - Instrumentation Functions","doc":"The `ListOfExtraArguments` can be used to write generic functions. This list is\nappended to the standard arguments for each function. Consider two read-only\nvariables for a device, `ipAdr` and `name` with object identifiers 1.1.23.4 and\n1.1.7 respectively. To access these variables, one could implement the two\nErlang functions `ip_access` and `name_access`, which will be in the MIB. The\nfunctions could be specified in a text file as follows:\n\n```erlang\n{ipAdr, {my_module, ip_access, []}}.\n% Or using the oid syntax for 'name'\n{[1,1,7], {my_module, name_access, []}}.\n```\n\nThe `ExtraArgument` parameter is the empty list. For example, when the agent\nreceives a get-request for the `ipAdr` variable, a call will be made to\n`ip_access(get)`. The value returned by this function is the answer to the\nget-request.\n\nIf `ip_access` and `name_access` are implemented similarly, we could write a\n`generic_access` function using the `ListOfExtraArguments`:\n\n```erlang\n{ipAdr, {my_module, generic_access, ['IPADR']}}.\n% The mnemonic 'name' is more convenient than 1.1.7\n{name, {my_module, generic_access, ['NAME']}}.\n```\n\nWhen the agent receives the same get-request as above, a call will be made to\n`generic_access(get, `'`IPADR')`.\n\nYet another possibility, closer to the hardware, could be:\n\n```erlang\n{ipAdr, {my_module, generic_access, [16#2543]}}.\n{name, {my_module, generic_access, [16#A2B3]}}.\n```","ref":"snmp_instr_functions.html#using-the-extraargument"},{"type":"extras","title":"Default Instrumentation - Instrumentation Functions","doc":"[](){: #snmp_3 }\n\nWhen the MIB definition work is finished, there are two major issues left.\n\n- Implementing the MIB\n- Implementing a Manager Application.\n\nImplementing an MIB can be a tedious task. Most probably, there is a need to\ntest the agent before all tables and variables are implemented. In this case,\nthe default instrumentation functions are useful. The toolkit can generate\ndefault instrumentation functions for variables as well as for tables.\nConsequently, a running prototype agent, which can handle `set`, `get`,\n`get-next` and table operations, is generated without any programming.\n\nThe agent stores the values in an internal volatile database, which is based on\nthe standard module `ets`. However, it is possible to let the MIB compiler\ngenerate functions which use an internal, persistent database, or the Mnesia\nDBMS. Refer to the Mnesia User Guide and the Reference Manual, section SNMP,\nmodule `snmp_generic` for more information.\n\nWhen parts of the MIB are implemented, you recompile it and continue on by using\ndefault functions. With this approach, the SNMP agent can be developed\nincrementally.\n\nThe default instrumentation allows the application on the manager side to be\ndeveloped and tested simultaneously with the agent. As soon as the ASN.1 file is\ncompleted, let the MIB compiler generate a default implementation and develop\nthe management application from this.","ref":"snmp_instr_functions.html#default-instrumentation"},{"type":"extras","title":"Table Operations - Instrumentation Functions","doc":"The generation of default functions for tables works for tables which use the\n`RowStatus` textual convention from SNMPv2, defined in STANDARD-MIB and\nSNMPv2-TC.\n\n> #### Note {: .info }\n>\n> We strongly encourage the use of the `RowStatus` convention for every table\n> that can be modified from the manager, even for newly designed SNMPv1 MIBs. In\n> SNMPv1, everybody has invented their own scheme for emulating table\n> operations, which has led to numerous inconsistencies. The convention in\n> SNMPv2 is flexible and powerful and has been tested successfully. If the table\n> is read only, no RowStatus column should be used.","ref":"snmp_instr_functions.html#table-operations"},{"type":"extras","title":"Atomic Set - Instrumentation Functions","doc":"In SNMP, the `set` operation is atomic. Either all variables which are specified\nin a `set` operation are changed, or none are changed. Therefore, the `set`\noperation is divided into two phases. In the first phase, the new value of each\nvariable is checked against the definition of the variable in the MIB. The\nfollowing definitions are checked:\n\n- the type\n- the length\n- the range\n- the variable is writable and within the MIB view.\n\nAt the end of phase one, the user defined `is_set_ok` functions are called for\neach scalar variable, and for each group of table operations.\n\nIf no error occurs, the second phase is performed. This phase calls the user\ndefined `set` function for all variables.\n\nIf an error occurs, either in the `is_set_ok` phase, or in the `set` phase, all\nfunctions which were called with `is_set_ok` but not `set`, are called with\n`undo`.\n\nThere are limitations with this transaction mechanism. If complex dependencies\nexist between variables, for example between `month` and `day`, another\nmechanism is needed. Setting the date to 'Feb 31' can be avoided by a somewhat\nmore generic transaction mechanism. You can continue and find more and more\ncomplex situations and construct an N-phase set-mechanism. This toolkit only\ncontains a trivial mechanism.\n\nThe most common application of transaction mechanisms is to keep row operations\ntogether. Since our agent sorts row operations, the mechanism implemented in\ncombination with the RowStatus (particularly 'createAndWait' value) solve most\nproblems elegantly.","ref":"snmp_instr_functions.html#atomic-set"},{"type":"extras","title":"Definition of Instrumentation Functions","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Definition of Instrumentation Functions\n\nThe section _Definition of Instrumentation Functions_ describes the user defined\nfunctions, which the agent calls at different times.","ref":"snmp_def_instr_functions.html"},{"type":"extras","title":"Variable Instrumentation - Definition of Instrumentation Functions","doc":"For scalar variables, a function `f(Operation, ...)` must be defined.\n\nThe `Operation` can be `new`, `delete`, `get`, `is_set_ok`, `set`, or `undo`.\n\nIn case of an error, all instrumentation functions may return either an SNMPv1\nor an SNMPv2 error code. If it returns an SNMPv2 code, it is converted into an\nSNMPv1 code before it is sent to a SNMPv1 manager. It is recommended to use the\nSNMPv2 error codes for all instrumentation functions, as these provide more\ndetails. See [Appendix A](snmp_app_a.md) for a description of error code\nconversions.","ref":"snmp_def_instr_functions.html#variable-instrumentation"},{"type":"extras","title":"f(new \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(new [, ExtraArgs])` is called for each variable in the MIB when\nthe MIB is loaded into the agent. This makes it possible to perform necessary\ninitialization.\n\nThis function is optional. The return value is discarded.","ref":"snmp_def_instr_functions.html#f-new-extraargs"},{"type":"extras","title":"f(delete \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(delete [, ExtraArgs])` is called for each object in an MIB when\nthe MIB is unloaded from the agent. This makes it possible to perform necessary\nclean-up.\n\nThis function is optional. The return value is discarded.","ref":"snmp_def_instr_functions.html#f-delete-extraargs"},{"type":"extras","title":"f(get \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(get [, ExtraArgs])` is called when a get-request or a get-next\nrequest refers to the variable.\n\nThis function is mandatory.\n\n#### Valid Return Values\n\n- `{value, Value}`. The `Value` must be of correct type, length and within\n  ranges, otherwise `genErr` is returned in the response PDU. If the object is\n  an enumerated integer, the symbolic enum value may be used as an atom. If the\n  object is of type BITS, the return value shall be an integer or a list of bits\n  that are set.\n- `{noValue, noSuchName}`(SNMPv1)\n- `{noValue, noSuchObject | noSuchInstance} `(SNMPv2)\n- `genErr`. Used if an error occurred. Note, this should be an internal\n  processing error, e.g. a caused by a programming fault somewhere. If the\n  variable does not exist, use `{noValue, noSuchName}` or\n  `{noValue, noSuchInstance}`.","ref":"snmp_def_instr_functions.html#f-get-extraargs"},{"type":"extras","title":"f(is_set_ok, NewValue \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(is_set_ok, NewValue [, ExtraArgs])` is called in phase one of\nthe set-request processing so that the new value can be checked for\ninconsistencies.\n\n`NewValue` is guaranteed to be of the correct type, length and within ranges, as\nspecified in the MIB. If the object is an enumerated integer or of type BITS,\nthe integer value is used.\n\nThis function is optional.\n\nIf this function is called, it will be called again, either with `undo` or with\n`set` as first argument.\n\n#### Valid return values\n\n- `noError`\n- `badValue | noSuchName | genErr`(SNMPv1)\n- `noAccess | noCreation | inconsistentValue | resourceUnavailable | inconsistentName | genErr`(SNMPv2)","ref":"snmp_def_instr_functions.html#f-is_set_ok-newvalue-extraargs"},{"type":"extras","title":"f(undo, NewValue \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"If an error occurred, this function is called after the `is_set_ok` function is\ncalled. If `set` is called for this object, `undo` is not called.\n\n`NewValue` is guaranteed to be of the correct type, length and within ranges, as\nspecified in the MIB. If the object is an enumerated integer or of type BITS,\nthe integer value is used.\n\nThis function is optional.\n\n#### Valid return values\n\n- `noError`\n- `genErr`(SNMPv1)\n- `undoFailed | genErr`(SNMPv2)","ref":"snmp_def_instr_functions.html#f-undo-newvalue-extraargs"},{"type":"extras","title":"f(set, NewValue \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"This function is called to perform the set in phase two of the set-request\nprocessing. It is only called if the corresponding `is_set_ok` function is\npresent and returns `noError`.\n\n`NewValue` is guaranteed to be of the correct type, length and within ranges, as\nspecified in the MIB. If the object is an enumerated integer or of type BITS,\nthe integer value is used.\n\nThis function is mandatory.\n\n#### Valid return values\n\n- `noError`\n- `genErr`(SNMPv1)\n- `commitFailed | undoFailed | genErr`(SNMPv2)","ref":"snmp_def_instr_functions.html#f-set-newvalue-extraargs"},{"type":"extras","title":"Table Instrumentation - Definition of Instrumentation Functions","doc":"For tables, a `f(Operation, ...)` function should be defined (the function shown\nis exemplified with `f`).\n\nThe `Operation` can be `new`, `delete`, `get`, `next`, `is_set_ok`, `undo` or\n`set`.\n\nIn case of an error, all instrumentation functions may return either an SNMPv1\nor an SNMPv2 error code. If it returns an SNMPv2 code, it is converted into an\nSNMPv1 code before it is sent to a SNMPv1 manager. It is recommended to use the\nSNMPv2 error codes for all instrumentation functions, as these provide more\ndetails. See [Appendix A](snmp_app_a.md) for a description of error code\nconversions.","ref":"snmp_def_instr_functions.html#table-instrumentation"},{"type":"extras","title":"f(new \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(new [, ExtraArgs])` is called for each object in an MIB when the\nMIB is loaded into the agent. This makes it possible to perform the necessary\ninitialization.\n\nThis function is optional. The return value is discarded.","ref":"snmp_def_instr_functions.html#f-new-extraargs"},{"type":"extras","title":"f(delete \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(delete [, ExtraArgs])` is called for each object in an MIB when\nthe MIB is unloaded from the agent. This makes it possible to perform any\nnecessary clean-up.\n\nThis function is optional. The return value is discarded.","ref":"snmp_def_instr_functions.html#f-delete-extraargs"},{"type":"extras","title":"f(get, RowIndex, Cols \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(get, RowIndex, Cols [, ExtraArgs])` is called when a get-request\nrefers to a table.\n\nThis function is mandatory.\n\n#### Arguments\n\n- `RowIndex` is a list of integers which define the key values for the row. The\n  `RowIndex` is the list representation (list of integers) which follow the\n  `Cols` integer in the OBJECT IDENTIFIER.\n- `Cols` is a list of integers which represent the column numbers. The `Cols`\n  are sorted by increasing value and are guaranteed to be valid column numbers.\n\n#### Valid Return Values\n\n- A list with as many elements as the `Cols` list, where each element is the\n  value of the corresponding column. Each element can be:\n\n  - `{value, Value}`. The `Value` must be of correct type, length and within\n    ranges, otherwise `genErr` is returned in the response PDU. If the object is\n    an enumerated integer, the symbolic enum value may be used (as an atom). If\n    the object is of type BITS, the return value shall be an integer or a list\n    of bits that are set.\n  - `{noValue, noSuchName}`(SNMPv1)\n  - `{noValue, noSuchObject | noSuchInstance}`(SNMPv2)\n\n- `{noValue, Error}`. If the row does not exist, because all columns have\n  `{noValue, Error}`), the single tuple `{noValue, Error}` can be returned. This\n  is a shorthand for a list with all elements `{noValue, Error}`.\n- `genErr`. Used if an error occurred. Note that this should be an internal\n  processing error, e.g. a caused by a programming fault somewhere. If some\n  column does not exist, use `{noValue, noSuchName}` or\n  `{noValue, noSuchInstance}`.","ref":"snmp_def_instr_functions.html#f-get-rowindex-cols-extraargs"},{"type":"extras","title":"f(get_next, RowIndex, Cols \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(get_next, RowIndex, Cols [, ExtraArgs])` is called when a\nget-next- or a get-bulk-request refers to the table.\n\nThe `RowIndex` argument may refer to an existing row or a non-existing row, or\nit may be unspecified. The `Cols` list may refer to inaccessible columns or\nnon-existing columns. For each column in the `Cols` list, the corresponding next\ninstance is determined, and the last part of its OBJECT IDENTIFIER and its value\nis returned.\n\nThis function is mandatory.\n\n#### Arguments\n\n- `RowIndex` is a list of integers (possibly empty) that defines the key values\n  for a row. The `RowIndex` is the list representation (list of integers), which\n  follow the `Cols` integer in the OBJECT IDENTIFIER.\n- `Cols` is a list of integers, greater than or equal to zero, which represents\n  the column numbers.\n\n#### Valid Return Values\n\n- A list with as many elements as the `Cols` list Each element can be:\n\n  - `{NextOid, NextValue}`, where `NextOid` is the lexicographic next OBJECT\n    IDENTIFIER for the corresponding column. This should be specified as the\n    OBJECT IDENTIFIER part following the table entry. This means that the first\n    integer is the column number and the rest is a specification of the keys.\n    `NextValue` is the value of this element.\n  - `endOfTable` if there are no accessible elements after this one.\n\n- `{genErr, Column}` where `Column` denotes the column that caused the error.\n  `Column` must be one of the columns in the `Cols` list. Note that this should\n  be an internal processing error, e.g. a caused by a programming fault\n  somewhere. If some column does not exist, you must return the next accessible\n  element (or `endOfTable`).","ref":"snmp_def_instr_functions.html#f-get_next-rowindex-cols-extraargs"},{"type":"extras","title":"f(is_set_ok, RowIndex, Cols \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(is_set_ok, RowIndex, Cols [, ExtraArgs])` is called in phase one\nof the set-request processing so that new values can be checked for\ninconsistencies.\n\nIf the function is called, it will be called again with `undo`, or with `set` as\nfirst argument.\n\nThis function is optional.\n\n#### Arguments\n\n- `RowIndex` is a list of integers which define the key values for the row. The\n  `RowIndex` is the list representation (list of integers) which follow the\n  `Cols` integer in the OBJECT IDENTIFIER.\n- `Cols` is a list of `{Column, NewValue}`, where `Column` is an integer, and\n  `NewValue` is guaranteed to be of the correct type, length and within ranges,\n  as specified in the MIB. If the object is an enumerated integer or of type\n  BITS, the integer value is used. The list is sorted by `Column` (increasing)\n  and each `Column` is guaranteed to be a valid column number.\n\n#### Valid Return Values\n\n- `{noError, 0}`\n- `{Error, Column}`, where `Error` is the same as for `is_set_ok` for variables,\n  and `Column` denotes the faulty column. `Column` must be one of the columns in\n  the `Cols` list.","ref":"snmp_def_instr_functions.html#f-is_set_ok-rowindex-cols-extraargs"},{"type":"extras","title":"f(undo, RowIndex, Cols \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"If an error occurs, The function `f(undo, RowIndex, Cols [, ExtraArgs])` is\ncalled after the `is_set_ok` function. If `set` is called for this object,\n`undo` is not called.\n\nThis function is optional.\n\n#### Arguments\n\n- `RowIndex` is a list of integers which define the key values for the row. The\n  `RowIndex` is the list representation (list of integers) which follow the\n  `Cols` integer in the OBJECT IDENTIFIER.\n- `Cols` is a list of `{Column, NewValue}`, where `Column` is an integer, and\n  `NewValue` is guaranteed to be of the correct type, length and within ranges,\n  as specified in the MIB. If the object is an enumerated integer or of type\n  BITS, the integer value is used. The list is sorted by `Column` (increasing)\n  and each `Column` is guaranteed to be a valid column number.\n\n#### Valid Return Values\n\n- `{noError, 0}`\n- `{Error, Column}` where `Error` is the same as for `undo` for variables, and\n  `Column` denotes the faulty column. `Column` must be one of the columns in the\n  `Cols` list.","ref":"snmp_def_instr_functions.html#f-undo-rowindex-cols-extraargs"},{"type":"extras","title":"f(set, RowIndex, Cols \\[, ExtraArgs]) - Definition of Instrumentation Functions","doc":"The function `f(set, RowIndex, Cols [, ExtraArgs])` is called to perform the set\nin phase two of the set-request processing. It is only called if the\ncorresponding `is_set_ok` function did not exist, or returned `{noError, 0}`.\n\nThis function is mandatory.\n\n#### Arguments\n\n- `RowIndex` is a list of integers that define the key values for the row. The\n  `RowIndex` is the list representation (list of integers) which follow the\n  `Cols` integer in the OBJECT IDENTIFIER.\n- `Cols` is a list of `{Column, NewValue}`, where `Column` is an integer, and\n  `NewValue` is guaranteed to be of the correct type, length and within ranges,\n  as specified in the MIB. If the object is an enumerated integer or of type\n  BITS, the integer value is used. The list is sorted by `Column` (increasing)\n  and each `Column` is guaranteed to be a valid column number.\n\n#### Valid Return Values\n\n- `{noError, 0}`\n- `{Error, Column}` where `Error` is the same as `set` for variables, and\n  `Column` denotes the faulty column. `Column` must be one of the columns in the\n  `Cols` list.","ref":"snmp_def_instr_functions.html#f-set-rowindex-cols-extraargs"},{"type":"extras","title":"Definition of Agent Net if","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Definition of Agent Net if\n\n![The Purpose of Agent Net if](assets/snmp_agent_netif_1.gif \"The Purpose of Agent Net if\")\n\nThe Network Interface (Net If) process delivers SNMP PDUs to a master agent, and\nreceives SNMP PDUs from the master agent. The most common behaviour of a Net if\nprocess is that is receives bytes from a network, decodes them into an SNMP PDU,\nwhich it sends to a master agent. When the master agent has processed the PDU,\nit sends a response PDU to the Net if process, which encodes the PDU into bytes\nand transmits the bytes onto the network.\n\nHowever, that simple behaviour can be modified in numerous ways. For example,\nthe Net if process can apply some kind of encrypting/decrypting scheme on the\nbytes or act as a proxy filter, which sends some packets to a proxy agent and\nsome packets to the master agent.\n\nIt is also possible to write your own Net if process. The default Net if process\nis implemented in the module `snmpa_net_if` and it uses UDP as the transport\nprotocol i.e the transport domains `transportDomainUdpIpv4` and/or\n`transportDomainUdpIpv6`.\n\nThis section describes how to write a Net if process.","ref":"snmp_agent_netif.html"},{"type":"extras","title":"Mandatory Functions - Definition of Agent Net if","doc":"A Net if process must implement the SNMP agent\n[network interface behaviour](`m:snmpa_network_interface`).","ref":"snmp_agent_netif.html#mandatory-functions"},{"type":"extras","title":"Messages - Definition of Agent Net if","doc":"The section _Messages_ describes mandatory messages, which Net If must send and\nbe able to receive.\n\nIn this section an `Address` field is a `{Domain, Addr}` tuple where `Domain` is\n`transportDomainUdpIpv4` or `transportDomainUdpIpv4`, and `Addr` is an\n`{`[`IpAddr`](`t:inet:ip_address/0`)`,IpPort}` tuple.\n\n[](){: #outgoing_messages }","ref":"snmp_agent_netif.html#messages"},{"type":"extras","title":"Outgoing Messages - Definition of Agent Net if","doc":"Net if must send the following message when it receives an SNMP PDU from the\nnetwork that is aimed for the MasterAgent:\n\n```text\nMasterAgent ! {snmp_pdu, Vsn, Pdu, PduMS, ACMData, From, Extra}\n```\n\n{: #om_snmp_pdu }\n\n- `Vsn` is either `'version-1'`, `'version-2'`, or `'version-3'`.\n- `Pdu` is an SNMP PDU record, as defined in `snmp_types.hrl`, with the SNMP\n  request.\n- `PduMS` is the Maximum Size of the response Pdu allowed. Normally this is\n  returned from `snmpa_mpd:process_packet` (see Reference Manual).\n- `ACMData` is data used by the Access Control Module in use. Normally this is\n  returned from `snmpa_mpd:process_packet` (see Reference Manual).\n- `From` is the source `Address`.\n- `Extra` is any term the Net if process wishes to send to the agent. This term\n  can be retrieved by the instrumentation functions by calling\n  `snmp:current_net_if_data()`. This data is also sent back to the Net if\n  process when the agent generates a response to the request.\n\nThe following message is used to report that a response to a request has been\nreceived. The only request an agent can send is an Inform-Request.\n\n```text\nPid ! {snmp_response_received, Vsn, Pdu, From}\n```\n\n{: #om_snmp_response_received }\n\n- `Pid` is the Process that waits for the response for the request. The Pid was\n  specified in the `send_pdu_req` message\n  [(see below)](snmp_agent_netif.md#im_send_pdu_req).\n- `Vsn` is either `'version-1'`, `'version-2'`, or `'version-3'`.\n- `Pdu` is the SNMP Pdu received\n- `From` is the source `Address`.\n\n[](){: #incoming_messages }","ref":"snmp_agent_netif.html#outgoing-messages"},{"type":"extras","title":"Incoming Messages - Definition of Agent Net if","doc":"This section describes the incoming messages which a Net if process must be able\nto receive.\n\n- [](){: #im_snmp_response }\n  `{snmp_response, Vsn, Pdu, Type, ACMData, To, Extra}`\n\n  This message is sent to the Net if process from a master agent as a response\n  to a previously received request.\n\n  - `Vsn` is either `'version-1'`, `'version-2'`, or `'version-3'`.\n  - `Pdu` is an SNMP PDU record (as defined in snmp_types.hrl) with the SNMP\n    response.\n  - `Type` is the `#pdu.type` of the original request.\n  - `ACMData` is data used by the Access Control Module in use. Normally this is\n    just sent to `snmpa_mpd:generate_response_message` (see Reference Manual).\n  - `To` is the destination `Address` that comes from the `From` field in the\n    corresponding `snmp_pdu` message previously sent to the MasterAgent.\n  - `Extra` is the term that the Net if process sent to the agent when the\n    request was sent to the agent.\n\n- [](){: #im_discarded_pdu }\n  `{discarded_pdu, Vsn, ReqId, ACMData, Variable, Extra}`\n\n  This message is sent from a master agent if it for some reason decided to\n  discard the pdu.\n\n  - `Vsn` is either `'version-1'`, `'version-2'`, or `'version-3'`.\n  - `ReqId` is the request id of the original request.\n  - `ACMData` is data used by the Access Control Module in use. Normally this is\n    just sent to `snmpa_mpd:generate_response_message` (see Reference Manual).\n  - `Variable` is the name of an snmp counter that represents the error, e.g.\n    `snmpInBadCommunityUses`.\n  - `Extra` is the term that the Net if process sent to the agent when the\n    request was sent to the agent.\n\n- [](){: #im_send_pdu } `{send_pdu, Vsn, Pdu, MsgData, To, Extra}`\n\n  This message is sent from a master agent when a trap is to be sent.\n\n  - `Vsn` is either `'version-1'`, `'version-2'`, or `'version-3'`.\n  - `Pdu` is an SNMP PDU record (as defined in snmp_types.hrl) with the SNMP\n    response.\n  - `MsgData` is the message specific data used in the SNMP message. This value\n    is normally sent to `snmpa_mpd:generate_msg/5`. In SNMPv1 and SNMPv2c,\n    this message data is the community string. In SNMPv3, it is the context\n    information.\n  - `To` is a list of `{Address, SecData}` tuples i.e the destination addresses\n    and their corresponding security parameters. This value is normally sent to\n    `snmpa_mpd:generate_msg/5`.\n  - `Extra` is any term that the notification sender wishes to pass to the Net\n    if process when sending a notification (see\n    [`send notification`](`snmpa:send_notification2/3`)for more info).\n\n- [](){: #im_send_pdu_req } `{send_pdu_req, Vsn, Pdu, MsgData, To, Pid, Extra}`\n\n  This message is sent from a master agent when a request is to be sent. The\n  only request an agent can send is Inform-Request. The net if process needs to\n  remember the request id and the Pid, and when a response is received for the\n  request id, send it to Pid, using a `snmp_response_received` message.\n\n  - `Vsn` is either `'version-1'`, `'version-2'`, or `'version-3'`.\n  - `Pdu` is an SNMP PDU record (as defined in snmp_types.hrl) with the SNMP\n    response.\n  - `MsgData` is the message specific data used in the SNMP message. This value\n    is normally sent to `snmpa_mpd:generate_msg/5`. In SNMPv1 and SNMPv2c,\n    this message data is the community string. In SNMPv3, it is the context\n    information.\n  - `To` is a list of `{Address, SecData}` tuples i.e the destination addresses\n    and their corresponding security parameters. This value is normally sent to\n    `snmpa_mpd:generate_msg/5`.\n  - `Pid` is a process identifier.\n  - `Extra` is any term that the notification sender wishes to pass to the Net\n    if process when sending a notification (see\n    [`send notification`](`snmpa:send_notification2/3`)for more info).","ref":"snmp_agent_netif.html#incoming-messages"},{"type":"extras","title":"Notes - Definition of Agent Net if","doc":"Since the Net if process is responsible for encoding and decoding of SNMP\nmessages, it must also update the relevant counters in the SNMP group in MIB-II.\nIt can use the functions in the module `snmpa_mpd` for this purpose (refer to\nthe Reference Manual, section `snmp`, module [snmpa_mpd](`m:snmp_pdus`) for more\ndetails.)\n\nThere are also some useful functions for encoding and decoding of SNMP messages\nin the module `m:snmp_pdus`.","ref":"snmp_agent_netif.html#notes"},{"type":"extras","title":"Definition of Manager Net if","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Definition of Manager Net if\n\n![The Purpose of Manager Net if](assets/snmp_manager_netif_1.gif \"The Purpose of Manager Net if\")\n\nThe Network Interface (Net If) process delivers SNMP PDUs to the manager server,\nand receives SNMP PDUs from the manager server. The most common behaviour of a\nNet if process is that is receives request PDU from the manager server, encodes\nthe PDU into bytes and transmits the bytes onto the network to an agent. When\nthe reply from the agent is received by the Net if process, which it decodes\ninto an SNMP PDU, which it sends to the manager server.\n\nHowever, that simple behaviour can be modified in numerous ways. For example,\nthe Net if process can apply some kind of encrypting/decrypting scheme on the\nbytes.\n\nThe snmp application provides two different modules, `snmpm_net_if` (the\ndefault) and `snmpm_net_if_mt`, both uses UDP as the transport protocol i.e the\ntransport domains `transportDomainUdpIpv4` and/or `transportDomainUdpIpv6`. The\ndifference between the two modules is that the latter is \"multi-threaded\", i.e.\nfor each message/request a new process is created that processes the\nmessage/request and then exits.\n\nThere is a `server` config option,\n[netif_sup](snmp_config.md#manager_server_nis) that enables \"active\" Net If\nsupervision. This is very simple mechanism. The (supervising) process simply\nsends a [ping](snmp_manager_netif.md#im_ping) message and expects a\n[pong](snmp_manager_netif.md#om_pong) message response (within a specific time).\nThe interval between each `ping/pong` exchange is user configurable. As is the\ntime that is allowed for the [pong](snmp_manager_netif.md#om_pong) message to\narrive. Both the NetIf module(s) provided with the app supports active\nsupervision. If a NetIf module/process is used which do not implement this, then\nthe server cannot be configured with active supervision.\n\nIt is also possible to write your own Net if process and this section describes\nhow to do that.\n\n[](){: #mandatory_functions }","ref":"snmp_manager_netif.html"},{"type":"extras","title":"Mandatory Functions - Definition of Manager Net if","doc":"A Net If process must implement the SNMP manager\n[network interface behaviour](`m:snmpm_network_interface`).","ref":"snmp_manager_netif.html#mandatory-functions"},{"type":"extras","title":"Messages - Definition of Manager Net if","doc":"The section _Messages_ describes mandatory (with exception for the ping/pong\nmessages) messages, which Net If must send to the manager server process.\n\nIn this section a `Domain` field is the transport domain i.e one of\n`transportDomainUdpIpv4` or `transportDomainUdpIpv6`, and an `Addr` field is an\n`{`[`IpAddr`](`t:inet:ip_address/0`)`,IpPort}` tuple.\n\n[](){: #outgoing_messages }","ref":"snmp_manager_netif.html#messages"},{"type":"extras","title":"Outgoing Messages - Definition of Manager Net if","doc":"Net if must send the following message when it receives an SNMP PDU from the\nnetwork that is aimed for the MasterAgent:\n\n```text\nServer ! {snmp_pdu, Pdu, Domain, Addr}\n```\n\n- `Pdu` is an SNMP PDU record, as defined in `snmp_types.hrl`, with the SNMP\n  request.\n- `Domain` is the source transport domain.\n- `Addr` is the source address.\n\n```text\nServer ! {snmp_trap, Trap, Domain, Addr}\n```\n\n- `Trap` is either an SNMP pdu record or an trappdu record, as defined in\n  `snmp_types.hrl`, with the SNMP request.\n- `Domain` is the source transport domain.\n- `Addr` is the source address.\n\n```text\nServer ! {snmp_inform, Ref, Pdu, PduMS, Domain, Addr}\n```\n\n- `Ref` is either the atom `ignore` or something that can be used to identify\n  the inform-request (e.g. request-id). `ignore` is used if the response\n  (acknowledgment) to the inform-request has already been sent (this means that\n  the server will not make the call to the\n  [inform_response](`c:snmpm_network_interface:inform_response/4`) function). See\n  the [inform request behaviour](snmp_config.md#manager_irb) configuration\n  option for more info.\n- `Pdu` is an SNMP PDU record, as defined in `snmp_types.hrl`, with the SNMP\n  request.\n- `Domain` is the source transport domain.\n- `Addr` is the source address.\n\n```text\nServer ! {snmp_report, Data, Domain, Addr}\n```\n\n- `Data` is either `{ok, Pdu}` or `{error, ReqId, ReasonInfo, Pdu}`. Which one\n  is used depends on the return value from the MPD\n  [`process_msg/6`](`snmpm_mpd:process_msg/6`) function. If the MsgData is `ok`, the\n  first is used, and if it is `{error, ReqId, Reason}` the latter is used.\n- `Pdu` is an SNMP PDU record, as defined in `snmp_types.hrl`, with the SNMP\n  request.\n- `ReqId` is an integer.\n- `ReasonInfo` is a term().\n- `Domain` is the source transport domain.\n- `Addr` is the source address.\n\n```text\nSupervisor ! {pong, self()}\n```\n\n{: #om_pong }\n\n- `Supervisor` is the process that sent the\n  [ping](snmp_manager_netif.md#im_ping) message (see below).\n\n[](){: #incoming_messages }","ref":"snmp_manager_netif.html#outgoing-messages"},{"type":"extras","title":"Incoming Messages - Definition of Manager Net if","doc":"This section describes the incoming messages which a Net If process may choose\nto respond to.\n\n- [](){: #im_ping } `{ping, Supervisor}`\n\n  This message is sent to the Net If process by a process that has been\n  configured to perform \"active supervision\" of the Net If process. The Net If\n  process should respond immediately with a\n  [pong](snmp_manager_netif.md#om_pong) message.\n\n  - `Supervisor` is a `t:pid/0`.","ref":"snmp_manager_netif.html#incoming-messages"},{"type":"extras","title":"Notes - Definition of Manager Net if","doc":"Since the Net if process is responsible for encoding and decoding of SNMP\nmessages, it must also update the relevant counters in the SNMP group in MIB-II.\nIt can use the functions in the module `snmpm_mpd` for this purpose (refer to\nthe Reference Manual, section `snmp`, module `snmpm_mpd` for more details).\n\nThere are also some useful functions for encoding and decoding of SNMP messages\nin the module `snmp_pdus`.","ref":"snmp_manager_netif.html#notes"},{"type":"extras","title":"Audit Trail Log","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Audit Trail Log\n\nThe chapter _Audit Trail Log_ describes the audit trail logging.\n\nBoth the agent and the manager can be configured to log incoming and outgoing\nmessages. It uses the Erlang standard log mechanism `disk_log` for logging. The\nsize and location of the log files are configurable. A wrap log is used, which\nmeans that when the log has grown to a maximum size, it starts from the\nbeginning of the log, overwriting existing log records.\n\nThe log can be either a `read`, `write` or a `read_write`.","ref":"snmp_audit_trail_log.html"},{"type":"extras","title":"Agent Logging - Audit Trail Log","doc":"For the agent, a `write`, means that all `set` requests and their responses are\nstored. No `get` requests or traps are stored in a `write`. A `read_write`, all\nrequests, responses and traps are stored.\n\nThe log uses a raw data format (basically the BER encoded message), in order to\nminimize the CPU load needed for the log mechanism. This means that the log is\nnot human readable, but needs to be formatted off-line before it can be read.\nUse the function `snmpa:log_to_txt/8` for this purpose.","ref":"snmp_audit_trail_log.html#agent-logging"},{"type":"extras","title":"Manager Logging - Audit Trail Log","doc":"For the manager, a `write`, means that all requests (`set` and `get`) and their\nresponses are stored. No traps are stored in a `write`. A `read_write`, all\nrequests, responses and traps are stored.\n\nThe log uses a raw data format (basically the BER encoded message), in order to\nminimize the CPU load needed for the log mechanism. This means that the log is\nnot human readable, but needs to be formatted off-line before it can be read.\nUse the function `snmpm:log_to_txt/8` for this purpose.","ref":"snmp_audit_trail_log.html#manager-logging"},{"type":"extras","title":"Advanced Agent Topics","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Advanced Agent Topics\n\nThe chapter _Advanced Agent Topics_ describes the more advanced agent related\nfeatures of the SNMP development tool. The following topics are covered:\n\n- When to use a Sub-agent\n- Agent semantics\n- Sub-agents and dependencies\n- Distributed tables\n- Fault tolerance\n- Using Mnesia tables as SNMP tables\n- Audit Trail Logging\n- Deviations from the standard","ref":"snmp_advanced_agent.html"},{"type":"extras","title":"When to use a Sub-agent - Advanced Agent Topics","doc":"The section _When to use a Sub-agent_ describes situations where the mechanism\nof loading and unloading MIBs is insufficient. In these cases a sub-agent is\nneeded.","ref":"snmp_advanced_agent.html#when-to-use-a-sub-agent"},{"type":"extras","title":"Special Set Transaction Mechanism - Advanced Agent Topics","doc":"Each sub-agent can implement its own mechanisms for `set`, `get` and `get-next`.\nFor example, if the application requires the `get` mechanism to be asynchronous,\nor needs a N-phase `set` mechanism, a specialized sub-agent should be used.\n\nThe toolkit allows different kinds of sub-agents at the same time. Accordingly,\ndifferent MIBs can have different `set` or `get` mechanisms.","ref":"snmp_advanced_agent.html#special-set-transaction-mechanism"},{"type":"extras","title":"Process Communication - Advanced Agent Topics","doc":"A simple distributed agent can be managed without sub-agents. The\ninstrumentation functions can use distributed Erlang to communicate with other\nparts of the application. However, a sub-agent can be used on each node if this\ngenerates too much unnecessary traffic. A sub-agent processes requests per\nincoming SNMP request, not per variable. Therefore the network traffic is\nminimized.\n\nIf the instrumentation functions communicate with UNIX processes, it might be a\ngood idea to use a special sub-agent. This sub-agent sends the SNMP request to\nthe other process in one packet in order to minimize context switches. For\nexample, if a whole MIB is implemented on the C level in UNIX, but you still\nwant to use the Erlang SNMP tool, then you may have one special sub-agent, which\nsends the variables in the request as a single operation down to C.","ref":"snmp_advanced_agent.html#process-communication"},{"type":"extras","title":"Frequent Loading of MIBs - Advanced Agent Topics","doc":"Loading and unloading of MIBs are quite cheap operations. However, if the\napplication does this very often, perhaps several times per minute, it should\nload the MIBs once and for all in a sub-agent. This sub-agent only registers and\nunregisters itself under another agent instead of loading the MIBs each time.\nThis is cheaper than loading an MIB.","ref":"snmp_advanced_agent.html#frequent-loading-of-mibs"},{"type":"extras","title":"Interaction With Other SNMP Agent Toolkits - Advanced Agent Topics","doc":"If the SNMP agent needs to interact with sub-agents constructed in another\npackage, a special sub-agent should be used, which communicates through a\nprotocol specified by the other package.","ref":"snmp_advanced_agent.html#interaction-with-other-snmp-agent-toolkits"},{"type":"extras","title":"Agent Semantics - Advanced Agent Topics","doc":"The agent can be configured to be multi-threaded, to process one incoming\nrequest at a time, or to have a request limit enabled (this can be used for load\ncontrol or to limit the effect of DoS attacks). If it is multi-threaded, read\nrequests (`get`, `get-next` and `get-bulk`) and traps are processed in parallel\nwith each other and `set` requests. However, all `set` requests are serialized,\nwhich means that if the agent is waiting for the application to complete a\ncomplicated write operation, it will not process any new write requests until\nthis operation is finished. It processes read requests and sends traps,\nconcurrently. The reason for not handle write requests in parallel is that a\ncomplex locking mechanism would be needed even in the simplest cases. Even with\nthe scheme described above, the user must be careful not to violate that the\n`set` requests are atoms. If this is hard to do, do not use the multi-threaded\nfeature.\n\nThe order within an request is undefined and variables are not processed in a\ndefined order. Do not assume that the first variable in the PDU will be\nprocessed before the second, even if the agent processes variables in this\norder. It cannot even be assumed that requests belonging to different sub-agents\nhave any order.\n\nIf the manager tries to set the same variable many times in the same PDU, the\nagent is free to improvise. There is no definition which determines if the\ninstrumentation will be called once or twice. If called once only, there is no\ndefinition that determines which of the new values is going to be supplied.\n\nWhen the agent receives a request, it keeps the request ID for one second after\nthe response is sent. If the agent receives another request with the same\nrequest ID during this time, from the same IP address and UDP port, that request\nwill be discarded. This mechanism has nothing to do with the function\n`snmpa:current_request_id/0`.","ref":"snmp_advanced_agent.html#agent-semantics"},{"type":"extras","title":"Sub-agents and Dependencies - Advanced Agent Topics","doc":"The toolkit supports the use of different types of sub-agents, but not the\nconstruction of sub-agents.\n\nAlso, the toolkit does not support dependencies between sub-agents. A sub-agent\nshould by definition be stand alone and it is therefore not good design to\ncreate dependencies between them.","ref":"snmp_advanced_agent.html#sub-agents-and-dependencies"},{"type":"extras","title":"Distributed Tables - Advanced Agent Topics","doc":"A common situation in more complex systems is that the data in a table is\ndistributed. Different table rows are implemented in different places. Some SNMP\ntool-kits dedicate an SNMP sub-agent for each part of the table and load the\ncorresponding MIB into all sub-agents. The Master Agent is responsible for\npresenting the distributed table as a single table to the manager. The toolkit\nsupplied uses a different method.\n\nThe method used to implement distributed tables with this SNMP tool is to\nimplement a table coordinator process responsible for coordinating the\nprocesses, which hold the table data and they are called table holders. All\ntable holders must in some way be known by the coordinator; the structure of the\ntable data determines how this is achieved. The coordinator may require that the\ntable holders explicitly register themselves and specify their information. In\nother cases, the table holders can be determined once at compile time.\n\nWhen the instrumentation function for the distributed table is called, the\nrequest should be forwarded to the table coordinator. The coordinator finds the\nrequested information among the table holders and then returns the answer to the\ninstrumentation function. The SNMP toolkit contains no support for coordination\nof tables since this must be independent of the implementation.\n\nThe advantages of separating the table coordinator from the SNMP tool are:\n\n- We do not need a sub-agent for each table holder. Normally, the sub-agent is\n  needed to take care of communication, but in Distributed Erlang we use\n  ordinary message passing.\n- Most likely, some type of table coordinator already exists. This process\n  should take care of the instrumentation for the table.\n- The method used to present a distributed table is strongly application\n  dependent. The use of different masking techniques is only valid for a small\n  subset of problems and registering every row in a distributed table makes it\n  non-distributed.","ref":"snmp_advanced_agent.html#distributed-tables"},{"type":"extras","title":"Fault Tolerance - Advanced Agent Topics","doc":"The SNMP agent toolkit gets input from three different sources:\n\n- UDP packets from the network\n- return values from the user defined instrumentation functions\n- return values from the MIB.\n\nThe agent is highly fault tolerant. If the manager gets an unexpected response\nfrom the agent, it is possible that some instrumentation function has returned\nan erroneous value. The agent will not crash even if the instrumentation does.\nIt should be noted that if an instrumentation function enters an infinite loop,\nthe agent will also be blocked forever. The supervisor ,or the application,\nspecifies how to restart the agent.","ref":"snmp_advanced_agent.html#fault-tolerance"},{"type":"extras","title":"Using the SNMP Agent in a Distributed Environment - Advanced Agent Topics","doc":"The normal way to use the agent in a distributed environment is to use one\nmaster agent located at one node, and zero or more sub-agents located on other\nnodes. However, this configuration makes the master agent node a single point of\nfailure. If that node goes down, the agent will not work.\n\nOne solution to this problem is to make the snmp application a distributed\nErlang application, and that means, the agent may be configured to run on one of\nseveral nodes. If the node where it runs goes down, another node restarts the\nagent. This is called _failover_. When the node starts again, it may _takeover_\nthe application. This solution to the problem adds another problem. Generally,\nthe new node has another IP address than the first one, which may cause problems\nin the communication between the SNMP managers and the agent.\n\nIf the snmp agent is configured as a distributed Erlang application, it will\nduring takeover try to load the same MIBs that were loaded at the old node. It\nuses the same filenames as the old node. If the MIBs are not located in the same\npaths at the different nodes, the MIBs must be loaded explicitly after takeover.","ref":"snmp_advanced_agent.html#using-the-snmp-agent-in-a-distributed-environment"},{"type":"extras","title":"Using Mnesia Tables as SNMP Tables - Advanced Agent Topics","doc":"The Mnesia DBMS can be used for storing data of SNMP tables. This means that an\nSNMP table can be implemented as a Mnesia table, and that a Mnesia table can be\nmade visible via SNMP. This mapping is largely automated.\n\nThere are three main reasons for using this mapping:\n\n- We get all features of Mnesia, such as fault tolerance, persistent data\n  storage, replication, and so on.\n- Much of the work involved is automated. This includes `get-next` processing\n  and `RowStatus` handling.\n- The table may be used as an ordinary Mnesia table, using the Mnesia API\n  internally in the application at the same time as it is visible through SNMP.\n\nWhen this mapping is used, insertion and deletion in the original Mnesia table\nis slower, with a factor O(log n). The read access is not affected.\n\nA drawback with implementing an SNMP table as a Mnesia table is that the\ninternal resource is forced to use the table definition from the MIB, which\nmeans that the external data model must be used internally. Actually, this is\nonly partially true. The Mnesia table may extend the SNMP table, which means\nthat the Mnesia table may have columns which are use internally and are not seen\nby SNMP. Still, the data model from SNMP must be maintained. Although this is\nundesirable, it is a pragmatic compromise in many situations where simple and\nefficient implementation is preferable to abstraction.","ref":"snmp_advanced_agent.html#using-mnesia-tables-as-snmp-tables"},{"type":"extras","title":"Creating the Mnesia Table - Advanced Agent Topics","doc":"The table must be created in Mnesia before the manager can use it. The table\nmust be declared as type `snmp`. This makes the table ordered in accordance with\nthe lexicographical ordering rules of SNMP. The name of the Mnesia table must be\nidentical to the SNMP table name. The types of the INDEX fields in the\ncorresponding SNMP table must be specified.\n\nIf the SNMP table has more than one INDEX column, the corresponding Mnesia row\nis a tuple, where the first element is a tuple with the INDEX columns.\nGenerally, if the SNMP table has _N_ INDEX columns and _C_ data columns, the\nMnesia table is of arity _(C-N)+1_, where the key is a tuple of arity _N_ if\n_N > 1_, or a single term if _N = 1_.\n\nRefer to the Mnesia User's Guide for information on how to declare a Mnesia\ntable as an SNMP table.\n\nThe following example illustrates a situation in which we have an SNMP table\nthat we wish to implement as a Mnesia table. The table stores information about\nemployees at a company. Each employee is indexed with the department number and\nthe name.\n\n```text\n       empTable OBJECT-TYPE\n              SYNTAX      SEQUENCE OF EmpEntry\n              ACCESS      not-accessible\n              STATUS      mandatory\n              DESCRIPTION\n                      \"A table with information about employees.\"\n       ::= { emp 1}\n       empEntry OBJECT-TYPE\n              SYNTAX      EmpEntry\n              ACCESS      not-accessible\n              STATUS      mandatory\n              DESCRIPTION\n                 \"\"\n              INDEX      { empDepNo, empName }\n       ::= { empTable 1 }\n       EmpEntry ::=\n              SEQUENCE {\n                  empDepNo         INTEGER,\n                  empName          DisplayString,\n                  empTelNo         DisplayString,\n                  empStatus        RowStatus\n              }\n```\n\nThe corresponding Mnesia table is specified as follows:\n\n```erlang\nmnesia:create_table([{name, employees},\n                     {snmp, [{key, {integer, string}}]},\n                     {attributes, [key, telno, row_status]}]).\n```\n\n> #### Note {: .info }\n>\n> In the Mnesia tables, the two key columns are stored as a tuple with two\n> elements. Therefore, the arity of the table is 3.","ref":"snmp_advanced_agent.html#creating-the-mnesia-table"},{"type":"extras","title":"Instrumentation Functions - Advanced Agent Topics","doc":"The MIB table shown in the previous section can be compiled as follows:\n\n```erlang\n1> snmpc:compile(\"EmpMIB\", [{db, mnesia}]).\n```\n\nThis is all that has to be done\\! Now the manager can read, add, and modify\nrows. Also, you can use the ordinary Mnesia API to access the table from your\nprograms. The only explicit action is to create the Mnesia table, an action the\nuser has to perform in order to create the required table schemas.","ref":"snmp_advanced_agent.html#instrumentation-functions"},{"type":"extras","title":"Adding Own Actions - Advanced Agent Topics","doc":"It is often necessary to take some specific action when a table is modified.\nThis is accomplished with an instrumentation function. It executes some specific\ncode when the table is set, and passes all other requests down to the\npre-defined function.\n\nThe following example illustrates this idea:\n\n```erlang\nemp_table(set, RowIndex, Cols) ->\n    notify_internal_resources(RowIndex, Cols),\n    snmp_generic:table_func(set, RowIndex, Cols, {empTable, mnesia});\nemp_table(Op, RowIndex, Cols) ->\n    snmp_generic:table_func(Op, RowIndex, Cols, {empTable, mnesia}).\n```\n\nThe default instrumentation functions are defined in the module `snmp_generic`.\nRefer to the Reference Manual, section SNMP, module `snmp_generic` for details.","ref":"snmp_advanced_agent.html#adding-own-actions"},{"type":"extras","title":"Extending the Mnesia Table - Advanced Agent Topics","doc":"A table may contain columns that are used internally, but should not be visible\nto a manager. These internal columns must be the last columns in the table. The\n`set` operation will not work with this arrangement, because there are columns\nthat the agent does not know about. This situation is handled by adding values\nfor the internal columns in the `set` function.\n\nTo illustrate this, suppose we extend our Mnesia `empTable` with one internal\ncolumn. We create it as before, but with an arity of 4, by adding another\nattribute.\n\n```erlang\nmnesia:create_table([{name, employees},\n                     {snmp, [{key, {integer, string}}]},\n                     {attributes, {key, telno, row_status, internal_col}}]).\n```\n\nThe last column is the internal column. When performing a `set` operation, which\ncreates a row, we must give a value to the internal column. The instrumentation\nfunctions will now look as follows:\n\n```erlang\n-define(createAndGo, 4).\n-define(createAndWait, 5).\n\nemp_table(set, RowIndex, Cols) ->\n  notify_internal_resources(RowIndex, Cols),\n  NewCols =\n    case is_row_created(empTable, Cols) of\n      true -> Cols ++ [{4, \"internal\"}]; % add internal column\n      false -> Cols                      % keep original cols\n  end,\n  snmp_generic:table_func(set, RowIndex, NewCols, {empTable, mnesia});\nemp_table(Op, RowIndex, Cols) ->\n  snmp_generic:table_func(Op, RowIndex, Cols, {empTable, mnesia}).\n\nis_row_created(Name, Cols) ->\n  case snmp_generic:get_status_col(Name, Cols) of\n    {ok, ?createAndGo} -> true;\n    {ok, ?createAndWait} -> true;\n    _ -> false\n  end.\n```\n\nIf a row is created, we always set the internal column to `\"internal\"`.","ref":"snmp_advanced_agent.html#extending-the-mnesia-table"},{"type":"extras","title":"Deviations from the Standard - Advanced Agent Topics","doc":"In some aspects the agent does not implement SNMP fully. Here are the\ndifferences:\n\n- The default functions and `snmp_generic` cannot handle an object of type\n  `NetworkAddress` as INDEX (SNMPv1 only\\!). Use `IpAddress` instead.\n- The agent does not check complex ranges specified for INTEGER objects. In\n  these cases it just checks that the value lies within the minimum and maximum\n  values specified. For example, if the range is specified as `1..10 | 12..20`\n  the agent would let 11 through, but not 0 or 21. The instrumentation functions\n  must check the complex ranges itself.\n- The agent will never generate the `wrongEncoding` error. If a variable binding\n  is erroneous encoded, the `asn1ParseError` counter will be incremented.\n- A `tooBig` error in an SNMPv1 packet will always use the `'NULL'` value in all\n  variable bindings.\n- The default functions and `snmp_generic` do not check the range of each OCTET\n  in textual conventions derived from OCTET STRING, e.g. `DisplayString` and\n  `DateAndTime`. This must be checked in an overloaded `is_set_ok` function.","ref":"snmp_advanced_agent.html#deviations-from-the-standard"},{"type":"extras","title":"SNMP Appendix A","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SNMP Appendix A","ref":"snmp_app_a.html"},{"type":"extras","title":"Appendix A - SNMP Appendix A","doc":"This appendix describes the conversion of SNMPv2 to SNMPv1 error messages. The\ninstrumentation functions should return v2 error messages.\n\nMapping of SNMPv2 error message to SNMPv1:\n\n| SNMPv2 message      | SNMPv1 message |\n| ------------------- | -------------- |\n| noError             | noError        |\n| genErr              | genErr         |\n| noAccess            | noSuchName     |\n| wrongType           | badValue       |\n| wrongLength         | badValue       |\n| wrongEncoding       | badValue       |\n| wrongValue          | badValue       |\n| noCreation          | noSuchName     |\n| inconsistentValue   | badValue       |\n| resourceUnavailable | genErr         |\n| commitFailed        | genErr         |\n| undoFailed          | genErr         |\n| notWritable         | noSuchName     |\n| inconsistentName    | noSuchName     |\n\n_Table: Error Messages_","ref":"snmp_app_a.html#appendix-a"},{"type":"extras","title":"SNMP Appendix B","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SNMP Appendix B","ref":"snmp_app_b.html"},{"type":"extras","title":"Appendix B - SNMP Appendix B","doc":"","ref":"snmp_app_b.html#appendix-b"},{"type":"extras","title":"RowStatus (from RFC1903) - SNMP Appendix B","doc":"```c\nRowStatus ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"The RowStatus textual convention is used to manage the\n            creation and deletion of conceptual rows, and is used as the\n            value of the SYNTAX clause for the status column of a\n            conceptual row (as described in Section 7.7.1 in RFC1902.)\n\n            The status column has six defined values:\n\n                 - `active', which indicates that the conceptual row is\n                 available for use by the managed device;\n\n                 - `notInService', which indicates that the conceptual\n                 row exists in the agent, but is unavailable for use by\n                 the managed device (see NOTE below);\n\n                 - `notReady', which indicates that the conceptual row\n                 exists in the agent, but is missing information\n                 necessary in order to be available for use by the\n                 managed device;\n\n                 - `createAndGo', which is supplied by a management\n                 station wishing to create a new instance of a\n                 conceptual row and to have its status automatically set\n                 to active, making it available for use by the managed\n                 device;\n\n                 - `createAndWait', which is supplied by a management\n                 station wishing to create a new instance of a\n                 conceptual row (but not make it available for use by\n                 the managed device); and,\n\n                 - `destroy', which is supplied by a management station\n                 wishing to delete all of the instances associated with\n                 an existing conceptual row.\n\n            Whereas five of the six values (all except `notReady') may\n            be specified in a management protocol set operation, only\n            three values will be returned in response to a management\n            protocol retrieval operation:  `notReady', `notInService' or\n            `active'.  That is, when queried, an existing conceptual row\n            has only three states:  it is either available for use by\n            the managed device (the status column has value `active');\n            it is not available for use by the managed device, though\n            the agent has sufficient information to make it so (the\n            status column has value `notInService'); or, it is not\n            available for use by the managed device, and an attempt to\n            make it so would fail because the agent has insufficient\n            information (the state column has value `notReady').\n\n\n                                     NOTE WELL\n\n                 This textual convention may be used for a MIB table,\n                 irrespective of whether the values of that table's\n                 conceptual rows are able to be modified while it is\n                 active, or whether its conceptual rows must be taken\n                 out of service in order to be modified.  That is, it is\n                 the responsibility of the DESCRIPTION clause of the\n                 status column to specify whether the status column must\n                 not be `active' in order for the value of some other\n                 column of the same conceptual row to be modified.  If\n                 such a specification is made, affected columns may be\n                 changed by an SNMP set PDU if the RowStatus would not\n                 be equal to `active' either immediately before or after\n                 processing the PDU.  In other words, if the PDU also\n                 contained a varbind that would change the RowStatus\n                 value, the column in question may be changed if the\n                 RowStatus was not equal to `active' as the PDU was\n                 received, or if the varbind sets the status to a value\n                 other than 'active'.\n\n\n            Also note that whenever any elements of a row exist, the\n            RowStatus column must also exist.\n\n            To summarize the effect of having a conceptual row with a\n            status column having a SYNTAX clause value of RowStatus,\n            consider the following state diagram:\n\n\n                                         STATE\n              +--------------+-----------+-------------+-------------\n              |      A       |     B     |      C      |      D\n              |              |status col.|status column|\n              |status column |    is     |      is     |status column\n    ACTION    |does not exist|  notReady | notInService|  is active\n--------------+--------------+-----------+-------------+-------------\nset status    |noError    ->D|inconsist- |inconsistent-|inconsistent-\ncolumn to     |       or     |   entValue|        Value|        Value\ncreateAndGo   |inconsistent- |           |             |\n              |         Value|           |             |\n--------------+--------------+-----------+-------------+-------------\nset status    |noError  see 1|inconsist- |inconsistent-|inconsistent-\ncolumn to     |       or     |   entValue|        Value|        Value\ncreateAndWait |wrongValue    |           |             |\n--------------+--------------+-----------+-------------+-------------\nset status    |inconsistent- |inconsist- |noError      |noError\ncolumn to     |         Value|   entValue|             |\nactive        |              |           |             |\n              |              |     or    |             |\n              |              |           |             |\n              |              |see 2   ->D|          ->D|          ->D\n--------------+--------------+-----------+-------------+-------------\nset status    |inconsistent- |inconsist- |noError      |noError   ->C\ncolumn to     |         Value|   entValue|             |\nnotInService  |              |           |             |\n              |              |     or    |             |      or\n              |              |           |             |\n              |              |see 3   ->C|          ->C|wrongValue\n--------------+--------------+-----------+-------------+-------------\nset status    |noError       |noError    |noError      |noError\ncolumn to     |              |           |             |\ndestroy       |           ->A|        ->A|          ->A|          ->A\n--------------+--------------+-----------+-------------+-------------\nset any other |see 4         |noError    |noError      |see 5\ncolumn to some|              |           |             |\nvalue         |              |      see 1|          ->C|          ->D\n--------------+--------------+-----------+-------------+-------------\n\n            (1) goto B or C, depending on information available to the\n            agent.\n\n            (2) if other variable bindings included in the same PDU,\n            provide values for all columns which are missing but\n            required, then return noError and goto D.\n\n            (3) if other variable bindings included in the same PDU,\n            provide values for all columns which are missing but\n            required, then return noError and goto C.\n\n            (4) at the discretion of the agent, the return value may be\n            either:\n\n                 inconsistentName:  because the agent does not choose to\n                 create such an instance when the corresponding\n                 RowStatus instance does not exist, or\n\n                 inconsistentValue:  if the supplied value is\n                 inconsistent with the state of some other MIB object's\n                 value, or\n\n                 noError: because the agent chooses to create the\n                 instance.\n\n            If noError is returned, then the instance of the status\n            column must also be created, and the new state is B or C,\n            depending on the information available to the agent.  If\n            inconsistentName or inconsistentValue is returned, the row\n            remains in state A.\n\n            (5) depending on the MIB definition for the column/table,\n            either noError or inconsistentValue may be returned.\n\n            NOTE: Other processing of the set request may result in a\n            response other than noError being returned, e.g.,\n            wrongValue, noCreation, etc.\n\n\n                              Conceptual Row Creation\n\n            There are four potential interactions when creating a\n            conceptual row:  selecting an instance-identifier which is\n            not in use; creating the conceptual row; initializing any\n            objects for which the agent does not supply a default; and,\n            making the conceptual row available for use by the managed\n            device.\n\n\n            Interaction 1: Selecting an Instance-Identifier\n\n            The algorithm used to select an instance-identifier varies\n            for each conceptual row.  In some cases, the instance-\n            identifier is semantically significant, e.g., the\n            destination address of a route, and a management station\n            selects the instance-identifier according to the semantics.\n\n            In other cases, the instance-identifier is used solely to\n            distinguish conceptual rows, and a management station\n            without specific knowledge of the conceptual row might\n            examine the instances present in order to determine an\n            unused instance-identifier.  (This approach may be used, but\n            it is often highly sub-optimal; however, it is also a\n            questionable practice for a naive management station to\n            attempt conceptual row creation.)\n\n            Alternately, the MIB module which defines the conceptual row\n            might provide one or more objects which provide assistance\n            in determining an unused instance-identifier.  For example,\n            if the conceptual row is indexed by an integer-value, then\n            an object having an integer-valued SYNTAX clause might be\n            defined for such a purpose, allowing a management station to\n            issue a management protocol retrieval operation.  In order\n            to avoid unnecessary collisions between competing management\n            stations, `adjacent' retrievals of this object should be\n            different.\n\n            Finally, the management station could select a pseudo-random\n            number to use as the index.  In the event that this index\n            was already in use and an inconsistentValue was returned in\n            response to the management protocol set operation, the\n            management station should simply select a new pseudo-random\n            number and retry the operation.\n\n            A MIB designer should choose between the two latter\n            algorithms based on the size of the table (and therefore the\n            efficiency of each algorithm).  For tables in which a large\n            number of entries are expected, it is recommended that a MIB\n            object be defined that returns an acceptable index for\n            creation.  For tables with small numbers of entries, it is\n            recommended that the latter pseudo-random index mechanism be\n            used.\n\n\n            Interaction 2: Creating the Conceptual Row\n\n            Once an unused instance-identifier has been selected, the\n            management station determines if it wishes to create and\n            activate the conceptual row in one transaction or in a\n            negotiated set of interactions.\n\n            Interaction 2a: Creating and Activating the Conceptual Row\n\n            The management station must first determine the column\n            requirements, i.e., it must determine those columns for\n            which it must or must not provide values.  Depending on the\n            complexity of the table and the management station's\n            knowledge of the agent's capabilities, this determination\n            can be made locally by the management station.  Alternately,\n            the management station issues a management protocol get\n            operation to examine all columns in the conceptual row that\n            it wishes to create.  In response, for each column, there\n            are three possible outcomes:\n\n                 - a value is returned, indicating that some other\n                 management station has already created this conceptual\n                 row.  We return to interaction 1.\n\n                 - the exception `noSuchInstance' is returned,\n                 indicating that the agent implements the object-type\n                 associated with this column, and that this column in at\n                 least one conceptual row would be accessible in the MIB\n                 view used by the retrieval were it to exist. For those\n                 columns to which the agent provides read-create access,\n                 the `noSuchInstance' exception tells the management\n                 station that it should supply a value for this column\n                 when the conceptual row is to be created.\n\n                 - the exception `noSuchObject' is returned, indicating\n                 that the agent does not implement the object-type\n                 associated with this column or that there is no\n                 conceptual row for which this column would be\n                 accessible in the MIB view used by the retrieval.  As\n                 such, the management station cannot issue any\n                 management protocol set operations to create an\n                 instance of this column.\n\n            Once the column requirements have been determined, a\n            management protocol set operation is accordingly issued.\n            This operation also sets the new instance of the status\n            column to `createAndGo'.\n\n            When the agent processes the set operation, it verifies that\n            it has sufficient information to make the conceptual row\n            available for use by the managed device.  The information\n            available to the agent is provided by two sources:  the\n            management protocol set operation which creates the\n            conceptual row, and, implementation-specific defaults\n            supplied by the agent (note that an agent must provide\n            implementation-specific defaults for at least those objects\n            which it implements as read-only).  If there is sufficient\n            information available, then the conceptual row is created, a\n            `noError' response is returned, the status column is set to\n            `active', and no further interactions are necessary (i.e.,\n            interactions 3 and 4 are skipped).  If there is insufficient\n            information, then the conceptual row is not created, and the\n            set operation fails with an error of `inconsistentValue'.\n            On this error, the management station can issue a management\n            protocol retrieval operation to determine if this was\n            because it failed to specify a value for a required column,\n            or, because the selected instance of the status column\n            already existed.  In the latter case, we return to\n            interaction 1.  In the former case, the management station\n            can re-issue the set operation with the additional\n            information, or begin interaction 2 again using\n            `createAndWait' in order to negotiate creation of the\n            conceptual row.\n\n                                     NOTE WELL\n\n                 Regardless of the method used to determine the column\n                 requirements, it is possible that the management\n                 station might deem a column necessary when, in fact,\n                 the agent will not allow that particular columnar\n                 instance to be created or written.  In this case, the\n                 management protocol set operation will fail with an\n                 error such as `noCreation' or `notWritable'.  In this\n                 case, the management station decides whether it needs\n                 to be able to set a value for that particular columnar\n                 instance.  If not, the management station re-issues the\n                 management protocol set operation, but without setting\n                 a value for that particular columnar instance;\n                 otherwise, the management station aborts the row\n                 creation algorithm.\n\n            Interaction 2b: Negotiating the Creation of the Conceptual\n            Row\n\n            The management station issues a management protocol set\n            operation which sets the desired instance of the status\n            column to `createAndWait'.  If the agent is unwilling to\n            process a request of this sort, the set operation fails with\n            an error of `wrongValue'.  (As a consequence, such an agent\n            must be prepared to accept a single management protocol set\n            operation, i.e., interaction 2a above, containing all of the\n            columns indicated by its column requirements.)  Otherwise,\n            the conceptual row is created, a `noError' response is\n            returned, and the status column is immediately set to either\n            `notInService' or `notReady', depending on whether it has\n            sufficient information to make the conceptual row available\n            for use by the managed device.  If there is sufficient\n            information available, then the status column is set to\n            `notInService'; otherwise, if there is insufficient\n            information, then the status column is set to `notReady'.\n            Regardless, we proceed to interaction 3.\n\n            Interaction 3: Initializing non-defaulted Objects\n\n            The management station must now determine the column\n            requirements.  It issues a management protocol get operation\n            to examine all columns in the created conceptual row.  In\n            the response, for each column, there are three possible\n            outcomes:\n\n                 - a value is returned, indicating that the agent\n                 implements the object-type associated with this column\n                 and had sufficient information to provide a value.  For\n                 those columns to which the agent provides read-create\n                 access (and for which the agent allows their values to\n                 be changed after their creation), a value return tells\n                 the management station that it may issue additional\n                 management protocol set operations, if it desires, in\n                 order to change the value associated with this column.\n\n                 - the exception `noSuchInstance' is returned,\n                 indicating that the agent implements the object-type\n                 associated with this column, and that this column in at\n                 least one conceptual row would be accessible in the MIB\n                 view used by the retrieval were it to exist. However,\n                 the agent does not have sufficient information to\n                 provide a value, and until a value is provided, the\n                 conceptual row may not be made available for use by the\n                 managed device.  For those columns to which the agent\n                 provides read-create access, the `noSuchInstance'\n                 exception tells the management station that it must\n                 issue additional management protocol set operations, in\n                 order to provide a value associated with this column.\n\n                 - the exception `noSuchObject' is returned, indicating\n                 that the agent does not implement the object-type\n                 associated with this column or that there is no\n                 conceptual row for which this column would be\n                 accessible in the MIB view used by the retrieval.  As\n                 such, the management station cannot issue any\n                 management protocol set operations to create an\n                 instance of this column.\n\n            If the value associated with the status column is\n            `notReady', then the management station must first deal with\n            all `noSuchInstance' columns, if any.  Having done so, the\n            value of the status column becomes `notInService', and we\n            proceed to interaction 4.\n\n            Interaction 4: Making the Conceptual Row Available\n\n            Once the management station is satisfied with the values\n            associated with the columns of the conceptual row, it issues\n            a management protocol set operation to set the status column\n            to `active'.  If the agent has sufficient information to\n            make the conceptual row available for use by the managed\n            device, the management protocol set operation succeeds (a\n            `noError' response is returned).  Otherwise, the management\n            protocol set operation fails with an error of\n            `inconsistentValue'.\n\n\n                                     NOTE WELL\n\n                 A conceptual row having a status column with value\n                 `notInService' or `notReady' is unavailable to the\n                 managed device.  As such, it is possible for the\n                 managed device to create its own instances during the\n                 time between the management protocol set operation\n                 which sets the status column to `createAndWait' and the\n                 management protocol set operation which sets the status\n                 column to `active'.  In this case, when the management\n                 protocol set operation is issued to set the status\n                 column to `active', the values held in the agent\n                 supersede those used by the managed device.\n\n            If the management station is prevented from setting the\n            status column to `active' (e.g., due to management station\n            or network failure) the conceptual row will be left in the\n            `notInService' or `notReady' state, consuming resources\n            indefinitely.  The agent must detect conceptual rows that\n            have been in either state for an abnormally long period of\n            time and remove them.  It is the responsibility of the\n            DESCRIPTION clause of the status column to indicate what an\n            abnormally long period of time would be.  This period of\n            time should be long enough to allow for human response time\n            (including `think time') between the creation of the\n            conceptual row and the setting of the status to `active'.\n            In the absence of such information in the DESCRIPTION\n            clause, it is suggested that this period be approximately 5\n            minutes in length.  This removal action applies not only to\n            newly-created rows, but also to previously active rows which\n            are set to, and left in, the notInService state for a\n            prolonged period exceeding that which is considered normal\n            for such a conceptual row.\n\n\n                             Conceptual Row Suspension\n\n            When a conceptual row is `active', the management station\n            may issue a management protocol set operation which sets the\n            instance of the status column to `notInService'.  If the\n            agent is unwilling to do so, the set operation fails with an\n            error of `wrongValue'.  Otherwise, the conceptual row is\n            taken out of service, and a `noError' response is returned.\n            It is the responsibility of the DESCRIPTION clause of the\n            status column to indicate under what circumstances the\n            status column should be taken out of service (e.g., in order\n            for the value of some other column of the same conceptual\n            row to be modified).\n\n\n                              Conceptual Row Deletion\n\n            For deletion of conceptual rows, a management protocol set\n            operation is issued which sets the instance of the status\n            column to `destroy'.  This request may be made regardless of\n            the current value of the status column (e.g., it is possible\n            to delete conceptual rows which are either `notReady',\n            `notInService' or `active'.)  If the operation succeeds,\n            then all instances associated with the conceptual row are\n            immediately removed.\"\n\n\n    SYNTAX       INTEGER {\n                     -- the following two values are states:\n                     -- these values may be read or written\n                     active(1),\n                     notInService(2),\n\n                     -- the following value is a state:\n                     -- this value may be read, but not written\n                     notReady(3),\n\n                     -- the following three values are\n                     -- actions: these values may be written,\n                     --   but are never read\n                     createAndGo(4),\n                     createAndWait(5),\n                     destroy(6)\n                 }\n```","ref":"snmp_app_b.html#rowstatus-from-rfc1903"},{"type":"extras","title":"SNMP Appendix C","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SNMP Appendix C","ref":"snmp_app_c.html"},{"type":"extras","title":"Appendix C - SNMP Appendix C","doc":"","ref":"snmp_app_c.html#appendix-c"},{"type":"extras","title":"Compile time configuration - SNMP Appendix C","doc":"There is one compile/configure time option: Defining the size of an \"empty\" PDU.\nThis is used when processing get-bulk requests. The default value for this is\n_21_, but can be _increased_ in two ways:\n\n- configure: `--with-snmp-empty-pdu-size=SIZE`\n- compile time: `environment variable: SNMP_EMPTY_PDU_SIZE=SIZE\"`\n\nWhere `SIZE` is a value greater or equal to 21.","ref":"snmp_app_c.html#compile-time-configuration"},{"type":"extras","title":"snmpc","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# snmpc\n\nSNMP MIB compiler frontend","ref":"snmpc_cmd.html"},{"type":"extras","title":"Description - snmpc","doc":"The `snmpc` program provides a way to run the SNMP MIB compiler of the Erlang\nsystem.","ref":"snmpc_cmd.html#description"},{"type":"extras","title":"snmpc \\[options] file.mib | file.bin - snmpc","doc":"`snmpc` compile a SNMP MIB file, see [compile/1,2](`snmpc:compile/1`) for more\ninfo.\n\nIt can also be used to generate a header file (.hrl) with definitions of Erlang\nconstants for the objects in the MIB, see [mib_to_hrl/1](`snmpc:mib_to_hrl/1`).\n\n[](){: #options }","ref":"snmpc_cmd.html#snmpc-options-file-mib-file-bin"},{"type":"extras","title":"Compiler options - snmpc","doc":"The following options are supported (note that most of these relate to the\ncompilation of the MIB file):\n\n[](){: #option_help }\n\n- **\\--help** - Prints help info.\n\n  [](){: #option_version }\n\n- **\\--version** - Prints application and mib format version.\n\n  [](){: #option_verbosity }\n\n- **\\--verbosity _verbosity_** - Print debug info.\n\n  `verbosity` = `trace` | `debug` | `log` | `info` | `silence`\n\n  Defaults to `silence`.\n\n  [](){: #option_w } [](){: #option_warnings }\n\n- **\\--warnings | --W** - Print warning messages.\n\n  [](){: #option_wae } [](){: #option_werror }\n\n- **\\--wae | --Werror** - Warnings as errors. Indicates that warnings shall be\n  treated as errors.\n\n  [](){: #option_odir }\n\n- **\\--o _directory_** - The directory where the compiler should place the\n  output files. If not specified, output files will be placed in the current\n  working directory.\n\n  [](){: #option_idir }\n\n- **\\--i _Directory_** - Specifies the path to search for imported (compiled)\n  MIB files. By default, the current working directory is always included.\n\n  This option can be present several times, each time specifying _one_ path.\n\n  [](){: #option_ildir }\n\n- **\\--il _Directory_** - This option (include_lib), specifies a list of\n  directories to search for imported MIBs. It assumes that the first element in\n  the directory name corresponds to an OTP application. The compiler will find\n  the current installed version. For example, the value \\[\"snmp/mibs/\"] will be\n  replaced by \\[\"snmp-3.1.1/mibs/\"] (or what the current version may be in the\n  system). The current directory and the \"snmp-home\"/priv/mibs/ are always\n  listed last in the include path.\n\n  [](){: #option_sgc }\n\n- **\\--sgc** - This option (skip group check), if present, disables the group\n  check of the mib compiler. That is, should the OBJECT-GROUP and the\n  NOTIFICATION-GROUP macro(s) be checked for correctness or not.\n\n  [](){: #option_dep }\n\n- **\\--dep** - Keep deprecated definition(s). If not specified the compiler will\n  ignore deprecated definitions.\n\n  [](){: #option_desc }\n\n- **\\--desc** - The DESCRIPTION field will be included.\n\n  [](){: #option_ref }\n\n- **\\--ref** - The REFERENCE field will be included.\n\n  [](){: #option_imp }\n\n- **\\--imp** - The IMPORTS field will be included.\n\n  [](){: #option_mi }\n\n- **\\--mi** - The MODULE-IDENTITY field will be included.\n\n  [](){: #option_mc }\n\n- **\\--mc** - The MODULE-COMPLIANCE field will be included.\n\n  [](){: #option_ac }\n\n- **\\--ac** - The AGENT-CAPABILITIES field will be included.\n\n  [](){: #option_mod }\n\n- **\\--mod _module_** - The module which implements all the instrumentation\n  functions.\n\n  The name of all instrumentation functions must be the same as the\n  corresponding managed object it implements.\n\n  [](){: #option_nd }\n\n- **\\--nd** - The default instrumentation functions will _not_ be used if a\n  managed object have no instrumentation function. Instead this will be reported\n  as an error, and the compilation aborts.\n\n  [](){: #option_rrnac }\n\n- **\\--rrnac** - This option, if present, specifies that the row name assign\n  check shall not be done strictly according to the SMI (which allows only the\n  value 1).\n\n  With this option, all values greater than zero is allowed (>= 1). This means\n  that the error will be converted to a warning.\n\n  By default it is not included, but if this option is present it will be.\n\n  [](){: #see_also }","ref":"snmpc_cmd.html#compiler-options"},{"type":"extras","title":"SEE ALSO - snmpc","doc":"[erlc(1)](`e:erts:erlc_cmd.md`), `m:compile`, `m:snmpc`","ref":"snmpc_cmd.html#see-also"}],"content_type":"text/plain","producer":{"name":"ex_doc","version":[48,46,51,52,46,49]}}