/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ops;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OPSChecker
implements ContentChecker {
    ZipFile zip;
    Report report;
    String path;
    String mimeType;
    XRefChecker xrefChecker;
    static XMLValidator xhtmlValidator = new XMLValidator("rng/ops20.nrl");
    static XMLValidator svgValidator = new XMLValidator("rng/svg11.rng");

    public OPSChecker(ZipFile zip, Report report, String path, String mimeType, XRefChecker xrefChecker) {
        this.zip = zip;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.mimeType = mimeType;
    }

    public void runChecks() {
        ZipEntry opfEntry = this.zip.getEntry(this.path);
        if (opfEntry == null) {
            this.report.error(null, 0, "OPS/XHTML file " + this.path + " is missing");
        } else {
            XMLParser opsParser = new XMLParser(this.zip, this.path, this.report);
            OPSHandler opsHandler = new OPSHandler(opsParser, this.path, this.xrefChecker);
            opsParser.addXMLHandler(opsHandler);
            if (this.mimeType.equals("image/svg+xml")) {
                opsParser.addValidator(svgValidator);
            } else {
                opsParser.addValidator(xhtmlValidator);
            }
            opsParser.process();
        }
    }
}

