/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSearchRequest
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitSearchRequest.class);

    public InitSearchRequest() {
        super("Init SearchRequest");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) {
        TLV tlv = container.getCurrentTLV();
        SearchRequestImpl internalSearchRequest = new SearchRequestImpl();
        internalSearchRequest.setMessageId(container.getMessageId());
        SearchRequestDecorator searchRequest = new SearchRequestDecorator(container.getLdapCodecService(), (SearchRequest)internalSearchRequest);
        searchRequest.setTlvId(tlv.getId());
        container.setMessage(searchRequest);
        LOG.debug("Search Request");
    }
}

