/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import java.util.Set;

public class ClassResolver {
    private final String mPkg;
    private final Set<String> mImports;
    private final ClassLoader mLoader;

    public ClassResolver(ClassLoader aLoader, String aPkg, Set<String> aImports) {
        this.mLoader = aLoader;
        this.mPkg = aPkg;
        this.mImports = aImports;
        this.mImports.add("java.lang.*");
    }

    public Class<?> resolve(String aName, String aCurrentClass) throws ClassNotFoundException {
        String innerClass;
        Class<?> clazz = this.resolveQualifiedName(aName);
        if (clazz != null) {
            return clazz;
        }
        for (String imp : this.mImports) {
            if (!imp.endsWith("." + aName) || (clazz = this.resolveQualifiedName(imp)) == null) continue;
            return clazz;
        }
        if (!"".equals(this.mPkg) && (clazz = this.resolveQualifiedName(this.mPkg + "." + aName)) != null) {
            return clazz;
        }
        if (!"".equals(aCurrentClass) && this.isLoadable(innerClass = (!"".equals(this.mPkg) ? this.mPkg + "." : "") + aCurrentClass + "$" + aName)) {
            return this.safeLoad(innerClass);
        }
        for (String imp : this.mImports) {
            String fqn;
            if (!imp.endsWith(".*") || (clazz = this.resolveQualifiedName(fqn = imp.substring(0, imp.lastIndexOf(46) + 1) + aName)) == null) continue;
            return clazz;
        }
        return this.safeLoad(aName);
    }

    public boolean isLoadable(String aName) {
        try {
            this.safeLoad(aName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Class<?> safeLoad(String aName) throws ClassNotFoundException {
        return Class.forName(aName, false, this.mLoader);
    }

    private Class<?> resolveQualifiedName(String aName) {
        try {
            String innerName;
            if (this.isLoadable(aName)) {
                return this.safeLoad(aName);
            }
            int dot = aName.lastIndexOf(".");
            if (dot != -1 && this.isLoadable(innerName = aName.substring(0, dot) + "$" + aName.substring(dot + 1))) {
                return this.safeLoad(innerName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }
}

