/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.util.LinkedList;
import jdiff.API;
import jdiff.Comments;
import jdiff.Modifiers;
import jdiff.XMLToAPI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class APIHandler
extends DefaultHandler {
    public API api_;
    public static boolean checkIsSentence = false;
    private String currentElement = null;
    private boolean createGlobalComments_ = false;
    private boolean inDoc = false;
    private String currentText = null;
    private String currentDepText = null;
    private LinkedList tagStack = null;
    private static boolean convertAtLinks = true;
    private static boolean trace = false;

    public APIHandler(API api, boolean createGlobalComments) {
        this.api_ = api;
        this.createGlobalComments_ = createGlobalComments;
        this.tagStack = new LinkedList();
    }

    public void startDocument() {
    }

    public void endDocument() {
        if (trace) {
            this.api_.dump();
        }
        System.out.println(" finished");
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equals("")) {
            localName = qName;
        }
        if (localName.compareTo("api") == 0) {
            String apiName = attributes.getValue("name");
            String version = attributes.getValue("jdversion");
            XMLToAPI.nameAPI(apiName);
        } else if (localName.compareTo("package") == 0) {
            this.currentElement = localName;
            String pkgName = attributes.getValue("name");
            XMLToAPI.addPackage(pkgName);
        } else if (localName.compareTo("class") == 0) {
            this.currentElement = localName;
            String className = attributes.getValue("name");
            String parentName = attributes.getValue("extends");
            boolean isAbstract = false;
            if (attributes.getValue("abstract").compareTo("true") == 0) {
                isAbstract = true;
            }
            XMLToAPI.addClass(className, parentName, isAbstract, this.getModifiers(attributes));
        } else if (localName.compareTo("interface") == 0) {
            this.currentElement = localName;
            String className = attributes.getValue("name");
            String parentName = attributes.getValue("extends");
            boolean isAbstract = false;
            if (attributes.getValue("abstract").compareTo("true") == 0) {
                isAbstract = true;
            }
            XMLToAPI.addInterface(className, parentName, isAbstract, this.getModifiers(attributes));
        } else if (localName.compareTo("implements") == 0) {
            String interfaceName = attributes.getValue("name");
            XMLToAPI.addImplements(interfaceName);
        } else if (localName.compareTo("constructor") == 0) {
            this.currentElement = localName;
            String ctorType = attributes.getValue("type");
            XMLToAPI.addCtor(ctorType, this.getModifiers(attributes));
        } else if (localName.compareTo("method") == 0) {
            this.currentElement = localName;
            String methodName = attributes.getValue("name");
            String returnType = attributes.getValue("return");
            boolean isAbstract = false;
            if (attributes.getValue("abstract").compareTo("true") == 0) {
                isAbstract = true;
            }
            boolean isNative = false;
            if (attributes.getValue("native").compareTo("true") == 0) {
                isNative = true;
            }
            boolean isSynchronized = false;
            if (attributes.getValue("synchronized").compareTo("true") == 0) {
                isSynchronized = true;
            }
            XMLToAPI.addMethod(methodName, returnType, isAbstract, isNative, isSynchronized, this.getModifiers(attributes));
        } else if (localName.compareTo("field") == 0) {
            this.currentElement = localName;
            String fieldName = attributes.getValue("name");
            String fieldType = attributes.getValue("type");
            boolean isTransient = false;
            if (attributes.getValue("transient").compareTo("true") == 0) {
                isTransient = true;
            }
            boolean isVolatile = false;
            if (attributes.getValue("volatile").compareTo("true") == 0) {
                isVolatile = true;
            }
            String value = attributes.getValue("value");
            XMLToAPI.addField(fieldName, fieldType, isTransient, isVolatile, value, this.getModifiers(attributes));
        } else if (localName.compareTo("param") == 0) {
            String paramName = attributes.getValue("name");
            String paramType = attributes.getValue("type");
            XMLToAPI.addParam(paramName, paramType);
        } else if (localName.compareTo("exception") == 0) {
            String paramName = attributes.getValue("name");
            String paramType = attributes.getValue("type");
            XMLToAPI.addException(paramName, paramType, this.currentElement);
        } else if (localName.compareTo("doc") == 0) {
            this.inDoc = true;
            this.currentText = null;
        } else if (this.inDoc) {
            this.addStartTagToText(localName, attributes);
        } else {
            System.out.println("Error: unknown element type: " + localName);
            System.exit(-1);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("")) {
            localName = qName;
        }
        if (localName.compareTo("doc") == 0) {
            this.inDoc = false;
            this.addTextToComments();
        } else if (this.inDoc) {
            this.addEndTagToText(localName);
        } else if (this.currentElement.compareTo("constructor") == 0 && localName.compareTo("constructor") == 0) {
            this.currentElement = "class";
        } else if (this.currentElement.compareTo("method") == 0 && localName.compareTo("method") == 0) {
            this.currentElement = "class";
        } else if (this.currentElement.compareTo("field") == 0 && localName.compareTo("field") == 0) {
            this.currentElement = "class";
        } else if (!(this.currentElement.compareTo("class") != 0 && this.currentElement.compareTo("interface") != 0 || localName.compareTo("class") != 0 && localName.compareTo("interface") != 0)) {
            this.currentElement = "package";
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inDoc) {
            String chunk = new String(ch, start, length);
            this.currentText = this.currentText == null ? chunk : this.currentText + chunk;
        }
    }

    public void addTextToComments() {
        this.currentText = this.currentText.trim();
        if (convertAtLinks) {
            this.currentText = Comments.convertAtLinks(this.currentText, this.currentElement, this.api_.currPkg_, this.api_.currClass_);
        }
        if (checkIsSentence && !this.currentText.endsWith(".") && this.currentText.compareTo("InsertCommentsHere") != 0) {
            System.out.println("Warning: text of comment does not end in a period: " + this.currentText);
        }
        String commentID = null;
        if (this.currentElement.compareTo("package") == 0) {
            this.api_.currPkg_.doc_ = this.currentText;
            commentID = this.api_.currPkg_.name_;
        } else if (this.currentElement.compareTo("class") == 0 || this.currentElement.compareTo("interface") == 0) {
            this.api_.currClass_.doc_ = this.currentText;
            commentID = this.api_.currPkg_.name_ + "." + this.api_.currClass_.name_;
        } else if (this.currentElement.compareTo("constructor") == 0) {
            this.api_.currCtor_.doc_ = this.currentText;
            commentID = this.api_.currPkg_.name_ + "." + this.api_.currClass_.name_ + ".ctor_changed(";
            commentID = this.api_.currCtor_.type_.compareTo("void") == 0 ? commentID + ")" : commentID + this.api_.currCtor_.type_ + ")";
        } else if (this.currentElement.compareTo("method") == 0) {
            this.api_.currMethod_.doc_ = this.currentText;
            commentID = this.api_.currPkg_.name_ + "." + this.api_.currClass_.name_ + "." + this.api_.currMethod_.name_ + "_changed(" + this.api_.currMethod_.getSignature() + ")";
        } else if (this.currentElement.compareTo("field") == 0) {
            this.api_.currField_.doc_ = this.currentText;
            commentID = this.api_.currPkg_.name_ + "." + this.api_.currClass_.name_ + "." + this.api_.currField_.name_;
        }
        if (this.createGlobalComments_ && commentID != null) {
            String ctOld;
            String ct = this.currentText;
            if (this.currentDepText != null) {
                ct = this.currentDepText;
                this.currentDepText = null;
            }
            if ((ctOld = Comments.allPossibleComments.put(commentID, ct)) != null) {
                System.out.println("Error: duplicate comment id: " + commentID);
                System.exit(5);
            }
        }
    }

    public void addStartTagToText(String localName, Attributes attributes) {
        String currentHTMLTag = localName;
        this.tagStack.add(currentHTMLTag);
        String tag = "<" + currentHTMLTag;
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            tag = tag + " " + name + "=\"" + value + "\"";
            ++i;
        }
        tag = Comments.isMinimizedTag(currentHTMLTag) ? tag + "/>" : tag + ">";
        this.currentText = this.currentText == null ? tag : this.currentText + tag;
    }

    public void addEndTagToText(String localName) {
        String currentHTMLTag = (String)this.tagStack.removeLast();
        if (!Comments.isMinimizedTag(currentHTMLTag)) {
            this.currentText = this.currentText + "</" + currentHTMLTag + ">";
        }
    }

    public Modifiers getModifiers(Attributes attributes) {
        Modifiers modifiers = new Modifiers();
        modifiers.isStatic = false;
        if (attributes.getValue("static").compareTo("true") == 0) {
            modifiers.isStatic = true;
        }
        modifiers.isFinal = false;
        if (attributes.getValue("final").compareTo("true") == 0) {
            modifiers.isFinal = true;
        }
        modifiers.isDeprecated = false;
        String cdt = attributes.getValue("deprecated");
        if (cdt.compareTo("not deprecated") == 0) {
            modifiers.isDeprecated = false;
            this.currentDepText = null;
        } else if (cdt.compareTo("deprecated, no comment") == 0) {
            modifiers.isDeprecated = true;
            this.currentDepText = null;
        } else {
            modifiers.isDeprecated = true;
            this.currentDepText = API.showHTMLTags(cdt);
        }
        modifiers.visibility = attributes.getValue("visibility");
        return modifiers;
    }

    public void warning(SAXParseException e) {
        System.out.println("Warning (" + e.getLineNumber() + "): parsing XML API file:" + e);
        e.printStackTrace();
    }

    public void error(SAXParseException e) {
        System.out.println("Error (" + e.getLineNumber() + "): parsing XML API file:" + e);
        e.printStackTrace();
        System.exit(1);
    }

    public void fatalError(SAXParseException e) {
        System.out.println("Fatal Error (" + e.getLineNumber() + "): parsing XML API file:" + e);
        e.printStackTrace();
        System.exit(1);
    }
}

