/*
 * ZIDRAV, file corruption repairer
 * Copyright (C) 1999  Ben Wilhelm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdlib.h>
#include <unistd.h>
#include "flayer.h"
#include "core.h"

#define DEF_BS 16384

#define ZV  "1.0"

int
main (int argc, char *argv[])
{
    int mode = 'c';
    int bs = 0;
    char * inf = NULL;
    char * outf = NULL;
    
    int c;
    while ((c = getopt(argc, argv, "Vhcpab:o:i:" )) != -1)
    {
        switch (c)
        {
            case ':':
                cout << "Missing parameter. Use '-h' option\n";
                exit (1);
            case '?':
                cout << "Check '-h' option\n";
                exit (1);
            case 'h':
                cout << "Possibile options:\n"
                    "This help message:\n"
                    "\tzidrav -h\n"
                    "Creating checksum:\n"
                    "\tzidrav [-b bs] [-o CDT] file\n"
                    "Creating patch:\n"
                    "\tzidrav -p [-i CDT] [-o CDP] file\n"
                    "Applying patch:\n"
                    "\tzidrav -a [-i CDP] file\n";
                exit (0);
            case 'V':
                cout << "ZIDRAV for *nix v" << ZV << "\n";
                exit(0);
            case 'p':
                mode = 'p';
                break;
            case 'a':
                mode = 'a';
                break;
            case 'b':
                bs = atoi(optarg);
                break;
            case 'i':
                inf = optarg;
                break;
            case 'o':
                outf = optarg;
                break;
        }
    }

    if (argc != optind + 1) 
    {
       cout << "Missing file name. Check '-h' option.\n";
       exit (1);
    }
    
    switch (mode)
    {
        case 'c':
            if (!bs)
                bs = DEF_BS;
            if (!outf)
            {
                outf = new char [strlen(argv[optind]) + strlen(".cdt") + 1];
                strcat(strcpy(outf, argv[optind]), ".cdt");
            }
            MakeChecksumFLayer(argv[optind], outf, bs);
            exit (0);            
        case 'p':
            if (!outf)
            {
                if (inf) 
                {
                    short len = strlen(inf);
                    if (!strcasecmp(inf + (len - 4), ".cdt"))
                    {
                        outf = strdup(inf);
                        strcpy(outf + (len - 4), ".cdp"); // change .cdt to .cdp
                    }
                    else // just add .cdp to the end of CDT file
                    {
                        outf = new char [len + 5];
                        strcpy(outf, inf);
                        strcat(outf, ".cdp");
                    }
                }
                else // add .cdp to the end of FILE
                {                    
                    outf = new char [strlen(argv[optind]) + strlen(".cdp") + 1];
                    strcat(strcpy(outf, argv[optind]), ".cdp");
                }
            }
            if (!inf)
            {
                inf = new char [strlen(argv[optind]) + strlen(".cdt") + 1];
                strcat(strcpy(inf, argv[optind]), ".cdt");
            }
            MakePatchFLayer(inf, argv[optind], outf);
            exit (0);
        case 'a':
            if (!inf)
            {
                inf = new char [strlen(argv[optind]) + strlen(".cdp") + 1];
                strcat(strcpy(inf, argv[optind]), ".cdp");
            }
            ApplyPatchFLayer(inf, argv[optind]);
            exit (0);
    }
    
}    
