/*
 *  UpdateRoloInfo()    -   updates Rolodex Info on the dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   14-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

void UpdateRoloInfo ()
{
    int
        length;

    char
        *text;

    length = 10*MaxTextLength;

    /*
    ** allocate memory
    */

    text = (char *) malloc (length*sizeof(char));

    if (text == (char *) NULL)
    {
        WriteStatus(1, rolomessageTextW,
            "Unable to display Info, Memory Allocation problem!");
        return;
    }

    (void) sprintf (text, "Yrolo Information:\n\n");
    if (rolofile != (char *) NULL)
        (void) sprintf (text, "%s Yrolo Filename:       %s\n",
            text, rolofile);    

        (void) sprintf (text, "%s Number of Cards:      %d\n",
        text, GnumberOfCards);

    if ((GwroteToTempfile == True) && (GrolodexModified == True))
        (void) sprintf (text, "%s Status:               Modified, Not saved yet.\n", text);


    XtVaSetValues (GinfoTextW,
        XmNvalue, text,
        NULL);
    (void) free ((char *) text);
}
