/*
 *	RegisterAsModal()	-	register a dialog as Modal
 *
 *	RCS:
 *		$Revision: 1.1 $
 *		$Date: 1995/05/07 19:34:10 $
 *
 *	Security:
 *		Unclassified
 *
 *	Description:
 *		This function register a dialog as modal. It is needed to know when
 *		a modal dialog is active in order to give corrent modality to help
 *		dialog
 *
 *	Adapted from the fine software llnlXftp
 *
 *	Input Parameters:
 *		type	identifier	description
 *
 *		text
 *
 *	Output Parameters:
 *		type	identifier	description
 *
 *		text
 *
 *	Return Values:
 *		value	description
 *
 *	Side Effects:
 *		text
 *
 *	Limitations and Comments:
 *		text
 *
 *	Development History:
 *		who					when		why
 *		muquit@semcor.com	18-Jan-95	first cut
 */

#include "xhead.h"
#include "xymrolo.h"

void RegisterAsModal (widget)
Widget
	widget;
{
	Widget
		shell;

	for (shell=widget; !XtIsShell(shell); shell=XtParent(shell));

	/*
	** add callbacks for monitoring use of modal dialog
	*/

	XtAddCallback (shell, XmNpopupCallback, CbSetModalFlag, 
		(XtPointer) True);

	XtAddCallback (shell, XmNpopdownCallback, CbSetModalFlag,
		(XtPointer) False);
}

void CbSetModalFlag (widget, client_data, call_data)
Widget
	widget;
XtPointer
	client_data;
XtPointer
	call_data;
{
	unsigned int
		flag;

	flag = (unsigned int) client_data;

	if (flag == GmodalDialogActive)
		Error("Bug in CbSetModalFlag()", (char *) NULL);

	GmodalDialogActive = flag;
}
