/*
 *  PrepareList()   -   prepares the list, if no rolo file is provided at
 *                      command line
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   15-Jan-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"


int PrepareList()
{
    int
        rc = 0;

    char
        *filename;

    char
        tmpbuf[MaxTextLength];

    filename = getenv("YROLODEX");

    if (filename == (char *) NULL)
    {
        filename = getenv ("HOME"); /* check if $HOME is set */
        if (filename == (char *) NULL)  /* $HOME not set */
            filename = ".yrolo.yr"; /* file will at cwd */
        else
        {
            filename = tmpbuf;
            (void) sprintf(filename,"%s/%s",getenv("HOME"),".yrolo.yr");
        }
    }

    rc = ReadList(filename);
    
    return (rc);
}
