/*
 *  PrintCards()    - prints the card/s
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   25-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

int  PrintCards (filename)
char
    *filename;
{
   int
        rc = 0;
    
   FILE
        *fp;
         
    char
        *s; 
    
    int
        n;

#ifdef DEBUG
    (void) fprintf (stderr,"filename: %s\n",
        filename);
#endif

    fp = OpenFile (filename, "w");


    if (fp != (FILE *) NULL)
    {
        if (GprintDisplayedCard == True)
        {
            n = DisplayedCard;
            if (XmToggleButtonGadgetGetState(GprintNameTbW))
            {
                s = GetCardName (n);
                (void) fprintf (fp, "%s\n", s);
            }

            if (XmToggleButtonGadgetGetState(GprintCompanyTbW))
            {
                s = GetCompanyName(n);
                (void) fprintf (fp, "%s\n", s);
            }

            if (XmToggleButtonGadgetGetState(GprintAddressTbW))
            {
                s = GetAddress (n);
                (void) fprintf (fp, "%s\n", s);

                s = GetAddress2 (n);
                (void) fprintf (fp, "%s\n", s);
            }

            if (XmToggleButtonGadgetGetState(GprintHomePhTbW))
            {
                s = GetNumber1(n);
                (void) fprintf (fp, "%s\n", s);
            }

            if (XmToggleButtonGadgetGetState(GprintWorkPhTbW))
            {
                s = GetNumber2(n);
                (void) fprintf (fp, "%s\n", s);
            }

            if (XmToggleButtonGadgetGetState(GprintFaxTbW))
            {
                s = GetNumber3(n);
                (void) fprintf (fp, "%s\n", s);
            }

            if (XmToggleButtonGadgetGetState(GprintEmailTbW))
            {
                s = GetEmail(n);
                (void) fprintf (fp, "%s\n", s);
            }

            if (XmToggleButtonGadgetGetState(GprintRemarksTbW))
            {
                s = GetText(n);
                (void) fprintf (fp, "%s\n", s);
            }
            (void) fprintf (fp, "\n");

        } /* GprintDisplayedCard == True */
        else
        {
            RoloRec
                *rr;

            for (rr=RoloList; rr != (RoloRec *) NULL; rr=rr->next)
            {
                if (XmToggleButtonGadgetGetState(GprintNameTbW))
                {
                    if (rr->name)
                        fprintf(fp, "%s\n", rr->name);
                    else
                        (void) fputc('\n', fp);
                }

                if (XmToggleButtonGadgetGetState(GprintCompanyTbW))
                {
                    if (rr->company) 
                        (void) fprintf(fp, "%s\n", rr->company); 
                    else 
                        (void) fputc('\n', fp); 
                }

                if (XmToggleButtonGadgetGetState(GprintAddressTbW))
                {
                    if (rr->address)
                        (void) fprintf(fp, "%s\n", rr->address);
                    else
                        (void) fputc('\n', fp);

                    if (rr->address2)
                        (void) fprintf(fp, "%s\n", rr->address2);
                    else
                        (void) fputc('\n', fp);
                }

                if (XmToggleButtonGadgetGetState(GprintHomePhTbW))
                {
                    if (rr->number)
                        (void) fprintf(fp, "%s\n", rr->number);
                    else
                        (void) fputc('\n', fp);
                }

                if (XmToggleButtonGadgetGetState(GprintWorkPhTbW))
                {
                    if (rr->number2)
                        (void) fprintf(fp, "%s\n", rr->number2);
                    else
                        (void) fputc('\n', fp);
                }

                if (XmToggleButtonGadgetGetState(GprintFaxTbW))
                {
                    if (rr->number3)
                        (void) fprintf(fp, "%s\n", rr->number3);
                    else
                        (void) fputc('\n', fp);
                }
                
                if (XmToggleButtonGadgetGetState(GprintEmailTbW))
                {
                    if (rr->email)
                        (void) fprintf(fp,"%s\n",rr->email);
                    else
                        (void) fputc('\n', fp);
                }

                if (XmToggleButtonGadgetGetState(GprintRemarksTbW))
                {
                    if (rr->text)
                        (void) fprintf(fp, "%s", rr->text);
                }
                (void) fprintf (fp,"\n");
            }

        } /* print all cards */
    }
    else
        WriteStatus(1,rolomessageTextW,
         "Error: Unable to Print!");

    if (fp != (FILE *) NULL)
    {
        if (*filename != '|')
            (void) fclose ((FILE *) fp);
        else
            (void) pclose ((FILE *) fp);
    }

return (rc);
}
