/*
 *  OpenFile()  - opens a file. 
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      if the filename prefix is '|', it is file pointer points to a
 *      system command
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *      (FILE *) fp on success
 *      (FILE *) NULL on failure
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      filename poits to a array of type char. 
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   25-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

FILE *OpenFile (filename, type)
char
    *filename;
char
    *type;
{
    FILE
        *fp;

    fp = (FILE *) NULL;


    if (*filename == '|')
    {
        if (*type == 'w')
        {
            (void) signal (SIGPIPE, SIG_IGN);
            fp = (FILE *) popen (filename+1, type);
        }
    }
    else
    {
        if (*type == 'w')
        {
            fp = (FILE *) fopen (filename, type);
        }
    }

return ((FILE *)fp);
}

#ifdef TEST

void main(argc,argv)
int
    argc;
char
    **argv;
{
    FILE
        *fp;

    char
        filename[MaxTextLength];

    if (argc != 3)
    {
        (void) fprintf (stderr,"%s file1 r/w\n", argv[0]);
        exit(1);
    }
    (void) strcpy (filename, argv[1]);
    fp = OpenFile (filename, argv[2]);

    if (fp != (FILE *) NULL)
    {
        (void) fprintf (stderr," succeded..!\n");
        if (*filename == '|')
        {
            (void) fprintf (stderr," closing pipe!\n");
            (void) pclose (fp);
        }
        else
        {
            (void) fprintf (stderr," closing file!\n");
            (void) fclose (fp);
        }
    }
    else
        (void) fprintf (stderr," failed..!\n");

}

#endif /* TEST */
