/*
 *	MakeCautionCursor()	- creates the Caution Cursor
 *
 *	RCS:
 *		$Revision: 1.1 $
 *		$Date: 1995/05/07 19:34:10 $
 *
 *	Security:
 *		Unclassified
 *
 *	Description:
 *		This functioin creates the cautionnification cursor
 *
 *	Input Parameters:
 *		type	identifier	description
 *
 *		text
 *
 *	Output Parameters:
 *		type	identifier	description
 *
 *		text
 *
 *	Return Values:
 *		value	description
 *
 *	Side Effects:
 *		text
 *
 *	Limitations and Comments:
 *		text
 *
 *	Development History:
 *		when	who		why
 *	03/29/95    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"

#include <caution.xbm>
#include <cautionm.xbm>

Cursor MakeCautionCursor (display, bgpixel, fgpixel)
Display
	*display;

unsigned long
	bgpixel;

unsigned long
	fgpixel;
{
	XColor 		bgcolor, fgcolor;
	Colormap	colormap;
	Cursor		cursor;
	Pixmap		mask, source;
	int 		screen;
    Window
        window;

    window = XRootWindow (display, XDefaultScreen(display));
	screen = XDefaultScreen (display);
	colormap = XDefaultColormap (display, screen);

	bgcolor.pixel = bgpixel;
	fgcolor.pixel = fgpixel;

	XQueryColor (display, colormap, &bgcolor);
	XQueryColor (display, colormap, &fgcolor);

	source = XCreateBitmapFromData (display, window,
		caution_bits,
		caution_width,
		caution_height);

	mask = XCreateBitmapFromData (display, window,
		cautionm_bits,
		cautionm_width,
		cautionm_height);

	if ((source == (Pixmap) NULL) || (mask == (Pixmap) NULL))
    {
	    fprintf (stderr, "Failed to create Pixmap for Cursor!\n");
        return ((Cursor) NULL);
    }

	cursor = XCreatePixmapCursor (display,
		source, mask,
		&bgcolor, &fgcolor,
		caution_x_hot, caution_y_hot);

	XFreePixmap (display, source);
	XFreePixmap (display, mask);
	return (cursor);
}
