/*
 *  IsBinary()  - checks if the file is binary
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *      1   - if the file is binary
 *      0   - if the file is text
 *      2   - unexpected EOF
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      filename points to a allocated space.
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   19-Mar-95   first cut
 */


#include <stdio.h>
#include <ctype.h>

int IsBinary(filename)
char
    *filename;
{
    FILE
        *fp;

    int
        c;

    int
        rc=0;

    fp = fopen(filename, "r");

    while ((c=fgetc(fp)) != EOF)
    {
        rc = isascii(c);
        if (rc == 0)
        {
            (void) fclose ((FILE *) fp);
            return (1); /* binary file */
        }
    }

    if (!feof(fp))
    {
        (void) fclose ((FILE *) fp);
        return (2);
    }

(void) fclose ((FILE *) fp);
return (0); /* text file */
}

#ifdef TEST

void main(argc, argv)
int
    argc;
char
    **argv;
{
    int
        status;

    if (argc < 2)
    {
        (void) fprintf(stderr,"Usage: %s file\n", argv[0]);
        exit(1);
    }

    status = IsBinary(argv[1]);

    switch (status)
    {
        case 1:
        {
            (void) fprintf(stderr,"Binary File\n");
            break;
        }

        case 0:
        {
            (void) fprintf(stderr,"Text file\n");
            break;
        }

        case 2:
        {
            (void) fprintf(stderr,"Unexpected EOF\n");
            break;
        }
    }
}

#endif /* TEST */
