/*
 *  FileMenuCB()    -   callback routine for File Menu items
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  10/29/94    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"

void FileMenuCB (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data;
XtPointer
    call_data;
{
    switch ((int) client_data)
    {
        case FILE_OPEN:
        {
            if (!XtIsManaged(w_special[FILE_OPEN_DIALOG_W]))
            {
                /*SetBusyCursorState (w_special[MAINWINDOW_W], True);*/
                SetCautionCursorState (w_special[MAINWINDOW_W], True);
                ManageWidget (w_special[FILE_OPEN_DIALOG_W]);
            }
            break;
        }

        case QUIT:
        {
            int
                i;

            for (i=0; i < 26; i++)
            {
                if (GArmPixmap[i] != (Pixmap) NULL)
                {
                    XFreePixmap(XtDisplay(w_special[TOPLEVEL_W]),
                        GArmPixmap[i]);
                    GArmPixmap[i] = (Pixmap) NULL;
                }

                if (GBPixmap[i] != (Pixmap) NULL)
                {
                    XFreePixmap(XtDisplay(w_special[TOPLEVEL_W]),
                        GBPixmap[i]);
                    GBPixmap[i] = (Pixmap) NULL;
                }
            }

            if ((GwroteToTempfile == True) && (GrolodexModified == True))
            {
                /*
                ** Manage the save dialog
                */

                GsaveAndExit = True;
                XBell (XtDisplay(GwarningDialogW), 99);
                XtManageChild (GwarningDialogW);
            }
            else
            {
                (void) unlink (GtempFilename);
                exit(1);
            }
            break;
        }

        default:
        {
            Warning("FileMenuCB():", "Invalid client_data");
        }
    }
}
