/*
 *  CreateSearchOptionD()   -   create search option dialog with 
 *                              toggle buttons
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *      True
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   26-Jan-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

Boolean CreateSearchOptionD (parent)
Widget
    parent;
{
    Widget
        frameW,
        radioW;

    Arg
        args[10];
    int
        n;

    n = 0;
    XtSetArg (args[n], XmNdeleteResponse, XmDO_NOTHING);    n++;
    XtSetArg (args[n], XmNtitle, "Restrict Search");          n++;

    GSformdW = XmCreatePromptDialog (parent, "Sform",
        args, n);

    XtAddCallback (GSformdW, XmNhelpCallback, 
        HelpCB, (XtPointer) SEARCH_OPTIONS);
    /*
    ** unmanage things we won't need
    */

        XtUnmanageChild(XmSelectionBoxGetChild (GSformdW,
            XmDIALOG_CANCEL_BUTTON));
      
        XtUnmanageChild(XmSelectionBoxGetChild (GSformdW,
            XmDIALOG_TEXT));

        XtUnmanageChild(XmSelectionBoxGetChild (GSformdW,
            XmDIALOG_SELECTION_LABEL));

    /*
    ** create a frame w
    */

    frameW = XtVaCreateManagedWidget ("Sframe",
        xmFrameWidgetClass, GSformdW,
        NULL);

    /*
    ** create a radio box
    */

    n = 0;
    XtSetArg(args[n], XmNpacking, XmPACK_COLUMN);           n++;
    XtSetArg(args[n], XmNradioBehavior, False);             n++;
    XtSetArg(args[n], XmNnumColumns, (XtArgVal)1);          n++;

    radioW = XmCreateRadioBox (frameW, "Sradio",
        args, n);

    /*
    ** name toggle
    */

    GSnameTbW = XtVaCreateManagedWidget ("SearchName",
        xmToggleButtonGadgetClass,  radioW,
        XmNset, (XtArgVal) True,
        NULL);

    /*
    ** company toggleB
    */

    GScompanyTbW = XtVaCreateManagedWidget ("SearchComnay",
        xmToggleButtonGadgetClass,  radioW,
        XmNset, (XtArgVal) True,
        NULL);

    /*
    ** address toggleB
    */

    GSaddressTbW = XtVaCreateManagedWidget ("SearchAddress",
        xmToggleButtonGadgetClass,  radioW,
        XmNset, (XtArgVal) True,
        NULL);

    /*
    ** phone 1 toggleB
    */

    GSph1TbW =  XtVaCreateManagedWidget ("SearchHomephone",
        xmToggleButtonGadgetClass,  radioW,
        XmNset, (XtArgVal) True,
        NULL);

    /*
    ** phone 2 toggleB
    */

    GSph2TbW =  XtVaCreateManagedWidget ("SearchWorkphone",
        xmToggleButtonGadgetClass,  radioW,
        XmNset, (XtArgVal) True,
        NULL);   

    /*
    ** fax toggleB
    */

    GSfaxTbW = XtVaCreateManagedWidget ("SearchFax",
        xmToggleButtonGadgetClass,  radioW,
        XmNset, (XtArgVal) True,
        NULL);

    /*
    ** email toggleB
    */
    GSemailTbW = XtVaCreateManagedWidget ("SearchEmail",
        xmToggleButtonGadgetClass,  radioW,
        XmNset, (XtArgVal) True,
        NULL);


    /*
    ** remarks toggleB
    */

    GSremarksTbW = XtVaCreateManagedWidget ("SearchRemarks",
        xmToggleButtonGadgetClass,  radioW,
        XmNset, (XtArgVal) True,
        NULL);

    XtManageChild (radioW);

    return (True);   /* Xt Will remove Work Proc Automatically */
}
