/*
 *  CreateSearchOutputDiaog()   -   shows the search output
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description
 *      This function creates the lit widget whill will hold the list
 *      found in the search. It's a modal dialog
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   24-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

static void SearchOpCancelCB _D ((Widget, XtPointer, XtPointer));

Boolean CreateSearchOutputDiaog (parent)
Widget
    parent;
{
    int
        n;

    Arg
        args[10];

    XmString
        xmstr;

    Widget
        formW,
        vsbW;

    Pixel
        bg_pixel;

    xmstr = XmStringCreateSimple ("-Search Matched-");

    n = 0;
    XtSetArg (args[n], XmNdialogTitle, xmstr);  n++;
    XtSetArg (args[n], XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL);            n++;

        
    GsearchOutputdW = XmCreatePromptDialog (parent,
        "Searchopd", args, n);

    XmStringFree (xmstr);

    XtUnmanageChild(XmSelectionBoxGetChild (GsearchOutputdW,
        XmDIALOG_TEXT));
 
    XtUnmanageChild(XmSelectionBoxGetChild(GsearchOutputdW,
        XmDIALOG_SELECTION_LABEL));

    XtUnmanageChild(XmSelectionBoxGetChild(GsearchOutputdW,
        XmDIALOG_OK_BUTTON));

    XtUnmanageChild(XmSelectionBoxGetChild(GsearchOutputdW,
        XmDIALOG_HELP_BUTTON));
    
    XtAddCallback (GsearchOutputdW, XmNcancelCallback,
        (XtCallbackProc) SearchOpCancelCB, NULL);

    /*
    ** create a form
    */

    formW = XtVaCreateWidget ("Sform",
        xmFormWidgetClass, GsearchOutputdW,
        NULL);

    /*
    ** create the list widget
    */

    n = 0;
    XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
    XtSetArg(args[n], XmNlistMarginWidth, 2);n++;
    XtSetArg(args[n], XmNscrollBarPlacement, XmBOTTOM_LEFT); n++;
    XtSetArg(args[n], XmNlistSpacing, 5); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNvisibleItemCount, 10);n++;

    GsearchListW = XmCreateScrolledList (formW, "Searchlist",
        args, n);

    XtAddCallback (GsearchListW, XmNbrowseSelectionCallback,
        (XtCallbackProc) SearchSelectCB, (XtPointer) NULL);

    /*
    ** set the scrollbar color
    */
    XtVaGetValues (XtParent(GsearchListW),
        XmNverticalScrollBar, &vsbW,
        NULL);

     bg_pixel = (Pixel) AllocateNamedColor(XtDisplay(w_special[TOPLEVEL_W]),
        scb_bgcolor);

     if (bg_pixel > 256) /* parse error */
        XtVaGetValues (w_special[TOPLEVEL_W],
            XmNbackground, &bg_pixel,
            NULL);
    SetScrollbarColors(vsbW, (Widget) NULL, bg_pixel);

    XtManageChild (GsearchListW);
    XtManageChild (formW);

    return (True);  /* Xt Will remove Work proc automatically */

}

static void SearchOpCancelCB (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data,
    call_data;
{
    SetBusyCursorState (w_special[MAINWINDOW_W], False);
}
