/*
 *  CreateMainWindow()  -   creates main window for yamrolo
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who                 why
 *  10/29/94    muquit@semcor.com   first cut
 */

#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"
#include "mqtools.h"

Widget CreateMainWindow (parent)
Widget
    parent;
{
    Arg
        args[20];

    int
        n;

    static Widget
        mainwW,
        searchframeW,
        searchRCW,
        searchLabelW,
        addCardPbW,
        editCardPbW,
        deleteCardPbW,
        sendmailPbW,
        rowColumnW,
        addressListW,
        menubarW;

    static Widget
        paneW,
        pformW,
        qformW,
        bframeW,
        browcolW,
        searchtextW;

    Widget  
        fieldframeW,
        fieldformW,
        vsbW;

    Pixel
        bg_pixel;

    extern MENUITEM
        file_items[],
        option_items[],
        help_items[];

    Widget
        hwidget,
        helpW;

    /*
    ** create main window
    */

    mainwW = XtVaCreateWidget ("MainW",
        xmMainWindowWidgetClass, parent,
        XmNshowSeparator, True,
        NULL);
    
    w_special[MAINWINDOW_W] = mainwW;

    /*
    ** create menubar
    */

    menubarW = XmCreateMenuBar (mainwW, "Menubar",
        NULL, 0);

    hwidget = MBuildPulldownMenu (menubarW, "File", 'F', file_items);
    XtAddCallback (hwidget, XmNhelpCallback, HelpContextCB,
        (XtPointer) FILE_MENU);

    hwidget = MBuildPulldownMenu (menubarW, "Options", 'O', option_items);
    XtAddCallback (hwidget, XmNhelpCallback, HelpContextCB,
        (XtPointer) OPTIONS_MENU);

    helpW = MBuildPulldownMenu (menubarW, "Help", 'H', help_items);
    XtVaSetValues (menubarW, XmNmenuHelpWidget, helpW, NULL);


    /*
    ** create a pane on the form
    */

    paneW = XtVaCreateWidget ("Pane",
        xmPanedWindowWidgetClass, mainwW,
        NULL);

    /*
    ** create a form on the pane
    */

    pformW = XtVaCreateWidget("Pform",
        xmFormWidgetClass, paneW,
        NULL);

    /*
    ** create the rowcolumn for folders
    */

    n = 0;
    XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
    XtSetArg (args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
    XtSetArg (args[n], XmNadjustLast, False);   n++;
    XtSetArg (args[n], XmNadjustMargin, False); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftOffset, (int)2); n++;
    XtSetArg(args[n], XmNrightOffset, (int)2); n++;
    XtSetArg(args[n], XmNtopOffset, (int)2); n++;
    XtSetArg(args[n], XmNx, 0); n++;
    XtSetArg(args[n], XmNy, 0); n++;


    rowColumnW = XtCreateWidget ("rowColumns",
        /*xmRowColumnWidgetClass, formW,*/
        xmRowColumnWidgetClass, pformW,
        args, n);
    
    XtManageChild (rowColumnW);

    /*
    ** Create the folder push buttons
    */

    CreateFolderPbW (rowColumnW);

    /*
    ** create the list
    */
 
    n = 0;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, rowColumnW); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    /*XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;*/
    XtSetArg(args[n], XmNtopOffset, (int)2); n++;
    XtSetArg(args[n], XmNleftOffset, (int)2); n++;
    /*XtSetArg(args[n], XmNrightOffset, (int)2); n++;*/
    XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
    /*XtSetArg(args[n], XmNselectionPolicy, XmSINGLE_SELECT); n++;*/
    /*XtSetArg(args[n], XmNhighlightThickness, 0); n++;*/
    XtSetArg(args[n], XmNlistMarginWidth, 2);n++;
    XtSetArg(args[n], XmNlistMarginHeight, 2);n++;
    XtSetArg(args[n], XmNscrollBarPlacement, XmBOTTOM_LEFT); n++;
    XtSetArg(args[n], XmNlistSpacing, 5); n++;


    addressListW = XmCreateScrolledList(pformW,"addressListW",
        args, n);

    XtManageChild (addressListW);
    w_special[ADDRESSLIST_W] = addressListW;

    XtAddCallback(addressListW, XmNbrowseSelectionCallback,
        (XtCallbackProc) SelectedCB, (XtPointer) NULL);

    XtAddCallback (addressListW, XmNhelpCallback,
        HelpCB, (XtPointer) ADDRESS_LIST_HELP);

    /*
    ** create a frame to the right side of the address list
    */

     fieldframeW = XtVaCreateManagedWidget ("Lframe",
        xmFrameWidgetClass, pformW,
        XmNshadowType, XmSHADOW_IN,
        /*XmNshadowType, XmSHADOW_ETCHED_OUT,
        XmNshadowThickness, 5,*/
        XmNleftAttachment, XmATTACH_WIDGET,
        XmNleftWidget, addressListW,
        XmNleftOffset, 10,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, rowColumnW,
        XmNtopOffset, 2,
        XmNbottomAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);
    /*
    ** create a form on the frame
    */

    fieldformW = XtVaCreateWidget ("Fform",
        xmFormWidgetClass, fieldframeW, 
        NULL);

    /*
    ** create the rolodex fields
    */

    CreateFields (fieldformW);

    /*
    ** create another form on the pane
    */

    qformW = XtVaCreateWidget ("Qform",
        xmFormWidgetClass, paneW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, pformW,
        NULL);

    /*
    ** create the status frame
    */

    bframeW = XtVaCreateManagedWidget("Bframe",
        xmFrameWidgetClass, qformW,
        XmNshadowType, XmSHADOW_ETCHED_IN, 
        XmNshadowThickness, 2,
        /*XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, addressListW,*/
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_FORM,
        NULL);

    /*
    ** create a rc on the frame
    */
    browcolW = XtVaCreateWidget("Browcol",
        xmRowColumnWidgetClass, bframeW,
        XmNorientation,XmVERTICAL,
        NULL);

    /*
    ** create the status message text widget, it's a global widget
    */

    rolomessageTextW =  XtVaCreateManagedWidget("Rstext",
        xmTextWidgetClass, browcolW,
        XmNeditable,                False,
        XmNcursorPositionVisible,   False,
        XmNshadowThickness,         0,
        NULL);

    XtAddCallback (rolomessageTextW, XmNhelpCallback,
        HelpCB, (XtPointer) STATUS_HELP);

    /*
    ** create a form at the bottom of drawing area on the main form
    */

    searchframeW = XtVaCreateWidget ("MframeW",
        xmFrameWidgetClass, qformW,
        XmNshadowType, XmSHADOW_ETCHED_OUT,
        XmNshadowThickness, 5,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, bframeW,
        XmNtopOffset, 2,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_FORM,
    /*    XmNbottomAttachment, XmATTACH_FORM,*/
        NULL);

    /*
    ** Create a rc on the frame
    */


    searchRCW = XtVaCreateWidget ("SerachRC",
        xmRowColumnWidgetClass, searchframeW,
        XmNorientation, XmHORIZONTAL,
        XmNentryAlignment, XmALIGNMENT_CENTER,
        XmNadjustLast, False,
        XmNadjustMargin, False,
        NULL);

    /*
    ** create a label on the form
    */

    searchLabelW = XtVaCreateManagedWidget ("SearchR",
        xmLabelGadgetClass, searchRCW,
        NULL);
    XtAddCallback (searchLabelW, XmNhelpCallback,
        HelpCB, (XtPointer) SEARCH_HELP);
    /*
    ** create a text widget on the rc, left of the label
    */

    searchtextW = XtVaCreateWidget ("SearchText",
        xmTextWidgetClass, searchRCW,
        XmNleftAttachment, XmATTACH_WIDGET,
        XmNleftWidget, searchLabelW,
        NULL);
    w_special[MESSAGE_TEXT_W] = searchtextW;

    XtAddCallback(searchtextW, XmNactivateCallback, SearchRoloCB, NULL);
    XtAddCallback (searchtextW, XmNhelpCallback,
        HelpCB, (XtPointer) SEARCH_HELP);

    /*
    ** create the clear Pb
    */
/*
    clearsPbW = XtVaCreateManagedWidget("Clearpb",
        xmPushButtonWidgetClass, searchRCW,
        NULL);

    XtAddCallback(clearsPbW, XmNactivateCallback, ClearSearchCB, NULL);
*/

    /*
    ** create the add card pb
    */

    addCardPbW = XtVaCreateManagedWidget("Addcardpb",
        xmPushButtonWidgetClass, searchRCW,
        NULL);

    XtAddCallback(addCardPbW, XmNactivateCallback, AddCardCB, NULL);
    XtAddCallback (addCardPbW, XmNhelpCallback,
        HelpCB, (XtPointer) ADD_CARD_HELP);
    /*
    ** create the Edit Card
    */
    editCardPbW = XtVaCreateManagedWidget("Editcardpb",
        xmPushButtonWidgetClass, searchRCW,
        NULL);

    XtAddCallback(editCardPbW, XmNactivateCallback,
        EditCardCB, NULL);
    XtAddCallback(editCardPbW, XmNhelpCallback,
        HelpCB, (XtPointer) EDIT_CARD_HELP);

    GEditPbW = editCardPbW;
    XtSetSensitive(editCardPbW, False);

    /*
    ** create the delete card
    */
    deleteCardPbW = XtVaCreateManagedWidget("Deletecardpb",
        xmPushButtonWidgetClass, searchRCW,
        NULL);

    w_special[DELETE_PB_W] = deleteCardPbW;

    XtAddCallback (deleteCardPbW, XmNactivateCallback,
        (XtCallbackProc) InfoButtonCB, (XtPointer) DELETE_CARD);
    XtAddCallback (deleteCardPbW, XmNhelpCallback,
        HelpCB, (XtPointer) DELETE_CARD_HELP);
    
    XtSetSensitive (deleteCardPbW, False);

    /*
    ** create sendmail button
    */

    sendmailPbW = XtVaCreateManagedWidget ("Sendmailpb",
        xmPushButtonWidgetClass, searchRCW,
        NULL);
    w_special[SENDMAIL_PB_W] = sendmailPbW;

    XtAddCallback (sendmailPbW, XmNactivateCallback,
        (XtCallbackProc) InfoButtonCB, (XtPointer) SEND_MAIL);
    XtAddCallback (sendmailPbW, XmNhelpCallback,
        HelpCB, (XtPointer) SEND_MAIL_HELP);

    XtSetSensitive(sendmailPbW, False);
    /*
    ** set the scrollbar colors
    */

    XtVaGetValues (XtParent(addressListW),
        XmNverticalScrollBar, &vsbW,
        NULL);

    bg_pixel = (Pixel) AllocateNamedColor(XtDisplay(w_special[TOPLEVEL_W]),
        scb_bgcolor);

    if (bg_pixel > 256) /* parse error */
    {
        /*
        ** choose the color of the toplevel widget
        */

        XtVaGetValues (w_special[TOPLEVEL_W],
            XmNbackground, &bg_pixel,
            NULL);
    }

    SetScrollbarColors(vsbW, (Widget) NULL, bg_pixel);

    XtManageChild (searchtextW);
    XtManageChild (searchframeW);
    XtManageChild (rolomessageTextW);
    XtManageChild (browcolW);
    XtManageChild (searchRCW);
    XtManageChild (pformW);
    XtManageChild (qformW);
    XtManageChild (fieldformW);
    XtManageChild (paneW);
    XtManageChild (menubarW);
    XtManageChild (mainwW);

    return (mainwW);
}
