/*
 *  CreateIncludeFileOpenD - creates the file selection dialog for inlcuding
 *                           file in the letter
 *                       
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who                 why
 *  10/29/94    muquit@semcor.com   first cut
 */

#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"

Boolean CreateIncludeFileOpenD (parent)
Widget
    parent;
{
    Arg
        args[7];

    register int
        n;

    static Widget
        fileselW;

    XmString
        xmstr1,
        xmstr2,
        xmstr3;

    char
        *text = "*.*";
    n = 0;
    XtSetArg (args[n], XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL);                n++;

    xmstr1 = XmStringCreateSimple ("Include File");

    XtSetArg (args[n], XmNdialogTitle, xmstr1);             n++;
    XtSetArg (args[n], XmNautoUnmanage, False);             n++;

    xmstr2 = XmStringCreateSimple ("Input File");
    xmstr3 = XmStringCreateSimple(text);

    XtSetArg (args[n], XmNselectionLabelString, xmstr2);    n++;
    XtSetArg (args[n], XmNpattern, xmstr3); n++;

    fileselW = XmCreateFileSelectionDialog(parent, "FileSelect",
        args, n);

    XtUnmanageChild (XmFileSelectionBoxGetChild(fileselW, 
        XmDIALOG_HELP_BUTTON));

    XtAddCallback (fileselW, XmNcancelCallback, UnmanageCB, 
        (XtPointer) fileselW);

    XtAddCallback (fileselW, XmNokCallback, IncludeFileCB,
        (XtPointer) NULL);


    GfileincD = fileselW;

    XmStringFree (xmstr1);
    XmStringFree (xmstr2);
    XmStringFree (xmstr3);

    return (True);  /* Xt will remove Work Proc automatically */

}
