/*
 *  FileOpenDialog()    -   This function opens the file selection dialog box
 *                       
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who                 why
 *  10/29/94    muquit@semcor.com   first cut
 */

#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"

Boolean CreateFileOpenDialog (parent)
Widget
    parent;
{
    Arg
        args[7];

    register int
        n;

    static Widget
        fileselW;

    XmString
        xmstr1,
        xmstr2,
        xmstr3;

    char
        *text = "*.yr";
    n = 0;
    XtSetArg (args[n], XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL);                n++;

    xmstr1 = XmStringCreateSimple ("Open Database");

    XtSetArg (args[n], XmNdialogTitle, xmstr1);             n++;
    XtSetArg (args[n], XmNautoUnmanage, False);             n++;

    xmstr2 = XmStringCreateSimple ("Input File");
    xmstr3 = XmStringCreateSimple(text);

    XtSetArg (args[n], XmNselectionLabelString, xmstr2);    n++;
    XtSetArg (args[n], XmNpattern, xmstr3); n++;

    fileselW = XmCreateFileSelectionDialog(parent, "FileSelect",
        args, n);

    XtVaSetValues (XtParent(fileselW),
        XmNallowShellResize, False,
        NULL);

    /*
    ** register the dialog as modal
    */
    RegisterAsModal (fileselW);

    XtAddCallback (fileselW, XmNcancelCallback, UnmanageCB, 
        (XtPointer) fileselW);

    XtAddCallback (fileselW, XmNokCallback, FileSelectionCB,
        (XtPointer) FILE_OPEN);

    XtAddCallback (fileselW, XmNhelpCallback, HelpCB,
        (XtPointer) FILE_OPEND_HELP);

    w_special[FILE_OPEN_DIALOG_W] = fileselW;

    XmStringFree (xmstr1);
    XmStringFree (xmstr2);
    XmStringFree (xmstr3);

    return (True);

}
