/*
 *  CreateFolderPbW()   -   create folder push buttons
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/11/94    muquit  first cut
 */

#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

#include "foldera.xbm"
#include "folderb.xbm"
#include "folderc.xbm"
#include "folderd.xbm"
#include "foldere.xbm"
#include "folderf.xbm"
#include "folderg.xbm"
#include "folderh.xbm"
#include "folderi.xbm"
#include "folderj.xbm"
#include "folderk.xbm"
#include "folderl.xbm"
#include "folderm.xbm"
#include "foldern.xbm"
#include "foldero.xbm"
#include "folderp.xbm"
#include "folderq.xbm"
#include "folderr.xbm"
#include "folders.xbm"
#include "foldert.xbm"
#include "folderu.xbm"
#include "folderv.xbm"
#include "folderw.xbm"
#include "folderx.xbm"
#include "foldery.xbm"
#include "folderz.xbm"

void CreateFolderPbW (parent)   /* parent is rowColumnW */
Widget
    parent;
{
    int
        i;
    
    Widget
        folderpbW;

    Pixmap
        armpixmap,
        pixmap;
    
    unsigned int
        fg_pixel;

    unsigned long
        bg_pixel;

    int
        depth = 8;

    char
        *array[26];

    Display
        *display;
    
    int
        screen;
    
    char
        **p,
        *indexElem[26],
        *index[26];

    static char *string[] =
    {
        "A","B","C","D","E","F",
        "G", "H", "I", "J", "K", "L",
        "M", "N", "O", "P", "Q", "R",
        "S", "T", "U", "V", "W", "X",
        "Y", "Z",
        (char *) NULL
    };

    static char *string2[] =
    {
        "a","b","c","d","e","f",
        "g", "h", "i", "j", "k", "l",
        "m", "n", "o", "p", "q", "r",
        "s", "t", "u", "v", "w", "x",
        "y", "z",
        (char *) NULL
    };

    display = XtDisplay(w_special[TOPLEVEL_W]);
    screen = DefaultScreen(display);
    
if (GnoPixmaps == False)
{
    if (GuseFolderPixmaps == True )
    {   
        for (i=0; i < 26; i++)
        {
            switch(i)
            {
                case 0:
                {
                    array[i] = foldera_bits;
                    index[i]="a";
                    break;
                }

                case 1:
                {
                    array[i] = folderb_bits;
                    index[i]="b";
                    break;
                }

                case 2:
                {
                    array[i] = folderc_bits;
                    index[i]="c";
                    break;
                }

                case 3:
                {
                    array[i] = folderd_bits;
                    index[i]="d";
                    break;
                }

                case 4:
                {
                    array[i] = foldere_bits;
                    index[i]="e";
                    break;
                }

                case 5:
                {
                    array[i] = folderf_bits;
                    index[i]="f";
                    break;
                }

                case 6:
                {
                    array[i] = folderg_bits;
                    index[i]="g";
                    break;
                }

                case 7:
                {
                    array[i] = folderh_bits;
                    index[i]="h";
                    break;
                }

                case 8:
                {
                    array[i] = folderi_bits;
                    index[i]="i";
                    break;
                }

                case 9:
                {
                    array[i] = folderj_bits;
                    index[i]="j";
                    break;
                }

                case 10:
                {
                    array[i] = folderk_bits;
                    index[i]="k";
                    break;
                }

                case 11:
                {
                    array[i] = folderl_bits;
                    index[i]="l";
                    break;
                }

                case 12:
                {
                    array[i] = folderm_bits;
                    index[i]="m";
                    break;
                }

                case 13:
                {
                    array[i] = foldern_bits;
                    index[i]="n";
                    break;
                }

                case 14:
                {
                    array[i] = foldero_bits;
                    index[i]="o";
                    break;
                }

                case 15:
                {
                    array[i] = folderp_bits;
                    index[i]="p";
                    break;
                }

                case 16:
                {
                    array[i] = folderq_bits;
                    index[i]="q";
                    break;
                }

                case 17:
                {
                    array[i] = folderr_bits;
                    index[i]="r";
                    break;
                }

                case 18:
                {
                    array[i] = folders_bits;
                    index[i]="s";
                    break;
                }

                case 19:
                {
                    array[i] = foldert_bits;
                    index[i]="t";
                    break;
                }

                case 20:
                {
                    array[i] = folderu_bits;
                    index[i]="u";
                    break;
                }

                case 21:
                {
                    array[i] = folderv_bits;
                    index[i]="v";
                    break;
                }

                case 22:
                {
                    array[i] = folderw_bits;
                    index[i]="w";
                    break;
                }

                case 23:
                {
                    array[i] = folderx_bits;
                    index[i]="x";
                    break;
                }

                case 24:
                {
                    array[i] = foldery_bits;
                    index[i]="y";
                    break;
                }
                case 25:

                {
                    array[i] = folderz_bits;
                    index[i]="z";
                    break;
                }
            }
        }/* for */
    }/* if */
    else
    {
        i=0; 
        for (p=string; *p != (char *) NULL; p++)
        {
            indexElem[i] = *p;
            i++;
        }
                 
        i=0;
        for (p=string2; *p != (char *) NULL; p++)
        {
            index[i] = *p;
            i++;
        }
    
    }
} /* GnoPixmaps */
    else    /* use XmSTRING */
    {
        i=0;
        for (p=string; *p != (char *) NULL; p++)
        {   
            indexElem[i] = *p;
            i++;
        }

        i=0;
        for (p=string2; *p != (char *) NULL; p++)
        {
            index[i] = *p;
            i++;
        }
    }

    /*
    ** alocate color
    */

    if (GnoPixmaps == False)
    {
        if (GuseFolderPixmaps == True)
            fg_pixel = AllocateNamedColor (display, "#87ceeb");
        else
            fg_pixel = AllocateNamedColor (display, "Red");
            
    }
    else
        fg_pixel = AllocateNamedColor (display, "Red");


    if (fg_pixel > 256)    /* failed to parse*/
        fg_pixel=(unsigned int) WhitePixel(display, screen);

    bg_pixel = BlackPixel(display, screen);

    /*
    ** get the depth
    */

    XtVaGetValues (w_special[TOPLEVEL_W],
        XmNdepth,       &depth,
        NULL);

    for(i=0; i <26; i ++)
    {

        if (GnoPixmaps == False)
        {
            if (GuseFolderPixmaps == True)
            {
                armpixmap = XCreatePixmapFromBitmapData(display,
                    DefaultRootWindow(display),
                    array[i],
                    foldera_width,
                    foldera_height,
                    (unsigned long) fg_pixel,
                    bg_pixel,
                    depth);

                GArmPixmap[i] = armpixmap;

                pixmap = XCreatePixmapFromBitmapData(display,
                    DefaultRootWindow(display),
                    array[i],
                    foldera_width,
                    foldera_height,
                    WhitePixel(display, screen),
                    BlackPixel(display, screen),
                    depth);

                GBPixmap[i] = pixmap;

                if ((armpixmap == (Pixmap)NULL) ||
                    (pixmap == (Pixmap) NULL))
                {
                    fprintf(stderr, 
                        "Unable to Create Folder Pixmaps!!!");
                    exit(1);
                }

            }
            else
            {
                pixmap = (Pixmap) NULL;
                armpixmap = (Pixmap) NULL;
            }
        }   /* GnoPixmaps */
        else
        {
            pixmap = (Pixmap) NULL;
            armpixmap = (Pixmap) NULL;
        }

        if (GnoPixmaps == False)
        {
            if (GuseFolderPixmaps == True)
            {
                folderpbW = XtVaCreateManagedWidget ("folderA",
                    xmPushButtonWidgetClass, parent,
                    XmNlabelType, XmPIXMAP,
                    XmNlabelPixmap, armpixmap,
                    XmNarmPixmap,   pixmap,
                    NULL);
            }
            else
                folderpbW = XtVaCreateManagedWidget (indexElem[i],
                    xmPushButtonWidgetClass, parent,
                    XmNspacing, 10,
                    NULL);
        }   /* GnoPixmaps */
        else
        {
            folderpbW = XtVaCreateManagedWidget (indexElem[i],
                xmPushButtonWidgetClass, parent,
                XmNspacing, 10,
                NULL);
        }   

        XtAddCallback (folderpbW, XmNactivateCallback,
            FolderPbCB, (XtPointer) index[i]);
        XtAddCallback (folderpbW, XmNhelpCallback,
            HelpCB, (XtPointer) FOLDER_PIXMAPS_HELP);

    }   /* for */
}
