/*
 *  CreateAskSaveDialogW()  -   creates the warning dialog to ask 
 *                              if you want to save the file
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   12-Mar-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"

void JustExit _D ((Widget, XtPointer, XtPointer));


Boolean CreateAskSaveDialogW (parent)
Widget
    parent;
{
    Arg
        args[10];
    int
        n;

    Widget
        widget;

    XmString
        xmstr,
        xmstr2,
        xmstr3;

    char *text;

    text = "Save database before exiting?";

    xmstr = XmStringCreateLtoR (text, XmSTRING_DEFAULT_CHARSET);
    xmstr2 = XmStringCreateLtoR ("Yes", XmSTRING_DEFAULT_CHARSET);
    xmstr3 = XmStringCreateLtoR ("No", XmSTRING_DEFAULT_CHARSET);


    n = 0;
    XtSetArg (args[n], XmNtitle, "Warning!");   n++;
    XtSetArg (args[n], XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL);    n++;
    XtSetArg (args[n], XmNdialogType, XmDIALOG_WARNING); n++;
    XtSetArg (args[n], XmNmessageString, xmstr);    n++;
    XtSetArg (args[n], XmNokLabelString, xmstr2);   n++;
    XtSetArg (args[n], XmNcancelLabelString, xmstr3);   n++;

    widget = XmCreateWarningDialog (parent, "Warning2",
        args, n);

    XmStringFree (xmstr);
    XmStringFree (xmstr2);
    XmStringFree (xmstr3);

    GwarningDialogW = widget;

    XtUnmanageChild (XmMessageBoxGetChild(widget, XmDIALOG_HELP_BUTTON));

    XtAddCallback (widget, XmNokCallback,
        PopSaveDialog, (XtPointer) NULL);
    XtAddCallback (widget, XmNcancelCallback,
        JustExit, (XtPointer) NULL);

    return (True);
}

void JustExit (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data;
XtPointer
    call_data;
{
    (void) unlink (GtempFilename);
    exit(1);
}
