#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "defines.h"

static int FileisOK (fullname, sbuf, reading)
char
    *fullname;
struct stat
    *sbuf;

int
    reading;
{

    int
        rc = 0;


    if ((sbuf->st_mode & S_IFMT) == S_IFDIR)
    {
        fprintf (stderr, "%s: a directory\n",
            fullname);
        rc = FILE_IS_A_DIRECTORY;
        goto ExitProcessing;
    }

    if (!(sbuf->st_mode & S_IFREG))
    {
        fprintf (stderr, "File %s is not a regular file!!!\n",
            fullname);
        rc = FILE_IS_NOT_REGULAR;
        goto ExitProcessing;
    }
    else
    {
        if(reading)
        {
            rc = access(fullname, R_OK);

            if (rc == -1)
            {
             fprintf (stderr, "%s: is unreadable\n",
                 fullname);
             rc = FILE_IS_UNREADABLE;
             goto ExitProcessing;
            }
        }
        else
        {
            rc = access (fullname, W_OK);
            if (rc == -1)
                rc = FILE_IS_NOT_WRITABLE;
            else
                rc = FILE_EXISTS;
        }
    }

ExitProcessing:
    return (rc);
}

int CheckFile (fullname, reading)
char
    *fullname;
int
    reading;
{
    int
        rc = 0;

    struct stat
        sbuf;

    /*
    ** if file exists, only then we will check if it's a valid
    ** file or not. If the file does not exist, it will fail during
    ** opening if something is wrong anyway.
    */

    if (!stat(fullname, &sbuf)) /* file exists */
        rc = FileisOK (fullname, &sbuf, reading);

    return(rc);
}

