#!/bin/sh
# MSWindows and AIX both require lists of all symbols declared as PLUG_API
# in order to properly link plugins.

# MSWindows - when plugin built, need API list to resolve symbols
#             defined in the yorick executable
# AIX - when yorick built, need API list to mark symbols which the
#       yorick executable exports

PLAY_DIRS=`grep '^PLAY_DIRS=' Make.cfg | sed -e 's/^PLAY_DIRS=//'`
if test "$PLAY_DIRS" = "win"; then
  WIN=win
else
  WIN=x11
fi

rm -f cfg.* yorapi.def
# header files containing PLUG_API declarations
grep -h PLUG_API >cfg.00 \
 play/play.h play/phash.h play/pstdlib.h play/pstdio.h play/$WIN/playwin.h \
 yorick/ydata.h yorick/binio.h yorick/yio.h yorick/defmem.h yorick/hash.h \
 yorick/bcast.h yorick/parse.h regexp/yfnmatch.h regexp/yregexp.h \
 matrix/cblasy.h matrix/dg.h fft/cfft.h gist/gist.h gist/hlevel.h gist/draw.h \
 gist/engine.h gist/cgm.h gist/ps.h gist/gtext.h gist/xbasic.h gist/xfancy.h

splitcmd=`echo one,two,three|sed -e 'y/,/\n/'|wc -l`
if test "$splitcmd" -eq "3"; then
  # in AIX sed, y recognizes \n but s does not
  splitcmd='y/,/\n/'
else
  # in Linux sed, s recognizes \n but y does not
  splitcmd='s/,/\n/g'
fi

sed -e 's/;.*/;/' -e 's/[ 	]*([^*].*)/:/' -e 's/([^*][^)]*/:/' cfg.00 >cfg.01
sed -e 's/)://' -e 's/\[.*\]//' -e 's/;//' -e 's/: *,/:/' cfg.01 >cfg.02
sed -e 's/PLUG_API //' -e 's/volatile //' -e 's/const //' -e 's/unsigned //' -e 's/struct //' -e 's/(\*//' cfg.02 >cfg.03
sed -e 's/^[ 	]*[a-zA-Z0-9_]*[ 	]*//' -e 's/\**//g' cfg.03 >cfg.04
sed -e 's/[ 	]*,[ 	]*/,/g' -e $splitcmd cfg.04 >cfg.05
sed -e 's/://g' -e 's/[ 	]*//g' cfg.05 >yorapi.def
rm -f cfg.*

# original MSWindows script
# dlltool -z preyor.def libyor.a
# sed -e 's/ @ .*//' -e 's/	//' <preyor.def | tail -n +3 >preyor.def1
# sed -e 's/.*/\0 = yorick.exe.\0/' <preyor.def1 >libyor.def
