/*
  libc-extension.h -- declare some libc extensions

  source file of the flowerlib

  (c)  1997--1998 Han-Wen Nienhuys <hanwen@cs.uu.nl>
       Jan Nieuwenhuizen <janneke@gnu.org>
*/


#ifndef LIBC_EXTENSION_HH
#define LIBC_EXTENSION_HH

#include "config.h"
#include <stdarg.h>

#if !HAVE_BASENAME		/* GNU extension. */
char* basename (char const *);
#endif

#if !HAVE_DIRNAME		/* GNU extension. */
char* dirname (char *);
#endif

#if !HAVE_SNPRINTF		/* GNU extension. */
int snprintf (char *str, size_t n, char const *format, ...);
#endif

#if !HAVE_VSNPRINTF	 	/* GNU extension. */
int vsnprintf (char *str, size_t, char const *format, va_list args);
#endif


#endif /* LIBC_EXTENSION_H */
