#!@SHELL@

error()
{
    echo $@
    exit 1
}

if [ $# -ne 2 ] ; then
    error "Usage: stripdoc MACRODOC-FILE MACRO-FILENAME"
    exit 2
fi

if [ ! -f $1 ] ; then
    error "cannot find input file $1!"
fi

awk 'BEGIN {
	active = 1;                         # assume active
    }
    {
	if ($1 == "@startdoc")              # documentation starts
	    active = 0;
	else if ($1 == "@enddoc")           # documentation ends
	    active = 1;
	else
	{
	    if (active)
		print;                      # normal text
	}
    }' $1 > $2
