/*                                                                                                                                       
// YAP2LC - an LDAP migration tool
//
// yap2lc.h
// License: GPL
// Author: Radu Negut <radun@romsys.ro>
// Version: 0.5.9 [23.12.2003]
// Section: checks entries for validity,
//	    duplicate cn removal, filter chain
*/

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <pwd.h>
#if HAVE_SHADOW_H == 1                                                                             
#include <shadow.h>                                                                                                                      
#endif
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "config.h"
#include "yap2lc.h"

extern global_t global;

#if HAVE_SHADOW_H == 1
int
sanity_check(struct passwd *pwd, struct spwd *shadow)
#else
int
sanity_check(struct passwd *pwd)
#endif
{
    int x = 0, res = 0, y;
    if(pwd->pw_uid < global.min_uid)
	{
	 commit_log(pwd->pw_name, pwd->pw_uid, UGIDFAIL);
	 ++res;
	}
    else if(pwd->pw_uid > global.max_uid && global.max_uid != 0)
	{
	 commit_log(pwd->pw_name, pwd->pw_uid, UGIDFAIL);
	 ++res;
	}
    if(global.exgids[0] != -1)
	{
	 for(y = 0; y < 10; y++)
	     {
	      if(global.exgids[y] == -1)
	          break;
	      if((int)pwd->pw_gid == global.exgids[y])
	          {
		   commit_log(pwd->pw_name, pwd->pw_uid, UGIDFAIL);
		   ++global.gidexcluded;
		   ++res;
		   break;
		  }
	     }
	}
#if HAVE_SHADOW_H == 1
    if(strlen(shadow->sp_pwdp) == 0 || (strncmp(shadow->sp_pwdp, "NP", 2) == 0))
	{
	 ++global.unpassworded;
	 if(global.allownopwd == 1)
	      commit_log(pwd->pw_name, pwd->pw_uid, NOPWD);
	 else
	     {
	      commit_log(pwd->pw_name, pwd->pw_uid, NOPWD);
	      ++res;
	     }
	 }
    if(shadow->sp_pwdp[0] == '*' || shadow->sp_pwdp[0] == '!')
	{
	 ++global.lockedout;
	 if(global.allowlockedout == 1)
	     {
	      commit_log(pwd->pw_name, pwd->pw_uid, LOCKEDOUT);
	      global.accstat = 0;
	     }
	 else
	     {
	      commit_log(pwd->pw_name, pwd->pw_uid, LOCKEDOUT);
	      ++res;
	     }
	}
#else
    if(strlen(pwd->pw_passwd) == 0 || (strncmp(pwd->pw_passwd, "NP", 2) == 0))
	{
	 ++global.unpassworded;
	 if(global.allownopwd == 1)
	      commit_log(pwd->pw_name, pwd->pw_uid, NOPWD);
	 else
	     {
	      commit_log(pwd->pw_name, pwd->pw_uid, NOPWD);
	      ++res;
	     }
	 }
    if(pwd->pw_passwd[0] == '*' || pwd->pw_passwd[0] == '!')
	{
	 ++global.lockedout;
	 if(global.allowlockedout == 1)
	     {
	      commit_log(pwd->pw_name, pwd->pw_uid, LOCKEDOUT);
	      global.accstat = 0;
	     }
	 else
	     {
	      commit_log(pwd->pw_name, pwd->pw_uid, LOCKEDOUT);
	      ++res;
	     }
	}
#endif
    if(strlen(pwd->pw_gecos) == 0)
	{
	 ++global.nocn;
	 if(global.lognocn == 0)
	     commit_log(pwd->pw_name, pwd->pw_uid, NOCN);
	 ++res;
	}
    while(pwd->pw_gecos[x] != '\0')
	{
	 if(((isalnum(pwd->pw_gecos[x] == 0))) && pwd->pw_gecos[x] != ' ')
	     {
	      ++global.nocn;
	      if(global.lognocn == 1)
	          commit_log(pwd->pw_name, pwd->pw_uid, NOCN);
	      ++res;
	     }
	 ++x;
	}
    if(global.remduplicates == 1 && global.impdup != 1)
	{
	 if(check_duplicate(pwd->pw_gecos) == 1)
	    {
	     ++global.duplicates;
	     if(global.logduplicates == 1)
		 commit_log(pwd->pw_name, pwd->pw_uid, DUPLICATE);
	     ++res;
	    }
	 if(check_duplicate(pwd->pw_gecos) == -1)
	     {
	      printf("Access to duplicate temp file is impossible; duplicate checking disabled.\n");
	      global.impdup = 1;
	     }
	}
    if(global.igngrperr == 0)
	{
	 if((u_long)pwd->pw_gid < 0)
	    {
	     ++global.gidexcluded;
	     commit_log(pwd->pw_name, pwd->pw_uid, NOGRP);
	     ++res;
	    }
	}
    if(global.regexpfilter == 1)
	{
	 switch(global.regextarget)
	    {
	     case RGXUNAME:
		if((regex_filter(global.reg_struct, pwd->pw_name)) == 1)
		    {
		     ++global.regexpfiltered;
		     commit_log(pwd->pw_name, pwd->pw_uid, RGXFAIL);
		     ++res;
		    }
	        break;
	     case RGXRNAME:
	        if((regex_filter(global.reg_struct, pwd->pw_gecos)) == 1)
		    {
		     ++global.regexpfiltered;
		     commit_log(pwd->pw_name, pwd->pw_uid, RGXFAIL);
		     ++res;
		    }
	        break;
	     default:
	        break;
	    }

	}
    return res;
}

int
check_duplicate(char *cname)
{
    int dupfd;
    u_long mark, x;
    off_t offset;
    char buf[MAX_NAME_LEN];
    bzero(buf, MAX_NAME_LEN);
    if((dupfd = open("./cnlist", O_RDWR | O_CREAT, S_IRUSR | S_IWUSR)) == -1)
	{
	 printf("Unable to access temporary duplicate storage; duplicate checking disabled.\n");
	 global.remduplicates = 0;
	 global.logduplicates = 0;
	 return -1;
	}
    offset = SEEK_CUR;
    mark = 0;
    while(read(dupfd, buf, MAX_NAME_LEN) > 0)
	{
	 for(x = 0; x < MAX_NAME_LEN; x++)
	     if(buf[x] == ':')
	         mark = x;
	 buf[mark] = '\0';
	 if((strstr(buf, cname)) != NULL)
	     {
	      close(dupfd);
	      return 1;
	     }
	 lseek(dupfd, (u_long)(offset + mark), SEEK_SET);
	}
    lseek(dupfd, 0, SEEK_END);
    write(dupfd, cname, strlen(cname));
    write(dupfd, ":", 1);
    close(dupfd);
    return 0;
}

