/* Configuration Stanza Scanner
 */

typedef struct _Config_* Config;


/* Public Methods */
#ifdef __STDC__
	Config		config_new();
	Config		config_dispose (Config self);
	int		config_nfields (Config self);
	char**		config_fields (Config self);
	int		config_scanbuf (Config self, char* buf);
	int		config_setbreak (	
				Config self,
				const char* delimiters,
				const char* punctuation
			);
	int		config_getoptions (Config self);
	int		config_setoptions (Config self, int options);
#else
	Config		config_new();
	Config		config_dispose ();
	int		config_nfields ();
	char**		config_fields ();
	int		config_scanbuf ();
	int		config_setbreak ();
	int		config_getoptions ();
	int		config_setoptions ();
#endif

/* for options */
#define CFG_OPT_UCASE	0x01		/* map to upper case */
#define CFG_OPT_LCASE	0x02		/* map to lower case */
#define CFG_OPT_CASEMAP	0x03		/* any case mapping option set */

#ifdef CLASS_Config_PRIVATE
struct _Config_ {
	char*	buf;
	char*	tbuf;
	char*	separators;
	char*	delimiters;
	char**	fields;
	int	nfields;
	int	maxfields;
	int	options;
	char	brk[256];
};
#endif
